/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.Pointer;

public class SystemInfo {
    public short wProcessorArchitecture;
    public short wReserved;
    public int dwPageSize;
    public int lpMinimumApplicationAddress;
    public int lpMaximumApplicationAddress;
    public int dwActiveProcessorMask;
    public int dwNumberOfProcessors;
    public int dwProcessorType;
    public int dwAllocationGranularity;
    public short wProcessorLevel;
    public short wProcessorRevision;

    public SystemInfo(Pointer lpSystemInfo) throws NativeException {
        int offset = -4;
        this.wProcessorArchitecture = lpSystemInfo.getAsShort(offset + 4);
        this.wReserved = lpSystemInfo.getAsShort(offset + 6);
        this.dwPageSize = lpSystemInfo.getAsInt(offset + 8);
        this.lpMinimumApplicationAddress = lpSystemInfo.getAsInt(offset + 12);
        this.lpMaximumApplicationAddress = lpSystemInfo.getAsInt(offset + 16);
        this.dwActiveProcessorMask = lpSystemInfo.getAsInt(offset + 20);
        this.dwNumberOfProcessors = lpSystemInfo.getAsInt(offset + 24);
        this.dwProcessorType = lpSystemInfo.getAsInt(offset + 28);
        this.dwAllocationGranularity = lpSystemInfo.getAsInt(offset + 32);
        this.wProcessorLevel = lpSystemInfo.getAsShort(offset + 36);
        this.wProcessorRevision = lpSystemInfo.getAsShort(offset + 38);
    }

    public String toString() {
        return "wProcessorArchitecture : " + this.wProcessorArchitecture + ("wReserved : " + this.wReserved) + ("dwPageSize : " + this.dwPageSize) + ("lpMinimumApplicationAddress : " + this.lpMinimumApplicationAddress) + ("lpMaximumApplicationAddress : " + this.lpMaximumApplicationAddress) + ("dwActiveProcessorMask : " + this.dwActiveProcessorMask) + ("dwNumberOfProcessors : " + this.dwNumberOfProcessors) + ("dwProcessorType : " + this.dwProcessorType) + ("dwAllocationGranularity : " + this.dwAllocationGranularity) + ("wProcessorLevel : " + this.wProcessorLevel) + ("wProcessorRevision : " + this.wProcessorRevision);
    }
}

