/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.bean;

public class LitePresence {
    private static final String OFFLINE_NAME = "OFFLINE";
    private static final String ONLINE_NAME = "ONLINE";
    private static final String INVISIBLE_NAME = "INVISIBLE";
    private static final String AWAY_NAME = "AWAY";
    private static final String BUSY_NAME = "BUSY";
    public static final LitePresence ONLINE = new LitePresence(Type.available, Mode.available, "ONLINE");
    public static final LitePresence INVISIBLE = new LitePresence(Type.available, Mode.away, "INVISIBLE");
    public static final LitePresence AWAY = new LitePresence(Type.available, Mode.away, "AWAY");
    public static final LitePresence BUSY = new LitePresence(Type.available, Mode.away, "BUSY");
    public static final LitePresence OFFLINE = new LitePresence(Type.unavailable, null, "OFFLINE");
    private Type type;
    private Mode mode;
    private String name;

    public static final LitePresence getPresence(String type, String mode, String name) {
        if (type == null) {
            return null;
        }
        LitePresence presence = null;
        if (type.equals(Type.unavailable.name())) {
            presence = OFFLINE;
        } else if (type.equals(Type.available.name())) {
            presence = name == null ? ONLINE : (name.equals(INVISIBLE_NAME) ? INVISIBLE : (name.equals(AWAY_NAME) ? AWAY : (name.equals(BUSY_NAME) ? BUSY : ONLINE)));
        } else {
            Mode _mode = mode == null ? null : Mode.valueOf(mode);
            presence = new LitePresence(Type.valueOf(type), _mode, name);
        }
        return presence;
    }

    public static final LitePresence getPresenceByName(String name) {
        if (name == null) {
            return null;
        }
        LitePresence presence = null;
        if (name.equals(OFFLINE_NAME)) {
            return OFFLINE;
        }
        if (name.equals(ONLINE_NAME)) {
            return ONLINE;
        }
        if (name.equals(INVISIBLE_NAME)) {
            return INVISIBLE;
        }
        if (name.equals(AWAY_NAME)) {
            return AWAY;
        }
        if (name.equals(BUSY_NAME)) {
            return BUSY;
        }
        return presence;
    }

    public LitePresence() {
    }

    public LitePresence(Type type) {
        this.type = type;
    }

    public LitePresence(Type type, Mode mode) {
        this.type = type;
        this.mode = mode;
    }

    public LitePresence(Type type, Mode mode, String name) {
        this.type = type;
        this.mode = mode;
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name + "-" + this.type.toString();
    }

    public static enum Type {
        available,
        unavailable,
        unsubscribe;

    }

    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;

    }
}

