/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client;

import com.blisscloud.ezuc.client.ApplicationInstanceListener;
import com.blisscloud.ezuc.client.ApplicationInstanceManager;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.login.LoginPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.SystemUtils;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatMsgQueueController;
import com.blisscloud.mobile.ezuc.agent.ConnectionAgent;
import com.blisscloud.mobile.ezuc.agent.NetworkService;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.VerifyEnterpriseNoTask;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import javafx.application.Platform;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.ini4j.Ini;

public class EZCustomer {
    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        String javaLibPath = System.getProperty("java.library.path");
        if (SystemUtils.isWindows()) {
            File file = new File("C:\\Windows\\krb5.ini");
            if (file.exists()) {
                System.setProperty("java.security.krb5.conf", file.getAbsolutePath());
            } else {
                System.err.println("krb5.ini not found!");
            }
        }
        Log.i(UCChatClient.class.getSimpleName(), "You are using JAVA " + javaVersion);
        Log.i(UCChatClient.class.getSimpleName(), "java.library.path: " + javaLibPath);
        Log.i(UCChatClient.class.getSimpleName(), "Max Memory is " + Runtime.getRuntime().maxMemory());
        if (javaVersion.compareTo("1.7") < 0) {
            Log.i(UCChatClient.class.getSimpleName(), "UC Chat Client Cancelled, unsupported JAVA version!");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    int result = JOptionPane.showConfirmDialog(null, I18NUtil.getString("setting_notice_java_version_check"), I18NUtil.getString("common_title_error"), 2, 0);
                    if (result == 0) {
                        Desktop desktop;
                        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                            try {
                                desktop.browse(new URI("http://www.java.com/"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    System.exit(0);
                }
            });
            return;
        }
        PreferencesUtil.load();
        if (!PreferencesUtil.isMultipleApplicationInstance()) {
            if (!ApplicationInstanceManager.registerInstance()) {
                Log.w(UCChatClient.class.getSimpleName(), "Another instance of this application is already running.  Exiting.");
                System.exit(0);
            }
            ApplicationInstanceManager.setApplicationInstanceListener(new ApplicationInstanceListener(){

                @Override
                public void newInstanceCreated() {
                    Log.w(UCChatClient.class.getSimpleName(), "New instance detected...just bring the first desktop instance to front");
                    EventQueue.invokeLater(new Runnable(this){

                        @Override
                        public void run() {
                            UCChatClient inst = UCChatClient.getInstance();
                            inst.setVisible(true);
                            int currentState = inst.getExtendedState();
                            inst.setExtendedState(1);
                            inst.setExtendedState(currentState == 1 ? 0 : currentState);
                            inst.toFront();
                            inst.repaint();
                        }
                    });
                }
            });
        }
        String releaseTime = "";
        String releaseVersion = "";
        int releaseVersionCode = -1;
        Properties versionProp = new Properties();
        try {
            versionProp.load(UCChatClient.class.getResourceAsStream("/version.info"));
            releaseTime = versionProp.getProperty("release.time");
            releaseVersion = versionProp.getProperty("release.version");
            releaseVersionCode = Integer.parseInt(versionProp.getProperty("release.version.code"));
        }
        catch (Exception e) {
            Log.e(UCChatClient.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        Log.i(UCChatClient.class.getSimpleName(), "EZDesktop Started");
        Log.i(UCChatClient.class.getSimpleName(), "    Release Time: " + releaseTime);
        Log.i(UCChatClient.class.getSimpleName(), "    Release Version: " + releaseVersion);
        Log.i(UCChatClient.class.getSimpleName(), "    Release Version Code: " + releaseVersionCode);
        Log.i(UCChatClient.class.getSimpleName(), "    App Directory: " + FileUtil.getAppRootDir().getAbsolutePath());
        Log.i(UCChatClient.class.getSimpleName(), "JVM file.encoding: " + System.getProperty("file.encoding"));
        Log.i(UCChatClient.class.getSimpleName(), "    os.arch: " + System.getProperty("os.arch"));
        Log.i(UCChatClient.class.getSimpleName(), "    os.name: " + System.getProperty("os.name"));
        int ucDBVersion = PreferencesUtil.getUCDatabaseVersion();
        Log.i(UCChatClient.class.getSimpleName(), "current UC database version:" + ucDBVersion + ", application UC database version:168");
        if (ucDBVersion == -1) {
            dbHelper = UCDBHelper.getDB(UCChatClient.context);
            dbHelper.onCreate(dbHelper.getWritableDatabase());
            PreferencesUtil.setUCDatabaseVersion(168);
        } else if (ucDBVersion < 168) {
            dbHelper = UCDBHelper.getDB(UCChatClient.context);
            dbHelper.onUpgrade(dbHelper.getWritableDatabase(), ucDBVersion, 168);
            PreferencesUtil.setUCDatabaseVersion(168);
        }
        int userDBVersion = PreferencesUtil.getUserDatabaseVersion();
        Log.i(UCChatClient.class.getSimpleName(), "current User database version:" + userDBVersion + ", application User database version:2");
        if (userDBVersion < 2) {
            UserDatabase.getDB(UCChatClient.context).onUpgrade(null, userDBVersion, 2);
            PreferencesUtil.setUserDatabaseVersion(2);
        }
        if (SystemUtils.isMac()) {
            EZCustomer.readyToRunStep1();
        } else if (SystemUtils.isWindows()) {
            File iniFile = new File("C:\\Windows\\ezuc.ini");
            if (!iniFile.exists()) {
                EZCustomer.readyToRunStep1();
                return;
            }
            if (!EZCustomer.checkIni(iniFile)) {
                EZCustomer.readyToRunStep1();
            }
        } else {
            System.exit(0);
        }
    }

    private static boolean checkIni(File iniFile) {
        try {
            String username;
            String currentLoginId;
            Ini ini = new Ini(iniFile);
            String iniSpn = ini.get((Object)"kerberos", (Object)"spn");
            String iniOid = ini.get((Object)"kerberos", (Object)"oid");
            if (StringUtils.isNotBlank((CharSequence)iniSpn)) {
                PreferencesUtil.setGSSSPN(UCChatClient.context, iniSpn);
            }
            if (StringUtils.isNotBlank((CharSequence)iniOid)) {
                PreferencesUtil.setGSSOID(UCChatClient.context, iniOid);
            }
            if (StringUtils.isBlank((CharSequence)(currentLoginId = PreferencesUtil.getLoginID(UCChatClient.context))) && StringUtils.isNotBlank((CharSequence)(username = System.getProperty("user.name")))) {
                PreferencesUtil.setLoginInfo(UCChatClient.context, username);
            }
            final String iniEnterpriseNo = ini.get((Object)"server", (Object)"enterpriseNo");
            String currentNo = PreferencesUtil.getEnterpriseNo(UCChatClient.context);
            if (StringUtils.isBlank((CharSequence)currentNo) && StringUtils.isNotBlank((CharSequence)iniEnterpriseNo)) {
                VerifyEnterpriseNoTask mQueryTask = new VerifyEnterpriseNoTask(UCChatClient.context, iniEnterpriseNo, new ICheckCompleteListener(){

                    @Override
                    public void onCheckCompleted(Object data, int result) {
                        if (0 == result) {
                            PreferencesUtil.setEnterpriseNoNotReady(UCChatClient.context, iniEnterpriseNo);
                        }
                        EZCustomer.readyToRunStep1();
                    }
                });
                mQueryTask.execute(new Void[0]);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void readyToRunStep1() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean hasEnterpriseSet;
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    UIManager.put("Button.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("CheckBox.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("ComboBox.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("Label.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("List.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("Menu.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("MenuBar.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("MenuItem.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("OptionPane.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("RadioButton.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("TextArea.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("TextField.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("TitledBorder.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("ToggleButton.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("ToolBar.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("Tree.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ToolTipManager.sharedInstance().setInitialDelay(200);
                Platform.setImplicitExit((boolean)false);
                PreferencesUtil.saveDeviceInformation(UCChatClient.context, 3);
                String loginId = PreferencesUtil.getLoginID(UCChatClient.context);
                boolean hasLoginId = TextUtils.isNotBlank((CharSequence)loginId);
                boolean hasPassword = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getLoginPWD(UCChatClient.context));
                boolean hasSysToken = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getLoginToken(UCChatClient.context));
                boolean remainLogin = PreferencesUtil.isRemainLoggedIn(UCChatClient.context);
                boolean hasEnterpriseNo = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getEnterpriseNo(UCChatClient.context));
                boolean hasEnterpriseIp = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getEnterpriseIp(UCChatClient.context));
                boolean bl = hasEnterpriseSet = hasEnterpriseNo || hasEnterpriseIp;
                if (hasEnterpriseSet && remainLogin && hasLoginId && (hasPassword || hasSysToken)) {
                    EZCustomer.readyToRun(true);
                    return;
                }
                if (!remainLogin && hasLoginId && hasPassword) {
                    EZCustomer.readyToRun(false);
                    return;
                }
                if (!remainLogin && hasLoginId && hasSysToken) {
                    PreferencesUtil.setRemainLoggedIn(UCChatClient.context);
                    remainLogin = true;
                    EZCustomer.readyToRun(true);
                    return;
                }
                EZCustomer.readyToRun(false);
            }
        });
    }

    private static void readyToRun(boolean reconnect) {
        UCChatClient inst = UCChatClient.getInstance();
        PhoneAgent.getInstance();
        WebAgent.getInstance();
        ConnectionAgent.getInstance();
        NetworkService.getInstance();
        ChatMsgQueueController.getInstance(UCChatClient.context);
        if (reconnect) {
            Log.i(UCChatClient.class.getSimpleName(), "***** \u986f\u793aLoadingDataPanel");
            inst.showLoadingDataPanel(1);
            if (PreferencesUtil.isSyncOldChatEventDone(UCChatClient.context)) {
                inst.setLoadingDataText(I18NUtil.getString("login_notice_data_loading"));
            }
            inst.getMainPanel().initDataProcess(1);
            inst.setVisible(true);
        } else {
            inst.showLoginPanel(LoginPanel.Mode.WAIT);
        }
        ChatRoomManager.markSendinMsgAsError(UCChatClient.context);
    }
}

