/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.addressbook.AddressBookPanel;
import com.blisscloud.ezuc.client.component.ChatBackgroundPanel;
import com.blisscloud.ezuc.client.component.CustomLineBorder;
import com.blisscloud.ezuc.client.component.GroupPanel;
import com.blisscloud.ezuc.client.contact.MyContactEditor;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class AddressBookFramePanel
extends JPanel {
    private static final long serialVersionUID = -9166443448881515395L;
    private JSplitPane jSplitPane1;
    private AddressBookPanel addressBookPanel;
    private ChatBackgroundPanel backgroundPanel;
    private MyContactEditor mMyContactEditor = new MyContactEditor();
    private JPanel detialPanel;
    private boolean tabSelected = false;

    public AddressBookFramePanel() {
        this.setLayout(new BorderLayout());
        this.initView();
    }

    private void initView() {
        this.jSplitPane1 = new JSplitPane();
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
        this.backgroundPanel = new ChatBackgroundPanel();
        this.addressBookPanel = new AddressBookPanel(this);
        this.addressBookPanel.setMinimumSize(new Dimension(340, 200));
        this.addressBookPanel.setBorder(new CustomLineBorder(GroupPanel.TITLE_BORDER_COLOR, 0, 0, 0, 1));
        this.jSplitPane1.add((Component)this.addressBookPanel, "left");
        this.detialPanel = new JPanel();
        this.detialPanel.setLayout(new BorderLayout());
        this.detialPanel.add((Component)this.backgroundPanel, "Center");
        this.jSplitPane1.add((Component)this.detialPanel, "right");
        int location = PreferencesUtil.getInt(UCChatClient.context, "DIVIDER_LOCATION_BULLETIN", 450);
        int size = PreferencesUtil.getInt(UCChatClient.context, "DIVIDER_SIZE_BULLETIN", -1);
        if (location > 0) {
            this.jSplitPane1.setDividerLocation(location);
        }
        if (size > 0) {
            this.jSplitPane1.setDividerSize(size);
        }
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent changeEvent) {
                int xdividerSize;
                JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
                String propertyName = changeEvent.getPropertyName();
                if (propertyName.equals("dividerLocation")) {
                    int xdividerLocation = sourceSplitPane.getDividerLocation();
                    if (xdividerLocation != 0) {
                        PreferencesUtil.putInt(UCChatClient.context, "DIVIDER_LOCATION_BULLETIN", xdividerLocation);
                    }
                } else if (propertyName.equals("dividerSize") && (xdividerSize = AddressBookFramePanel.this.jSplitPane1.getDividerSize()) != 0) {
                    PreferencesUtil.putInt(UCChatClient.context, "DIVIDER_SIZE_BULLETIN", xdividerSize);
                }
            }
        });
    }

    public synchronized void showMyContact(Long myContactId) {
        this.mMyContactEditor.setMyContactId(myContactId);
        this.detialPanel.remove(this.backgroundPanel);
        this.detialPanel.add((Component)this.mMyContactEditor, "Center");
        this.detialPanel.revalidate();
        this.detialPanel.repaint();
    }

    public synchronized void closeMyContact() {
        this.detialPanel.remove(this.mMyContactEditor);
        this.detialPanel.add((Component)this.backgroundPanel, "Center");
        this.detialPanel.revalidate();
        this.detialPanel.repaint();
    }

    public void onTabSelected(boolean twice) {
        if (twice) {
            this.addressBookPanel.onTabSelected(twice);
        }
    }

    public void onTabUnselected() {
        this.tabSelected = false;
    }

    public void refreshData() {
        this.addressBookPanel.refreshEmployeeList();
        this.addressBookPanel.refreshGroupList();
        this.addressBookPanel.refreshMyContactList();
        this.addressBookPanel.refreshMeetmeList();
    }

    public void refreshCompanyInfo() {
        this.addressBookPanel.refreshCompanyName();
        this.addressBookPanel.refreshLicenseControl();
    }

    public void release() {
        if (this.addressBookPanel != null) {
            this.addressBookPanel.release();
        }
        this.closeMyContact();
    }
}

