/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.EmployeeInfoPopup;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.tool.CustomBorder;
import com.blisscloud.ezuc.client.util.PhoneStatusUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;

public class EmployeeEntryPanel
extends EntryPanel {
    private static EmployeeInfoPopup employeeInfoPopup;
    private PersonalPhoto lblHeadIcon;
    private JLabel lblName;
    private JLabel lblPresence;
    private JLabel lblStatus;
    private RoundedCornerLabel btnChat;
    private RoundedCornerLabel btnCall;
    LiteContact liteContact;
    String liteContactJID;
    Timer timer1 = null;

    public EmployeeEntryPanel(LiteContact contact, String displayName) {
        this.initGUI();
        this.setLiteContact(contact, displayName);
    }

    public void setLiteContact(LiteContact contact, String displayName) {
        this.liteContact = contact;
        this.liteContactJID = contact.getJid();
        this.setDisplayName(displayName);
        Image contactImage = ContactManager.getContactImage(contact, 48, false, true);
        if (JidUtil.isLocationJid(this.liteContactJID)) {
            this.setPhoneStatus(ContactManager.getPhoneLocStatus(this.liteContact.getJid()));
        } else {
            this.setPhoneStatus(ContactManager.getPhoneEmpStatus("" + this.liteContact.getId()));
        }
        this.lblHeadIcon.setImage(contactImage);
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(EntryPanel.ENTRY_SIZE);
            this.setBorder(new CustomBorder());
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setOpaque(false);
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
            this.lblHeadIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(EmployeeEntryPanel.this.lblHeadIcon, evt, EmployeeEntryPanel.this);
                    EmployeeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        EmployeeEntryPanel.this.showPersonalInfo();
                    }
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(EmployeeEntryPanel.this.lblHeadIcon, evt, EmployeeEntryPanel.this);
                    EmployeeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(EmployeeEntryPanel.this.lblHeadIcon, evt, EmployeeEntryPanel.this);
                    EmployeeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(EmployeeEntryPanel.this.lblHeadIcon, evt, EmployeeEntryPanel.this);
                    EmployeeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(EmployeeEntryPanel.this.lblHeadIcon, evt, EmployeeEntryPanel.this);
                    EmployeeEntryPanel.this.dispatchEvent(newEvt);
                }
            });
            this.lblName = new JLabel();
            this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 0, 0), 0, 0));
            this.lblName.setFont(UIConstants.FONT_14_PLAIN);
            JPanel panelCall = new JPanel();
            this.add((Component)panelCall, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setHgap(4);
            panelFunctionLayout.setVgap(0);
            panelCall.setLayout(panelFunctionLayout);
            panelCall.setOpaque(false);
            this.btnChat = new RoundedCornerLabel(I18NUtil.getString("abook_popup_btn_chat"), null, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            panelCall.add(this.btnChat);
            this.btnChat.setForeground(Color.WHITE);
            this.btnChat.setCursor(UIConstants.CURSOR_HAND);
            this.btnChat.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (EmployeeEntryPanel.this.btnChat.isEnabled() && evt.getButton() == 1) {
                        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                        mainPanel.showChatroom(EmployeeEntryPanel.this.getChatId());
                    }
                }
            });
            this.btnCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_callout"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            panelCall.add(this.btnCall);
            this.btnCall.setForeground(Color.WHITE);
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (EmployeeEntryPanel.this.btnCall.isEnabled() && evt.getButton() == 1) {
                        EmployeeEntryPanel.this.startDialOut();
                        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                        mainPanel.showChatroom(EmployeeEntryPanel.this.getChatId());
                    }
                }
            });
            this.setCallBtnVisible(false);
            this.lblPresence = new JLabel();
            this.add((Component)this.lblPresence, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblPresence.setFont(UIConstants.FONT_12_PLAIN);
            this.lblStatus = new JLabel();
            this.add((Component)this.lblStatus, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblStatus.setFont(UIConstants.FONT_12_PLAIN);
            this.lblStatus.setForeground(UIConstants.COLOR_LIGHT_GRAY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showPersonalInfo() {
        if (employeeInfoPopup == null) {
            employeeInfoPopup = new EmployeeInfoPopup(UCChatClient.getInstance());
        }
        employeeInfoPopup.setContact(ContactManager.getContact((Context)UCChatClient.context, this.liteContact.getJid()));
        employeeInfoPopup.show(this.lblHeadIcon, 0, 3 + this.lblHeadIcon.getHeight());
    }

    public void startDialOut() {
        if (this.btnCall.isEnabled()) {
            ChatRoomManager.startDialOut(this.btnCall, this.liteContact.getJid());
        }
    }

    @Override
    public EntryPanel.Type getType() {
        return EntryPanel.Type.EMPLOYEE;
    }

    @Override
    public String getEntryId() {
        return EntryPanel.Type.EMPLOYEE.name() + "-" + this.liteContact.getId();
    }

    @Override
    public String getValueId() {
        return String.valueOf(this.liteContact.getId());
    }

    @Override
    public String getChatId() {
        return this.liteContact.getJid();
    }

    @Override
    public String getPhoneNumber() {
        return this.liteContact.getExt();
    }

    @Override
    public String getDisplayName() {
        return this.lblName.getText();
    }

    @Override
    public String getSummary() {
        return this.lblStatus.getText();
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        if (!this.selected) {
            this.setCallBtnVisible(false);
            return;
        }
        String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
        if (myJid.equalsIgnoreCase(this.liteContactJID)) {
            this.setCallBtnVisible(false);
            return;
        }
        PhoneAgent.LineAvailableType ableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtnText(ableToCall != PhoneAgent.LineAvailableType.NONE, ableToCall);
    }

    private void handleCallBtnText(boolean btnVisible, PhoneAgent.LineAvailableType ableToCall) {
        this.setCallBtnVisible(btnVisible);
        if (!btnVisible) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line1"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line2"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_THREE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line3"));
        } else {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout"));
        }
    }

    private synchronized void setCallBtnVisible(final boolean btnVisible) {
        if (this.timer1 != null) {
            this.timer1.stop();
            this.timer1 = null;
        }
        if (btnVisible) {
            this.timer1 = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    EmployeeEntryPanel.this.btnCall.setVisible(btnVisible);
                    EmployeeEntryPanel.this.btnChat.setVisible(btnVisible);
                }
            });
            this.timer1.setRepeats(false);
            this.timer1.start();
        } else {
            this.btnCall.setVisible(btnVisible);
            this.btnChat.setVisible(btnVisible);
        }
    }

    public void setPhoneStatus(String status) {
        if (JidUtil.isLocationJid(this.liteContactJID) || JidUtil.isEmployeeJid(this.liteContactJID)) {
            this.lblPresence.setText(PhoneStatusUtil.getPhoneStatusText(status));
            this.lblPresence.setForeground(PhoneStatusUtil.getPhoneStatusColor(status));
            String statusText = PhoneStatusUtil.getPhoneStatusText(status);
            if (StringUtils.isNotBlank((CharSequence)statusText)) {
                this.setToolTipText(statusText);
            }
        }
    }

    public void setDisplayName(String displayName) {
        this.lblName.setText(displayName);
    }

    public void setPersonalStatus(String status) {
        this.lblStatus.setText(status);
    }

    public void setPersonalPhoto(Image photo) {
        if (photo == null || photo.getWidth(this) <= 0 || photo.getHeight(this) <= 0) {
            this.lblHeadIcon.setImage(UIConstants.ICON_PERSON48.getImage());
        } else {
            this.lblHeadIcon.setImage(photo);
        }
    }
}

