/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookSortingMode;
import com.blisscloud.ezuc.client.component.BubblePanel;
import com.blisscloud.ezuc.client.component.UCPopupWindow;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SortingModePopup
extends UCPopupWindow {
    private static final Color COLOR_SORTING_MODE = new Color(240, 240, 240);
    private JPanel panelContent;
    private SortingModeCallback callback;
    private Map<AddressBookSortingMode, Action> sortingModeActionMap = new HashMap<AddressBookSortingMode, Action>();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                SortingModePopup inst = new SortingModePopup(frame, AddressBookSortingMode.alphabet, null);
                inst.setVisible(true);
                inst.setSize(400, 300);
            }
        });
    }

    public SortingModePopup(JFrame frame, AddressBookSortingMode defaultSorting, SortingModeCallback callback) {
        super(frame);
        this.initGUI();
        this.initSortingMode(defaultSorting);
        this.callback = callback;
    }

    private void initGUI() {
        try {
            this.panelContent = new BubblePanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(new Color(236, 236, 236));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSortingMode(AddressBookSortingMode defaultSorting) {
        AddressBookSortingMode[] modes = AddressBookSortingMode.values();
        for (int i = 0; i < modes.length; ++i) {
            SortingModeAction sortingModeAction = new SortingModeAction(modes[i], modes[i] == defaultSorting);
            this.sortingModeActionMap.put(modes[i], sortingModeAction);
            JButton btnMode = new JButton(sortingModeAction);
            this.panelContent.add((Component)btnMode, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
            btnMode.setFont(UIConstants.FONT_14_PLAIN);
            btnMode.setForeground(COLOR_SORTING_MODE);
            btnMode.setBorderPainted(false);
            btnMode.setContentAreaFilled(false);
            btnMode.setFocusPainted(false);
            btnMode.setOpaque(false);
            btnMode.setHorizontalAlignment(2);
            btnMode.setCursor(UIConstants.CURSOR_HAND);
        }
    }

    public void setSelectedSortMode(AddressBookSortingMode mode) {
        for (AddressBookSortingMode _mode : this.sortingModeActionMap.keySet()) {
            Action action = this.sortingModeActionMap.get((Object)_mode);
            action.putValue("SmallIcon", _mode == mode ? UIConstants.ICON_CHECK_MARK : UIConstants.ICON_EMPTY);
        }
    }

    public static interface SortingModeCallback {
        public void onSortingModeChanged(AddressBookSortingMode var1);
    }

    class SortingModeAction
    extends AbstractAction {
        AddressBookSortingMode mode;

        public SortingModeAction(AddressBookSortingMode mode, boolean selected) {
            this.mode = mode;
            if (mode == AddressBookSortingMode.alphabet) {
                this.putValue("Name", "A-Z");
            } else if (mode == AddressBookSortingMode.department) {
                this.putValue("Name", I18NUtil.getString("abook_department"));
            } else if (mode == AddressBookSortingMode.status) {
                this.putValue("Name", I18NUtil.getString("abook_sort_menu_status"));
            }
            this.putValue("SmallIcon", selected ? UIConstants.ICON_CHECK_MARK : UIConstants.ICON_EMPTY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SortingModePopup.this.callback != null) {
                SortingModePopup.this.callback.onSortingModeChanged(this.mode);
            }
            SortingModePopup.this.setSelectedSortMode(this.mode);
            SortingModePopup.this.setVisible(false);
        }
    }
}

