/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.bean.web.LiteBulletinAttachment;
import com.blisscloud.ezuc.bean.web.LiteBulletinDetail;
import com.blisscloud.ezuc.bean.web.LiteBulletinHeader;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bulletin.LoadSubjectPhotoPanel;
import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.component.GlassPanelCallback;
import com.blisscloud.ezuc.client.main.SelectChatroomDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatSendFileTask;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ForwardData;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.task.GetBulletinSubjectPhotoTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.AppUtils;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class BulletinArea
extends JFXPanel
implements DomService {
    private static final long serialVersionUID = 3967061380118977394L;
    private static final String KEY_SRC = "src";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_HEIGHT = "height";
    private static final String KEY_STYLE = "style";
    private static final String KEY_ATTACHMENT_INDEX = "attachmentIndex";
    private static final String KEY_BULLETIN_INDEX = "bulletinIndex";
    private static final String KEY_ID = "id";
    private static final String KEY_COMMAND = "command";
    private static final String ACTION_SELECT_ALL = "selectAll";
    private static final String ACTION_OPEN_URL = "openUrl";
    private static final String ACTION_SHOW_SUBJECT_PHOTO = "showSubjectPhoto";
    private static final String ACTION_OPEN_ATTACHMENT = "openAttachment";
    private static final String ACTION_CANCEL_DOWNLOAD = "cancelDownload";
    private static final String ACTION_SWITCH_MARK = "switchMark";
    private static final String ACTION_SAVE_FILE = "saveFile";
    private static final String ACTION_FORWARD_FILE = "forwardFile";
    private static final String EVENT_TYPE_CLICK = "click";
    private static final String EVENT_TYPE_DOUBLE_CLICK = "dblclick";
    private static final double MAX_PHOTO_SIZE = 400.0;
    private static final int WIDTH_PROGRESS_BAR = 135;
    private static String bulletinAreaBody = null;
    private static String defaultSubjectPotoURI = null;
    private static String attachmentIconURI = null;
    private static String cancelDownloadIconURI = null;
    private static String markIconURI = null;
    private static String unmarkIconURI = null;
    private Map<String, DownloadFileTask> downloadFileTaskMap = new HashMap<String, DownloadFileTask>();
    ContextMenu menu;
    MenuItem itemCopy;
    MenuItem itemSelectAll;
    private WebView webView;
    private Document document;
    private long mBulletinId;
    EventListener clickListener = new EventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(Event ev) {
            block61: {
                Element targetElem = (Element)((Object)ev.getTarget());
                String targetCommand = targetElem.getAttribute(BulletinArea.KEY_COMMAND);
                final String bulletinIndex = targetElem.getAttribute(BulletinArea.KEY_BULLETIN_INDEX);
                if (BulletinArea.ACTION_SELECT_ALL.equals(targetCommand)) {
                    String keyId = targetElem.getAttribute(BulletinArea.KEY_ID);
                    BulletinArea.this.webView.getEngine().executeScript("selectText(\"" + keyId + "\");");
                } else if (BulletinArea.ACTION_OPEN_URL.equals(targetCommand)) {
                    String urlToOpen = targetElem.getAttribute("urlToOpen");
                    try {
                        Desktop.getDesktop().browse(new URL(urlToOpen).toURI());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (BulletinArea.ACTION_SHOW_SUBJECT_PHOTO.equals(targetCommand)) {
                    Log.i(BulletinArea.class.getSimpleName(), "Click Subject Photo ---------");
                    try {
                        long bulletinId = Long.parseLong(bulletinIndex);
                        LiteBulletinDetail detail = UCDBBulletin.getBulletinDetail(UCChatClient.context, bulletinId);
                        if (detail == null) {
                            return;
                        }
                        if (TextUtils.isBlank((CharSequence)detail.getSubjectPhoto())) {
                            return;
                        }
                        File photoFile = FileUtil.getBulletinSubjectPhoto(bulletinId);
                        if (photoFile == null) {
                            return;
                        }
                        LoadSubjectPhotoPanel lip = new LoadSubjectPhotoPanel();
                        lip.showImage(photoFile, "Bulletin-" + bulletinId + ".png");
                        UCChatClient.getInstance().showGlassPanel(lip, true, false, null, new GlassPanelCallback(this){

                            @Override
                            public void onHide() {
                            }
                        });
                    }
                    catch (Exception e) {
                        Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                } else if (BulletinArea.ACTION_OPEN_ATTACHMENT.equals(targetCommand)) {
                    Log.i(BulletinArea.class.getSimpleName(), "Open attachment ---------");
                    try {
                        8 e = this;
                        synchronized (e) {
                            String attachmentIndexStr = targetElem.getAttribute(BulletinArea.KEY_ATTACHMENT_INDEX);
                            if (TextUtils.isBlank((CharSequence)attachmentIndexStr)) {
                                return;
                            }
                            int attIndex = -1;
                            try {
                                attIndex = Integer.parseInt(attachmentIndexStr);
                            }
                            catch (Throwable t) {
                                return;
                            }
                            long bulletinId = Long.parseLong(bulletinIndex);
                            String key = BulletinArea.this.getAttKey(bulletinId, attIndex);
                            if (BulletinArea.this.downloadFileTaskMap.containsKey(key)) {
                                Log.i(BulletinArea.class.getSimpleName(), "Downloading , skip now ...");
                                return;
                            }
                            LiteBulletinAttachment att = UCDBBulletin.getBulletinAttachment(UCChatClient.context, bulletinId, attIndex);
                            if (att == null) {
                                return;
                            }
                            String fileDownloadURL = att.getUrl();
                            File cacheFile = FileUtil.getBulletinAttachment(bulletinId, attIndex);
                            File validNameFile = new File(FileUtil.getTempDir(), FileUtil.extractFileName(att.getFileName()));
                            if (validNameFile.exists() && validNameFile.length() != att.getSize()) {
                                Log.i(BulletinArea.class.getSimpleName(), "validNameFile " + att.getSize() + " exist but size incorrect, delete and redownload now ...");
                                validNameFile.delete();
                            }
                            if (cacheFile.exists() && cacheFile.length() != att.getSize()) {
                                Log.i(BulletinArea.class.getSimpleName(), "cacheFile " + att.getSize() + " exist but size incorrect, delete and redownload now ...");
                                cacheFile.delete();
                            }
                            if (validNameFile.exists()) {
                                BulletinArea.openFile(validNameFile);
                            } else if (cacheFile.exists()) {
                                Files.copy(cacheFile.toPath(), validNameFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                BulletinArea.openFile(validNameFile);
                            } else {
                                if (TextUtils.isBlank((CharSequence)fileDownloadURL)) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("media_filepath_is_corrupted"), 10);
                                    return;
                                }
                                int index = fileDownloadURL.indexOf("/ucrm");
                                if (index == -1) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("media_filepath_is_corrupted"), 10);
                                    return;
                                }
                                BulletinArea.this.appendFileDownloadProgressBar(bulletinId, attIndex);
                                String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
                                DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, att.getSize(), new MyDownloadOpenTaskCallBack(bulletinId, attIndex, att.getFileName(), cacheFile));
                                BulletinArea.this.putTask(key, task);
                                task.start();
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                } else if (BulletinArea.ACTION_CANCEL_DOWNLOAD.equals(targetCommand)) {
                    Log.i(BulletinArea.class.getSimpleName(), "Cancel download ---------");
                    try {
                        long bulletinId = Long.parseLong(bulletinIndex);
                        String attachmentIndexStr = targetElem.getAttribute(BulletinArea.KEY_ATTACHMENT_INDEX);
                        if (TextUtils.isBlank((CharSequence)attachmentIndexStr)) {
                            return;
                        }
                        int attIndex = -1;
                        try {
                            attIndex = Integer.parseInt(attachmentIndexStr);
                        }
                        catch (Throwable t) {
                            return;
                        }
                        DownloadFileTask task = BulletinArea.this.downloadFileTaskMap.get(BulletinArea.this.getAttKey(bulletinId, attIndex));
                        task.cancel();
                    }
                    catch (Exception e) {
                        Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                } else if (BulletinArea.ACTION_SWITCH_MARK.equals(targetCommand)) {
                    try {
                        long bulletinId = Long.parseLong(bulletinIndex);
                        LiteBulletinHeader header = UCDBBulletin.getBulletinHeader(UCChatClient.context, bulletinId);
                        if (header.isMark()) {
                            UCDBRemoteMark.deleteRemoteMark((Context)UCChatClient.context, 4, bulletinId);
                            UCDBRemoteMark.addRemoteMark((Context)UCChatClient.context, 5, bulletinId);
                            UCDBBulletin.markBulletinAsMarked(UCChatClient.context, bulletinId, false);
                            Element imgMarkIcon = BulletinArea.this.document.getElementById("bulletinMarkImg");
                            imgMarkIcon.setAttribute(BulletinArea.KEY_SRC, unmarkIconURI);
                            WebAgent.getInstance().markBulletinAsUnmark(bulletinId);
                            BroadcastUtil.sendBulletinStatusChangedEvent(UCChatClient.context, bulletinId);
                            break block61;
                        }
                        UCDBRemoteMark.deleteRemoteMark((Context)UCChatClient.context, 5, bulletinId);
                        UCDBRemoteMark.addRemoteMark((Context)UCChatClient.context, 4, bulletinId);
                        UCDBBulletin.markBulletinAsMarked(UCChatClient.context, bulletinId, true);
                        Element imgMarkIcon = BulletinArea.this.document.getElementById("bulletinMarkImg");
                        imgMarkIcon.setAttribute(BulletinArea.KEY_SRC, markIconURI);
                        WebAgent.getInstance().markBulletinAsMark(bulletinId);
                        BroadcastUtil.sendBulletinStatusChangedEvent(UCChatClient.context, bulletinId);
                    }
                    catch (Exception e) {
                        Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                } else if (BulletinArea.ACTION_FORWARD_FILE.equals(targetCommand)) {
                    boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
                    if (!hasChatPermission) {
                        return;
                    }
                    final String attachmentIndexStr = targetElem.getAttribute(BulletinArea.KEY_ATTACHMENT_INDEX);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                2 var1_1 = this;
                                synchronized (var1_1) {
                                    if (TextUtils.isBlank((CharSequence)attachmentIndexStr)) {
                                        return;
                                    }
                                    int attIndex = -1;
                                    try {
                                        attIndex = Integer.parseInt(attachmentIndexStr);
                                    }
                                    catch (Throwable t) {
                                        return;
                                    }
                                    long bulletinId = Long.parseLong(bulletinIndex);
                                    String key = BulletinArea.this.getAttKey(bulletinId, attIndex);
                                    if (BulletinArea.this.downloadFileTaskMap.containsKey(key)) {
                                        Log.i(BulletinArea.class.getSimpleName(), "Downloading , skip now ...");
                                        return;
                                    }
                                    if (attIndex != -1) {
                                        LiteBulletinAttachment att = UCDBBulletin.getBulletinAttachment(UCChatClient.context, bulletinId, attIndex);
                                        if (att == null) {
                                            return;
                                        }
                                        BulletinArea.this.forwardMessage(bulletinId, att);
                                    } else {
                                        BulletinArea.this.forwardMessage(bulletinId, null);
                                    }
                                }
                            }
                            catch (Exception e) {
                                Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                            }
                        }
                    });
                } else if (BulletinArea.ACTION_SAVE_FILE.equals(targetCommand)) {
                    try {
                        8 hasChatPermission = this;
                        synchronized (hasChatPermission) {
                            String attachmentIndexStr = targetElem.getAttribute(BulletinArea.KEY_ATTACHMENT_INDEX);
                            if (TextUtils.isBlank((CharSequence)attachmentIndexStr)) {
                                return;
                            }
                            int attIndex = -1;
                            try {
                                attIndex = Integer.parseInt(attachmentIndexStr);
                            }
                            catch (Throwable t) {
                                return;
                            }
                            long bulletinId = Long.parseLong(bulletinIndex);
                            String key = BulletinArea.this.getAttKey(bulletinId, attIndex);
                            if (BulletinArea.this.downloadFileTaskMap.containsKey(key)) {
                                Log.i(BulletinArea.class.getSimpleName(), "Downloading , skip now ...");
                                return;
                            }
                            if (attIndex != -1) {
                                LiteBulletinAttachment att = UCDBBulletin.getBulletinAttachment(UCChatClient.context, bulletinId, attIndex);
                                if (att == null) {
                                    return;
                                }
                                BulletinArea.this.saveAs(bulletinId, att);
                            } else {
                                BulletinArea.this.saveAs(bulletinId, null);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    };

    public BulletinArea(long bulletinId) {
        this.mBulletinId = bulletinId;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BulletinArea.this.initJavaFXComponent();
            }
        });
    }

    @Override
    public Element createElement(String tag) {
        return this.document.createElement(tag);
    }

    @Override
    public Element getElementById(String key) {
        return this.document.getElementById(key);
    }

    @Override
    public Text createTextNode(String content) {
        return this.document.createTextNode(content);
    }

    @Override
    public void registerPhotoKey(String key, String jid) {
    }

    @Override
    public void registerRefPhotoKey(String key, String jid) {
    }

    @Override
    public void registerRefKey(String key, String packetId) {
    }

    @Override
    public void addEventListener(Element element, String event) {
        ((EventTarget)((Object)element)).addEventListener(event, this.clickListener, false);
    }

    @Override
    public void addErrorEventListener(Element element, String event) {
    }

    protected void initJavaFXComponent() {
        this.itemCopy = new MenuItem(I18NUtil.getString("common_btn_copy"));
        this.itemCopy.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                String selection = (String)BulletinArea.this.webView.getEngine().executeScript("window.getSelection().toString();");
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(selection);
                clipboard.setContent((Map)content);
            }
        });
        this.itemSelectAll = new MenuItem(I18NUtil.getString("chat_btn_content_select_all"));
        this.itemSelectAll.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent e) {
                String selectionAll = (String)BulletinArea.this.webView.getEngine().executeScript("var selection = window.getSelection();var rangeToSelect = document.createRange(); rangeToSelect.selectNodeContents(document.documentElement); selection.removeAllRanges(); selection.addRange(rangeToSelect);");
            }
        });
        this.menu = new ContextMenu();
        this.menu.getItems().addAll(this.itemCopy, this.itemSelectAll);
        this.webView = new WebView();
        this.webView.setContextMenuEnabled(false);
        this.webView.setOnKeyPressed(event -> {
            if ((event.isControlDown() || event.isMetaDown()) && (event.getCode() == KeyCode.C || "c".equalsIgnoreCase(event.getText()))) {
                String selection = (String)this.webView.getEngine().executeScript("window.getSelection().toString();");
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(selection);
                clipboard.setContent((Map)content);
                event.consume();
            }
        });
        this.webView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouse) {
                if (mouse.getButton() == MouseButton.SECONDARY) {
                    String selection = (String)BulletinArea.this.webView.getEngine().executeScript("window.getSelection().toString()");
                    BulletinArea.this.itemCopy.setDisable(TextUtils.isBlank((CharSequence)selection));
                    BulletinArea.this.menu.show((Node)BulletinArea.this.webView, mouse.getScreenX(), mouse.getScreenY());
                } else if (BulletinArea.this.menu != null) {
                    BulletinArea.this.menu.hide();
                }
            }
        });
        Set nodes = this.webView.lookupAll(".scroll-bar");
        for (Node node : nodes) {
            ScrollBar scroll;
            if (!ScrollBar.class.isInstance(node) || (scroll = (ScrollBar)node).getOrientation() != Orientation.VERTICAL) continue;
            scroll.setPrefWidth(18.0);
            scroll.valueProperty().addListener(new ChangeListener<Number>(this){

                @Override
                public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                }
            });
            break;
        }
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)this.webView);
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        final WebEngine webEngine = this.webView.getEngine();
        webEngine.loadContent(bulletinAreaBody.toString());
        webEngine.getLoadWorker().stateProperty().addListener(new ChangeListener<Worker.State>(){

            @Override
            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    BulletinArea.this.document = webEngine.getDocument();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BulletinArea.this.initialData();
                                BulletinArea.this.configureBulletinId(BulletinArea.this.mBulletinId);
                                BulletinArea.this.loadContent(BulletinArea.this.mBulletinId);
                            }
                            catch (UCThreadException e) {
                                Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                            }
                        }
                    });
                }
            }
        });
    }

    public void initialData() {
        Element photoeElement = this.document.getElementById("bulletinSubjectPhoto");
        photoeElement.setAttribute(KEY_COMMAND, ACTION_SHOW_SUBJECT_PHOTO);
        this.addEventListener(photoeElement, EVENT_TYPE_CLICK);
        Element imgMarkIcon = this.document.getElementById("bulletinMarkImg");
        imgMarkIcon.setAttribute(KEY_COMMAND, ACTION_SWITCH_MARK);
        this.addEventListener(imgMarkIcon, EVENT_TYPE_CLICK);
        Element linkForward = this.document.getElementById("btnForward_subject_Photo");
        linkForward.setAttribute(KEY_COMMAND, ACTION_FORWARD_FILE);
        linkForward.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(-1));
        this.addEventListener(linkForward, EVENT_TYPE_CLICK);
        Element linkSave = this.document.getElementById("btnSave_subject_Photo");
        linkSave.setAttribute(KEY_COMMAND, ACTION_SAVE_FILE);
        linkSave.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(-1));
        this.addEventListener(linkSave, EVENT_TYPE_CLICK);
        for (int i = 0; i < 5; ++i) {
            this.initialBulletinAttachment(i);
        }
    }

    private void initialBulletinAttachment(int i) {
        Element imgIcon = this.document.getElementById("bulletinAttachImg_" + i);
        Element divName = this.document.getElementById("bulletin_attachment_name_" + i);
        Element divSize = this.document.getElementById("bulletin_attachment_size_" + i);
        Element linkForward = this.document.getElementById("btnForward_" + i);
        Element linkSave = this.document.getElementById("btnSave_" + i);
        Element elem_cancelDownload = this.document.getElementById("cancelDownload_" + i);
        imgIcon.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(i));
        imgIcon.setAttribute(KEY_COMMAND, ACTION_OPEN_ATTACHMENT);
        this.addEventListener(imgIcon, EVENT_TYPE_CLICK);
        divName.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(i));
        divName.setAttribute(KEY_COMMAND, ACTION_OPEN_ATTACHMENT);
        this.addEventListener(divName, EVENT_TYPE_CLICK);
        divSize.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(i));
        divSize.setAttribute(KEY_COMMAND, ACTION_OPEN_ATTACHMENT);
        this.addEventListener(divSize, EVENT_TYPE_CLICK);
        linkForward.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(i));
        linkForward.setAttribute(KEY_COMMAND, ACTION_FORWARD_FILE);
        this.addEventListener(linkForward, EVENT_TYPE_CLICK);
        linkSave.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(i));
        linkSave.setAttribute(KEY_COMMAND, ACTION_SAVE_FILE);
        this.addEventListener(linkSave, EVENT_TYPE_CLICK);
        elem_cancelDownload.setAttribute(KEY_ATTACHMENT_INDEX, String.valueOf(i));
        elem_cancelDownload.setAttribute(KEY_COMMAND, ACTION_CANCEL_DOWNLOAD);
        this.addEventListener(elem_cancelDownload, EVENT_TYPE_CLICK);
    }

    public void configureBulletinId(long bulletinId) {
        Element photoeElement = this.document.getElementById("bulletinSubjectPhoto");
        photoeElement.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
        Element imgMarkIcon = this.document.getElementById("bulletinMarkImg");
        imgMarkIcon.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
        Element linkForwardSubjectPhoto = this.document.getElementById("btnForward_subject_Photo");
        linkForwardSubjectPhoto.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
        Element linkSaveSubjectPhoto = this.document.getElementById("btnSave_subject_Photo");
        linkSaveSubjectPhoto.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
        for (int i = 0; i < 5; ++i) {
            Element imgIcon = this.document.getElementById("bulletinAttachImg_" + i);
            Element divName = this.document.getElementById("bulletin_attachment_name_" + i);
            Element divSize = this.document.getElementById("bulletin_attachment_size_" + i);
            Element linkForward = this.document.getElementById("btnForward_" + i);
            Element linkSave = this.document.getElementById("btnSave_" + i);
            Element elem_cancelDownload = this.document.getElementById("cancelDownload_" + i);
            imgIcon.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
            divName.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
            divSize.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
            linkForward.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
            linkSave.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
            elem_cancelDownload.setAttribute(KEY_BULLETIN_INDEX, String.valueOf(bulletinId));
        }
    }

    public void reloadContent(long bulletinId) {
        this.mBulletinId = bulletinId;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    BulletinArea.this.configureBulletinId(BulletinArea.this.mBulletinId);
                    BulletinArea.this.loadContent(BulletinArea.this.mBulletinId);
                }
                catch (UCThreadException e) {
                    Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void loadContent(long bulletinId) throws UCThreadException {
        LiteBulletinHeader header = UCDBBulletin.getBulletinHeader(UCChatClient.context, bulletinId);
        LiteBulletinDetail detail = UCDBBulletin.getBulletinDetail(UCChatClient.context, bulletinId);
        Element elem_bulletinSubject = this.document.getElementById("bulletinSubject");
        this.cleanTextNodes(elem_bulletinSubject);
        elem_bulletinSubject.appendChild(this.document.createTextNode(header.getSubject()));
        String timeStamp = DateTimeUtil.getBulletinTimeStr(header.getStart());
        Element elem_bulletinTimeTd = this.document.getElementById("bulletinTime");
        this.cleanTextNodes(elem_bulletinTimeTd);
        elem_bulletinTimeTd.appendChild(this.document.createTextNode(timeStamp));
        Element imgMarkIcon = this.document.getElementById("bulletinMarkImg");
        if (header.isMark()) {
            imgMarkIcon.setAttribute(KEY_SRC, markIconURI);
        } else {
            imgMarkIcon.setAttribute(KEY_SRC, unmarkIconURI);
        }
        Element elem_bulletinReadCountTd = this.document.getElementById("bulletinReadCount");
        this.cleanTextNodes(elem_bulletinReadCountTd);
        elem_bulletinReadCountTd.appendChild(this.document.createTextNode(String.format(I18NUtil.getString("chat_title_msg_read_with_count"), detail.getCount())));
        this.loadSubjectPhoto(bulletinId, detail);
        Element elem_bulletinContent = this.document.getElementById("bulletinContent");
        elem_bulletinContent.setAttribute(KEY_ID, "bulletinContent");
        elem_bulletinContent.setAttribute(KEY_COMMAND, ACTION_SELECT_ALL);
        this.addEventListener(elem_bulletinContent, EVENT_TYPE_DOUBLE_CLICK);
        this.cleanTextNodes(elem_bulletinContent);
        ChatTextWriter writer = new ChatTextWriter((DomService)this, elem_bulletinContent, null, null, null);
        MsgTextConverter.convertAndAppendText(detail.getContent(), writer);
        this.loadAttachments(bulletinId, detail);
        this.webView.getEngine().executeScript("var selection = window.getSelection(); selection.removeAllRanges();");
    }

    private void loadSubjectPhoto(long bulletinId, LiteBulletinDetail detail) {
        boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
        if (TextUtils.isNotBlank((CharSequence)detail.getSubjectPhoto())) {
            Element photoeLayoutElement = this.document.getElementById("bulletinSubjectPhotoLayout");
            photoeLayoutElement.setAttribute(KEY_STYLE, "display:;");
            Element photoeElement = this.document.getElementById("bulletinSubjectPhoto");
            if (!FileUtil.existBulletinSubjectPhoto(bulletinId)) {
                GetBulletinSubjectPhotoTask task = new GetBulletinSubjectPhotoTask(UCChatClient.context, detail.getId(), detail.getSubjectPhoto());
                TaskController.getInstance().addTask(task);
                task.start();
                this.showDefaultImg(photoeElement);
            } else {
                try {
                    File photoFile = FileUtil.getBulletinSubjectPhoto(bulletinId);
                    BufferedImage image = FileUtil.readBulletinSubjectPhoto(bulletinId);
                    double ratio = 1.0;
                    ratio = image.getWidth() > image.getHeight() ? 400.0 / (double)image.getWidth() : 400.0 / (double)image.getHeight();
                    int imageWidth = Double.valueOf((double)image.getWidth() * ratio).intValue();
                    int imageHeight = Double.valueOf((double)image.getHeight() * ratio).intValue();
                    photoeElement.setAttribute(KEY_WIDTH, String.valueOf(imageWidth));
                    photoeElement.setAttribute(KEY_HEIGHT, String.valueOf(imageHeight));
                    photoeElement.setAttribute(KEY_SRC, photoFile.toURI().toString() + "?" + System.currentTimeMillis());
                }
                catch (Throwable t) {
                    this.showDefaultImg(photoeElement);
                }
            }
        } else {
            Element photoeElement = this.document.getElementById("bulletinSubjectPhotoLayout");
            photoeElement.setAttribute(KEY_STYLE, "display:none;");
        }
        if (hasChatPermission) {
            btnForward = this.document.getElementById("btnForward_subject_Photo");
            btnForward.setAttribute(KEY_STYLE, "display:;");
        } else {
            btnForward = this.document.getElementById("btnForward_subject_Photo");
            btnForward.setAttribute(KEY_STYLE, "display:none;");
        }
    }

    private void showDefaultImg(Element photoeElement) {
        Image image = new ImageIcon(UIConstants.class.getClassLoader().getResource("images/bulletin/bulletin_photo_default.png")).getImage();
        double ratio = 1.0;
        ratio = image.getWidth(null) > image.getHeight(null) ? 400.0 / (double)image.getWidth(null) : 400.0 / (double)image.getHeight(null);
        int imageWidth = Double.valueOf((double)image.getWidth(null) * ratio).intValue();
        int imageHeight = Double.valueOf((double)image.getHeight(null) * ratio).intValue();
        photoeElement.setAttribute(KEY_WIDTH, String.valueOf(imageWidth));
        photoeElement.setAttribute(KEY_HEIGHT, String.valueOf(imageHeight));
        photoeElement.setAttribute(KEY_SRC, defaultSubjectPotoURI);
    }

    private void loadAttachments(long bulletinId, LiteBulletinDetail detail) {
        boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
        for (int i = 0; i < 5; ++i) {
            Element btnForward;
            Element box = this.document.getElementById("downloadProgressBox_" + i);
            box.setAttribute(KEY_STYLE, "display:none;");
            Element att = this.document.getElementById("bulletinAttachments_" + i);
            att.setAttribute(KEY_STYLE, "display:none;");
            if (hasChatPermission) {
                btnForward = this.document.getElementById("btnForward_" + i);
                btnForward.setAttribute(KEY_STYLE, "display:;");
                continue;
            }
            btnForward = this.document.getElementById("btnForward_" + i);
            btnForward.setAttribute(KEY_STYLE, "display:none;");
        }
        ArrayList<LiteBulletinAttachment> attachments = detail.getFiles();
        if (attachments != null && attachments.size() != 0) {
            for (int i = 0; i < attachments.size(); ++i) {
                LiteBulletinAttachment attach = attachments.get(i);
                this.appendBulletinAttachment(attach);
                if (!this.downloadFileTaskMap.containsKey(this.getAttKey(bulletinId, attach.getIndex()))) continue;
                this.appendFileDownloadProgressBar(bulletinId, attach.getIndex());
            }
        }
    }

    private void appendBulletinAttachment(LiteBulletinAttachment attach) {
        Element att = this.document.getElementById("bulletinAttachments_" + attach.getIndex());
        att.setAttribute(KEY_STYLE, "display:;");
        Element divName = this.document.getElementById("bulletin_attachment_name_" + attach.getIndex());
        Element divSize = this.document.getElementById("bulletin_attachment_size_" + attach.getIndex());
        this.cleanTextNodes(divName);
        this.cleanTextNodes(divSize);
        divName.appendChild(this.document.createTextNode(attach.getFileName()));
        divSize.appendChild(this.document.createTextNode(FileUtil.getFileSizeText(attach.getSize())));
    }

    private void putTask(String attKey, DownloadFileTask task) {
        this.downloadFileTaskMap.put(attKey, task);
    }

    private String getAttKey(long bulletinId, int attIndex) {
        return bulletinId + "_" + attIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forwardMessage(final long bulletinId, final LiteBulletinAttachment att) {
        SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
        scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
        if (result == null) {
            return;
        }
        try {
            if (att == null) {
                File cacheFile = FileUtil.getBulletinSubjectPhoto(bulletinId);
                if (!cacheFile.exists()) return;
                BulletinArea.doForwardAfterDownloadFinish(bulletinId, null, result.getChatroomJids());
                return;
            } else {
                File cacheFile = FileUtil.getBulletinAttachment(bulletinId, att.getIndex());
                if (cacheFile.exists()) {
                    BulletinArea.doForwardAfterDownloadFinish(bulletinId, att, result.getChatroomJids());
                    return;
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BulletinArea.this.appendFileDownloadProgressBar(bulletinId, att.getIndex());
                        }
                    });
                    String fileDownloadURL = att.getUrl();
                    String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
                    DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, att.getSize(), new MyDownloadForwardAsTaskCallBack(bulletinId, att, cacheFile, result.getChatroomJids()));
                    this.putTask(this.getAttKey(bulletinId, att.getIndex()), task);
                    task.start();
                }
            }
            return;
        }
        catch (Exception e) {
            Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    public static void doForwardAfterDownloadFinish(long bulletinId, LiteBulletinAttachment att, List<String> targetSelectedJids) {
        ForwardData forwardData = new ForwardData();
        File attFile = null;
        if (att == null) {
            LiteBulletinDetail detial = UCDBBulletin.getBulletinDetail(UCChatClient.context, bulletinId);
            if (detial == null) {
                return;
            }
            attFile = FileUtil.getBulletinSubjectPhoto(bulletinId);
            if (!attFile.exists()) {
                return;
            }
            forwardData.setFileName("bulletin_photo_" + bulletinId + ".png");
            forwardData.setFileDownloadURL(detial.getSubjectPhoto());
            forwardData.setMsgType(5);
            forwardData.setIndex(-1);
            forwardData.setFileContent(AppUtils.genThumbnailPhoto(attFile));
            forwardData.setFileSize(attFile.length());
        } else {
            attFile = FileUtil.getBulletinAttachment(bulletinId, att.getIndex());
            if (!attFile.exists()) {
                return;
            }
            forwardData.setFileName(att.getFileName());
            forwardData.setFileDownloadURL(att.getUrl());
            String mimeType = FileUtil.getFileMimeType(att.getFileName());
            if (mimeType != null) {
                if (mimeType.startsWith("image/")) {
                    forwardData.setMsgType(5);
                } else if (mimeType.startsWith("video/")) {
                    forwardData.setMsgType(4);
                } else {
                    forwardData.setMsgType(11);
                }
            } else {
                forwardData.setMsgType(11);
            }
            if (forwardData.getMsgType() == 5) {
                forwardData.setFileContent(AppUtils.genThumbnailPhoto(attFile));
                forwardData.setFileSize(attFile.length());
            } else if (forwardData.getMsgType() == 4) {
                forwardData.setFileContent(AppUtils.genThumbnailVideo(attFile));
                forwardData.setFileSize(attFile.length());
            } else {
                forwardData.setFileSize(attFile.length());
            }
        }
        File cacheFile = FileUtil.getDownloadCacheFile(forwardData.getFileDownloadURL());
        try {
            Files.copy(attFile.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (targetSelectedJids != null) {
            ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
            for (String receiverJid : targetSelectedJids) {
                chatReceiverList.add(new ChatReceiver(receiverJid));
            }
            ChatSendFileTask task = new ChatSendFileTask(null, chatReceiverList, forwardData.getFileName(), forwardData.getFileSize(), forwardData.getFileContent(), forwardData.getMsgType());
            task.setFileDownloadUrl(forwardData.getFileDownloadURL());
            task.setDuration(forwardData.getFileSize());
            WebAgent.getInstance().sendChatFile(task);
            if (PreferencesUtil.isSyncOldChatEventDone(UCChatClient.context)) {
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
                BroadcastUtil.sendMsgChangedEvent(UCChatClient.context, task.getReceiverJidList(), true);
            }
            if (chatReceiverList.size() > 0) {
                ChatReceiver lastReceiver = (ChatReceiver)chatReceiverList.get(chatReceiverList.size() - 1);
                AppUtils.startChat(UCChatClient.context, lastReceiver.getReceiverJid());
            }
        }
    }

    private void saveAs(long bulletinId, LiteBulletinAttachment att) throws UCThreadException {
        Object fileName = null;
        fileName = att == null ? "bulletin_photo_" + bulletinId + ".png" : att.getFileName();
        File saveAsFile = DomUtil.selectFileFromChooser(this.webView.getScene().getWindow(), (String)fileName);
        if (saveAsFile != null) {
            try {
                if (att == null) {
                    File cacheFile = FileUtil.getBulletinSubjectPhoto(bulletinId);
                    if (cacheFile.exists()) {
                        Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                    }
                } else {
                    File cacheFile = FileUtil.getBulletinAttachment(bulletinId, att.getIndex());
                    if (cacheFile.exists()) {
                        Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                    } else {
                        this.appendFileDownloadProgressBar(bulletinId, att.getIndex());
                        String fileDownloadURL = att.getUrl();
                        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
                        DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, att.getSize(), new MyDownloadSaveAsTaskCallBack(bulletinId, att.getIndex(), cacheFile, saveAsFile));
                        task.start();
                        this.putTask(this.getAttKey(bulletinId, att.getIndex()), task);
                    }
                }
            }
            catch (Exception e) {
                Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
            }
        }
    }

    private static void openFile(File namedFile) {
        try {
            Desktop.getDesktop().open(namedFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void appendFileDownloadProgressBar(long bulletinId, int attachIndex) {
        DownloadFileTask task = this.downloadFileTaskMap.get(this.getAttKey(bulletinId, attachIndex));
        if (task != null && task.getProgress() != 100 && task.getProgress() != 0) {
            int percent = task.getProgress();
            Element elem_progressBox = this.document.getElementById("downloadProgressBox_" + attachIndex);
            elem_progressBox.setAttribute(KEY_STYLE, "display:inline; padding-left:8px");
            Element elem_progressPercentBar = this.document.getElementById("downloadProgressPercentBar_" + attachIndex);
            int percentWidth = 135 * percent / 100;
            elem_progressPercentBar.setAttribute(KEY_STYLE, "width:" + percentWidth + "px;");
            this.cleanTextNodes(elem_progressPercentBar);
            Element elem_progressPercentText = this.document.getElementById("downloadProgressPercentText_" + attachIndex);
            this.cleanTextNodes(elem_progressPercentText);
            elem_progressPercentText.appendChild(this.document.createTextNode(percent + "%"));
        } else {
            Element elem_progressBox = this.document.getElementById("downloadProgressBox_" + attachIndex);
            elem_progressBox.setAttribute(KEY_STYLE, "display:none;");
            Element elem_progressPercentBar = this.document.getElementById("downloadProgressPercentBar_" + attachIndex);
            elem_progressPercentBar.setAttribute(KEY_STYLE, "width:0px;");
            this.cleanTextNodes(elem_progressPercentBar);
            Element elem_progressPercentText = this.document.getElementById("downloadProgressPercentText_" + attachIndex);
            this.cleanTextNodes(elem_progressPercentText);
            elem_progressPercentText.appendChild(this.document.createTextNode("0%"));
        }
    }

    public void updateFileDownloadProgress(final Integer attIndex, final int percent) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_progressBox = BulletinArea.this.document.getElementById("downloadProgressBox_" + attIndex);
                elem_progressBox.setAttribute(BulletinArea.KEY_STYLE, "display:inline; padding-left:8px");
                Element elem_progressPercentBar = BulletinArea.this.document.getElementById("downloadProgressPercentBar_" + attIndex);
                int percentWidth = 135 * percent / 100;
                elem_progressPercentBar.setAttribute(BulletinArea.KEY_STYLE, "width:" + percentWidth + "px;");
                Element elem_progressPercentText = BulletinArea.this.document.getElementById("downloadProgressPercentText_" + attIndex);
                BulletinArea.this.cleanTextNodes(elem_progressPercentText);
                elem_progressPercentText.appendChild(BulletinArea.this.document.createTextNode(percent + "%"));
            }
        });
    }

    public void updateFileDownloadCompleted(final Integer attIndex) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_downloadProgressBox = BulletinArea.this.document.getElementById("downloadProgressBox_" + attIndex);
                elem_downloadProgressBox.setAttribute(BulletinArea.KEY_STYLE, "display:none;");
            }
        });
    }

    public void updateFileDownloadCancelled(final Integer attIndex) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_downloadProgressBox = BulletinArea.this.document.getElementById("downloadProgressBox_" + attIndex);
                elem_downloadProgressBox.setAttribute(BulletinArea.KEY_STYLE, "display:none;");
            }
        });
    }

    public void updateFileDownloadFailed(final Integer attIndex) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_downloadProgressBox = BulletinArea.this.document.getElementById("downloadProgressBox_" + attIndex);
                elem_downloadProgressBox.setAttribute(BulletinArea.KEY_STYLE, "display:none;");
            }
        });
    }

    public void updateStatus() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LiteBulletinDetail detail;
                LiteBulletinHeader header = UCDBBulletin.getBulletinHeader(UCChatClient.context, BulletinArea.this.mBulletinId);
                if (header != null && BulletinArea.this.document != null) {
                    Element imgMarkIcon = BulletinArea.this.document.getElementById("bulletinMarkImg");
                    if (header.isMark()) {
                        imgMarkIcon.setAttribute(BulletinArea.KEY_SRC, markIconURI);
                    } else {
                        imgMarkIcon.setAttribute(BulletinArea.KEY_SRC, unmarkIconURI);
                    }
                }
                if ((detail = UCDBBulletin.getBulletinDetail(UCChatClient.context, BulletinArea.this.mBulletinId)) != null && BulletinArea.this.document != null) {
                    BulletinArea.this.renderReadCount(detail);
                }
            }
        });
    }

    private void renderReadCount(LiteBulletinDetail detail) {
        Element elem_bulletinReadCountTd = this.document.getElementById("bulletinReadCount");
        this.cleanTextNodes(elem_bulletinReadCountTd);
        elem_bulletinReadCountTd.appendChild(this.document.createTextNode(String.format(I18NUtil.getString("chat_title_msg_read_with_count"), detail.getCount())));
    }

    private void cleanTextNodes(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                org.w3c.dom.Node node = nodeList.item(i);
                element.removeChild(node);
            }
        }
    }

    public void updatePhoto() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LiteBulletinDetail detail = UCDBBulletin.getBulletinDetail(UCChatClient.context, BulletinArea.this.mBulletinId);
                if (detail != null) {
                    BulletinArea.this.loadSubjectPhoto(BulletinArea.this.mBulletinId, detail);
                }
            }
        });
    }

    public void updateDetails() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LiteBulletinDetail detail = UCDBBulletin.getBulletinDetail(UCChatClient.context, BulletinArea.this.mBulletinId);
                if (detail != null && BulletinArea.this.document != null) {
                    BulletinArea.this.renderReadCount(detail);
                    Element elem_bulletinContent = BulletinArea.this.document.getElementById("bulletinContent");
                    BulletinArea.this.cleanTextNodes(elem_bulletinContent);
                    elem_bulletinContent.appendChild(BulletinArea.this.document.createTextNode(detail.getContent()));
                    BulletinArea.this.loadAttachments(BulletinArea.this.mBulletinId, detail);
                }
            }
        });
    }

    static {
        StringBuilder sb = new StringBuilder();
        try {
            String sCurrentLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(BulletinArea.class.getResourceAsStream("/bulletinArea_body.html")));
            while ((sCurrentLine = br.readLine()) != null) {
                sb.append(sCurrentLine).append('\n');
            }
        }
        catch (IOException e) {
            Log.e(BulletinArea.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        bulletinAreaBody = sb.toString();
        try {
            Locale locale = I18NUtil.getAppLocale();
            bulletinAreaBody = locale == Locale.CHINA || locale == Locale.CHINESE || locale == Locale.SIMPLIFIED_CHINESE ? bulletinAreaBody.replace("$fontFamily", "\"Microsoft YaHei\", \"\u5fae\u8f6f\u96c5\u9ed1\", \"SimSun\", \"\u5b8b\u4f53\", \"Microsoft JhengHei\", \"\u5fae\u8edf\u6b63\u9ed1\u9ad4\", \"PMingLiU\", \"MingLiU\", serif") : bulletinAreaBody.replace("$fontFamily", "\"Microsoft JhengHei\", \"\u5fae\u8edf\u6b63\u9ed1\u9ad4\", \"Microsoft YaHei\", \"\u5fae\u8f6f\u96c5\u9ed1\", \"SimSun\", \"\u5b8b\u4f53\", \"PMingLiU\", \"MingLiU\", serif");
        }
        catch (Throwable t) {
            Log.e(BulletinArea.class.getSimpleName(), t.getLocalizedMessage(), t);
        }
        try {
            String uri = BulletinArea.class.getClassLoader().getResource("images/background_chatroom.jpg").toURI().toString();
            bulletinAreaBody = bulletinAreaBody.replace("$bodyBackgroundURL", uri);
        }
        catch (URISyntaxException e1) {
            Log.e(BulletinArea.class.getSimpleName(), e1.getLocalizedMessage(), e1);
        }
        try {
            defaultSubjectPotoURI = BulletinArea.class.getClassLoader().getResource("images/bulletin/bulletin_photo_default.png").toURI().toString();
            attachmentIconURI = BulletinArea.class.getClassLoader().getResource("images/bulletin/bulletin_attach.png").toURI().toString();
            cancelDownloadIconURI = BulletinArea.class.getClassLoader().getResource("images/message/cancelDownload.png").toURI().toString();
            markIconURI = BulletinArea.class.getClassLoader().getResource("images/bulletin/bulletin_list_marked.png").toURI().toString();
            unmarkIconURI = BulletinArea.class.getClassLoader().getResource("images/bulletin/bulletin_list_unmarked.png").toURI().toString();
        }
        catch (URISyntaxException e1) {
            Log.e(BulletinArea.class.getSimpleName(), e1.getLocalizedMessage(), e1);
        }
        try {
            bulletinAreaBody = bulletinAreaBody.replace("$msgSave", I18NUtil.getString("common_btn_save_as"));
            bulletinAreaBody = bulletinAreaBody.replace("$msgForward", I18NUtil.getString("common_btn_forward"));
            bulletinAreaBody = bulletinAreaBody.replace("$attachmentIconUri", attachmentIconURI);
            bulletinAreaBody = bulletinAreaBody.replace("$cancelDownloadIconUri", cancelDownloadIconURI);
        }
        catch (Exception e1) {
            Log.e(BulletinArea.class.getSimpleName(), e1.getLocalizedMessage(), e1);
        }
    }

    class MyDownloadForwardAsTaskCallBack
    implements DownloadFileTaskCallBack {
        long mBulletinIndex;
        List<String> selectedJids;
        LiteBulletinAttachment mAtt;
        File mFile;
        File mSaveAsFile;

        public MyDownloadForwardAsTaskCallBack(long bulletinId, LiteBulletinAttachment att, File fileToSend, List<String> targetSelectedJids) {
            this.mBulletinIndex = bulletinId;
            this.mAtt = att;
            this.mFile = fileToSend;
            this.selectedJids = targetSelectedJids;
        }

        @Override
        public void onFileLengthGot(int length) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadProgress(this.mAtt.getIndex(), progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadCompleted(this.mAtt.getIndex());
            }
            BulletinArea.doForwardAfterDownloadFinish(this.mBulletinIndex, this.mAtt, this.selectedJids);
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mAtt.getIndex()));
        }

        @Override
        public void onDownloadFileCancelled() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadCancelled(this.mAtt.getIndex());
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mAtt.getIndex()));
        }

        @Override
        public void onDownloadFileFailed() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadFailed(this.mAtt.getIndex());
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mAtt.getIndex()));
        }

        @Override
        public void onDownloadFileNotFound() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mAtt.getIndex()));
        }
    }

    class MyDownloadSaveAsTaskCallBack
    implements DownloadFileTaskCallBack {
        long mBulletinIndex;
        Integer mIndex;
        File mFile;
        File mSaveAsFile;

        public MyDownloadSaveAsTaskCallBack(long bulletinId, Integer index, File toFile, File saveAsFile) {
            this.mBulletinIndex = bulletinId;
            this.mIndex = index;
            this.mFile = toFile;
            this.mSaveAsFile = saveAsFile;
        }

        @Override
        public void onFileLengthGot(int length) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadProgress(this.mIndex, progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadCompleted(this.mIndex);
                ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
            }
            try {
                Files.copy(this.mFile.toPath(), this.mSaveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }

        @Override
        public void onDownloadFileCancelled() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadCancelled(this.mIndex);
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }

        @Override
        public void onDownloadFileFailed() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadFailed(this.mIndex);
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }

        @Override
        public void onDownloadFileNotFound() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }
    }

    class MyDownloadOpenTaskCallBack
    implements DownloadFileTaskCallBack {
        long mBulletinIndex;
        Integer mIndex;
        File mCacheFile;
        String mFileName;

        public MyDownloadOpenTaskCallBack(long bulletinId, Integer index, String fileName, File toFile) {
            this.mBulletinIndex = bulletinId;
            this.mIndex = index;
            this.mCacheFile = toFile;
            this.mFileName = fileName;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadProgress(this.mIndex, progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDownloadFileCompleted() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadCompleted(this.mIndex);
            }
            try {
                BulletinArea bulletinArea = BulletinArea.this;
                synchronized (bulletinArea) {
                    File validNamedFile = new File(FileUtil.getTempDir(), FileUtil.extractFileName(this.mFileName));
                    Files.copy(this.mCacheFile.toPath(), validNamedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    BulletinArea.openFile(validNamedFile);
                }
                BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
            }
            catch (Throwable t) {
                Log.i(BulletinArea.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
            }
        }

        @Override
        public void onDownloadFileCancelled() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadCancelled(this.mIndex);
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }

        @Override
        public void onDownloadFileFailed() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                BulletinArea.this.updateFileDownloadFailed(this.mIndex);
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }

        @Override
        public void onDownloadFileNotFound() {
            if (BulletinArea.this.mBulletinId == this.mBulletinIndex) {
                ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
            }
            BulletinArea.this.downloadFileTaskMap.remove(BulletinArea.this.getAttKey(this.mBulletinIndex, this.mIndex));
        }
    }
}

