/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bulletin.BulletinSortingMode;
import com.blisscloud.ezuc.client.component.BubblePanel;
import com.blisscloud.ezuc.client.component.UCPopupWindow;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BulletinFilterMenuPopup
extends UCPopupWindow {
    private static final Color COLOR_SORTING_MODE = new Color(240, 240, 240);
    private JPanel panelContent;
    private SortingModeCallback callback;
    private Map<BulletinSortingMode, Action> sortingModeActionMap = new HashMap<BulletinSortingMode, Action>();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                BulletinFilterMenuPopup inst = new BulletinFilterMenuPopup(frame, BulletinSortingMode.ALL, null);
                inst.setVisible(true);
                inst.setSize(400, 300);
            }
        });
    }

    public BulletinFilterMenuPopup(JFrame frame, BulletinSortingMode defaultSorting, SortingModeCallback callback) {
        super(frame);
        this.initGUI();
        this.initSortingMode(defaultSorting);
        this.callback = callback;
    }

    private void initGUI() {
        try {
            this.panelContent = new BubblePanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(new Color(236, 236, 236));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSortingMode(BulletinSortingMode defaultSorting) {
        BulletinSortingMode[] modes = BulletinSortingMode.values();
        for (int i = 0; i < modes.length; ++i) {
            SortingModeAction sortingModeAction = new SortingModeAction(modes[i], modes[i] == defaultSorting);
            this.sortingModeActionMap.put(modes[i], sortingModeAction);
            JButton btnMode = new JButton(sortingModeAction);
            this.panelContent.add((Component)btnMode, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
            btnMode.setFont(UIConstants.FONT_14_PLAIN);
            btnMode.setForeground(COLOR_SORTING_MODE);
            btnMode.setBorderPainted(false);
            btnMode.setContentAreaFilled(false);
            btnMode.setFocusPainted(false);
            btnMode.setOpaque(false);
            btnMode.setHorizontalAlignment(2);
            btnMode.setCursor(UIConstants.CURSOR_HAND);
        }
    }

    public void setSelectedSortMode(BulletinSortingMode mode) {
        for (BulletinSortingMode _mode : this.sortingModeActionMap.keySet()) {
            Action action = this.sortingModeActionMap.get((Object)_mode);
            action.putValue("SmallIcon", _mode == mode ? UIConstants.ICON_CHECK_MARK : UIConstants.ICON_EMPTY);
        }
    }

    public static interface SortingModeCallback {
        public void onSortingModeChanged(BulletinSortingMode var1);
    }

    class SortingModeAction
    extends AbstractAction {
        BulletinSortingMode mode;

        public SortingModeAction(BulletinSortingMode mode, boolean isSelected) {
            this.mode = mode;
            if (this.mode == BulletinSortingMode.ALL) {
                this.putValue("Name", I18NUtil.getString("bulletin_time"));
            } else if (this.mode == BulletinSortingMode.UNREAD) {
                this.putValue("Name", I18NUtil.getString("bulletin_unread"));
            } else if (this.mode == BulletinSortingMode.MARKED) {
                this.putValue("Name", I18NUtil.getString("bulletin_mark"));
            }
            this.putValue("SmallIcon", isSelected ? UIConstants.ICON_CHECK_MARK : UIConstants.ICON_EMPTY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BulletinFilterMenuPopup.this.callback != null) {
                BulletinFilterMenuPopup.this.callback.onSortingModeChanged(this.mode);
            }
            BulletinFilterMenuPopup.this.setSelectedSortMode(this.mode);
            BulletinFilterMenuPopup.this.setVisible(false);
        }
    }
}

