/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.bulletin.BulletinDetailPanel;
import com.blisscloud.ezuc.client.bulletin.BulletinPanel;
import com.blisscloud.ezuc.client.component.ChatBackgroundPanel;
import com.blisscloud.ezuc.client.component.CustomLineBorder;
import com.blisscloud.ezuc.client.component.GroupPanel;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class BulletinFramePanel
extends JPanel {
    private static final long serialVersionUID = 2614845742448103793L;
    private JSplitPane jSplitPane1;
    private BulletinPanel bulletinPanel;
    private BulletinDetailPanel bulletinView = null;
    private ChatBackgroundPanel backgroundPanel;
    private JPanel detialPanel;
    private boolean tabSelected = false;

    public BulletinFramePanel() {
        this.setLayout(new BorderLayout());
        this.initView();
    }

    private void initView() {
        this.jSplitPane1 = new JSplitPane();
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
        this.backgroundPanel = new ChatBackgroundPanel();
        this.bulletinPanel = new BulletinPanel();
        this.bulletinPanel.setBorder(new CustomLineBorder(GroupPanel.TITLE_BORDER_COLOR, 0, 0, 0, 1));
        this.jSplitPane1.add((Component)this.bulletinPanel, "left");
        this.detialPanel = new JPanel();
        this.detialPanel.setLayout(new BorderLayout());
        this.detialPanel.add((Component)this.backgroundPanel, "Center");
        this.jSplitPane1.add((Component)this.detialPanel, "right");
        int location = PreferencesUtil.getInt(UCChatClient.context, "DIVIDER_LOCATION_BULLETIN", 400);
        int size = PreferencesUtil.getInt(UCChatClient.context, "DIVIDER_SIZE_BULLETIN", -1);
        if (location > 0) {
            this.jSplitPane1.setDividerLocation(location);
        }
        if (size > 0) {
            this.jSplitPane1.setDividerSize(size);
        }
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent changeEvent) {
                int xdividerSize;
                JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
                String propertyName = changeEvent.getPropertyName();
                if (propertyName.equals("dividerLocation")) {
                    int xdividerLocation = sourceSplitPane.getDividerLocation();
                    if (xdividerLocation != 0) {
                        PreferencesUtil.putInt(UCChatClient.context, "DIVIDER_LOCATION_BULLETIN", xdividerLocation);
                    }
                } else if (propertyName.equals("dividerSize") && (xdividerSize = BulletinFramePanel.this.jSplitPane1.getDividerSize()) != 0) {
                    PreferencesUtil.putInt(UCChatClient.context, "DIVIDER_SIZE_BULLETIN", xdividerSize);
                }
            }
        });
    }

    public synchronized void showBulletin(Long bulletinId) {
        if (this.bulletinView == null) {
            this.bulletinView = new BulletinDetailPanel(bulletinId);
        } else {
            this.bulletinView.loadBulletin(bulletinId);
        }
        this.detialPanel.remove(this.backgroundPanel);
        this.detialPanel.add((Component)this.bulletinView, "Center");
        this.detialPanel.revalidate();
        this.detialPanel.repaint();
    }

    public synchronized void closeBulletin() {
        if (this.bulletinView != null) {
            this.detialPanel.remove(this.bulletinView);
        }
        this.detialPanel.add((Component)this.backgroundPanel, "Center");
        this.detialPanel.revalidate();
        this.detialPanel.repaint();
    }

    public void onTabSelected(boolean twice) {
        if (twice) {
            this.bulletinPanel.scrollTop();
        }
    }

    public void onTabUnselected() {
        this.tabSelected = false;
    }

    public void refreshData() {
        this.bulletinPanel.prepare();
    }
}

