/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.callRecord;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.callRecord.PhoneHistoryEntryParameter;
import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.main.SelectChatroomDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.tool.PhoneListBorder;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.ExternalCallMessage;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;

public class PhoneHistoryEntryPanel
extends JPanel {
    private static final long serialVersionUID = -8073511014432646353L;
    public static final int ENTRY_HEIGHT = 50;
    private JLabel lblNew;
    private JLabel lblTime;
    private JLabel lblSystemRecording;
    private JLabel lblStatus;
    private JLabel lblReportKey;
    private JLabel lblNumber;
    private JLabel lblDuration;
    private JLabel lblSummary;
    private JLabel lblCustomer;
    private JLabel lblCustomerNo;
    private JLabel lblSuffix;
    private RoundedCornerLabel btnCall;
    private JProgressBar pbDownload;
    private JLabel lblCancelDownload;
    private boolean selected;
    private ExternalCallMessage mMsg;
    private boolean isNewMsg;
    private String numberToDial = null;
    private DownloadFileTask downloadTask = null;
    private PhoneHistoryEntryParameter phoneHistoryEntryParameter = null;
    private static int ICON_SIZE = 20;
    private static int COLUMN_GAP = 10;
    private Timer timer1 = null;

    public PhoneHistoryEntryPanel(ExternalCallMessage msg, boolean isNewMsg, PhoneHistoryEntryParameter parameter) {
        this.mMsg = msg;
        this.isNewMsg = isNewMsg;
        this.phoneHistoryEntryParameter = parameter;
        this.initGui();
        this.initData();
    }

    public ExternalCallMessage getMsg() {
        return this.mMsg;
    }

    public long getId() {
        return this.mMsg.getId();
    }

    public String getNumberToDial() {
        return this.numberToDial;
    }

    public String getNumberNoPrefix() {
        return this.mMsg.getNoPrefixNumber();
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new PhoneListBorder());
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setPreferredSize(new Dimension(800, 50));
        this.setMinimumSize(new Dimension(800, 50));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        this.setOpaque(false);
        int x = 0;
        this.lblNew = new JLabel();
        this.add((Component)this.lblNew, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblNew.setPreferredSize(new Dimension(30, 30));
        this.lblNew.setMaximumSize(new Dimension(30, 30));
        this.lblNew.setMinimumSize(new Dimension(30, 30));
        this.lblSystemRecording = new JLabel();
        this.add((Component)this.lblSystemRecording, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblSystemRecording.setFont(UIConstants.FONT_14_PLAIN);
        this.lblSystemRecording.setCursor(UIConstants.CURSOR_HAND);
        this.lblSystemRecording.setPreferredSize(new Dimension(15, 30));
        this.lblSystemRecording.setMaximumSize(new Dimension(15, 30));
        this.lblSystemRecording.setMinimumSize(new Dimension(15, 30));
        this.lblSystemRecording.setIcon(UIConstants.ICON_PLAY);
        this.lblSystemRecording.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                try {
                    int msgType = PhoneHistoryEntryPanel.this.mMsg.getMsgType();
                    if (msgType == 223 || msgType == 221) {
                        if (!PreferencesUtil.isCheckRecording(UCChatClient.context)) {
                            return;
                        }
                        PhoneHistoryEntryPanel.this.playSystemRecording();
                    } else if (msgType == 1006 || msgType == 13 || msgType == 1005 || msgType == 12) {
                        PhoneHistoryEntryPanel.this.playFile();
                    }
                }
                catch (Exception e) {
                    Log.e(PhoneHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage());
                }
            }
        });
        this.pbDownload = new JProgressBar();
        this.add((Component)this.pbDownload, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.pbDownload.setMinimum(0);
        this.pbDownload.setMaximum(100);
        this.pbDownload.setValue(0);
        this.pbDownload.setStringPainted(true);
        this.pbDownload.setPreferredSize(new Dimension(100, 25));
        this.pbDownload.setMinimumSize(new Dimension(100, 25));
        this.pbDownload.setVisible(false);
        this.lblCancelDownload = new JLabel();
        this.add((Component)this.lblCancelDownload, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.lblCancelDownload.setFont(UIConstants.FONT_14_PLAIN);
        this.lblCancelDownload.setPreferredSize(new Dimension(16, 16));
        this.lblCancelDownload.setMaximumSize(new Dimension(16, 16));
        this.lblCancelDownload.setMinimumSize(new Dimension(16, 16));
        this.lblCancelDownload.setIcon(GraphicUtil.getScaledIcon("images/message/cancelDownload.png", 16, 16));
        this.lblCancelDownload.setVisible(false);
        this.lblCancelDownload.setCursor(UIConstants.CURSOR_HAND);
        this.lblCancelDownload.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                try {
                    if (PhoneHistoryEntryPanel.this.downloadTask != null) {
                        PhoneHistoryEntryPanel.this.downloadTask.cancel();
                        PhoneHistoryEntryPanel.this.downloadTask = null;
                    }
                }
                catch (Exception e) {
                    Log.e(PhoneHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage());
                }
            }
        });
        if (PreferencesUtil.isContactReportKeyDisp(UCChatClient.context)) {
            this.lblReportKey = new JLabel();
            this.add((Component)this.lblReportKey, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblReportKey.setFont(UIConstants.FONT_14_PLAIN);
            this.lblReportKey.setPreferredSize(new Dimension(100, 50));
            this.lblReportKey.setMaximumSize(new Dimension(100, 50));
            this.lblReportKey.setMinimumSize(new Dimension(100, 50));
            this.lblReportKey.setCursor(Cursor.getPredefinedCursor(12));
            this.lblReportKey.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String textToCopy = PhoneHistoryEntryPanel.this.lblReportKey.getText();
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(textToCopy), null);
                }
            });
        }
        this.lblStatus = new JLabel();
        this.add((Component)this.lblStatus, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblStatus.setFont(UIConstants.FONT_14_PLAIN);
        this.lblStatus.setPreferredSize(new Dimension(100, 50));
        this.lblStatus.setMaximumSize(new Dimension(100, 50));
        this.lblStatus.setMinimumSize(new Dimension(100, 50));
        this.lblNumber = new JLabel();
        this.add((Component)this.lblNumber, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblNumber.setFont(UIConstants.FONT_14_PLAIN);
        this.lblNumber.setPreferredSize(new Dimension(150, 50));
        this.lblNumber.setMaximumSize(new Dimension(150, 50));
        this.lblNumber.setMinimumSize(new Dimension(150, 50));
        this.lblCustomerNo = new JLabel();
        this.add((Component)this.lblCustomerNo, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblCustomerNo.setFont(UIConstants.FONT_14_PLAIN);
        this.lblCustomerNo.setPreferredSize(new Dimension(100, 50));
        this.lblCustomerNo.setMaximumSize(new Dimension(100, 50));
        this.lblCustomerNo.setMinimumSize(new Dimension(100, 50));
        this.lblCustomerNo.setVisible(true);
        this.lblCustomer = new JLabel();
        this.add((Component)this.lblCustomer, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblCustomer.setFont(UIConstants.FONT_14_PLAIN);
        this.lblCustomer.setPreferredSize(new Dimension(100, 50));
        this.lblCustomer.setMaximumSize(new Dimension(100, 50));
        this.lblCustomer.setMinimumSize(new Dimension(100, 50));
        this.lblCustomer.setVisible(true);
        this.lblDuration = new JLabel();
        this.add((Component)this.lblDuration, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblDuration.setFont(UIConstants.FONT_14_PLAIN);
        this.lblDuration.setPreferredSize(new Dimension(100, 50));
        this.lblDuration.setMaximumSize(new Dimension(100, 50));
        this.lblDuration.setMinimumSize(new Dimension(100, 50));
        this.lblTime = new JLabel();
        this.add((Component)this.lblTime, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblTime.setFont(UIConstants.FONT_14_PLAIN);
        this.lblTime.setPreferredSize(new Dimension(110, 50));
        this.lblTime.setMaximumSize(new Dimension(110, 50));
        this.lblTime.setMinimumSize(new Dimension(110, 50));
        this.lblSummary = new JLabel();
        this.add((Component)this.lblSummary, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblSummary.setFont(UIConstants.FONT_14_PLAIN);
        this.lblSummary.setPreferredSize(new Dimension(300, 50));
        this.lblSummary.setMaximumSize(new Dimension(300, 50));
        this.lblSummary.setMinimumSize(new Dimension(300, 50));
        this.lblSummary.setVisible(true);
        this.btnCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_callout"), null, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
        this.add((Component)this.btnCall, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.btnCall.setForeground(Color.WHITE);
        this.btnCall.setToolTipText(I18NUtil.getString("abook_popup_btn_talk"));
        this.btnCall.setCursor(UIConstants.CURSOR_HAND);
        this.setCallBtnVisible(false);
        this.btnCall.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneHistoryEntryPanel.this.btnCall.isEnabled() && evt.getButton() == 1) {
                    DialoutManager.dialOtherContactNumberWithPrefix(UCChatClient.context, PhoneHistoryEntryPanel.this.numberToDial);
                }
            }
        });
        this.lblSuffix = new JLabel();
        this.add((Component)this.lblSuffix, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.lblSuffix.setFont(UIConstants.FONT_14_PLAIN);
    }

    private void playSystemRecording() throws Exception {
        if (this.mMsg.getContactRecordId() == null || this.mMsg.getContactRecordId() == 0L) {
            return;
        }
        File sysRecordingDir = MediaFileUtil.getSysRecordingRoot(UCChatClient.context);
        File cacheFile = new File(sysRecordingDir, this.mMsg.getSysRecordingDispName());
        if (cacheFile.exists() && cacheFile.length() == this.mMsg.getFileSize()) {
            Desktop.getDesktop().open(cacheFile);
        } else {
            this.downloadAndOpenSysRecording(cacheFile, this.mMsg.getContactRecordId(), this.mMsg.getEncodedRecordKey(), this.mMsg.getRecordSiteId(), this.mMsg.getFileSize());
        }
    }

    private void downloadAndSaveAsSysRecording(File cacheFile, File saveAs, Long contactRecordLogId, String encodedRecordKey, long recordSiteId, long fileSize) {
        String fileDownloadURL = "/ucrm/file/downloadFile?k=" + encodedRecordKey + "&s=" + recordSiteId + "&type=r";
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL;
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, fileSize, new DownloadSaveAsSysRecordingTaskCallBack(cacheFile, saveAs));
        this.downloadTask.start();
    }

    private void downloadAndForwardSystemRecording(File cacheFile, Long contactRecordLogId, String encodedRecordKey, long recordSiteId, long fileSize, List<ChatReceiver> chatReceiverList) {
        String fileDownloadURL = "/ucrm/file/downloadFile?k=" + encodedRecordKey + "&s=" + recordSiteId + "&type=r";
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL;
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, fileSize, new DownloadForwardSysRecordingTaskCallBack(cacheFile, chatReceiverList));
        this.downloadTask.start();
    }

    private void downloadAndOpenSysRecording(File cacheFile, Long contactRecordLogId, String encodedRecordKey, long recordSiteId, long fileSize) {
        String fileDownloadURL = "/ucrm/file/downloadFile?k=" + encodedRecordKey + "&s=" + recordSiteId + "&type=r";
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL;
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, fileSize, new DownloadOpenSysRecordingTaskCallBack(cacheFile));
        this.downloadTask.start();
    }

    private void playFile() throws Exception {
        VoiceItem item;
        if (!this.mMsg.isPlayed()) {
            ChatRoomManager.markMsgAsPlayed(UCChatClient.context, this.mMsg);
        }
        if ((item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, this.mMsg)) == null) {
            Log.i(PhoneHistoryEntryPanel.class.getSimpleName(), "VoiceItem null:" + this.mMsg.getContent());
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
            return;
        }
        File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
        if (localRecFile != null) {
            if (localRecFile.exists()) {
                Desktop.getDesktop().open(localRecFile);
            }
        } else {
            File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
            if (cacheFile == null) {
                return;
            }
            if (cacheFile.exists()) {
                Desktop.getDesktop().open(cacheFile);
            } else {
                this.downloadAndOpenFile(cacheFile, item);
            }
        }
    }

    private void downloadAndOpenFile(File cacheFile, VoiceItem item) {
        String fileDownloadURL = item.getUrl();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new DownloadOpenTaskCallBack(item, cacheFile));
        this.downloadTask.start();
    }

    private void downloadAndForwardVoiceRecording(File cacheFile, VoiceItem item, List<ChatReceiver> chatReceiverList) {
        String fileDownloadURL = item.getUrl();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new DownloadForwardTaskCallBack(item, cacheFile, chatReceiverList));
        this.downloadTask.start();
    }

    private void downloadAndSaveAsVoiceRecording(File cacheFile, File saveAsFile, VoiceItem item) {
        String fileDownloadURL = item.getUrl();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new DownloadSaveAsTaskCallBack(cacheFile, saveAsFile));
        this.downloadTask.start();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.handleCallBtn();
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setOpaque(this.selected);
        this.revalidate();
        this.repaint();
    }

    public void setMenuDisplayed(boolean b) {
        if (!this.selected) {
            this.setBackground(EntryPanel.ENTRY_MENU_DISPLAYED_BACKGROUND);
            this.setOpaque(b);
        }
        this.revalidate();
        this.repaint();
    }

    public void updateNewMsgFlag(boolean isNewMsg) {
        this.isNewMsg = isNewMsg;
        if (isNewMsg) {
            this.lblNew.setIcon(UIConstants.ICON_HISTORY_LIST_UNREAD);
        } else {
            this.lblNew.setIcon(null);
        }
    }

    public void updatePhoneHistory(ExternalCallMessage msg, boolean isNewMsg, PhoneHistoryEntryParameter parameter) {
        this.mMsg = msg;
        this.isNewMsg = isNewMsg;
        this.phoneHistoryEntryParameter = parameter;
        this.handleCallBtn();
        this.initData();
    }

    private void initData() {
        if (this.isNewMsg) {
            this.lblNew.setIcon(UIConstants.ICON_HISTORY_LIST_UNREAD);
        } else {
            this.lblNew.setIcon(null);
        }
        this.lblTime.setText(DateTimeUtil.getTimeStr(this.mMsg.getTargetStartTime(), true));
        if (StringUtils.isNotBlank((CharSequence)this.mMsg.getCustomerNo())) {
            this.lblCustomerNo.setText(this.mMsg.getCustomerNo());
        } else {
            this.lblCustomerNo.setText("");
        }
        if (StringUtils.isNotBlank((CharSequence)this.mMsg.getCustomerName())) {
            this.lblCustomer.setText(this.mMsg.getCustomerName());
        } else {
            this.lblCustomer.setText("");
        }
        ArrayList<String> summaryCategoryList = new ArrayList<String>();
        ArrayList<String> summaryOutcomeList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.mMsg.getSummaryCategoryIds())) {
            for (String id : this.mMsg.getSummaryCategoryIds().split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                summaryCategoryList.add(SummaryTreeCache.getSummaryItem(Long.parseLong(id)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.mMsg.getSummaryOutcomeIds())) {
            for (String id : this.mMsg.getSummaryOutcomeIds().split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                summaryOutcomeList.add(SummaryTreeCache.getSummaryItem(Long.parseLong(id)));
            }
        }
        StringBuffer summarybuffer = new StringBuffer();
        if (summaryCategoryList.size() > 0) {
            if (summarybuffer.length() > 0) {
                summarybuffer.append(" / ");
            }
            summarybuffer.append(StringUtils.join(summaryCategoryList, (String)I18NUtil.getString("comma")));
        }
        if (summaryOutcomeList.size() > 0) {
            if (summarybuffer.length() > 0) {
                summarybuffer.append(" / ");
            }
            summarybuffer.append(StringUtils.join(summaryOutcomeList, (String)I18NUtil.getString("comma")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.mMsg.getSummaryNote())) {
            if (summarybuffer.length() > 0) {
                summarybuffer.append(" / ");
            }
            summarybuffer.append(this.mMsg.getSummaryNote());
        }
        if (StringUtils.isNotBlank((CharSequence)summarybuffer.toString())) {
            this.lblSummary.setText(summarybuffer.toString());
            this.lblSummary.setVisible(true);
        } else {
            this.lblSummary.setText("");
            this.lblSummary.setVisible(false);
        }
        this.numberToDial = this.mMsg.getTargetPhoneNumber();
        if (PreferencesUtil.isContactReportKeyDisp(UCChatClient.context) && this.mMsg.getContactRecordId() != null && this.mMsg.getContactRecordId() > 0L) {
            this.lblReportKey.setText("" + this.mMsg.getContactRecordId());
        }
        this.lblNumber.setText(this.mMsg.getTargetPhoneNumber());
        this.lblStatus.setIcon(this.mMsg.getTargetImageIcon());
        this.lblStatus.setText(this.mMsg.getTargetSuffix());
        this.lblDuration.setText(this.mMsg.getTargetDuration());
        if (this.mMsg.getTargetPlayed()) {
            icon = GraphicUtil.getScaledIcon("images/message/audio_play.png", 8, 8);
            this.lblDuration.setIcon(icon);
        } else {
            icon = GraphicUtil.getScaledIcon("images/message/audio_unplaymark.png", 8, 8);
            this.lblDuration.setIcon(icon);
        }
        int newWidth = 30 + COLUMN_GAP;
        this.lblNew.setPreferredSize(new Dimension(newWidth, 50));
        this.lblNew.setMaximumSize(new Dimension(newWidth, 50));
        this.lblNew.setMinimumSize(new Dimension(newWidth, 50));
        int customerNoWidth = this.phoneHistoryEntryParameter.getMaxCustomerNoLength() + COLUMN_GAP;
        this.lblCustomerNo.setPreferredSize(new Dimension(customerNoWidth, 50));
        this.lblCustomerNo.setMaximumSize(new Dimension(customerNoWidth, 50));
        this.lblCustomerNo.setMinimumSize(new Dimension(customerNoWidth, 50));
        int customerNameWidth = this.phoneHistoryEntryParameter.getMaxCustomerNameLength() + COLUMN_GAP;
        this.lblCustomer.setPreferredSize(new Dimension(customerNameWidth, 50));
        this.lblCustomer.setMaximumSize(new Dimension(customerNameWidth, 50));
        this.lblCustomer.setMinimumSize(new Dimension(customerNameWidth, 50));
        int timeWidth = this.phoneHistoryEntryParameter.getMaxTimeLength() + COLUMN_GAP;
        this.lblTime.setPreferredSize(new Dimension(timeWidth, 50));
        this.lblTime.setMaximumSize(new Dimension(timeWidth, 50));
        this.lblTime.setMinimumSize(new Dimension(timeWidth, 50));
        if (PreferencesUtil.isContactReportKeyDisp(UCChatClient.context)) {
            int reportyKeyLength = this.phoneHistoryEntryParameter.getMaxReportKeyLength() + COLUMN_GAP;
            this.lblReportKey.setPreferredSize(new Dimension(reportyKeyLength, 50));
            this.lblReportKey.setMaximumSize(new Dimension(reportyKeyLength, 50));
            this.lblReportKey.setMinimumSize(new Dimension(reportyKeyLength, 50));
        }
        int statusLength = ICON_SIZE + this.lblStatus.getIconTextGap() + this.phoneHistoryEntryParameter.getMaxStatusLength() + COLUMN_GAP;
        this.lblStatus.setPreferredSize(new Dimension(statusLength, 50));
        this.lblStatus.setMaximumSize(new Dimension(statusLength, 50));
        this.lblStatus.setMinimumSize(new Dimension(statusLength, 50));
        int phoneNumberLength = this.phoneHistoryEntryParameter.getMaxPhoneNumberLength() + COLUMN_GAP;
        this.lblNumber.setPreferredSize(new Dimension(phoneNumberLength, 50));
        this.lblNumber.setMaximumSize(new Dimension(phoneNumberLength, 50));
        this.lblNumber.setMinimumSize(new Dimension(phoneNumberLength, 50));
        int durationLength = 8 + this.phoneHistoryEntryParameter.getMaxDurationLength() + COLUMN_GAP;
        this.lblDuration.setPreferredSize(new Dimension(durationLength, 50));
        this.lblDuration.setMaximumSize(new Dimension(durationLength, 50));
        this.lblDuration.setMinimumSize(new Dimension(durationLength, 50));
        int maxLength = newWidth + timeWidth + statusLength + phoneNumberLength + durationLength + 100;
        this.setPreferredSize(new Dimension(maxLength, 50));
        this.setMinimumSize(new Dimension(maxLength, 50));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        if (this.canPlaySystemRecording() || this.canPlayVoicePersonal()) {
            this.lblSystemRecording.setCursor(UIConstants.CURSOR_HAND);
            this.lblSystemRecording.setIcon(UIConstants.ICON_PLAY);
        } else {
            this.lblSystemRecording.setCursor(null);
            this.lblSystemRecording.setIcon(null);
        }
    }

    private void handleCallBtn() {
        if (!this.selected) {
            this.setCallBtnVisible(false);
            return;
        }
        PhoneAgent.LineAvailableType ableToCall = PhoneAgent.getInstance().isAvailableToCall();
        boolean btnVisible = ableToCall != PhoneAgent.LineAvailableType.NONE;
        this.handleCallBtnText(btnVisible, ableToCall);
    }

    private void handleCallBtnText(boolean btnVisible, PhoneAgent.LineAvailableType ableToCall) {
        this.setCallBtnVisible(btnVisible);
        if (!btnVisible) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line1"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line2"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_THREE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line3"));
        } else {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout"));
        }
    }

    public boolean canPlaySystemRecording() {
        int msgType = this.mMsg.getMsgType();
        if (msgType == 223 || msgType == 221) {
            if (!PreferencesUtil.isCheckRecording(UCChatClient.context)) {
                return false;
            }
            if (this.mMsg.getContactRecordId() == null) {
                return false;
            }
            return StringUtils.isNotBlank((CharSequence)this.mMsg.getEncodedRecordKey());
        }
        return false;
    }

    public boolean canPlayVoicePersonal() {
        int msgType = this.mMsg.getMsgType();
        return msgType == 1006 || msgType == 13 || msgType == 1005 || msgType == 12;
    }

    public void handleFoward() {
        SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
        scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
        if (result == null) {
            return;
        }
        List<String> selectedJids = result.getChatroomJids();
        if (selectedJids == null || selectedJids.size() == 0) {
            return;
        }
        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
        for (String receiverJid : selectedJids) {
            chatReceiverList.add(new ChatReceiver(receiverJid));
        }
        if (this.canPlaySystemRecording()) {
            if (this.mMsg.getContactRecordId() == null || this.mMsg.getContactRecordId() == 0L) {
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            File sysRecordingDir = MediaFileUtil.getSysRecordingRoot(UCChatClient.context);
            File cacheFile = new File(sysRecordingDir, this.mMsg.getSysRecordingDispName());
            if (cacheFile.exists() && cacheFile.length() == this.mMsg.getFileSize()) {
                ChatActionUtil.uploadFile(chatReceiverList, cacheFile, true, null, this);
            } else {
                this.downloadAndForwardSystemRecording(cacheFile, this.mMsg.getContactRecordId(), this.mMsg.getEncodedRecordKey(), this.mMsg.getRecordSiteId(), this.mMsg.getFileSize(), chatReceiverList);
            }
        } else {
            VoiceItem item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, this.mMsg);
            if (item == null) {
                Log.i(PhoneHistoryEntryPanel.class.getSimpleName(), "VoiceItem null:" + this.mMsg.getContent());
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
            if (localRecFile != null) {
                if (localRecFile.exists()) {
                    ChatActionUtil.uploadFile(chatReceiverList, localRecFile, true, null, this);
                }
            } else {
                File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
                if (cacheFile == null) {
                    return;
                }
                if (cacheFile.exists()) {
                    ChatActionUtil.uploadFile(chatReceiverList, cacheFile, true, null, this);
                } else {
                    this.downloadAndForwardVoiceRecording(cacheFile, item, chatReceiverList);
                }
            }
        }
    }

    public void handleSaveToFile() {
        if (this.canPlaySystemRecording()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    File selectedFile;
                    String fileName = PhoneHistoryEntryPanel.this.mMsg.getSysRecordingDispName();
                    if (fileName == null) {
                        Log.i(PhoneHistoryEntryPanel.class.getSimpleName(), "filename is null");
                        return;
                    }
                    FileChooser fc = new FileChooser();
                    fc.setInitialFileName(fileName);
                    String exten = "wav";
                    if (StringUtils.isNotBlank((CharSequence)exten)) {
                        fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(exten.toUpperCase(), new String[]{"*." + exten.toLowerCase()}));
                    }
                    if ((selectedFile = fc.showSaveDialog(null)) != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PhoneHistoryEntryPanel.this.doSave(selectedFile, true);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                PreferencesUtil.setChatLastSaveDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                            }
                        });
                    }
                }
            });
        } else if (this.canPlayVoicePersonal()) {
            final VoiceItem item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, this.mMsg);
            if (item == null) {
                Log.i(PhoneHistoryEntryPanel.class.getSimpleName(), "VoiceItem null:" + this.mMsg.getContent());
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    File selectedFile;
                    String fileName = VoicemailManager.getVoiceItemDispName(item);
                    if (fileName == null) {
                        Log.i(PhoneHistoryEntryPanel.class.getSimpleName(), "filename is null");
                        return;
                    }
                    FileChooser fc = new FileChooser();
                    fc.setInitialFileName(fileName);
                    String exten = "wav";
                    if (StringUtils.isNotBlank((CharSequence)exten)) {
                        fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(exten.toUpperCase(), new String[]{"*." + exten.toLowerCase()}));
                    }
                    if ((selectedFile = fc.showSaveDialog(null)) != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PhoneHistoryEntryPanel.this.doSave(selectedFile, false);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                PreferencesUtil.setChatLastSaveDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                            }
                        });
                    }
                }
            });
        }
    }

    private void doSave(File saveAsFile, boolean isSystemFile) throws IOException {
        if (saveAsFile == null) {
            return;
        }
        if (isSystemFile) {
            if (this.mMsg.getContactRecordId() == null || this.mMsg.getContactRecordId() == 0L) {
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            File sysRecordingDir = MediaFileUtil.getSysRecordingRoot(UCChatClient.context);
            File cacheFile = new File(sysRecordingDir, this.mMsg.getSysRecordingDispName());
            if (cacheFile.exists() && cacheFile.length() == this.mMsg.getFileSize()) {
                Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
            } else {
                this.downloadAndSaveAsSysRecording(cacheFile, saveAsFile, this.mMsg.getContactRecordId(), this.mMsg.getEncodedRecordKey(), this.mMsg.getRecordSiteId(), this.mMsg.getFileSize());
            }
        } else {
            VoiceItem item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, this.mMsg);
            if (item == null) {
                Log.i(PhoneHistoryEntryPanel.class.getSimpleName(), "VoiceItem null:" + this.mMsg.getContent());
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
            if (localRecFile != null) {
                if (localRecFile.exists()) {
                    Files.copy(localRecFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                }
            } else {
                File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
                if (cacheFile == null) {
                    return;
                }
                if (cacheFile.exists()) {
                    Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                } else {
                    this.downloadAndSaveAsVoiceRecording(cacheFile, saveAsFile, item);
                }
            }
        }
    }

    private synchronized void setCallBtnVisible(final boolean btnVisible) {
        if (this.timer1 != null) {
            this.timer1.stop();
            this.timer1 = null;
        }
        if (!this.btnCall.isVisible() && btnVisible) {
            this.timer1 = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    PhoneHistoryEntryPanel.this.btnCall.setVisible(btnVisible);
                }
            });
            this.timer1.setRepeats(false);
            this.timer1.start();
        } else {
            this.btnCall.setVisible(btnVisible);
        }
    }

    class DownloadSaveAsSysRecordingTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;
        File mSaveAsFile;

        public DownloadSaveAsSysRecordingTaskCallBack(File toFile, File saveAsFile) {
            this.mFile = toFile;
            this.mSaveAsFile = saveAsFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                            PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                            PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        Files.copy(DownloadSaveAsSysRecordingTaskCallBack.this.mFile.toPath(), DownloadSaveAsSysRecordingTaskCallBack.this.mSaveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                    }
                    catch (Exception e) {
                        Log.e(PhoneHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadForwardSysRecordingTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;
        List<ChatReceiver> mChatReceiverList;

        public DownloadForwardSysRecordingTaskCallBack(File toFile, List<ChatReceiver> chatReceiverList) {
            this.mFile = toFile;
            this.mChatReceiverList = chatReceiverList;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                            PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                            PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        ChatActionUtil.uploadFile(DownloadForwardSysRecordingTaskCallBack.this.mChatReceiverList, DownloadForwardSysRecordingTaskCallBack.this.mFile, true, null, PhoneHistoryEntryPanel.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadOpenSysRecordingTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;

        public DownloadOpenSysRecordingTaskCallBack(File toFile) {
            this.mFile = toFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                            PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                            PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        Desktop.getDesktop().open(DownloadOpenSysRecordingTaskCallBack.this.mFile);
                    }
                    catch (Exception e) {
                        Log.e(PhoneHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadOpenTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;
        VoiceItem mItem;

        public DownloadOpenTaskCallBack(VoiceItem item, File toFile) {
            this.mItem = item;
            this.mFile = toFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                            PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                            PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        Desktop.getDesktop().open(DownloadOpenTaskCallBack.this.mFile);
                    }
                    catch (Exception e) {
                        Log.e(PhoneHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadForwardTaskCallBack
    implements DownloadFileTaskCallBack {
        VoiceItem mItem;
        File mFile;
        List<ChatReceiver> mChatReceiverList;

        public DownloadForwardTaskCallBack(VoiceItem item, File toFile, List<ChatReceiver> chatReceiverList) {
            this.mItem = item;
            this.mFile = toFile;
            this.mChatReceiverList = chatReceiverList;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                            PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                            PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        ChatActionUtil.uploadFile(DownloadForwardTaskCallBack.this.mChatReceiverList, DownloadForwardTaskCallBack.this.mFile, true, null, PhoneHistoryEntryPanel.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadSaveAsTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;
        File mSaveAsFile;

        public DownloadSaveAsTaskCallBack(File toFile, File saveAsFile) {
            this.mFile = toFile;
            this.mSaveAsFile = saveAsFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                            PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                            PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        Files.copy(DownloadSaveAsTaskCallBack.this.mFile.toPath(), DownloadSaveAsTaskCallBack.this.mSaveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (PhoneHistoryEntryPanel.this.pbDownload != null) {
                PhoneHistoryEntryPanel.this.pbDownload.setValue(0);
                PhoneHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (PhoneHistoryEntryPanel.this.lblCancelDownload != null) {
                PhoneHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }
}

