/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.cc;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.customer.ColumnType;
import com.blisscloud.ezuc.client.customer.CustomerField;
import com.blisscloud.ezuc.client.customer.CustomerFieldItem;
import com.blisscloud.ezuc.client.customer.FieldDataType;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplicationCache {
    private static volatile ApplicationCache instance = null;
    private static Object lock = new Object();
    private JSONObject mDataObj;
    private JSONObject mSchemaObj;
    public ConcurrentHashMap<ColumnType, CustomerField> schameMap = new ConcurrentHashMap();
    public ArrayList<CustomerField> customEnableList = new ArrayList();
    public boolean codeAutoEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationCache getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    Log.w(ApplicationCache.class.getSimpleName(), "ApplicationCache service instance is null, recreate now !");
                    instance = new ApplicationCache();
                }
            }
        }
        return instance;
    }

    public ApplicationCache() {
        this.processSchemaMap();
    }

    public void setApplicationList(JSONObject dataObj) {
        this.mDataObj = dataObj;
        PreferencesUtil.saveApplicationSetting(UCChatClient.context, dataObj.toString());
    }

    public synchronized void setSchemaList(JSONObject dataObj) {
        this.mSchemaObj = dataObj;
        PreferencesUtil.saveCustomerSchemaSetting(UCChatClient.context, dataObj.toString());
        this.processSchemaMap();
    }

    public List<Application> getApplicationList() {
        JSONObject data = null;
        if (this.mDataObj != null) {
            data = this.mDataObj;
        } else {
            String jsonStr = PreferencesUtil.getApplicationSetting(UCChatClient.context);
            if (jsonStr != null) {
                try {
                    data = new JSONObject(jsonStr);
                }
                catch (JSONException e) {
                    Log.e(ApplicationCache.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                }
            }
        }
        ArrayList<Application> resultList = new ArrayList<Application>();
        if (data != null && data.has("appList")) {
            try {
                JSONArray ary = data.getJSONArray("appList");
                for (int i = 0; i < ary.length(); ++i) {
                    JSONObject jo = ary.getJSONObject(i);
                    Application app = new Application();
                    app.setId(jo.getLong("id"));
                    app.setName(jo.getString("name"));
                    if (jo.has("descr")) {
                        app.setDescr(jo.getString("descr"));
                    }
                    app.setAppType(jo.getInt("appType"));
                    app.setObj(jo);
                    resultList.add(app);
                }
            }
            catch (Throwable t) {
                Log.e(ApplicationCache.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
            }
        }
        return resultList;
    }

    public String getTitle(int titleData) {
        CustomerField field = this.schameMap.get((Object)ColumnType.CUSTOMER_TITLE);
        CustomerFieldItem item = field.getEnumMap().get(titleData);
        if (item == null) {
            return "";
        }
        return item.getName();
    }

    private void processSchemaMap() {
        ConcurrentHashMap<ColumnType, CustomerField> newMap = new ConcurrentHashMap<ColumnType, CustomerField>();
        ArrayList<CustomerField> newCustomEnableList = new ArrayList<CustomerField>();
        try {
            JSONObject data = null;
            if (this.mSchemaObj != null) {
                data = this.mSchemaObj;
            } else {
                String jsonStr = PreferencesUtil.getCustomerSchemaSetting(UCChatClient.context);
                if (jsonStr != null) {
                    data = new JSONObject(jsonStr);
                }
            }
            if (data != null) {
                if (data.has("codeAutoEnabled")) {
                    this.codeAutoEnabled = data.getBoolean("codeAutoEnabled");
                }
                if (data.has("schemaList")) {
                    JSONArray ary = data.getJSONArray("schemaList");
                    for (int i = 0; i < ary.length(); ++i) {
                        JSONObject jo = ary.getJSONObject(i);
                        CustomerField field = new CustomerField();
                        field.setColumnType(ColumnType.getValue(jo.getInt("columnType")));
                        field.setDataType(FieldDataType.getValue(jo.getInt("dataType")));
                        field.setDataLength(jo.getInt("dataLength"));
                        if (jo.has("defaultValue")) {
                            field.setDefaultValue(jo.getString("defaultValue"));
                        }
                        if (jo.has("multiLanguageKeyUnique")) {
                            field.setMultiLanguageKeyUnique(jo.getString("multiLanguageKeyUnique"));
                        }
                        if (jo.has("multiLanguageKey")) {
                            field.setMultiLanguageKey(jo.getString("multiLanguageKey"));
                        }
                        if (jo.has("nameUnique")) {
                            field.setNameUnique(jo.getString("nameUnique"));
                        }
                        if (jo.has("dispName")) {
                            field.setDispName(jo.getString("dispName"));
                        }
                        if (jo.has("formatDesc")) {
                            field.setFormatDesc(jo.getString("formatDesc"));
                        }
                        field.setEnumData(jo.getBoolean("enumData"));
                        field.setShowOnList(jo.getBoolean("showOnList"));
                        field.setEnabled(jo.getBoolean("enabled"));
                        field.setMandatoryFlag(jo.getBoolean("mandatoryFlag"));
                        field.setUniqueFlag(jo.getBoolean("uniqueFlag"));
                        field.setName(ApplicationCache.getCustomerFieldName(field));
                        if (field.isEnumData() && jo.has("enumList")) {
                            HashMap<Integer, CustomerFieldItem> enumMap = new HashMap<Integer, CustomerFieldItem>();
                            StringBuffer b = new StringBuffer();
                            JSONArray itemAry = jo.getJSONArray("enumList");
                            ArrayList<CustomerFieldItem> itemList = new ArrayList<CustomerFieldItem>();
                            for (int j = 0; j < itemAry.length(); ++j) {
                                CustomerFieldItem item = new CustomerFieldItem();
                                JSONObject itemObj = itemAry.getJSONObject(j);
                                if (itemObj.has("key")) {
                                    item.setKey(itemObj.getInt("key"));
                                }
                                if (itemObj.has("multiLanguageKey")) {
                                    item.setMultiLanguageKey(itemObj.getString("multiLanguageKey"));
                                }
                                if (itemObj.has("dispName")) {
                                    item.setDispName(itemObj.getString("dispName"));
                                }
                                if (itemObj.has("system")) {
                                    item.setSystem(itemObj.getBoolean("system"));
                                }
                                String itemName = this.getCustomerFieldItemName(item);
                                item.setName(itemName);
                                enumMap.put(item.getKey(), item);
                                itemList.add(item);
                                if (item.getKey() == -1) continue;
                                if (b.length() > 0) {
                                    b.append(" ");
                                }
                                b.append(item.getKey());
                                b.append("=");
                                b.append(itemName);
                            }
                            field.setEnumItems(itemList);
                            field.setEnumMap(enumMap);
                            field.setEnumDataDescr(b.toString());
                        }
                        newMap.put(field.getColumnType(), field);
                        if (field.getColumnType().getId() <= 100 || !field.isEnabled()) continue;
                        newCustomEnableList.add(field);
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.e(ApplicationCache.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
        this.schameMap = newMap;
        this.customEnableList = newCustomEnableList;
    }

    public static String getCustomerFieldName(CustomerField field) {
        String name = null;
        if (field.getColumnType().getId() <= 100) {
            if (StringUtils.isNotBlank((CharSequence)field.getMultiLanguageKeyUnique())) {
                name = I18NUtil.getString(field.getMultiLanguageKeyUnique());
            }
            if (StringUtils.isNotBlank((CharSequence)field.getMultiLanguageKey())) {
                name = I18NUtil.getString(field.getMultiLanguageKey());
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)field.getNameUnique())) {
                name = I18NUtil.getString(field.getNameUnique());
            }
            if (StringUtils.isNotBlank((CharSequence)field.getDispName())) {
                name = field.getDispName();
            }
        }
        return name;
    }

    public String getCustomerFieldItemName(CustomerFieldItem item) {
        String name = null;
        if (StringUtils.isNotBlank((CharSequence)item.getMultiLanguageKey())) {
            name = I18NUtil.getString(item.getMultiLanguageKey());
        }
        if (StringUtils.isNotBlank((CharSequence)item.getDispName())) {
            name = item.getDispName();
        }
        return name;
    }
}

