/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.cc;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.cc.ApplicationCache;
import com.blisscloud.ezuc.client.cc.ApplicationSelectionRenderer;
import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.customer.ChangeCustomerDialog;
import com.blisscloud.ezuc.client.customer.CustomerItem;
import com.blisscloud.ezuc.client.customer.ModifyCustomerDialog;
import com.blisscloud.ezuc.client.customer.NewCustomerDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.summary.CheckBoxNodeEditor;
import com.blisscloud.ezuc.client.summary.CheckBoxNodeRenderer;
import com.blisscloud.ezuc.client.summary.RadioBtnNodeEditor;
import com.blisscloud.ezuc.client.summary.RadioBtnNodeRenderer;
import com.blisscloud.ezuc.client.summary.SummaryTreeModel;
import com.blisscloud.ezuc.client.summary.SummaryTreeModelListener;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ExternalCallMessage;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactRecordDialog
extends GenericDialog {
    private static final long serialVersionUID = 7381374601038768206L;
    private String dialoutUuid = UUID.randomUUID().toString();
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private ExternalCallMessage msg = null;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JLabel contactReportValueLabel = null;
    private JPanel centerPanel = null;
    private JLabel phoenNumberValueLabel = null;
    private JLabel lblStatus = null;
    private JLabel lblTime = null;
    private JLabel durationTitle = null;
    private JLabel lblDuration = null;
    private JLabel customerTitle = null;
    private JLabel lblCustomer = null;
    private JPanel customerPanel = null;
    private JTree categoryTree;
    private JTree outcomeTree;
    private JPanel treePanel;
    private JTextArea noteArea;
    private Long customerId;
    private ModifyCustomerDialog modifyCustomerDialog;
    private ChangeCustomerDialog changeCustomerDialog;
    private NewCustomerDialog newCustomerDialog;
    private JLabel searchAction;
    private JLabel editAction;
    private JLabel createNewAction;
    boolean categoryTreeEnabled = false;
    boolean outcomeTreeEnabled = false;
    private JComboBox<Application> applicationBox;
    private DefaultComboBoxModel<Application> applicationBoxModel = new DefaultComboBoxModel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ExternalCallMessage msg = new ExternalCallMessage();
                msg.setTargetPhoneNumber("0912930792");
                String phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_TALKING]");
                ImageIcon targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, 20, 20);
                msg.checkInit();
                msg.setTargetImageIcon(targetImageIcon);
                msg.setTargetSuffix(I18NUtil.getString("call_status_dialin"));
                msg.setTargetStartTime(System.currentTimeMillis() - 432000000L);
                msg.setTargetEndTime(System.currentTimeMillis() - 432000000L + 600000L);
                msg.setTargetDuration("10:00");
                msg.setMsgType(221);
                msg.setSummaryNote("\u76f8\u4fe1\u7fa4\u806f\u672a\u4f86\u50f9\u503c\u3001\u4e5f\u4fe1\u4efb\u6f58CEO\u7684\uff0c\u5c31\u4e0d\u61c9\u8a72\u4e82\u8ce3\uff0c\u62b1\u7dca\u8655\u7406\uff0c\u8ddf\u8457\u597d\u516c\u53f8\u4e00\u8d77\u6210\u9577\uff0c\u4eab\u53d7\u7372\u5229 \u76f8\u4fe1\u7fa4\u806f\u672a\u4f86\u50f9\u503c\u3001\u4e5f\u4fe1\u4efb\u6f58CEO\u7684\uff0c\u5c31\u4e0d\u61c9\u8a72\u4e82\u8ce3\uff0c\u62b1\u7dca\u8655\u7406\uff0c\u8ddf\u8457\u597d\u516c\u53f8\u4e00\u8d77\u6210\u9577\uff0c\u4eab\u53d7\u7372\u5229 \u76f8\u4fe1\u7fa4\u806f\u672a\u4f86\u50f9\u503c\u3001\u4e5f\u4fe1\u4efb\u6f58CEO\u7684\uff0c\u5c31\u4e0d\u61c9\u8a72\u4e82\u8ce3\uff0c\u62b1\u7dca\u8655\u7406\uff0c\u8ddf\u8457\u597d\u516c\u53f8\u4e00\u8d77\u6210\u9577\uff0c\u4eab\u53d7\u7372\u5229");
                msg.setSummaryCategoryIds(",499,");
                msg.setSummaryOutcomeIds(",520,");
                try {
                    SummaryTreeCache.setSummaryTree(new JSONObject("{\"outboundCategoryId\":303,\"types\":[{\"name\":\"\u552e\u5f8c\u670d\u52d9\",\"id\":302,\"parentId\":298},{\"name\":\"\u552e\u5f8c\u670d\u52d9\u56de\u64a5\",\"id\":307,\"parentId\":303},{\"name\":\"\u6295\u8a34\u56de\u64a5\",\"id\":306,\"parentId\":303},{\"name\":\"\u8a02\u55ae\u56de\u64a5\",\"id\":305,\"parentId\":303},{\"name\":\"\u8aee\u8a62\u56de\u64a5\",\"id\":304,\"parentId\":303},{\"name\":\"\u5df2\u7d50\u6848\",\"id\":309,\"parentId\":308},{\"name\":\"\u6709\u6548\u806f\u7d61\",\"id\":314,\"parentId\":312},{\"name\":\"\u7121\u6548\u806f\u7d61\",\"id\":313,\"parentId\":312},{\"name\":\"\u9810\u8a2d\u7684\u64a5\u5165\u806f\u7d61\u4e8b\u9805\",\"id\":298},{\"name\":\"\u9810\u8a2d\u7684\u64a5\u5165\u806f\u7d61\u7d50\u679c\",\"id\":308},{\"name\":\"\u9810\u8a2d\u7684\u64a5\u51fa\u806f\u7d61\u4e8b\u9805\",\"id\":303},{\"name\":\"\u9810\u8a2d\u7684\u64a5\u51fa\u806f\u7d61\u7d50\u679c\",\"id\":312}],\"outcomeSearch\":\"298,308,303,312\",\"inboundOutcomeId\":308,\"categorySearch\":\"298,308,303,312\",\"outboundOutcomeId\":312,\"inboundCategoryId\":298,\"items\":[{\"name\":\"\u5546\u54c1\u5831\u4fee\",\"id\":487,\"parentId\":302},{\"name\":\"\u89e3\u7b54\u554f\u984c\",\"id\":492,\"parentId\":304},{\"name\":\"\u78ba\u8a8d\u554f\u984c\",\"id\":493,\"parentId\":304},{\"name\":\"\u78ba\u8a8d\u8cc7\u6599\\/\u88dc\u8cc7\u6599\",\"id\":494,\"parentId\":305},{\"name\":\"\u901a\u77e5\u8655\u7406\u7d50\u679c\",\"id\":495,\"parentId\":305},{\"name\":\"\u5b89\u64ab\",\"id\":496,\"parentId\":306},{\"name\":\"\u8981\u6c42\u88dc\u8cc7\u6599\",\"id\":497,\"parentId\":306},{\"name\":\"\u901a\u77e5\u8655\u7406\u7d50\u679c\",\"id\":498,\"parentId\":306},{\"name\":\"\u8981\u6c42\u88dc\u8cc7\u6599\",\"id\":499,\"parentId\":307},{\"name\":\"\u901a\u77e5\u8655\u7406\u7d50\u679c\",\"id\":500,\"parentId\":307},{\"name\":\"\u7acb\u5373\u56de\u8986\",\"id\":501,\"parentId\":309},{\"name\":\"\u5fd9\u7dda\u4e2d\",\"id\":510,\"parentId\":313},{\"name\":\"\u7121\u4eba\u63a5\u807d\",\"id\":511,\"parentId\":313},{\"name\":\"\u975e\u672c\u4eba\u63a5\u807d\",\"id\":512,\"parentId\":313},{\"name\":\"\u8a9e\u97f3\\/\u7b54\u9304\\/Fax\",\"id\":513,\"parentId\":313},{\"name\":\"\u66ab\u505c\u4f7f\u7528\",\"id\":514,\"parentId\":313},{\"name\":\"\u7a7a\u865f\",\"id\":515,\"parentId\":313},{\"name\":\"\u62d2\u7d55\u8a2a\u554f\",\"id\":516,\"parentId\":313},{\"name\":\"\u8981\u6c42\u7981\u64a5\",\"id\":517,\"parentId\":313},{\"name\":\"\u5f85\u56de\u64a5\",\"id\":518,\"parentId\":314},{\"name\":\"\u4efb\u52d9\u5b8c\u6210\",\"id\":519,\"parentId\":314},{\"name\":\"\u4efb\u52d9\u5931\u6557\",\"id\":520,\"parentId\":314}]}"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                ContactRecordDialog inst = new ContactRecordDialog(frame, msg);
                inst.setVisible(true);
            }
        });
    }

    public ContactRecordDialog(JFrame frame, ExternalCallMessage msg) {
        super(frame);
        this.msg = msg;
        this.initGUI();
        this.initData();
        this.initReceiver();
    }

    public void display() {
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            if (this.receiver != null) {
                UCChatClient.context.unregisterReceiver(this.receiver);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void expandAllNodes(JTree tree, int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != rowCount) {
            this.expandAllNodes(tree, rowCount, tree.getRowCount());
        }
    }

    private void initData() {
        if (this.contactReportValueLabel != null && this.msg.getContactRecordId() != null) {
            this.contactReportValueLabel.setText(this.msg.getContactRecordId().toString());
        }
        this.phoenNumberValueLabel.setText(this.msg.getTargetPhoneNumber());
        this.lblStatus.setIcon(this.msg.getTargetImageIcon());
        this.lblStatus.setText(this.msg.getTargetSuffix());
        String starttime = DateTimeUtil.getTimeStr(this.msg.getTargetStartTime(), true);
        String endTime = this.msg.getTargetEndTime() != null ? DateTimeUtil.getTimeStr((long)this.msg.getTargetEndTime(), true) : null;
        this.lblTime.setText(starttime + (String)(endTime != null ? " ~ " + endTime : ""));
        String duration = this.msg.getTargetDuration();
        if (StringUtils.isNotBlank((CharSequence)duration)) {
            this.durationTitle.setVisible(true);
            this.lblDuration.setVisible(true);
            this.lblDuration.setText(duration);
        } else {
            this.durationTitle.setVisible(false);
            this.lblDuration.setVisible(false);
            this.lblDuration.setText("");
        }
        this.customerId = this.msg.getCustomerId();
        if (this.customerId != null && this.customerId != 0L) {
            this.lblCustomer.setText(this.msg.getCustomerName());
            this.editAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
            this.editAction.setVisible(true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.msg.getSummaryNote())) {
            this.noteArea.setText(this.msg.getSummaryNote());
        } else {
            this.noteArea.setText("");
        }
        this.applicationBoxModel.removeAllElements();
        List<Application> myApplicationList = ApplicationCache.getInstance().getApplicationList();
        Collections.sort(myApplicationList, new Comparator<Application>(this){

            @Override
            public int compare(Application o1, Application o2) {
                return Long.compare(o1.getId(), o2.getId());
            }
        });
        Application selectedItem = null;
        for (Application app : myApplicationList) {
            try {
                int appType = app.getObj().getInt("appType");
                if (appType == 0) {
                    this.applicationBoxModel.addElement(app);
                }
                if (this.msg.getAppId() == null || this.msg.getAppId().longValue() != app.getId()) continue;
                selectedItem = app;
            }
            catch (Throwable t) {
                Log.e(ContactRecordDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
            }
        }
        if (selectedItem != null) {
            this.applicationBox.setSelectedItem(selectedItem);
        } else {
            this.applicationBox.setSelectedIndex(0);
        }
        this.applicationBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContactRecordDialog.this.buildTree((Application)ContactRecordDialog.this.applicationBox.getSelectedItem());
            }
        });
        this.buildTree((Application)this.applicationBox.getSelectedItem());
    }

    private void buildTree(Application targetApp) {
        SummaryTreeModel model;
        Long summaryCategoryId = null;
        Long summaryOutcomeId = null;
        boolean categoryMultiEnabled = false;
        boolean outcomeMultiEnabled = false;
        if (targetApp != null) {
            try {
                JSONObject attObj = targetApp.getObj();
                int summaryType = 0;
                if (attObj.has("summaryType")) {
                    summaryType = attObj.getInt("summaryType");
                }
                if (summaryType == 0) {
                    if (this.msg.isOutbound()) {
                        if (SummaryTreeCache.outboundCategoryMultiChooseEnabed) {
                            categoryMultiEnabled = true;
                        }
                        summaryCategoryId = SummaryTreeCache.iOutboundCategoryId;
                        if (SummaryTreeCache.outboundOutcomeMultiChooseEnabed) {
                            outcomeMultiEnabled = true;
                        }
                        summaryOutcomeId = SummaryTreeCache.iOutboundOutcomeId;
                    } else {
                        if (SummaryTreeCache.inboundCategoryMultiChooseEnabed) {
                            categoryMultiEnabled = true;
                        }
                        summaryCategoryId = SummaryTreeCache.iInboundCategoryId;
                        if (SummaryTreeCache.inboundOutcomeMultiChooseEnabed) {
                            outcomeMultiEnabled = true;
                        }
                        summaryOutcomeId = SummaryTreeCache.iInboundOutcomeId;
                    }
                } else if (summaryType == 1) {
                    if (attObj.has("summaryCategoryId")) {
                        summaryCategoryId = attObj.getLong("summaryCategoryId");
                    }
                    if (attObj.has("categoryMultiChooseEnabed") && attObj.getBoolean("categoryMultiChooseEnabed")) {
                        categoryMultiEnabled = true;
                    }
                    if (attObj.has("summaryOutcomeId")) {
                        summaryOutcomeId = attObj.getLong("summaryOutcomeId");
                    }
                    if (attObj.has("outcomeMultiChooseEnabed") && attObj.getBoolean("outcomeMultiChooseEnabed")) {
                        outcomeMultiEnabled = true;
                    }
                }
            }
            catch (Throwable t) {
                Log.e(ContactRecordDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
            }
        } else if (this.msg.isOutbound()) {
            if (SummaryTreeCache.outboundCategoryMultiChooseEnabed) {
                categoryMultiEnabled = true;
            }
            summaryCategoryId = SummaryTreeCache.iOutboundCategoryId;
            if (SummaryTreeCache.outboundOutcomeMultiChooseEnabed) {
                outcomeMultiEnabled = true;
            }
            summaryOutcomeId = SummaryTreeCache.iOutboundOutcomeId;
        } else {
            if (SummaryTreeCache.inboundCategoryMultiChooseEnabed) {
                categoryMultiEnabled = true;
            }
            summaryCategoryId = SummaryTreeCache.iInboundCategoryId;
            if (SummaryTreeCache.inboundOutcomeMultiChooseEnabed) {
                outcomeMultiEnabled = true;
            }
            summaryOutcomeId = SummaryTreeCache.iInboundOutcomeId;
        }
        ArrayList<Long> categorySelectList = new ArrayList<Long>();
        ArrayList<Long> outcomeSelectList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)this.msg.getSummaryCategoryIds())) {
            for (String id : this.msg.getSummaryCategoryIds().split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                categorySelectList.add(Long.parseLong(id));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.msg.getSummaryOutcomeIds())) {
            for (String id : this.msg.getSummaryOutcomeIds().split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                outcomeSelectList.add(Long.parseLong(id));
            }
        }
        if (summaryCategoryId != null) {
            if (categoryMultiEnabled) {
                this.categoryTree.setCellEditor(new CheckBoxNodeEditor());
                this.categoryTree.setCellRenderer(new CheckBoxNodeRenderer());
            } else {
                this.categoryTree.setCellEditor(new RadioBtnNodeEditor());
                this.categoryTree.setCellRenderer(new RadioBtnNodeRenderer());
            }
            this.categoryTree.setEditable(true);
            model = new SummaryTreeModel(summaryCategoryId, categorySelectList, categoryMultiEnabled);
            model.addTreeModelListener(new SummaryTreeModelListener(this.categoryTree));
            this.categoryTree.setModel(model);
            this.expandAllNodes(this.categoryTree, 0, this.categoryTree.getRowCount());
            this.categoryTree.setVisible(true);
            this.categoryTreeEnabled = true;
        } else {
            this.categoryTree.setVisible(false);
        }
        if (summaryOutcomeId != null) {
            if (outcomeMultiEnabled) {
                this.outcomeTree.setCellEditor(new CheckBoxNodeEditor());
                this.outcomeTree.setCellRenderer(new CheckBoxNodeRenderer());
            } else {
                this.outcomeTree.setCellEditor(new RadioBtnNodeEditor());
                this.outcomeTree.setCellRenderer(new RadioBtnNodeRenderer());
            }
            this.outcomeTree.setEditable(true);
            model = new SummaryTreeModel(summaryOutcomeId, outcomeSelectList, outcomeMultiEnabled);
            model.addTreeModelListener(new SummaryTreeModelListener(this.outcomeTree));
            this.outcomeTree.setModel(model);
            this.expandAllNodes(this.outcomeTree, 0, this.outcomeTree.getRowCount());
            this.outcomeTree.setVisible(true);
            this.outcomeTreeEnabled = true;
        } else {
            this.outcomeTree.setVisible(false);
        }
        if (this.outcomeTree.isVisible() || this.categoryTree.isVisible()) {
            this.treePanel.setVisible(true);
        } else {
            this.treePanel.setVisible(false);
        }
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("contact_record_edit"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.centerPanel = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.centerPanel.setLayout(panelContentLayout);
            this.mainPanel.add((Component)this.centerPanel, "Center");
            int y = 0;
            if (PreferencesUtil.isContactReportKeyDisp(UCChatClient.context)) {
                JLabel contactReportKeyDispTitle = new JLabel();
                this.centerPanel.add((Component)contactReportKeyDispTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
                contactReportKeyDispTitle.setText(I18NUtil.getString("contact_record_dialog_key"));
                contactReportKeyDispTitle.setFont(UIConstants.FONT_13_BOLD);
                this.contactReportValueLabel = new JLabel();
                this.centerPanel.add((Component)this.contactReportValueLabel, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
                this.contactReportValueLabel.setFont(UIConstants.FONT_13_PLAIN);
                this.contactReportValueLabel.setCursor(Cursor.getPredefinedCursor(12));
                this.contactReportValueLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        String textToCopy = ContactRecordDialog.this.contactReportValueLabel.getText();
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(textToCopy), null);
                    }
                });
            }
            JLabel phoenNumberTitle = new JLabel();
            this.centerPanel.add((Component)phoenNumberTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            phoenNumberTitle.setText(I18NUtil.getString("contact_record_dialog_phone"));
            phoenNumberTitle.setFont(UIConstants.FONT_13_BOLD);
            this.phoenNumberValueLabel = new JLabel();
            this.centerPanel.add((Component)this.phoenNumberValueLabel, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.phoenNumberValueLabel.setFont(UIConstants.FONT_13_PLAIN);
            JLabel statusTitle = new JLabel();
            this.centerPanel.add((Component)statusTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            statusTitle.setText(I18NUtil.getString("contact_record_dialog_status"));
            statusTitle.setFont(UIConstants.FONT_13_BOLD);
            this.lblStatus = new JLabel();
            this.centerPanel.add((Component)this.lblStatus, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblStatus.setFont(UIConstants.FONT_13_PLAIN);
            JLabel timeTitle = new JLabel();
            this.centerPanel.add((Component)timeTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            timeTitle.setText(I18NUtil.getString("contact_record_dialog_time"));
            timeTitle.setFont(UIConstants.FONT_13_BOLD);
            this.lblTime = new JLabel();
            this.centerPanel.add((Component)this.lblTime, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblTime.setFont(UIConstants.FONT_13_PLAIN);
            this.durationTitle = new JLabel();
            this.centerPanel.add((Component)this.durationTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.durationTitle.setText(I18NUtil.getString("contact_record_dialog_duration"));
            this.durationTitle.setFont(UIConstants.FONT_13_BOLD);
            this.lblDuration = new JLabel();
            this.centerPanel.add((Component)this.lblDuration, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblDuration.setFont(UIConstants.FONT_13_PLAIN);
            this.customerTitle = new JLabel();
            this.centerPanel.add((Component)this.customerTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.customerTitle.setText(I18NUtil.getString("contact_record_dialog_customer"));
            this.customerTitle.setFont(UIConstants.FONT_13_BOLD);
            this.customerPanel = new JPanel();
            this.customerPanel.setLayout(new FlowLayout(0, 0, 0));
            this.lblCustomer = new JLabel();
            this.lblCustomer.setFont(UIConstants.FONT_13_PLAIN);
            this.customerPanel.add(this.lblCustomer);
            this.searchAction = new JLabel();
            this.searchAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
            this.searchAction.setIcon(UIConstants.USER_SEARCH);
            this.searchAction.setText(I18NUtil.getString("home_btn_customer_search"));
            this.searchAction.setCursor(Cursor.getPredefinedCursor(12));
            this.searchAction.setIconTextGap(1);
            this.searchAction.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String phoneNum = ContactRecordDialog.this.msg.getTargetPhoneNumber();
                    ContactRecordDialog.this.changeCustomerDialog = new ChangeCustomerDialog(UCChatClient.getInstance(), phoneNum, ContactRecordDialog.this.dialoutUuid);
                    ContactRecordDialog.this.changeCustomerDialog.setLocationRelativeTo(ContactRecordDialog.this);
                    CustomerItem item = ContactRecordDialog.this.changeCustomerDialog.showDialog();
                    if (item != null) {
                        ContactRecordDialog.this.customerId = item.getId();
                        if (ContactRecordDialog.this.customerId != null && ContactRecordDialog.this.customerId != 0L) {
                            ContactRecordDialog.this.lblCustomer.setText(item.getNameNoTitle());
                            ContactRecordDialog.this.editAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
                            ContactRecordDialog.this.editAction.setVisible(true);
                        }
                    }
                }
            });
            this.customerPanel.add(this.searchAction);
            this.editAction = new JLabel();
            this.editAction.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
            this.editAction.setIcon(UIConstants.USER_EDIT);
            this.editAction.setText(I18NUtil.getString("home_btn_customer_edit"));
            this.editAction.setCursor(Cursor.getPredefinedCursor(12));
            this.editAction.setIconTextGap(1);
            this.editAction.setVisible(false);
            this.editAction.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WebAgent.getInstance().targetPersonalCustomer(ContactRecordDialog.this.customerId, ContactRecordDialog.this.dialoutUuid);
                }
            });
            this.customerPanel.add(this.editAction);
            this.createNewAction = new JLabel();
            this.createNewAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
            this.createNewAction.setIcon(UIConstants.USER_ADD);
            this.createNewAction.setText(I18NUtil.getString("home_btn_customer_add"));
            this.createNewAction.setCursor(Cursor.getPredefinedCursor(12));
            this.createNewAction.setIconTextGap(1);
            this.customerPanel.add(this.createNewAction);
            this.createNewAction.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ApplicationCache.getInstance().codeAutoEnabled) {
                        WebAgent.getInstance().fetchNewCustomerStrId(ContactRecordDialog.this.dialoutUuid);
                    } else {
                        ContactRecordDialog.this.openNewFormDialog(null);
                    }
                }
            });
            this.centerPanel.add((Component)this.customerPanel, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            JLabel applicationTitle = new JLabel();
            this.centerPanel.add((Component)applicationTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            applicationTitle.setText(I18NUtil.getString("contact_record_dialog_app"));
            applicationTitle.setFont(UIConstants.FONT_13_BOLD);
            this.applicationBox = new JComboBox();
            this.applicationBox.setFont(UIConstants.FONT_13_PLAIN);
            this.applicationBox.setModel(this.applicationBoxModel);
            this.applicationBox.setRenderer(new ApplicationSelectionRenderer());
            this.centerPanel.add(this.applicationBox, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 0, 8), 0, 0));
            JLabel summaryTitle = new JLabel();
            this.centerPanel.add((Component)summaryTitle, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 2, 8), 0, 0));
            summaryTitle.setText(I18NUtil.getString("contact_record_dialog_summary"));
            summaryTitle.setFont(UIConstants.FONT_13_BOLD);
            GridLayout layout = new GridLayout(0, 2);
            layout.setHgap(10);
            this.treePanel = new JPanel(layout);
            this.treePanel.setBorder(BorderFactory.createEmptyBorder());
            this.centerPanel.add((Component)this.treePanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 2.0, 10, 1, new Insets(3, 8, 0, 8), 0, 0));
            JPanel leftPanel = new JPanel();
            leftPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(2);
            borderLayout.setVgap(2);
            leftPanel.setLayout(borderLayout);
            leftPanel.setBackground(Color.WHITE);
            final HintTextField txtSearch = new HintTextField(I18NUtil.getString("common_placeholder_search"), UIConstants.FONT_12_PLAIN);
            leftPanel.add((Component)txtSearch, "North");
            txtSearch.setFont(UIConstants.FONT_12_PLAIN);
            txtSearch.setForeground(Color.DARK_GRAY);
            txtSearch.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            txtSearch.setOpaque(false);
            txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ContactRecordDialog.this.filterTree(ContactRecordDialog.this.categoryTree, txtSearch.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ContactRecordDialog.this.filterTree(ContactRecordDialog.this.categoryTree, txtSearch.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ContactRecordDialog.this.filterTree(ContactRecordDialog.this.categoryTree, txtSearch.getText());
                }
            });
            this.categoryTree = new JTree();
            this.categoryTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.categoryTree.getSelectionModel().setSelectionMode(1);
            JScrollPane xx = new JScrollPane(this.categoryTree);
            xx.setBackground(Color.WHITE);
            xx.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            leftPanel.add((Component)xx, "Center");
            this.treePanel.add(leftPanel);
            JPanel rightPanel = new JPanel();
            rightPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            borderLayout = new BorderLayout();
            borderLayout.setHgap(2);
            borderLayout.setVgap(2);
            rightPanel.setLayout(borderLayout);
            rightPanel.setBackground(Color.WHITE);
            txtSearch = new HintTextField(I18NUtil.getString("common_placeholder_search"), UIConstants.FONT_12_PLAIN);
            rightPanel.add((Component)txtSearch, "North");
            txtSearch.setFont(UIConstants.FONT_12_PLAIN);
            txtSearch.setForeground(Color.DARK_GRAY);
            txtSearch.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            txtSearch.setOpaque(false);
            txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ContactRecordDialog.this.filterTree(ContactRecordDialog.this.outcomeTree, txtSearch.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ContactRecordDialog.this.filterTree(ContactRecordDialog.this.outcomeTree, txtSearch.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ContactRecordDialog.this.filterTree(ContactRecordDialog.this.outcomeTree, txtSearch.getText());
                }
            });
            this.outcomeTree = new JTree();
            this.outcomeTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.outcomeTree.getSelectionModel().setSelectionMode(1);
            xx = new JScrollPane(this.outcomeTree);
            xx.setBackground(Color.WHITE);
            xx.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            rightPanel.add((Component)xx, "Center");
            this.treePanel.add(rightPanel);
            JLabel noteTitle = new JLabel();
            this.centerPanel.add((Component)noteTitle, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 8, 2, 8), 0, 0));
            noteTitle.setText(I18NUtil.getString("contact_record_dialog_note"));
            noteTitle.setFont(UIConstants.FONT_13_BOLD);
            this.noteArea = new JTextArea(5, 20);
            this.noteArea.setLineWrap(true);
            this.noteArea.setWrapStyleWord(true);
            JScrollPane scroll = new JScrollPane(this.noteArea);
            scroll.setHorizontalScrollBarPolicy(31);
            this.centerPanel.add((Component)scroll, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 8, 6, 8), 0, 0));
            this.noteArea.setFont(UIConstants.FONT_13_BOLD);
            this.noteArea.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "Shift+Enter");
            this.noteArea.getActionMap().put("Shift+Enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ContactRecordDialog.this.noteArea.getDocument().insertString(ContactRecordDialog.this.noteArea.getCaretPosition(), "\n", null);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            this.buttonPanel = new JPanel();
            this.mainPanel.add((Component)this.buttonPanel, "South");
            FlowLayout buttonPanelLayout = new FlowLayout();
            buttonPanelLayout.setAlignment(1);
            this.buttonPanel.setLayout(buttonPanelLayout);
            this.buttonPanel.setOpaque(false);
            this.btnSave = new JButton();
            this.buttonPanel.add(this.btnSave);
            this.btnSave.setText(I18NUtil.getString("common_btn_apply"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ContactRecordDialog.this.btnSaveActionPerformed(evt, false);
                }
            });
            this.btnCancel = new JButton();
            this.buttonPanel.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ContactRecordDialog.this.btnCancelActionPerformed(evt, true);
                }
            });
            this.setSize(660, 760);
            this.setMinimumSize(new Dimension(660, 300));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void filterTree(final JTree tree, String filterKey) {
        ((SummaryTreeModel)tree.getModel()).filterKey(filterKey);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.updateUI();
            }
        });
    }

    private void openNewFormDialog(final String strId) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContactRecordDialog.this.newCustomerDialog = new NewCustomerDialog(UCChatClient.getInstance(), strId, ContactRecordDialog.this.msg.getTargetPhoneNumber(), ContactRecordDialog.this.dialoutUuid, true);
                ContactRecordDialog.this.newCustomerDialog.setLocationRelativeTo(ContactRecordDialog.this);
                ContactRecordDialog.this.newCustomerDialog.showDialog();
            }
        });
    }

    protected void btnCancelActionPerformed(ActionEvent evt, boolean b) {
        this.setVisible(false);
    }

    protected void btnSaveActionPerformed(ActionEvent evt, boolean b) {
        List<Object> catogeryList = new ArrayList();
        List<Object> outcomeList = new ArrayList();
        if (this.categoryTree.isVisible() && (catogeryList = ((SummaryTreeModel)this.categoryTree.getModel()).getSelectedIdList()).size() == 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("contact_record_dialog_category_missing"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        if (this.outcomeTree.isVisible() && (outcomeList = ((SummaryTreeModel)this.outcomeTree.getModel()).getSelectedIdList()).size() == 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("contact_record_dialog_outcome_missing"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        Long logId = this.msg.getContactRecordId();
        if (logId == null) {
            logId = this.msg.getTargetCallBackupId();
        }
        Application app = (Application)this.applicationBox.getSelectedItem();
        WebAgent.getInstance().saveContactSummary(logId, this.customerId, StringUtils.join(catogeryList, (String)","), StringUtils.join(outcomeList, (String)","), this.noteArea.getText(), app != null ? Long.valueOf(app.getId()) : null);
        this.setVisible(false);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if (action.equals("ezuc.intent.action.event.CONTACT_SUMMARY_TREE_UPDATE")) {
                        ContactRecordDialog.this.initData();
                    } else if (action.equals("ezuc.intent.action.event.SEARCH_CUSTOMER_RESULT")) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (ContactRecordDialog.this.changeCustomerDialog == null || !ContactRecordDialog.this.changeCustomerDialog.isVisible()) {
                            return;
                        }
                        JSONObject resultObj = intent.getJSONObjectExtra("result");
                        if (resultObj != null) {
                            JSONArray customerAry = resultObj.getJSONArray("customerList");
                            ContactRecordDialog.this.changeCustomerDialog.updateCustomerList(customerAry);
                        }
                    } else if ("ezuc.intent.action.event.CUSTOMER_STR_ID_FETCHED".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        String strId = intent.getStringExtra("strId");
                        ContactRecordDialog.this.openNewFormDialog(strId);
                    } else if ("ezuc.intent.action.event.SAVE_CUSTOMER_DONE".equals(action)) {
                        boolean fill;
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (ContactRecordDialog.this.newCustomerDialog != null) {
                            ContactRecordDialog.this.newCustomerDialog.dispose();
                        }
                        if (!(fill = intent.getBooleanExtra("fill", true))) {
                            return;
                        }
                        JSONObject customerObj = intent.getJSONObjectExtra("customer");
                        if (customerObj == null) {
                            return;
                        }
                        if (!customerObj.has("CDETAIL")) {
                            return;
                        }
                        JSONObject customerDetailObj = customerObj.getJSONObject("CDETAIL");
                        CustomerItem item = new CustomerItem();
                        item.setDetail(customerDetailObj);
                        ContactRecordDialog.this.customerId = item.getId();
                        if (ContactRecordDialog.this.customerId != null && ContactRecordDialog.this.customerId != 0L) {
                            ContactRecordDialog.this.lblCustomer.setText(item.getNameNoTitle());
                            ContactRecordDialog.this.editAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
                            ContactRecordDialog.this.editAction.setVisible(true);
                        }
                    } else if ("ezuc.intent.action.event.SAVE_CUSTOMER_FAILED".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (ContactRecordDialog.this.newCustomerDialog != null) {
                            ContactRecordDialog.this.newCustomerDialog.onSaveFailed(intent);
                        }
                    } else if ("ezuc.intent.action.event.TARGET_CUSTOMER_DONE".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        JSONObject customerObj = intent.getJSONObjectExtra("customer");
                        if (customerObj == null) {
                            return;
                        }
                        if (!customerObj.has("CDETAIL")) {
                            return;
                        }
                        JSONObject customerDetail = customerObj.getJSONObject("CDETAIL");
                        ContactRecordDialog.this.modifyCustomerDialog = new ModifyCustomerDialog(UCChatClient.getInstance(), ContactRecordDialog.this.dialoutUuid, customerDetail, true);
                        ContactRecordDialog.this.modifyCustomerDialog.setLocationRelativeTo(ContactRecordDialog.this);
                        ContactRecordDialog.this.modifyCustomerDialog.showDialog();
                    } else if ("ezuc.intent.action.event.MODIFY_CUSTOMER_DONE".equals(action)) {
                        JSONObject customerObj;
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (ContactRecordDialog.this.modifyCustomerDialog != null) {
                            ContactRecordDialog.this.modifyCustomerDialog.dispose();
                        }
                        if ((customerObj = intent.getJSONObjectExtra("customer")) == null) {
                            return;
                        }
                        if (!customerObj.has("CDETAIL")) {
                            return;
                        }
                        JSONObject customerDetailObj = customerObj.getJSONObject("CDETAIL");
                        CustomerItem item = new CustomerItem();
                        item.setDetail(customerDetailObj);
                        ContactRecordDialog.this.customerId = item.getId();
                        if (ContactRecordDialog.this.customerId != null && ContactRecordDialog.this.customerId != 0L) {
                            ContactRecordDialog.this.lblCustomer.setText(item.getNameNoTitle());
                            ContactRecordDialog.this.editAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
                            ContactRecordDialog.this.editAction.setVisible(true);
                        }
                    } else if ("ezuc.intent.action.event.MODIFY_CUSTOMER_FAILED".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!ContactRecordDialog.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (ContactRecordDialog.this.modifyCustomerDialog != null) {
                            ContactRecordDialog.this.modifyCustomerDialog.onModifyFailed(intent);
                        }
                    }
                }
                catch (Throwable t) {
                    Log.e(ContactRecordDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.CONTACT_SUMMARY_TREE_UPDATE");
        this.filter.addAction("ezuc.intent.action.event.SEARCH_CUSTOMER_RESULT");
        this.filter.addAction("ezuc.intent.action.event.TARGET_CUSTOMER_DONE");
        this.filter.addAction("ezuc.intent.action.event.CUSTOMER_STR_ID_FETCHED");
        this.filter.addAction("ezuc.intent.action.event.SAVE_CUSTOMER_DONE");
        this.filter.addAction("ezuc.intent.action.event.SAVE_CUSTOMER_FAILED");
        this.filter.addAction("ezuc.intent.action.event.MODIFY_CUSTOMER_DONE");
        this.filter.addAction("ezuc.intent.action.event.MODIFY_CUSTOMER_FAILED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }
}

