/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.cc;

import com.blisscloud.ezuc.client.cc.SummaryItem;
import com.blisscloud.ezuc.client.cc.SummaryType;
import com.blisscloud.ezuc.client.util.simulate.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SummaryTreeCache {
    private static Object lock = new Object();
    public static HashMap<Long, String> iSummaryItemsNameMap = new HashMap();
    public static HashMap<Long, SummaryItem> iSummaryItemsMap = new HashMap();
    public static HashMap<Long, SummaryType> iSummaryTypesMap = new HashMap();
    public static ArrayList<SummaryItem> iSummaryItemList = new ArrayList();
    public static ArrayList<SummaryType> iSummaryTypeList = new ArrayList();
    public static Long iInboundCategoryId;
    public static Long iInboundOutcomeId;
    public static Long iOutboundCategoryId;
    public static Long iOutboundOutcomeId;
    public static boolean inboundCategoryMultiChooseEnabed;
    public static boolean inboundOutcomeMultiChooseEnabed;
    public static boolean outboundCategoryMultiChooseEnabed;
    public static boolean outboundOutcomeMultiChooseEnabed;
    public static Long[] iCategorySearch;
    public static Long[] iOutcomeSearch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSummaryTree(JSONObject summaryTree) {
        Object object = lock;
        synchronized (object) {
            try {
                Long parentId;
                String name;
                int i;
                JSONArray ary;
                String searchIds;
                String[] xxIds;
                String searchIds2;
                String[] xxIds2;
                iInboundCategoryId = summaryTree.has("inboundCategoryId") ? Long.valueOf(summaryTree.getLong("inboundCategoryId")) : null;
                iInboundOutcomeId = summaryTree.has("inboundOutcomeId") ? Long.valueOf(summaryTree.getLong("inboundOutcomeId")) : null;
                iOutboundCategoryId = summaryTree.has("outboundCategoryId") ? Long.valueOf(summaryTree.getLong("outboundCategoryId")) : null;
                iOutboundOutcomeId = summaryTree.has("outboundOutcomeId") ? Long.valueOf(summaryTree.getLong("outboundOutcomeId")) : null;
                inboundCategoryMultiChooseEnabed = summaryTree.has("inboundCategoryMultiChooseEnabed") ? summaryTree.getBoolean("inboundCategoryMultiChooseEnabed") : false;
                inboundOutcomeMultiChooseEnabed = summaryTree.has("inboundOutcomeMultiChooseEnabed") ? summaryTree.getBoolean("inboundOutcomeMultiChooseEnabed") : false;
                outboundCategoryMultiChooseEnabed = summaryTree.has("outboundCategoryMultiChooseEnabed") ? summaryTree.getBoolean("outboundCategoryMultiChooseEnabed") : false;
                outboundOutcomeMultiChooseEnabed = summaryTree.has("outboundOutcomeMultiChooseEnabed") ? summaryTree.getBoolean("outboundOutcomeMultiChooseEnabed") : false;
                Long[] categorySearch = null;
                if (summaryTree.has("categorySearch") && (xxIds2 = (searchIds2 = summaryTree.getString("categorySearch")).split(",")) != null) {
                    categorySearch = new Long[xxIds2.length];
                    for (int i2 = 0; i2 < xxIds2.length; ++i2) {
                        categorySearch[i2] = Long.parseLong(xxIds2[i2]);
                    }
                }
                iCategorySearch = categorySearch;
                Long[] outcomeSearch = null;
                if (summaryTree.has("outcomeSearch") && (xxIds = (searchIds = summaryTree.getString("outcomeSearch")).split(",")) != null) {
                    outcomeSearch = new Long[xxIds.length];
                    for (int i3 = 0; i3 < xxIds.length; ++i3) {
                        outcomeSearch[i3] = Long.parseLong(xxIds[i3]);
                    }
                }
                iOutcomeSearch = outcomeSearch;
                HashMap<Long, String> summaryItemNamesMap = new HashMap<Long, String>();
                HashMap<Long, SummaryItem> summaryItemsMap = new HashMap<Long, SummaryItem>();
                HashMap<Long, SummaryType> summaryTypesMap = new HashMap<Long, SummaryType>();
                ArrayList<SummaryItem> summaryItemList = new ArrayList<SummaryItem>();
                ArrayList<SummaryType> summaryTypeList = new ArrayList<SummaryType>();
                if (summaryTree.has("types")) {
                    ary = summaryTree.getJSONArray("types");
                    for (i = 0; i < ary.length(); ++i) {
                        JSONObject typeObj = ary.getJSONObject(i);
                        Long typeId = typeObj.getLong("id");
                        name = typeObj.getString("name");
                        parentId = null;
                        if (typeObj.has("parentId")) {
                            parentId = typeObj.getLong("parentId");
                        }
                        SummaryType type = new SummaryType(typeId, name, parentId);
                        summaryTypesMap.put(typeId, type);
                        summaryTypeList.add(type);
                    }
                }
                if (summaryTree.has("items")) {
                    ary = summaryTree.getJSONArray("items");
                    for (i = 0; i < ary.length(); ++i) {
                        JSONObject itemObj = ary.getJSONObject(i);
                        Long itemId = itemObj.getLong("id");
                        name = itemObj.getString("name");
                        parentId = itemObj.getLong("parentId");
                        boolean archived = itemObj.getBoolean("archived");
                        SummaryItem item = new SummaryItem(itemId, name, parentId, archived);
                        summaryItemNamesMap.put(itemId, name);
                        summaryItemsMap.put(itemId, item);
                        summaryItemList.add(item);
                    }
                }
                iSummaryTypesMap = summaryTypesMap;
                iSummaryItemsMap = summaryItemsMap;
                iSummaryItemsNameMap = summaryItemNamesMap;
                iSummaryItemList = summaryItemList;
                iSummaryTypeList = summaryTypeList;
            }
            catch (Throwable t) {
                Log.e(SummaryTreeCache.class.getName(), "ERROR:" + t.getMessage(), t);
            }
        }
    }

    public static String getSummaryItem(Long itemId) {
        return iSummaryItemsNameMap.get(itemId);
    }

    public static List<Long> matchSummaryItemList(String searchSummary) {
        if (StringUtils.isBlank((CharSequence)searchSummary)) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        for (Map.Entry<Long, SummaryItem> item : iSummaryItemsMap.entrySet()) {
            try {
                SummaryItem itemObj = item.getValue();
                if (!itemObj.getName().toLowerCase().contains(searchSummary.toLowerCase())) continue;
                idList.add(itemObj.getId());
            }
            catch (Throwable throwable) {}
        }
        return idList;
    }

    public static TreePath getTreePath(Long summaryItemId) {
        ArrayList<Object> list = new ArrayList<Object>();
        SummaryItem item = iSummaryItemsMap.get(summaryItemId);
        if (item == null) {
            return null;
        }
        list.add(item);
        SummaryTreeCache.handleType(list, item.getParentId());
        Collections.reverse(list);
        return new TreePath(list.toArray(new Object[list.size()]));
    }

    private static void handleType(ArrayList<Object> list, Long parentId) {
        if (parentId == null) {
            return;
        }
        SummaryType type = iSummaryTypesMap.get(parentId);
        if (type != null) {
            list.add(type);
            SummaryTreeCache.handleType(list, type.getParentId());
        }
    }
}

