/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FileUploadConfirmDialog
extends GenericDialog {
    private JPanel panelContent;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JLabel mIconPhoto;
    private JLabel lFileSize;
    private JLabel lFileName;
    private JButton btnConfirm;
    private JButton btnCancel;
    private boolean mOK = false;
    private String mReceiverName = null;
    private File mFile = null;

    public FileUploadConfirmDialog(JFrame frame, String receiverName, File file) {
        super(frame);
        this.mReceiverName = receiverName;
        this.mFile = file;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("media_confirm_upload_file_title"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(30, 30, 5, 30), 0, 0));
            this.lblTitle.setText(String.format(I18NUtil.getString("media_confirm_upload_doc_check"), this.mReceiverName));
            URL uri = this.getDocumentIconURI(this.mFile.getName());
            ImageIcon icon = new ImageIcon(uri);
            this.mIconPhoto = new JLabel(icon);
            this.panelContent.add((Component)this.mIconPhoto, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 15, 5), 0, 0));
            JPanel p = new JPanel();
            GridLayout mgr = new GridLayout(0, 1);
            p.setLayout(mgr);
            this.lFileName = new JLabel(this.mFile.getName());
            p.add(this.lFileName);
            this.lFileSize = new JLabel(FileUtil.getFileSizeText(this.mFile.length()));
            p.add(this.lFileSize);
            this.panelContent.add((Component)p, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 20, 30), 0, 0));
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 15, 15, 15), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FileUploadConfirmDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FileUploadConfirmDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(380, 600);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL getDocumentIconURI(String fileName) {
        URL uri = UIConstants.getDocumentIconURI(fileName);
        if (uri != null) {
            return uri;
        }
        return UIConstants.getDefaultDocURI();
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    public boolean showDialog() {
        this.mOK = false;
        this.setVisible(true);
        return this.mOK;
    }
}

