/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageUploadConfirmDialog
extends GenericDialog {
    private JPanel panelContent;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JLabel mSelectedPhoto;
    private JButton btnConfirm;
    private JButton btnCancel;
    private boolean mOK = false;
    private String mReceiverName = null;
    private File mFile = null;
    private JCheckBox mOriginalCheckBox;

    public ImageUploadConfirmDialog(JFrame frame, String receiverName, File file) {
        super(frame);
        this.mReceiverName = receiverName;
        this.mFile = file;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("media_confirm_upload_file_title"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 30, 5, 30), 0, 0));
            this.lblTitle.setText(String.format(I18NUtil.getString("media_confirm_upload_image_check"), this.mReceiverName));
            BufferedImage image = FileUtil.readFileHandleExif(this.mFile);
            double ratio = 1.0;
            ratio = image.getWidth(null) > image.getHeight(null) ? 400.0 / (double)image.getWidth(null) : 400.0 / (double)image.getHeight(null);
            int scaledWidth = (int)((double)image.getWidth() * ratio);
            int scaledHeight = (int)((double)image.getHeight() * ratio);
            this.mSelectedPhoto = new JLabel(GraphicUtil.getScaledIcon(image, scaledWidth, scaledHeight));
            this.panelContent.add((Component)this.mSelectedPhoto, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 5, 30), 0, 0));
            this.mOriginalCheckBox = new JCheckBox();
            this.panelContent.add((Component)this.mOriginalCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 30), 0, 0));
            String msg = I18NUtil.getString("media_label_original_picture") + "(" + FileUtil.convertFileSizeDisplay(this.mFile.length()) + ")";
            this.mOriginalCheckBox.setText(msg);
            this.mOriginalCheckBox.setOpaque(false);
            this.mOriginalCheckBox.setSelected(false);
            this.mOriginalCheckBox.setFont(UIConstants.FONT_12_PLAIN);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 15, 15, 15), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImageUploadConfirmDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImageUploadConfirmDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(380, 600);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    public boolean showDialog() {
        this.mOK = false;
        this.setVisible(true);
        return this.mOK;
    }

    public boolean isOriginal() {
        return this.mOriginalCheckBox != null && this.mOriginalCheckBox.isSelected();
    }
}

