/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.AudioPlayerRequest;
import com.blisscloud.ezuc.client.chat.DeleteService;
import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.MessageStatusUtil;
import com.blisscloud.ezuc.client.chat.MessageTemplate;
import com.blisscloud.ezuc.client.chat.RecallService;
import com.blisscloud.ezuc.client.chat.ResendMessagePanel;
import com.blisscloud.ezuc.client.chat.SaveHandler;
import com.blisscloud.ezuc.client.chat.ShowMsgReadUnreadStatusDialog;
import com.blisscloud.ezuc.client.chat.action.CancelUpload;
import com.blisscloud.ezuc.client.chat.action.CopyFile;
import com.blisscloud.ezuc.client.chat.action.DeleteFile;
import com.blisscloud.ezuc.client.chat.action.DialOutbound;
import com.blisscloud.ezuc.client.chat.action.DisplayLocation;
import com.blisscloud.ezuc.client.chat.action.DownloadAudio;
import com.blisscloud.ezuc.client.chat.action.DownloadDocument;
import com.blisscloud.ezuc.client.chat.action.DownloadImage;
import com.blisscloud.ezuc.client.chat.action.DownloadPersonalRecord;
import com.blisscloud.ezuc.client.chat.action.DownloadVoicemail;
import com.blisscloud.ezuc.client.chat.action.FaxMsg;
import com.blisscloud.ezuc.client.chat.action.ForwardMsg;
import com.blisscloud.ezuc.client.chat.action.ForwardVoicePersonalFile;
import com.blisscloud.ezuc.client.chat.action.OpenUrlHandler;
import com.blisscloud.ezuc.client.chat.action.RecallMsg;
import com.blisscloud.ezuc.client.chat.action.SaveFile;
import com.blisscloud.ezuc.client.chat.action.SaveFileToDownload;
import com.blisscloud.ezuc.client.chat.action.SaveVoicePersonalFile;
import com.blisscloud.ezuc.client.chat.action.SaveVoicePersonalFileToDownload;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyAudioRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyDocumentRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyImageRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyLocationRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyPersonalRecordRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyPhoneCancelRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyPhoneTalkingRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyPunchcardRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyTextRenderer;
import com.blisscloud.ezuc.client.chat.dom.MyVideoRenderer;
import com.blisscloud.ezuc.client.chat.dom.NoticeMsgRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherAudioRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherDocumentRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherImageRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherLocationRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherPersonalRecordRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherPhoneCancelRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherPhoneTalkingRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherPunchcardRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherTextRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherVideoRenderer;
import com.blisscloud.ezuc.client.chat.dom.OtherVoicemailRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.chat.roomimpl.MsgPhoneFormatter;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.MessageContentUtil;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBVoiceMsg;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class MessageArea
extends JFXPanel
implements DomService,
ActionService,
DeleteService,
RecallService {
    public static final int DEFAULT_JUMP_INTERVAL = 100;
    public static final int DELAY_JUMP_INTERVAL = 500;
    private static final int RELOAD_DELAY_TIME = 100;
    private static final long serialVersionUID = -6406433767617975901L;
    private WebView webView;
    private BorderPane borderPane;
    private WebEngine webEngine;
    private Document document;
    private MessageTemplate template;
    private Element tableContent;
    private ContextMenu menu;
    private MenuItem itemForward;
    private MenuItem itemSave;
    private MenuItem itemSaveDownload;
    private MenuItem itemOpenDownloadFolder;
    private MenuItem itemOpenTempFolder;
    private MenuItem itemDelete;
    private MenuItem itemRecall;
    private MenuItem itemReply;
    private MenuItem itemCopySelection;
    private MenuItem itemCopyText;
    private MenuItem itemCopyMsg;
    private MenuItem itemCopyImg;
    private MenuItem itemFax;
    private ScrollBar targetScroll;
    private int documentInitial = 0;
    private String chatId;
    private boolean historyMode;
    private MessageAreaCallback callback;
    private Map<Element, Set<String>> elementEventMap = new HashMap<Element, Set<String>>();
    private Map<Element, Set<String>> elementErrorEventMap = new HashMap<Element, Set<String>>();
    private HashSet<String> messageSet = new HashSet();
    private Map<String, DownloadFileTask> downloadFileTaskMap = new HashMap<String, DownloadFileTask>();
    private Map<String, String> downloadUrlMap = new HashMap<String, String>();
    private Map<String, String> headPhotoMap = new HashMap<String, String>();
    private Map<String, String> refPhotoMap = new HashMap<String, String>();
    private Map<String, String> refMap = new HashMap<String, String>();
    private Map<String, String> systemMsgMap = new HashMap<String, String>();
    private boolean scrollBarAtBottom = true;
    private ChangeListener<Worker.State> stateChangeListener = null;
    private ChangeListener<Number> scrollchangeListener = null;
    private Label dateDispLabel = null;
    private java.util.Timer messageAreaTimer = new java.util.Timer("MessageAreaTimer");
    private UCTimerTask updateMsgTask;
    private UCTimerTask scrollTask1;
    private UCTimerTask scrollTask2;
    private AudioPlayerRequest currentPlayerRequest;
    private Timer hideDateTimer;
    private EventListener clickListener = null;
    private EventListener errorClickListener = null;
    private Object scrollObject = new Object();
    static String MY_MSG_MAIN_PREFIX = "myMessageTextMain_";
    static String MY_MSG_PREFIX = "myMessageText_";
    static String OTHER_MSG_MAIN_PREFIX = "otherMessageTextMain_";
    static String OTHER_MSG_PREFIX = "otherMessageText_";

    public MessageArea(String chatId, MessageAreaCallback callback) {
        this(chatId, false, callback);
    }

    public MessageArea(String chatId, boolean historyMode, MessageAreaCallback callback) {
        this.chatId = chatId;
        this.callback = callback;
        this.historyMode = historyMode;
        this.clickListener = new NormalEventListener();
        this.errorClickListener = new ErrorEventListener();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageArea.this.initJavaFXComponent();
            }
        });
    }

    protected void initJavaFXComponent() {
        this.itemFax = new MenuItem(I18NUtil.getString("common_btn_fax"));
        this.itemFax.setGraphic((Node)new ImageView(new Image("images/menu/fax.png", 20.0, 20.0, true, true)));
        this.itemFax.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                String itemtype = (String)MessageArea.this.webView.getEngine().executeScript("getItemType()");
                Element element = null;
                if ("MY_IMG".equals(itemtype) || "MY_DOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                } else if ("OTHER_IMG".equals(itemtype) || "OTHER_DOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                }
                if (element == null) {
                    return;
                }
                final ElementAttrMap targetMap = MessageArea.this.convertTargetElem(element);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FaxMsg.handle(MessageArea.this, targetMap);
                    }
                });
            }
        });
        this.itemForward = new MenuItem(I18NUtil.getString("common_btn_forward"));
        this.itemForward.setGraphic((Node)new ImageView(new Image("images/menu/forward.png", 20.0, 20.0, true, true)));
        this.itemForward.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                String targetCommand;
                String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                String itemtype = (String)MessageArea.this.webView.getEngine().executeScript("getItemType()");
                Element element = null;
                if ("MY_IMG".equals(itemtype) || "MY_AUDIO".equals(itemtype) || "MY_VIDEO".equals(itemtype) || "MY_DOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                    targetCommand = "forwardFile";
                } else if ("MY_PERSONAL_RECORD".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                    targetCommand = "forwardPersonalRecord";
                } else if ("OTHER_IMG".equals(itemtype) || "OTHER_AUDIO".equals(itemtype) || "OTHER_VIDEO".equals(itemtype) || "OTHER_DOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                    targetCommand = "forwardFile";
                } else if ("OTHER_PERSONAL_RECORD".equals(itemtype) || "OTHER_VOICEMAIL".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                    targetCommand = "forwardPersonalRecord";
                } else if ("MY_MSG".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageText_" + packetId);
                    targetCommand = "forwardFile";
                } else if ("OTHER_MSG".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageText_" + packetId);
                    targetCommand = "forwardFile";
                } else if ("MY_LOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myLocationAddress_" + packetId);
                    targetCommand = "forwardFile";
                } else if ("OTHER_LOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherLocationAddress_" + packetId);
                    targetCommand = "forwardFile";
                } else {
                    targetCommand = null;
                }
                if (element == null || targetCommand == null) {
                    return;
                }
                final ElementAttrMap targetMap = MessageArea.this.convertTargetElem(element);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageArea.this.handleActionLocal(targetCommand, targetMap);
                    }
                });
            }
        });
        this.itemOpenTempFolder = new MenuItem(I18NUtil.getString("common_btn_open_temp_folder"));
        this.itemOpenTempFolder.setGraphic((Node)new ImageView(new Image("images/menu/folder.png", 20.0, 20.0, true, true)));
        this.itemOpenTempFolder.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(this){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){

                    @Override
                    public void run() {
                        File tempFolder = FileUtil.getTempDir();
                        if (tempFolder.exists() && tempFolder.isDirectory()) {
                            try {
                                Desktop.getDesktop().open(tempFolder);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        });
        this.itemOpenDownloadFolder = new MenuItem(I18NUtil.getString("common_btn_open_download_folder"));
        this.itemOpenDownloadFolder.setGraphic((Node)new ImageView(new Image("images/menu/folder.png", 20.0, 20.0, true, true)));
        this.itemOpenDownloadFolder.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(this){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){

                    @Override
                    public void run() {
                        String userHome = System.getProperty("user.home");
                        File defaultDownloads = new File(userHome, "Downloads");
                        if (!defaultDownloads.exists()) {
                            return;
                        }
                        if (defaultDownloads.isDirectory()) {
                            try {
                                Desktop.getDesktop().open(defaultDownloads);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        });
        this.itemSave = new MenuItem(I18NUtil.getString("common_btn_save_as"));
        this.itemSave.setGraphic((Node)new ImageView(new Image("images/menu/save.png", 20.0, 20.0, true, true)));
        this.itemSave.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                SaveHandler.handle(MessageArea.this, false);
            }
        });
        this.itemSaveDownload = new MenuItem(I18NUtil.getString("common_btn_save_as_to_download"));
        this.itemSaveDownload.setGraphic((Node)new ImageView(new Image("images/menu/save.png", 20.0, 20.0, true, true)));
        this.itemSaveDownload.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                SaveHandler.handle(MessageArea.this, true);
            }
        });
        this.itemCopyImg = new MenuItem(I18NUtil.getString("common_btn_copy"));
        this.itemCopyImg.setGraphic((Node)new ImageView(new Image("images/menu/copy.png", 20.0, 20.0, true, true)));
        this.itemCopyImg.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                String targetCommand;
                String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                String itemtype = (String)MessageArea.this.webView.getEngine().executeScript("getItemType()");
                Element element = null;
                if ("MY_IMG".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                    targetCommand = "copyImgToClipboard";
                } else if ("OTHER_IMG".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                    targetCommand = "copyImgToClipboard";
                } else {
                    targetCommand = null;
                }
                if (element == null || targetCommand == null) {
                    return;
                }
                final ElementAttrMap targetMap = MessageArea.this.convertTargetElem(element);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageArea.this.handleActionLocal(targetCommand, targetMap);
                    }
                });
            }
        });
        this.itemDelete = new MenuItem(I18NUtil.getString("common_btn_delete"));
        this.itemDelete.setGraphic((Node)new ImageView(new Image("images/menu/delete.png", 20.0, 20.0, true, true)));
        this.itemDelete.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                String targetCommand;
                String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                String itemtype = (String)MessageArea.this.webView.getEngine().executeScript("getItemType()");
                Element element = null;
                if ("MY_IMG".equals(itemtype) || "MY_AUDIO".equals(itemtype) || "MY_VIDEO".equals(itemtype) || "MY_DOC".equals(itemtype) || "MY_PHONE_TALKING".equals(itemtype) || "MY_PHONE_CANCEL".equals(itemtype) || "MY_PERSONAL_RECORD".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                    targetCommand = "deleteFile";
                } else if ("OTHER_IMG".equals(itemtype) || "OTHER_AUDIO".equals(itemtype) || "OTHER_VIDEO".equals(itemtype) || "OTHER_DOC".equals(itemtype) || "OTHER_PHONE_TALKING".equals(itemtype) || "OTHER_PHONE_CANCEL".equals(itemtype) || "OTHER_PERSONAL_RECORD".equals(itemtype) || "OTHER_VOICEMAIL".equals(itemtype) || "OTHER_VOICEMAIL".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                    targetCommand = "deleteFile";
                } else if ("NOTICE".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("noticeMessageThumbnail_" + packetId);
                    targetCommand = "deleteFile";
                } else if ("MY_MSG".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("myMessageText_" + packetId);
                    targetCommand = "deleteFile";
                } else if ("OTHER_MSG".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("otherMessageText_" + packetId);
                    targetCommand = "deleteFile";
                } else if ("MY_LOC".equals(itemtype) || "MY_PUNCH".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("msg_" + packetId);
                    targetCommand = "deleteFile";
                } else if ("OTHER_LOC".equals(itemtype) || "OTHER_PUNCH".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("msg_" + packetId);
                    targetCommand = "deleteFile";
                } else {
                    targetCommand = null;
                }
                if (element == null || targetCommand == null) {
                    return;
                }
                final ElementAttrMap targetMap = MessageArea.this.convertTargetElem(element);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageArea.this.handleActionLocal(targetCommand, targetMap);
                    }
                });
            }
        });
        this.itemReply = new MenuItem(I18NUtil.getString("common_btn_quote"));
        this.itemReply.setGraphic((Node)new ImageView(new Image("images/menu/reply.png", 20.0, 20.0, true, true)));
        this.itemReply.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                final String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageArea.this.callback.onQuoteSelected(packetId);
                    }
                });
            }
        });
        this.itemRecall = new MenuItem(I18NUtil.getString("common_btn_recall"));
        this.itemRecall.setGraphic((Node)new ImageView(new Image("images/menu/recall.png", 20.0, 20.0, true, true)));
        this.itemRecall.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                String targetCommand;
                String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                String itemtype = (String)MessageArea.this.webView.getEngine().executeScript("getItemType()");
                Element element = null;
                if ("MY_MSG".equals(itemtype) || "MY_LOC".equals(itemtype) || "MY_PUNCH".equals(itemtype) || "MY_IMG".equals(itemtype) || "MY_AUDIO".equals(itemtype) || "MY_VIDEO".equals(itemtype) || "MY_DOC".equals(itemtype)) {
                    element = MessageArea.this.document.getElementById("msg_" + packetId);
                    targetCommand = "recallMsg";
                } else {
                    targetCommand = null;
                }
                if (element == null || targetCommand == null) {
                    return;
                }
                final ElementAttrMap targetMap = MessageArea.this.convertTargetElem(element);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageArea.this.handleActionLocal(targetCommand, targetMap);
                    }
                });
            }
        });
        this.itemCopySelection = new MenuItem(I18NUtil.getString("common_btn_copy_text_selection"));
        this.itemCopySelection.setGraphic((Node)new ImageView(new Image("images/menu/copy.png", 20.0, 20.0, true, true)));
        this.itemCopySelection.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                MessageArea.this.doCopySelection();
            }
        });
        this.itemCopyText = new MenuItem(I18NUtil.getString("common_btn_copy_text"));
        this.itemCopyText.setGraphic((Node)new ImageView(new Image("images/menu/copy.png", 20.0, 20.0, true, true)));
        this.itemCopyText.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                MessageArea.this.doCopyText();
            }
        });
        this.itemCopyMsg = new MenuItem(I18NUtil.getString("common_btn_copy_msg"));
        this.itemCopyMsg.setGraphic((Node)new ImageView(new Image("images/menu/copy.png", 20.0, 20.0, true, true)));
        this.itemCopyMsg.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

            @Override
            public void handle(javafx.event.ActionEvent e) {
                MessageArea.this.doCopyMsg();
            }
        });
        this.webView = new WebView();
        this.webView.setContextMenuEnabled(false);
        this.webView.setOnKeyPressed(event -> {
            if ((event.isControlDown() || event.isMetaDown()) && (event.getCode() == KeyCode.C || "c".equalsIgnoreCase(event.getText()))) {
                this.doCopyShort();
                event.consume();
            }
        });
        this.webView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouse) {
                try {
                    if (mouse.getButton() == MouseButton.SECONDARY) {
                        boolean faxEnabled;
                        if (MessageArea.this.historyMode) {
                            return;
                        }
                        Boolean isMenuOn = (Boolean)MessageArea.this.webView.getEngine().executeScript("isMenuOn()");
                        if (!isMenuOn.booleanValue()) {
                            return;
                        }
                        MessageArea.this.requestFocusInWindow();
                        MessageArea.this.menu = new ContextMenu();
                        boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
                        String itemtype = (String)MessageArea.this.webView.getEngine().executeScript("getItemType()");
                        String packetId = (String)MessageArea.this.webView.getEngine().executeScript("getMousePacketId()");
                        MessageStatus msgStatus = null;
                        long msgTime = -1L;
                        int menuItemCount = 0;
                        if (StringUtils.isNotBlank((CharSequence)packetId)) {
                            Message msg = MessageArea.this.callback.getMessageByPacketId(packetId);
                            msgStatus = DomUtil.convertMsgStatus(msg.getStatus());
                            msgTime = msg.getServerTime();
                        }
                        if (hasChatPermission && MessageArea.this.callback.isChatModeEnabled() && ApiVersion.isApi29Later() && ("MY_IMG".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_IMG".equals(itemtype) || "MY_VIDEO".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_VIDEO".equals(itemtype) || "MY_DOC".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_DOC".equals(itemtype) || "MY_AUDIO".equals(itemtype) || "OTHER_AUDIO".equals(itemtype) || "MY_MSG".equals(itemtype) || "OTHER_MSG".equals(itemtype) || "MY_LOC".equals(itemtype) || "OTHER_LOC".equals(itemtype) || "MY_PUNCH".equals(itemtype) || "OTHER_PUNCH".equals(itemtype))) {
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemReply);
                            ++menuItemCount;
                        }
                        if (menuItemCount > 0) {
                            MessageArea.this.menu.getItems().add(new SeparatorMenuItem());
                            menuItemCount = 0;
                        }
                        if (!JidUtil.isCustomerJid(MessageArea.this.chatId)) {
                            int deadline = PreferencesUtil.getMsgRecallDeadline(UCChatClient.context);
                            if (ApiVersion.isApi11Later() && (System.currentTimeMillis() - msgTime) / 60000L <= (long)deadline && MessageStatusUtil.isRecallable(itemtype, msgStatus)) {
                                MessageArea.this.menu.getItems().add(MessageArea.this.itemRecall);
                                ++menuItemCount;
                            }
                        }
                        if (menuItemCount > 0) {
                            MessageArea.this.menu.getItems().add(new SeparatorMenuItem());
                            menuItemCount = 0;
                        }
                        if ("MY_IMG".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_IMG".equals(itemtype) || "MY_VIDEO".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_VIDEO".equals(itemtype) || "MY_DOC".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_DOC".equals(itemtype) || "MY_PERSONAL_RECORD".equals(itemtype) || "OTHER_PERSONAL_RECORD".equals(itemtype) || "OTHER_VOICEMAIL".equals(itemtype)) {
                            String userHome;
                            File defaultDownloads;
                            if (hasChatPermission) {
                                MessageArea.this.menu.getItems().add(MessageArea.this.itemForward);
                                ++menuItemCount;
                            }
                            if (menuItemCount > 0) {
                                MessageArea.this.menu.getItems().add(new SeparatorMenuItem());
                                menuItemCount = 0;
                            }
                            if ((defaultDownloads = new File(userHome = System.getProperty("user.home"), "Downloads")).exists()) {
                                MessageArea.this.menu.getItems().add(MessageArea.this.itemSaveDownload);
                                ++menuItemCount;
                            }
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemSave);
                            ++menuItemCount;
                            if (defaultDownloads.exists()) {
                                MessageArea.this.menu.getItems().add(MessageArea.this.itemOpenDownloadFolder);
                                ++menuItemCount;
                            }
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemOpenTempFolder);
                            ++menuItemCount;
                        } else if (("MY_AUDIO".equals(itemtype) || "OTHER_AUDIO".equals(itemtype) || "MY_MSG".equals(itemtype) || "OTHER_MSG".equals(itemtype) || "MY_LOC".equals(itemtype) || "OTHER_LOC".equals(itemtype)) && hasChatPermission) {
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemForward);
                            ++menuItemCount;
                        }
                        if (menuItemCount > 0) {
                            MessageArea.this.menu.getItems().add(new SeparatorMenuItem());
                            menuItemCount = 0;
                        }
                        if ((faxEnabled = PreferencesUtil.isFaxEnabled(UCChatClient.context)) && ("MY_IMG".equals(itemtype) || "OTHER_IMG".equals(itemtype) || "MY_DOC".equals(itemtype) || "OTHER_DOC".equals(itemtype))) {
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemFax);
                            ++menuItemCount;
                        }
                        if (menuItemCount > 0) {
                            MessageArea.this.menu.getItems().add(new SeparatorMenuItem());
                            menuItemCount = 0;
                        }
                        if ("MY_IMG".equals(itemtype) && msgStatus != null && msgStatus != MessageStatus.UPLOADING || "OTHER_IMG".equals(itemtype)) {
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemCopyImg);
                            ++menuItemCount;
                        }
                        if ("MY_MSG".equals(itemtype) || "OTHER_MSG".equals(itemtype)) {
                            String selection = (String)MessageArea.this.webView.getEngine().executeScript("window.getSelection().toString();");
                            if (StringUtils.isNotBlank((CharSequence)selection)) {
                                MessageArea.this.menu.getItems().add(MessageArea.this.itemCopySelection);
                                ++menuItemCount;
                            } else {
                                MessageArea.this.menu.getItems().add(MessageArea.this.itemCopyText);
                                ++menuItemCount;
                            }
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemCopyMsg);
                            ++menuItemCount;
                        }
                        if (menuItemCount > 0) {
                            MessageArea.this.menu.getItems().add(new SeparatorMenuItem());
                            menuItemCount = 0;
                        }
                        if (!"SYS".equals(itemtype)) {
                            MessageArea.this.menu.getItems().add(MessageArea.this.itemDelete);
                            ++menuItemCount;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Log.d(MessageArea.class.getSimpleName(), "focus:" + MessageArea.this.webView.isFocused());
                                MessageArea.this.webView.requestFocus();
                            }
                        });
                        MessageArea.this.menu.show((Node)MessageArea.this.webView, mouse.getScreenX(), mouse.getScreenY());
                    } else if (MessageArea.this.menu != null) {
                        MessageArea.this.menu.hide();
                        MessageArea.this.menu = null;
                    }
                }
                catch (Throwable t) {
                    Log.e(MessageArea.class.getSimpleName(), t.getLocalizedMessage(), t);
                }
            }
        });
        this.scrollchangeListener = new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                MessageArea.this.doScroll();
            }
        };
        this.stateChangeListener = new ChangeListener<Worker.State>(){

            @Override
            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    if (MessageArea.this.documentInitial == 0) {
                        Document doc = MessageArea.this.webEngine.getDocument();
                        MessageArea.this.template = new MessageTemplate(doc);
                        MessageArea.this.documentInitial = 1;
                        MessageArea.this.webEngine.loadContent(MessageResource.messageAreaBody.toString());
                    } else if (MessageArea.this.documentInitial == 1) {
                        MessageArea.this.document = MessageArea.this.webEngine.getDocument();
                        MessageArea.this.tableContent = MessageArea.this.document.getElementById("tableContent");
                        MessageArea.this.documentInitial = 2;
                    }
                }
            }
        };
        this.webView.getChildrenUnmodifiable().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (Node node : c.getAddedSubList()) {
                        ScrollBar scroll;
                        if (!ScrollBar.class.isInstance(node) || (scroll = (ScrollBar)node).getParent() != MessageArea.this.webView || scroll.getOrientation() != Orientation.VERTICAL) continue;
                        MessageArea.this.targetScroll = scroll;
                        MessageArea.this.targetScroll.setPrefWidth(18.0);
                        MessageArea.this.targetScroll.valueProperty().addListener(MessageArea.this.scrollchangeListener);
                    }
                }
            }
        });
        this.borderPane = new BorderPane();
        this.borderPane.setCenter((Node)this.webView);
        StackPane s = new StackPane();
        HBox box = new HBox();
        box.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.dateDispLabel = new Label();
        this.dateDispLabel.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.dateDispLabel.setTextFill((Paint)Color.WHITE);
        Locale locale = I18NUtil.getAppLocale();
        if (locale == Locale.CHINA || locale == Locale.SIMPLIFIED_CHINESE) {
            this.dateDispLabel.setFont(Font.font((String)"Microsoft YaHei", (FontWeight)FontWeight.NORMAL, (double)12.0));
        } else {
            this.dateDispLabel.setFont(Font.font((String)"Microsoft JhengHei", (FontWeight)FontWeight.NORMAL, (double)12.0));
        }
        this.dateDispLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)128, (int)128, (int)128, (double)1.0), new CornerRadii(5.0), new Insets(-3.0, -8.0, -3.0, -8.0))}));
        this.dateDispLabel.setVisible(false);
        box.getChildren().add(this.dateDispLabel);
        box.setAlignment(Pos.TOP_CENTER);
        box.setPickOnBounds(false);
        s.getChildren().addAll(this.borderPane, box);
        Scene scene = new Scene((Parent)s);
        this.setScene(scene);
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener(this.stateChangeListener);
        this.webEngine.loadContent(MessageResource.messageTemplate.toString());
    }

    private void doCopyText() {
        Message message;
        String selection = "";
        String packetId = (String)this.webView.getEngine().executeScript("getMousePacketId()");
        if (StringUtils.isNotBlank((CharSequence)packetId) && (message = this.callback.getMessageByPacketId(packetId)) != null) {
            selection = message.getContent();
        }
        if (StringUtils.isNotBlank((CharSequence)selection)) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(selection);
            clipboard.setContent((Map)content);
        }
    }

    private void doCopySelection() {
        String selection = (String)this.webView.getEngine().executeScript("window.getSelection().toString();");
        if (StringUtils.isNotBlank((CharSequence)selection)) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(selection);
            clipboard.setContent((Map)content);
        }
    }

    private void doCopyShort() {
    }

    private List<String> getSelectedMsgList() {
        String selection = (String)this.webView.getEngine().executeScript("findSelectedTextNodeParentId();");
        ArrayList<String> packetIdList = new ArrayList<String>();
        try {
            JSONArray ary = new JSONArray(selection);
            for (int i = 0; i < ary.length(); ++i) {
                String packetId;
                String id = ary.getString(i);
                if (id.startsWith(MY_MSG_MAIN_PREFIX)) {
                    packetId = id.substring(MY_MSG_MAIN_PREFIX.length());
                    if (packetIdList.contains(packetId)) continue;
                    packetIdList.add(packetId);
                    continue;
                }
                if (id.startsWith(OTHER_MSG_MAIN_PREFIX)) {
                    packetId = id.substring(OTHER_MSG_MAIN_PREFIX.length());
                    if (packetIdList.contains(packetId)) continue;
                    packetIdList.add(packetId);
                    continue;
                }
                if (id.startsWith(MY_MSG_PREFIX)) {
                    packetId = id.substring(MY_MSG_PREFIX.length());
                    if (packetIdList.contains(packetId)) continue;
                    packetIdList.add(packetId);
                    continue;
                }
                if (!id.startsWith(OTHER_MSG_PREFIX) || packetIdList.contains(packetId = id.substring(OTHER_MSG_PREFIX.length()))) continue;
                packetIdList.add(packetId);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return packetIdList;
    }

    private void doCopyMsg() {
        this.doCopyMsg(this.getSelectedMsgList());
    }

    private void doCopyMsg(List<String> packetIdList) {
        String packetId;
        if (packetIdList.size() == 0 && StringUtils.isNotBlank((CharSequence)(packetId = (String)this.webView.getEngine().executeScript("getMousePacketId()")))) {
            packetIdList.add(packetId);
        }
        StringBuffer selectionBuf = new StringBuffer();
        String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
        for (String packetId2 : packetIdList) {
            Message msg = this.callback.getMessageByPacketId(packetId2);
            if (msg == null) continue;
            if (selectionBuf.length() > 0) {
                selectionBuf.append("\n");
            }
            selectionBuf.append(DateTimeUtil.getBulletinTimeStr(msg.getServerTime()));
            String participantJID = msg.getFromJid();
            if (participantJID.equals(myJid)) {
                selectionBuf.append(" ");
                selectionBuf.append(ContactManager.getContactShortName((Context)UCChatClient.context, ContactManager.getContact((Context)UCChatClient.context, myJid)));
            } else {
                selectionBuf.append(" ");
                selectionBuf.append(MsgUtil.getFromName(UCChatClient.context, participantJID, null));
            }
            selectionBuf.append(" ");
            selectionBuf.append(msg.getContent());
        }
        if (selectionBuf.length() > 0) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(selectionBuf.toString());
            clipboard.setContent((Map)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScroll() {
        Object object = this.scrollObject;
        synchronized (object) {
            final int scrollAtTop = (Integer)this.webView.getEngine().executeScript("document.documentElement.scrollTop || document.body.scrollTop");
            if (this.callback != null && scrollAtTop == 0) {
                Log.d(MessageArea.class.getSimpleName(), "scroll to top");
                this.callback.onScrollTop();
                this.targetScroll.requestLayout();
            }
            if (this.scrollTask1 != null) {
                this.scrollTask1.cancel();
            }
            this.scrollTask1 = new UCTimerTask(){

                @Override
                public void doRun() {
                    Platform.runLater((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (MessageArea.this.webView == null || MessageArea.this.webView.getEngine() == null) {
                                return;
                            }
                            Object object = MessageArea.this.scrollObject;
                            synchronized (object) {
                                String packetId;
                                Message msg;
                                if (scrollAtTop != 0) {
                                    MessageArea.this.scrollBarAtBottom = false;
                                    Boolean isBottom = (Boolean)MessageArea.this.webView.getEngine().executeScript("(document.body.offsetHeight + document.body.scrollTop) >= document.body.scrollHeight");
                                    Log.d(MessageArea.class.getSimpleName(), "isBottom:" + isBottom);
                                    if (isBottom != null && isBottom.booleanValue()) {
                                        MessageArea.this.scrollBarAtBottom = true;
                                    }
                                    if (MessageArea.this.callback != null) {
                                        if (MessageArea.this.scrollBarAtBottom) {
                                            Log.d(MessageArea.class.getSimpleName(), "scroll to bottom");
                                            MessageArea.this.callback.onScrollBottom();
                                            MessageArea.this.targetScroll.requestLayout();
                                        } else {
                                            Log.d(MessageArea.class.getSimpleName(), "scroll to bottom");
                                            MessageArea.this.callback.onScrollNotBottom();
                                        }
                                    }
                                }
                                String eleId = (String)MessageArea.this.webView.getEngine().executeScript("findTopVisibleEle()");
                                Element e = MessageArea.this.document.getElementById(eleId);
                                if (e == null) {
                                    return;
                                }
                                if (e.hasAttribute("packetId") && (msg = MessageArea.this.callback.getMessageByPacketId(packetId = e.getAttribute("packetId"))) != null) {
                                    long serverTimestamp = msg.getServerTime();
                                    String newStr = DateTimeUtil.getTimeStr(serverTimestamp);
                                    MessageArea.this.dateDispLabel.setText(newStr);
                                    MessageArea.this.dateDispLabel.setVisible(true);
                                    if (MessageArea.this.hideDateTimer != null) {
                                        MessageArea.this.hideDateTimer.stop();
                                        MessageArea.this.hideDateTimer = null;
                                    }
                                    MessageArea.this.hideDateTimer = new Timer(3000, new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent ld2) {
                                            Platform.runLater((Runnable)new Runnable(){

                                                @Override
                                                public void run() {
                                                    MessageArea.this.dateDispLabel.setText("");
                                                    MessageArea.this.dateDispLabel.setVisible(false);
                                                }
                                            });
                                        }
                                    });
                                    MessageArea.this.hideDateTimer.setRepeats(false);
                                    MessageArea.this.hideDateTimer.start();
                                }
                            }
                        }
                    });
                }
            };
            this.messageAreaTimer.schedule((TimerTask)this.scrollTask1, 300L);
        }
    }

    private void checkDocumentInitial() {
        while (this.documentInitial != 2) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public String getChatId() {
        return this.chatId;
    }

    public boolean showPacketId(String packetId) {
        if (this.messageSet.contains(packetId)) {
            return false;
        }
        this.messageSet.add(packetId);
        return true;
    }

    public void hidePacketId(String packetId) {
        this.messageSet.remove(packetId);
    }

    public void reloadPage() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
                for (String key : MessageArea.this.headPhotoMap.keySet()) {
                    String jid = MessageArea.this.headPhotoMap.get(key);
                    Object photoURI = null;
                    if (myJid.equals(jid)) {
                        photoURI = ContactManager.getContactPhotoURI(jid);
                    } else if (JidUtil.isAPIUserJid(jid)) {
                        MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(UCChatClient.context, jid);
                        photoURI = MessageChannelManager.getChannelPhotoURI(channel.getId());
                    } else if (JidUtil.isMyContactJid(jid)) {
                        long contactId = JidUtil.trimExternalContactId(jid);
                        photoURI = ContactManager.getExternalContactPhotoURI(contactId);
                    } else if (JidUtil.isEmployeeJid(jid)) {
                        photoURI = ContactManager.getContactPhotoURI(jid);
                    } else if (JidUtil.isCustomerJid(jid)) {
                        photoURI = CustomerManager.getContactPhotoURI(jid);
                    }
                    photoURI = photoURI == null ? MessageResource.noNamePhotoURI : (String)photoURI + "?" + System.currentTimeMillis();
                    Element photoelem = MessageArea.this.document.getElementById(key);
                    if (photoelem == null) continue;
                    photoelem.setAttribute("src", "");
                    photoelem.setAttribute("src", (String)photoURI);
                }
            }
        });
    }

    public void reloadSystemInfo() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap<String, LiteContact> contactCache = new HashMap<String, LiteContact>();
                    for (String packetId : MessageArea.this.systemMsgMap.keySet()) {
                        String key = MessageArea.this.systemMsgMap.get(packetId);
                        Message msg = MessageArea.this.callback.getMessageByPacketId(packetId);
                        if (msg == null) continue;
                        int msgType = msg.getMsgType();
                        Object content = msg.getContent();
                        if (!MsgUtil.isSystemMsg(msgType)) continue;
                        LiteConferenceRoom meetingRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, MessageArea.this.chatId);
                        content = MessageContentUtil.convertMessage(UCChatClient.context, msg, contactCache, meetingRoom != null);
                        content = "  " + (String)content + "  ";
                        Element elem_systemMessageText = MessageArea.this.document.getElementById(key);
                        DomUtil.cleanTextNodes(elem_systemMessageText);
                        elem_systemMessageText.appendChild(MessageArea.this.document.createTextNode((String)content));
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public ElementAttrMap convertTargetElem(Element targetElem) {
        ElementAttrMap attributeMap = new ElementAttrMap();
        NamedNodeMap map = targetElem.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            org.w3c.dom.Node node = map.item(i);
            attributeMap.put(node.getNodeName(), node.getNodeValue());
        }
        return attributeMap;
    }

    public void handleErrorAction(Event ev) {
        Element targetElem = (Element)((Object)ev.getTarget());
        final String packetId = targetElem.getAttribute("packetId");
        final long msgId = Long.parseLong(targetElem.getAttribute("messageId").toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResendMessagePanel resendMsgPanel = new ResendMessagePanel(MessageArea.this, packetId, msgId);
                UCChatClient.getInstance().showGlassPanel(resendMsgPanel, true);
            }
        });
    }

    public void handleAction(Event ev) {
        final ElementAttrMap targetMap = this.convertTargetElem((Element)((Object)ev.getTarget()));
        final String targetCommand = targetMap.get("command");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageArea.this.handleActionLocal(targetCommand, targetMap);
            }
        });
    }

    public boolean isMsgLoaded(String packetId) {
        return this.messageSet.contains(packetId);
    }

    public int getMessageSize() {
        return this.messageSet.size();
    }

    public void scrollToPacketId(String packetId) {
        this.checkDocumentInitial();
        if (!this.messageSet.contains(packetId)) {
            this.callback.dumpToPacketId(packetId);
        } else {
            this.doScrollToPacketId(packetId, 100);
        }
    }

    public void doScrollToPacketId(final String packetId, final int interval) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageArea.this.webView.getEngine().executeScript("scrollToMsg(\"msg_" + packetId + "\", " + interval + ");");
            }
        });
    }

    public void doScrollToPacketIdWithShift(final String packetId, final int shift, final int interval) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageArea.this.webView.getEngine().executeScript("scrollToMsgWithShift(\"msg_" + packetId + "\", " + shift + ", " + interval + ");");
            }
        });
    }

    public void handleActionLocal(String targetCommand, final ElementAttrMap targetMap) {
        if ("scrollToMsg".equals(targetCommand)) {
            this.scrollToPacketId(targetMap.get("refPacketId"));
        } else if ("selectAll".equals(targetCommand)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    String keyId = targetMap.get("mainTextId");
                    MessageArea.this.webView.getEngine().executeScript("selectText(\"" + keyId + "\");");
                }
            });
        } else if ("displayLocation".equals(targetCommand)) {
            DisplayLocation.handle(this, targetMap);
        } else if ("redialMine".equals(targetCommand)) {
            DialOutbound.handleRedialMine(this, targetMap);
        } else if ("redialOthers".equals(targetCommand)) {
            DialOutbound.handleRedialOthers(this, targetMap);
        } else if ("downloadImage".equals(targetCommand)) {
            DownloadImage.handle(this, targetMap);
        } else if ("downloadAudio".equals(targetCommand)) {
            DownloadAudio.handle(this, targetMap);
        } else if ("downloadPersonalRecord".equals(targetCommand)) {
            DownloadPersonalRecord.handle(this, targetMap);
        } else if ("downloadVoiceMail".equals(targetCommand)) {
            DownloadVoicemail.handle(this, targetMap);
        } else if ("downloadVideo".equals(targetCommand) || "downloadDocument".equals(targetCommand)) {
            DownloadDocument.handle(this, targetMap);
        } else if ("cancelUpload".equals(targetCommand)) {
            Log.i(MessageArea.class.getSimpleName(), "Cancel upload---------");
            CancelUpload.handle(this, targetMap);
        } else if ("cancelDownload".equals(targetCommand)) {
            Log.i(MessageArea.class.getSimpleName(), "Cancel download---------");
            String packetId = targetMap.get("packetId");
            DownloadFileTask task = this.downloadFileTaskMap.get(packetId);
            task.cancel();
        } else if ("saveFile".equals(targetCommand)) {
            SaveFile.handle(this, targetMap);
        } else if ("saveFileToDownload".equals(targetCommand)) {
            SaveFileToDownload.handle(this, targetMap);
        } else if ("copyImgToClipboard".equals(targetCommand)) {
            CopyFile.handle(this, targetMap);
        } else if ("forwardAudio".equals(targetCommand)) {
            ForwardMsg.handle(this, targetMap);
        } else if ("forwardFile".equals(targetCommand)) {
            ForwardMsg.handle(this, targetMap);
        } else if ("showReadUnreadList".equals(targetCommand)) {
            String packetId = targetMap.get("packetId");
            ShowMsgReadUnreadStatusDialog scd = new ShowMsgReadUnreadStatusDialog(UCChatClient.getInstance(), this.chatId, packetId);
            scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
            scd.showDialog();
        } else if ("forwardPersonalRecord".equals(targetCommand)) {
            ForwardVoicePersonalFile.handle(this, targetMap);
        } else if ("saveVoiceRecordFile".equals(targetCommand)) {
            SaveVoicePersonalFile.handle(this, targetMap);
        } else if ("saveVoiceRecordFileToDownload".equals(targetCommand)) {
            SaveVoicePersonalFileToDownload.handle(this, targetMap);
        } else if ("deleteFile".equals(targetCommand)) {
            String packetId = targetMap.get("packetId");
            DeleteFile.handle(this, packetId);
        } else if ("recallMsg".equals(targetCommand)) {
            String packetId = targetMap.get("packetId");
            RecallMsg.handle(this, packetId);
        } else if ("openUrl".equals(targetCommand)) {
            String urlToOpen = targetMap.get("urlToOpen");
            OpenUrlHandler.handle(urlToOpen);
        } else if ("attachName".equals(targetCommand)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    String packetId = targetMap.get("packetId");
                    Element elem_other_name_selected = MessageArea.this.document.getElementById("otherName_" + packetId);
                    String name = elem_other_name_selected.getTextContent();
                    if (TextUtils.isNotBlank((CharSequence)name)) {
                        MessageArea.this.callback.attachFromName(name);
                    }
                }
            });
        }
    }

    public void onHide() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MessageArea.this.stopAudioFile();
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void onClose() {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Set<String> eventSet;
                    try {
                        MessageArea.this.stopAudioFile();
                    }
                    catch (UCThreadException e) {
                        Log.e(MessageArea.class.getSimpleName(), e.getMessage(), e);
                    }
                    if (MessageArea.this.elementEventMap != null) {
                        HashSet<Element> elementSet = new HashSet<Element>(MessageArea.this.elementEventMap.keySet());
                        for (Element element : elementSet) {
                            eventSet = MessageArea.this.elementEventMap.get(element);
                            if (eventSet == null) continue;
                            for (String event : eventSet) {
                                ((EventTarget)((Object)element)).removeEventListener(event, MessageArea.this.clickListener, false);
                            }
                        }
                    }
                    if (MessageArea.this.elementErrorEventMap != null) {
                        HashSet<Element> errorElementSet = new HashSet<Element>(MessageArea.this.elementErrorEventMap.keySet());
                        for (Element element : errorElementSet) {
                            eventSet = MessageArea.this.elementErrorEventMap.get(element);
                            if (eventSet == null) continue;
                            for (String event : eventSet) {
                                ((EventTarget)((Object)element)).removeEventListener(event, MessageArea.this.errorClickListener, false);
                            }
                        }
                    }
                    MessageArea.this.elementEventMap.clear();
                    MessageArea.this.elementErrorEventMap.clear();
                    MessageArea.this.messageSet.clear();
                    MessageArea.this.downloadFileTaskMap.clear();
                    MessageArea.this.downloadUrlMap.clear();
                    MessageArea.this.headPhotoMap.clear();
                    MessageArea.this.refPhotoMap.clear();
                    MessageArea.this.refMap.clear();
                    MessageArea.this.systemMsgMap.clear();
                    if (MessageArea.this.webView != null) {
                        MessageArea.this.webView.setOnMouseClicked(null);
                    }
                    if (MessageArea.this.targetScroll != null) {
                        MessageArea.this.targetScroll.valueProperty().removeListener(MessageArea.this.scrollchangeListener);
                    }
                    if (MessageArea.this.webEngine != null) {
                        MessageArea.this.webEngine.getLoadWorker().stateProperty().removeListener(MessageArea.this.stateChangeListener);
                        MessageArea.this.stateChangeListener = null;
                        MessageArea.this.webEngine.load(null);
                    }
                    if (MessageArea.this.itemCopySelection != null) {
                        MessageArea.this.itemCopySelection.setOnAction(null);
                        MessageArea.this.itemCopySelection = null;
                    }
                    if (MessageArea.this.itemCopyText != null) {
                        MessageArea.this.itemCopyText.setOnAction(null);
                        MessageArea.this.itemCopyText = null;
                    }
                    if (MessageArea.this.itemCopyMsg != null) {
                        MessageArea.this.itemCopyMsg.setOnAction(null);
                        MessageArea.this.itemCopyMsg = null;
                    }
                    if (MessageArea.this.itemForward != null) {
                        MessageArea.this.itemForward.setOnAction(null);
                        MessageArea.this.itemForward = null;
                    }
                    if (MessageArea.this.itemSave != null) {
                        MessageArea.this.itemSave.setOnAction(null);
                        MessageArea.this.itemSave = null;
                    }
                    if (MessageArea.this.itemSaveDownload != null) {
                        MessageArea.this.itemSaveDownload.setOnAction(null);
                        MessageArea.this.itemSaveDownload = null;
                    }
                    if (MessageArea.this.itemOpenTempFolder != null) {
                        MessageArea.this.itemOpenTempFolder.setOnAction(null);
                        MessageArea.this.itemOpenTempFolder = null;
                    }
                    if (MessageArea.this.itemOpenDownloadFolder != null) {
                        MessageArea.this.itemOpenDownloadFolder.setOnAction(null);
                        MessageArea.this.itemOpenDownloadFolder = null;
                    }
                    if (MessageArea.this.itemDelete != null) {
                        MessageArea.this.itemDelete.setOnAction(null);
                        MessageArea.this.itemDelete = null;
                    }
                    if (MessageArea.this.itemRecall != null) {
                        MessageArea.this.itemRecall.setOnAction(null);
                        MessageArea.this.itemRecall = null;
                    }
                }
            });
            if (this.hideDateTimer != null) {
                this.hideDateTimer.stop();
            }
            if (this.currentPlayerRequest != null) {
                this.currentPlayerRequest.cleanup();
            }
            if (this.updateMsgTask != null) {
                this.updateMsgTask.cancel();
            }
            if (this.scrollTask1 != null) {
                this.scrollTask1.cancel();
            }
            if (this.scrollTask2 != null) {
                this.scrollTask2.cancel();
            }
            if (this.messageAreaTimer != null) {
                this.messageAreaTimer.cancel();
            }
            this.documentInitial = 0;
            if (this.getParent() != null) {
                this.getParent().remove((Component)((Object)this));
            }
        }
        catch (Throwable t) {
            Log.i(MessageArea.class.getSimpleName(), t.getMessage(), t);
        }
    }

    public void resetDataForJump() {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Set<String> eventSet;
                if (MessageArea.this.elementEventMap != null) {
                    HashSet<Element> elementSet = new HashSet<Element>(MessageArea.this.elementEventMap.keySet());
                    for (Element element : elementSet) {
                        eventSet = MessageArea.this.elementEventMap.get(element);
                        if (eventSet == null) continue;
                        for (String event : eventSet) {
                            ((EventTarget)((Object)element)).removeEventListener(event, MessageArea.this.clickListener, false);
                        }
                    }
                }
                if (MessageArea.this.elementErrorEventMap != null) {
                    HashSet<Element> errorElementSet = new HashSet<Element>(MessageArea.this.elementErrorEventMap.keySet());
                    for (Element element : errorElementSet) {
                        eventSet = MessageArea.this.elementErrorEventMap.get(element);
                        if (eventSet == null) continue;
                        for (String event : eventSet) {
                            ((EventTarget)((Object)element)).removeEventListener(event, MessageArea.this.errorClickListener, false);
                        }
                    }
                }
                MessageArea.this.elementEventMap.clear();
                MessageArea.this.elementErrorEventMap.clear();
                MessageArea.this.clickListener = new NormalEventListener();
                MessageArea.this.errorClickListener = new ErrorEventListener();
                ArrayList<org.w3c.dom.Node> toRemoveNotList = new ArrayList<org.w3c.dom.Node>();
                NodeList list = MessageArea.this.tableContent.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    org.w3c.dom.Node node = list.item(i);
                    toRemoveNotList.add(node);
                }
                for (org.w3c.dom.Node node : toRemoveNotList) {
                    MessageArea.this.tableContent.removeChild(node);
                }
                MessageArea.this.messageSet.clear();
                MessageArea.this.downloadFileTaskMap.clear();
                MessageArea.this.downloadUrlMap.clear();
                MessageArea.this.headPhotoMap.clear();
                MessageArea.this.refPhotoMap.clear();
                MessageArea.this.refMap.clear();
                MessageArea.this.systemMsgMap.clear();
            }
        });
    }

    public void refreshScrollBar() {
        if (this.scrollBarAtBottom) {
            this.scrollToBottom(100);
        }
    }

    public void scrollToPosition(final int position) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageArea.this.webView.getEngine().executeScript("scrollToPosition(" + position + ");");
            }
        });
    }

    public void scrollToBottom() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageArea.this.webView.getEngine().executeScript("scrollToBottom();");
            }
        });
    }

    public void scrollToBottom(final int interval) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MessageArea.this.webView.getEngine().executeScript("scrollToBottom(" + interval + ");");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private org.w3c.dom.Node cloneAndAdd(org.w3c.dom.Node template, boolean appendToBottom) {
        org.w3c.dom.Node clonedNode = template.cloneNode(true);
        if (appendToBottom) {
            this.tableContent.appendChild(clonedNode);
        } else {
            this.tableContent.insertBefore(clonedNode, this.getFirstNode());
        }
        return clonedNode;
    }

    private org.w3c.dom.Node getFirstNode() {
        org.w3c.dom.Node firstNode = null;
        NodeList nodeList = this.tableContent.getChildNodes();
        if (nodeList.getLength() > 0) {
            firstNode = nodeList.item(0);
        }
        return firstNode;
    }

    public void addMyMessage(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String text = msg.getContent();
                    if (text.startsWith("[PHONE_TALKING]")) {
                        org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myPhoneTalkingTemplate, appendToBottom);
                        MyPhoneTalkingRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    } else if (text.startsWith("[PHONE_CANCEL]")) {
                        org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myPhoneCancelTemplate, appendToBottom);
                        MyPhoneCancelRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    } else {
                        org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myMessageTemplate, appendToBottom);
                        MyTextRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    }
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyLocation(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myLocationTemplate, appendToBottom);
                    MyLocationRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyPunchCard(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myPunchCardTemplate, appendToBottom);
                    MyPunchcardRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyImage(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String extraInfo = msg.getExtraMsgInfo();
                    org.w3c.dom.Node myMessageNode = null;
                    myMessageNode = StringUtils.isNotBlank((CharSequence)extraInfo) ? MessageArea.this.cloneAndAdd(MessageArea.this.template.myImageWithMsgTemplate, appendToBottom) : MessageArea.this.cloneAndAdd(MessageArea.this.template.myImageTemplate, appendToBottom);
                    MyImageRenderer.render(MessageArea.this, (Element)myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyAudio(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myAudioTemplate, appendToBottom);
                    MyAudioRenderer.render(MessageArea.this, (Element)myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId));
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyVideo(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String extraInfo = msg.getExtraMsgInfo();
                    org.w3c.dom.Node myMessageNode = null;
                    myMessageNode = StringUtils.isNotBlank((CharSequence)extraInfo) ? MessageArea.this.cloneAndAdd(MessageArea.this.template.myVideoWithMsgTemplate, appendToBottom) : MessageArea.this.cloneAndAdd(MessageArea.this.template.myVideoTemplate, appendToBottom);
                    MyVideoRenderer.render(MessageArea.this, (Element)myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyDocument(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String extraInfo = msg.getExtraMsgInfo();
                    org.w3c.dom.Node myMessageNode = null;
                    myMessageNode = StringUtils.isNotBlank((CharSequence)extraInfo) ? MessageArea.this.cloneAndAdd(MessageArea.this.template.myDocumentWithMsgTemplate, appendToBottom) : MessageArea.this.cloneAndAdd(MessageArea.this.template.myDocumentTemplate, appendToBottom);
                    MyDocumentRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId), searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addMyPersonalRecord(final String myJid, final String myName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node myMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.myPersonalRecordTemplate, appendToBottom);
                    MyPersonalRecordRenderer.render(MessageArea.this, myMessageNode, msg, myJid, myName, JidUtil.isChatConfJid(MessageArea.this.chatId));
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void updateFileUploadSucceed(final String packetId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_uploadProgressBox;
                Element elem_btnSave;
                Element elem_btnForward = MessageArea.this.document.getElementById("btnForward_" + packetId);
                if (elem_btnForward != null) {
                    elem_btnForward.setAttribute("style", "display:;");
                }
                if ((elem_btnSave = MessageArea.this.document.getElementById("btnSave_" + packetId)) != null) {
                    elem_btnSave.setAttribute("style", "display:;");
                }
                if ((elem_uploadProgressBox = MessageArea.this.document.getElementById("uploadProgressBox_" + packetId)) != null) {
                    elem_uploadProgressBox.setAttribute("style", "display:none;");
                }
            }
        });
    }

    public void updateFileUploadFailed(final String packetId, String fileName) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_uploadProgressBox;
                Element elem_myMessageStatus = MessageArea.this.document.getElementById("myMessageStatus_" + packetId);
                if (elem_myMessageStatus != null) {
                    elem_myMessageStatus.setAttribute("src", DomUtil.getMessageStatusIcon(MessageStatus.NOT_PROCESSED));
                    elem_myMessageStatus.setAttribute("style", "cursor:pointer;");
                    MessageArea.this.addErrorEventListener(elem_myMessageStatus, "click");
                }
                if ((elem_uploadProgressBox = MessageArea.this.document.getElementById("uploadProgressBox_" + packetId)) != null) {
                    elem_uploadProgressBox.setAttribute("style", "display:none;");
                }
            }
        });
    }

    public void updateFileUploadProgress(final String packetId, final int percent) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_progressPercentBar = MessageArea.this.document.getElementById("uploadProgressPercentBar_" + packetId);
                if (elem_progressPercentBar != null) {
                    int percentWidth = 135 * percent / 100;
                    elem_progressPercentBar.setAttribute("style", "width:" + percentWidth + "px;");
                    MessageArea.this.webView.getEngine().executeScript("document.getElementById('uploadProgressPercentText_" + packetId + "').innerHTML=\"" + percent + "%\"");
                }
            }
        });
    }

    public void updateMessageContent(final String packetId) {
        String noticeThumbnail;
        this.checkDocumentInitial();
        Message msg = this.callback.getMessageByPacketId(packetId);
        if (msg == null) {
            return;
        }
        final int fixHeight = 35;
        int msgType = msg.getMsgType();
        if (msgType == 5 || msgType == 11) {
            final String imageBase64Content = msg.getContent();
            BufferedImage bi = null;
            if (TextUtils.isNotBlank((CharSequence)imageBase64Content)) {
                bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
                if (bi == null) {
                    return;
                }
                final int imageWidth = bi.getWidth();
                final int imageHeight = bi.getHeight();
                this.messageAreaTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Element elem_imageIcon = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                                if (elem_imageIcon == null) {
                                    elem_imageIcon = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                                }
                                if (elem_imageIcon != null) {
                                    elem_imageIcon.setAttribute("width", String.valueOf(imageWidth));
                                    elem_imageIcon.setAttribute("height", String.valueOf(imageHeight));
                                    elem_imageIcon.setAttribute("src", "");
                                    elem_imageIcon.setAttribute("src", "data:image/png;base64," + imageBase64Content);
                                }
                            }
                        });
                    }
                }, 100L);
                HashSet<String> keyRelated = new HashSet<String>();
                for (String key : this.refPhotoMap.keySet()) {
                    String refPacketId = this.refPhotoMap.get(key);
                    if (!msg.getPacketId().equals(refPacketId)) continue;
                    keyRelated.add(key);
                }
                if (keyRelated.size() > 0) {
                    BufferedImage biSquare = GraphicUtil.crop(bi);
                    BufferedImage biSquare2 = GraphicUtil.convertThumbnailImage(biSquare, 35);
                    final int squareWidth = biSquare2.getWidth();
                    final String imageBase64ContentSquare = GraphicUtil.convertImageToBase64String(biSquare2);
                    for (final String key : keyRelated) {
                        this.messageAreaTimer.schedule((TimerTask)new UCTimerTask(){

                            @Override
                            public void doRun() {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        Element photoElem = MessageArea.this.document.getElementById(key);
                                        if (photoElem != null) {
                                            photoElem.setAttribute("width", String.valueOf(squareWidth));
                                            photoElem.setAttribute("height", String.valueOf(squareWidth));
                                            photoElem.setAttribute("src", "");
                                            photoElem.setAttribute("src", "data:image/png;base64," + imageBase64ContentSquare);
                                        }
                                    }
                                });
                            }
                        }, 100L);
                    }
                }
            }
        } else if (msgType == 4) {
            String imageBase64Content = msg.getContent();
            BufferedImage bi = null;
            if (TextUtils.isNotBlank((CharSequence)imageBase64Content)) {
                bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
                if (bi == null) {
                    return;
                }
                final BufferedImage bi2 = GraphicUtil.convertVideoThumbnailImage(bi, 300, 50);
                if (bi2 == null) {
                    return;
                }
                final int imageWidth = bi2.getWidth();
                final int imageHeight = bi2.getHeight();
                this.messageAreaTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Element elem_imageIcon = MessageArea.this.document.getElementById("otherMessageIcon_" + packetId);
                                if (elem_imageIcon == null) {
                                    elem_imageIcon = MessageArea.this.document.getElementById("myMessageIcon_" + packetId);
                                }
                                if (elem_imageIcon != null) {
                                    elem_imageIcon.setAttribute("width", String.valueOf(imageWidth));
                                    elem_imageIcon.setAttribute("height", String.valueOf(imageHeight));
                                    elem_imageIcon.setAttribute("src", "");
                                    elem_imageIcon.setAttribute("src", "data:image/png;base64," + GraphicUtil.convertImageToBase64String(bi2));
                                }
                            }
                        });
                    }
                }, 100L);
                HashSet<String> keyRelated = new HashSet<String>();
                for (String key : this.refPhotoMap.keySet()) {
                    String refPacketId = this.refPhotoMap.get(key);
                    if (!msg.getPacketId().equals(refPacketId)) continue;
                    keyRelated.add(key);
                }
                if (keyRelated.size() > 0) {
                    BufferedImage biSquare = GraphicUtil.crop(bi);
                    biSquare = GraphicUtil.convertVideoThumbnailImage(biSquare, 35, 17);
                    final int squareWidth = biSquare.getWidth();
                    final String imageBase64ContentSquare = GraphicUtil.convertImageToBase64String(biSquare);
                    for (final String key : keyRelated) {
                        this.messageAreaTimer.schedule((TimerTask)new UCTimerTask(){

                            @Override
                            public void doRun() {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        Element photoElem = MessageArea.this.document.getElementById(key);
                                        if (photoElem != null) {
                                            photoElem.setAttribute("width", String.valueOf(squareWidth));
                                            photoElem.setAttribute("height", String.valueOf(squareWidth));
                                            photoElem.setAttribute("src", "");
                                            photoElem.setAttribute("src", "data:image/png;base64," + imageBase64ContentSquare);
                                        }
                                    }
                                });
                            }
                        }, 100L);
                    }
                }
            }
        } else if (msgType == 99 && TextUtils.isNotBlank((CharSequence)(noticeThumbnail = msg.getNoticeThumbnail()))) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(noticeThumbnail);
            if (bi == null) {
                return;
            }
            final int imageWidth = bi.getWidth();
            final int imageHeight = bi.getHeight();
            this.messageAreaTimer.schedule((TimerTask)new UCTimerTask(){

                @Override
                public void doRun() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Element elem_noticeThumbnail = MessageArea.this.document.getElementById("noticeMessageThumbnail_" + packetId);
                            if (elem_noticeThumbnail != null) {
                                elem_noticeThumbnail.setAttribute("width", String.valueOf(imageWidth * fixHeight / imageHeight));
                                elem_noticeThumbnail.setAttribute("height", String.valueOf(fixHeight));
                                elem_noticeThumbnail.setAttribute("src", "data:image/png;base64," + noticeThumbnail);
                            }
                        }
                    });
                }
            }, 100L);
        }
    }

    public void updateMyMessage(String packetId) {
        this.checkDocumentInitial();
        this.updateMyMessageLocal(packetId, 0);
    }

    private void updateMyMessageLocal(final String packetId, final int tryCount) {
        if (tryCount > 5) {
            return;
        }
        if (tryCount > 0) {
            Log.i(MessageArea.class.getSimpleName(), "updateMyMessage pacektId:" + packetId + " tryCount:" + tryCount);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (MessageArea.this.document == null) {
                    return;
                }
                Element elem_myMessageStatus = MessageArea.this.document.getElementById("myMessageStatus_" + packetId);
                if (elem_myMessageStatus != null) {
                    Message msg = MessageArea.this.callback.getMessageByPacketId(packetId);
                    MessageStatus msgStatus = DomUtil.convertMsgStatus(msg.getStatus());
                    elem_myMessageStatus.setAttribute("src", DomUtil.getMessageStatusIcon(msgStatus));
                    if (msgStatus == MessageStatus.NOT_PROCESSED) {
                        elem_myMessageStatus.setAttribute("style", "cursor:pointer;");
                        MessageArea.this.addErrorEventListener(elem_myMessageStatus, "click");
                    }
                } else {
                    if (MessageArea.this.updateMsgTask != null) {
                        MessageArea.this.updateMsgTask.cancel();
                    }
                    MessageArea.this.updateMsgTask = new UCTimerTask(){

                        @Override
                        public void doRun() {
                            MessageArea.this.updateMyMessageLocal(packetId, tryCount + 1);
                        }
                    };
                    MessageArea.this.messageAreaTimer.schedule((TimerTask)MessageArea.this.updateMsgTask, 500L);
                }
            }
        });
    }

    public void addOtherMessage(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    if (MessageArea.this.template == null) {
                        return;
                    }
                    String text = msg.getContent();
                    if (text.startsWith("[PHONE_TALKING]")) {
                        org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherPhoneTalkingTemplate, appendToBottom);
                        OtherPhoneTalkingRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    } else if (text.startsWith("[PHONE_CANCEL]")) {
                        org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherPhoneCancelTemplate, appendToBottom);
                        OtherPhoneCancelRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    } else {
                        org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherMessageTemplate, appendToBottom);
                        OtherTextRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    }
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherLocation(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherLocationTemplate, appendToBottom);
                    OtherLocationRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherPunchCard(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherPunchCardTemplate, appendToBottom);
                    OtherPunchcardRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherImage(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String extraInfo = msg.getExtraMsgInfo();
                    org.w3c.dom.Node otherMessageNode = null;
                    otherMessageNode = StringUtils.isNotBlank((CharSequence)extraInfo) ? MessageArea.this.cloneAndAdd(MessageArea.this.template.otherImageWithMsgTemplate, appendToBottom) : MessageArea.this.cloneAndAdd(MessageArea.this.template.otherImageTemplate, appendToBottom);
                    OtherImageRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherAudio(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherAudioTemplate, appendToBottom);
                    OtherAudioRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherVoiceMail(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherVoiceMailTemplate, appendToBottom);
                    OtherVoicemailRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherPersonalRecord(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node otherMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.otherPersonalRecordTemplate, appendToBottom);
                    OtherPersonalRecordRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherVideo(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String extraInfo = msg.getExtraMsgInfo();
                    org.w3c.dom.Node otherMessageNode = null;
                    otherMessageNode = StringUtils.isNotBlank((CharSequence)extraInfo) ? MessageArea.this.cloneAndAdd(MessageArea.this.template.otherVideoWithMsgTemplate, appendToBottom) : MessageArea.this.cloneAndAdd(MessageArea.this.template.otherVideoTemplate, appendToBottom);
                    OtherVideoRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void addOtherDocument(final String otherJid, final String otherName, final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    String extraInfo = msg.getExtraMsgInfo();
                    org.w3c.dom.Node otherMessageNode = null;
                    otherMessageNode = StringUtils.isNotBlank((CharSequence)extraInfo) ? MessageArea.this.cloneAndAdd(MessageArea.this.template.otherDocumentWithMsgTemplate, appendToBottom) : MessageArea.this.cloneAndAdd(MessageArea.this.template.otherDocumentTemplate, appendToBottom);
                    OtherDocumentRenderer.render(MessageArea.this, otherMessageNode, msg, otherJid, otherName, searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    public void checkAllDate() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd", Locale.US);
                NodeList list = MessageArea.this.tableContent.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Element e;
                    org.w3c.dom.Node node = list.item(i);
                    if (!(node instanceof Element) || !(e = (Element)node).hasAttribute("timeKey")) continue;
                    try {
                        String timeStr = e.getAttribute("timeKey");
                        String id = e.getAttribute("id");
                        id = id.replace("systemMessage_", "systemMessageText_");
                        Element elem_systemMessageText = MessageArea.this.document.getElementById(id);
                        DomUtil.cleanTextNodes(elem_systemMessageText);
                        Date date = formater.parse(timeStr);
                        String newStr = DateTimeUtil.getTimeStr(date.getTime());
                        elem_systemMessageText.appendChild(MessageArea.this.document.createTextNode(newStr));
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    public void checkAllPhoneData() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                NodeList list = MessageArea.this.tableContent.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Element e;
                    org.w3c.dom.Node node = list.item(i);
                    if (!(node instanceof Element) || !(e = (Element)node).hasAttribute("phoneRelated")) continue;
                    try {
                        Element elem;
                        String[] terms;
                        String phoneNum;
                        String msgId = e.getAttribute("messageId");
                        String packetId = e.getAttribute("packetId");
                        Message msg = ChatRoomManager.getMsg(UCChatClient.context, Long.parseLong(msgId));
                        String phoneRelatedKey = e.getAttribute("phoneRelated");
                        if ("ot".equals(phoneRelatedKey)) {
                            phoneNum = MsgPhoneFormatter.convertInboundTalkingContent(UCChatClient.context, msg.getContent());
                            Element elem2 = MessageArea.this.document.getElementById("otherPhoneTalkingText_" + packetId);
                            String[] terms2 = phoneNum.split("\\n");
                            DomUtil.cleanTextNodes(elem2);
                            elem2.appendChild(MessageArea.this.document.createTextNode(terms2[1]));
                            continue;
                        }
                        if ("oc".equals(phoneRelatedKey)) {
                            phoneNum = MsgPhoneFormatter.convertInboundMissCallContent(UCChatClient.context, msg.getContent());
                            terms = phoneNum.split("\\n");
                            elem = MessageArea.this.document.getElementById("otherPhoneCancelText_" + packetId);
                            DomUtil.cleanTextNodes(elem);
                            elem.appendChild(MessageArea.this.document.createTextNode(terms[1]));
                            continue;
                        }
                        if ("mt".equals(phoneRelatedKey)) {
                            phoneNum = MsgPhoneFormatter.convertOutboundTalkingContent(UCChatClient.context, msg.getContent());
                            terms = phoneNum.split("\\n");
                            elem = MessageArea.this.document.getElementById("myPhoneTalkingText_" + packetId);
                            DomUtil.cleanTextNodes(elem);
                            elem.appendChild(MessageArea.this.document.createTextNode(terms[1]));
                            continue;
                        }
                        if (!"mc".equals(phoneRelatedKey)) continue;
                        phoneNum = MsgPhoneFormatter.convertOutboundMissCallContent(UCChatClient.context, msg.getContent());
                        terms = phoneNum.split("\\n");
                        elem = MessageArea.this.document.getElementById("myPhoneCancelText_" + packetId);
                        DomUtil.cleanTextNodes(elem);
                        elem.appendChild(MessageArea.this.document.createTextNode(terms[1]));
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    public void recallMessage(final String packetId) {
        this.callback.onRecall(packetId);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                for (String key : MessageArea.this.refMap.keySet()) {
                    Element elem_ref_div;
                    String refPacketId = MessageArea.this.refMap.get(key);
                    if (!packetId.equals(refPacketId) || (elem_ref_div = MessageArea.this.document.getElementById(key)) == null) continue;
                    try {
                        DomUtil.cleanTextNodes(elem_ref_div);
                        if (key.startsWith("myMessageTextRef_")) {
                            MyTextRenderer.applyUnableToLoadReply(MessageArea.this, elem_ref_div);
                            continue;
                        }
                        if (!key.startsWith("otherMessageTextRef_")) continue;
                        OtherTextRenderer.applyUnableToLoadReply(MessageArea.this, elem_ref_div);
                    }
                    catch (UCThreadException e) {
                        e.printStackTrace();
                    }
                }
                MessageArea.this.cleanEventByPacketId(packetId);
                Element elem_target = null;
                boolean myMsg = false;
                Element elem_myMessage = MessageArea.this.document.getElementById("msg_" + packetId);
                if (elem_myMessage != null) {
                    elem_target = elem_myMessage;
                    String mineFlag = elem_myMessage.getAttribute("mineFlag");
                    myMsg = "1".equals(mineFlag);
                }
                if (elem_target != null) {
                    Message message;
                    String uid = UUID.randomUUID().toString();
                    org.w3c.dom.Node systemMessageNode = MessageArea.this.template.systemMessageTemplate.cloneNode(true);
                    if (systemMessageNode instanceof Element) {
                        Element sysElement = (Element)systemMessageNode;
                        String systemNodeId = "systemMessage_" + uid;
                        sysElement.setAttribute("id", systemNodeId);
                    }
                    String systemKeyId = "systemMessageText_" + uid;
                    if (packetId != null && TextUtils.isNotBlank((CharSequence)packetId)) {
                        MessageArea.this.systemMsgMap.put(packetId, systemKeyId);
                    }
                    MessageArea.this.tableContent.replaceChild(systemMessageNode, elem_target);
                    Element elem_systemMessageText = MessageArea.this.document.getElementById("systemMessageText");
                    elem_systemMessageText.setAttribute("id", systemKeyId);
                    String notice = I18NUtil.getString("recall_msg_self");
                    if (!myMsg && (message = MessageArea.this.callback.getMessageByPacketId(packetId)) != null) {
                        String fromName = MsgUtil.getFromName(UCChatClient.context, message.getFromJid(), null);
                        notice = String.format(I18NUtil.getString("recall_msg_other"), fromName);
                    }
                    elem_systemMessageText.appendChild(MessageArea.this.document.createTextNode(notice));
                }
            }
        });
    }

    public void deleteMessage(final String packetId) {
        this.callback.onDelete(packetId);
        this.hidePacketId(packetId);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                for (String key : MessageArea.this.refMap.keySet()) {
                    Element elem_ref_div;
                    String refPacketId = MessageArea.this.refMap.get(key);
                    if (!packetId.equals(refPacketId) || (elem_ref_div = MessageArea.this.document.getElementById(key)) == null) continue;
                    try {
                        DomUtil.cleanTextNodes(elem_ref_div);
                        if (key.startsWith("myMessageTextRef_")) {
                            MyTextRenderer.applyUnableToLoadReply(MessageArea.this, elem_ref_div);
                            continue;
                        }
                        if (!key.startsWith("otherMessageTextRef_")) continue;
                        OtherTextRenderer.applyUnableToLoadReply(MessageArea.this, elem_ref_div);
                    }
                    catch (UCThreadException e) {
                        e.printStackTrace();
                    }
                }
                Element elem_message = MessageArea.this.document.getElementById("msg_" + packetId);
                if (elem_message != null) {
                    MessageArea.this.tableContent.removeChild(elem_message);
                }
                MessageArea.this.cleanEventByPacketId(packetId);
            }
        });
    }

    private void cleanEventByPacketId(String packetId) {
        Set<String> eventSet;
        String xpacketId;
        HashSet<Element> elementSet;
        if (this.elementEventMap != null) {
            elementSet = new HashSet<Element>(this.elementEventMap.keySet());
            for (Element element : elementSet) {
                xpacketId = element.getAttribute("packetId");
                if (xpacketId == null || !packetId.equals(xpacketId) || (eventSet = this.elementEventMap.remove(element)) == null) continue;
                for (String event : eventSet) {
                    ((EventTarget)((Object)element)).removeEventListener(event, this.clickListener, false);
                }
            }
        }
        if (this.elementErrorEventMap != null) {
            elementSet = new HashSet<Element>(this.elementErrorEventMap.keySet());
            for (Element element : elementSet) {
                xpacketId = element.getAttribute("packetId");
                if (xpacketId == null || !packetId.equals(xpacketId) || (eventSet = this.elementErrorEventMap.remove(element)) == null) continue;
                for (String event : eventSet) {
                    ((EventTarget)((Object)element)).removeEventListener(event, this.errorClickListener, false);
                }
            }
        }
    }

    public void readedByMessage(final String packetId) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Message msg;
                int readCount;
                Element elem_myMessageReadStatus = MessageArea.this.document.getElementById("myMessageReadStatus_" + packetId);
                if (elem_myMessageReadStatus != null && (readCount = MsgUtil.getReadCount(msg = MessageArea.this.callback.getMessageByPacketId(packetId))) != 0) {
                    NodeList list = elem_myMessageReadStatus.getChildNodes();
                    for (int i = list.getLength() - 1; i >= 0; --i) {
                        elem_myMessageReadStatus.removeChild(list.item(i));
                    }
                    if (JidUtil.isChatConfJid(MessageArea.this.chatId)) {
                        elem_myMessageReadStatus.appendChild(MessageArea.this.document.createTextNode(String.format(I18NUtil.getString("chat_title_msg_read_with_count"), readCount)));
                        elem_myMessageReadStatus.setAttribute("packetId", packetId);
                        elem_myMessageReadStatus.setAttribute("command", "showReadUnreadList");
                        elem_myMessageReadStatus.setAttribute("class", "functionButton");
                        MessageArea.this.addEventListener(elem_myMessageReadStatus, "click");
                    } else {
                        elem_myMessageReadStatus.appendChild(MessageArea.this.document.createTextNode(I18NUtil.getString("chat_title_msg_read")));
                        elem_myMessageReadStatus.setAttribute("packetId", packetId);
                        elem_myMessageReadStatus.setAttribute("command", "showReadUnreadList");
                        elem_myMessageReadStatus.setAttribute("class", "functionButton");
                        MessageArea.this.addEventListener(elem_myMessageReadStatus, "click");
                    }
                }
            }
        });
    }

    public void playMessage(final String packetId) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Message message = MessageArea.this.callback.getMessageByPacketId(packetId);
                if (message.isPlayed()) {
                    Element elem_voicemailUnplay;
                    Element elem_audioUnplay = MessageArea.this.document.getElementById("otherAudioUnplayIcon_" + packetId);
                    if (elem_audioUnplay != null) {
                        elem_audioUnplay.getParentNode().removeChild(elem_audioUnplay);
                    }
                    if ((elem_voicemailUnplay = MessageArea.this.document.getElementById("otherVoicemailUnplayIcon_" + packetId)) != null) {
                        elem_voicemailUnplay.getParentNode().removeChild(elem_voicemailUnplay);
                    }
                }
            }
        });
    }

    public void resendMsg(Message message) {
        this.callback.resendMsg(message);
    }

    public void addSystemMessage(final String packetId, final String text, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String uid = UUID.randomUUID().toString();
                org.w3c.dom.Node systemMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.systemMessageTemplate, appendToBottom);
                if (systemMessageNode instanceof Element) {
                    Element sysElement = (Element)systemMessageNode;
                    String systemNodeId = "systemMessage_" + uid;
                    sysElement.setAttribute("id", systemNodeId);
                }
                String systemKeyId = "systemMessageText_" + uid;
                if (packetId != null && TextUtils.isNotBlank((CharSequence)packetId)) {
                    MessageArea.this.systemMsgMap.put(packetId, systemKeyId);
                }
                Element elem_systemMessageText = MessageArea.this.document.getElementById("systemMessageText");
                elem_systemMessageText.setAttribute("id", systemKeyId);
                elem_systemMessageText.appendChild(MessageArea.this.document.createTextNode(text));
                if (appendToBottom && scrollToBottom) {
                    MessageArea.this.refreshScrollBar();
                }
            }
        });
    }

    public void addSystemMessage(final HashMap<String, Object> msgValue, final boolean appendToBottom, final boolean scrollToBottom) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Message msg = (Message)msgValue.get("txtContent");
                int msgType = msg.getMsgType();
                String packetId = msg.getPacketId();
                String timeKey = (String)msgValue.get("timeKey");
                if (msgType == 200) {
                    ArrayList<org.w3c.dom.Node> toRemoveNotList = new ArrayList<org.w3c.dom.Node>();
                    NodeList list = MessageArea.this.tableContent.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Element e;
                        org.w3c.dom.Node node = list.item(i);
                        if (!(node instanceof Element) || !(e = (Element)node).hasAttribute("timeKey") || !e.getAttribute("timeKey").equals(timeKey)) continue;
                        toRemoveNotList.add(node);
                    }
                    for (org.w3c.dom.Node node : toRemoveNotList) {
                        MessageArea.this.tableContent.removeChild(node);
                    }
                }
                String uid = UUID.randomUUID().toString();
                org.w3c.dom.Node systemMessageNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.systemMessageTemplate, appendToBottom);
                if (systemMessageNode instanceof Element) {
                    Element sysElement = (Element)systemMessageNode;
                    String systemNodeId = "systemMessage_" + uid;
                    sysElement.setAttribute("id", systemNodeId);
                    sysElement.setAttribute("timeKey", timeKey);
                }
                String systemKeyId = "systemMessageText_" + uid;
                if (packetId != null && TextUtils.isNotBlank((CharSequence)packetId)) {
                    MessageArea.this.systemMsgMap.put(packetId, systemKeyId);
                }
                Element elem_systemMessageText = MessageArea.this.document.getElementById("systemMessageText");
                elem_systemMessageText.setAttribute("id", systemKeyId);
                elem_systemMessageText.appendChild(MessageArea.this.document.createTextNode(msg.getContent()));
                if (appendToBottom && scrollToBottom) {
                    MessageArea.this.refreshScrollBar();
                }
            }
        });
    }

    public void addNoticeMessage(final Message msg, final boolean appendToBottom, final boolean scrollToBottom, final String searchKey, final String targetPacketId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!MessageArea.this.showPacketId(msg.getPacketId())) {
                    return;
                }
                try {
                    org.w3c.dom.Node noticeNode = MessageArea.this.cloneAndAdd(MessageArea.this.template.noticeMessageTemplate, appendToBottom);
                    NoticeMsgRenderer.render(MessageArea.this, noticeNode, msg, searchKey, targetPacketId);
                    if (appendToBottom && scrollToBottom) {
                        MessageArea.this.refreshScrollBar();
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    @Override
    public Window getWindow() {
        return this.webView.getScene().getWindow();
    }

    @Override
    public Component getParentPanel() {
        return this;
    }

    @Override
    public boolean isMsgPlayCurrent(String packetId) {
        return this.currentPlayerRequest != null && this.currentPlayerRequest.isCurrentPlaying(packetId);
    }

    @Override
    public synchronized void playAudioFile(ElementAttrMap targetMap, Message message, File audioFile, int audioPlayType) {
        try {
            VoiceItem item;
            if (targetMap == null || message == null || audioFile == null) {
                Log.e(MessageArea.class.getSimpleName(), "parameter error, targetMap:" + String.valueOf(targetMap) + ", message:" + String.valueOf(message) + ", audioFile:" + String.valueOf(audioFile));
                return;
            }
            if (this.currentPlayerRequest != null) {
                this.currentPlayerRequest.close();
                this.currentPlayerRequest = null;
            }
            AudioPlayerRequest r = new AudioPlayerRequest(audioPlayType, message, audioFile, targetMap, this.document);
            if (audioPlayType == 2 && (item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, r.getMessage())) != null && !item.isPlayed()) {
                Message relatedMsg;
                UCDBVoiceMsg.updateVoiceMsgPlayedStatus(UCChatClient.context, item.getId(), item.getPacketId());
                BroadcastUtil.sendVoiceRecordChangedEvent(UCChatClient.context);
                if (TextUtils.isNotBlank((CharSequence)item.getPacketId()) && (relatedMsg = this.callback.getMessageByPacketId(item.getPacketId())) != null) {
                    ChatRoomManager.markMsgAsPlayed(UCChatClient.context, relatedMsg);
                }
            }
            this.currentPlayerRequest = r;
            this.currentPlayerRequest.play();
            this.messageAreaTimer.schedule((TimerTask)r.getPlayTimerTask(), 0L, 300L);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stopAudioFile() throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        if (this.currentPlayerRequest != null) {
            this.currentPlayerRequest.close();
            this.currentPlayerRequest = null;
        }
    }

    @Override
    public void recallMsgUI(String packetId) {
        Log.i(MessageArea.class.getSimpleName(), "recallMsg " + this.chatId);
        this.recallMessage(packetId);
    }

    @Override
    public void cleanMsgUI(String packetId) {
        Log.i(MessageArea.class.getSimpleName(), "cleanMsgUI " + this.chatId);
        this.deleteMessage(packetId);
    }

    @Override
    public void openFile(File file) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasDownloadTask(String packetId) {
        return this.downloadFileTaskMap.containsKey(packetId);
    }

    @Override
    public void registerDownloadMap(String packetId, DownloadFileTask task) {
        this.downloadFileTaskMap.put(packetId, task);
    }

    @Override
    public void unregisterDownloadMap(String packetId) {
        this.downloadFileTaskMap.remove(packetId);
    }

    @Override
    public boolean hasDownloadUrl(String downloadUrl) {
        for (String url : this.downloadUrlMap.values()) {
            if (!url.equals(downloadUrl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerDownloadUrlMap(String packetId, String downloadUrl) {
        this.downloadUrlMap.put(packetId, downloadUrl);
    }

    @Override
    public void unregisterDownloadUrlMap(String packetId) {
        this.downloadUrlMap.remove(packetId);
    }

    @Override
    public void updateFileDownloadProgress(final String packetId, final int percent) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_progressPercentBar = MessageArea.this.document.getElementById("downloadProgressPercentBar_" + packetId);
                int percentWidth = 135 * percent / 100;
                elem_progressPercentBar.setAttribute("style", "width:" + percentWidth + "px;");
                MessageArea.this.webView.getEngine().executeScript("document.getElementById('downloadProgressPercentText_" + packetId + "').innerHTML=\"" + percent + "%\"");
            }
        });
    }

    @Override
    public void updateFileDownloadCompleted(final String packetId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_downloadProgressBox = MessageArea.this.document.getElementById("downloadProgressBox_" + packetId);
                elem_downloadProgressBox.setAttribute("style", "display:none;");
            }
        });
    }

    @Override
    public void updateFileDownloadCancelled(final String packetId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_downloadProgressBox = MessageArea.this.document.getElementById("downloadProgressBox_" + packetId);
                elem_downloadProgressBox.setAttribute("style", "display:none;");
            }
        });
    }

    @Override
    public void updateFileDownloadFailed(final String packetId) {
        this.checkDocumentInitial();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element elem_downloadProgressBox = MessageArea.this.document.getElementById("downloadProgressBox_" + packetId);
                elem_downloadProgressBox.setAttribute("style", "display:none;");
            }
        });
    }

    @Override
    public Element createElement(String tag) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        return this.document.createElement(tag);
    }

    @Override
    public Element getElementById(String key) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        return this.document.getElementById(key);
    }

    @Override
    public Text createTextNode(String content) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        return this.document.createTextNode(content);
    }

    @Override
    public void registerPhotoKey(String key, String jid) {
        this.headPhotoMap.put(key, jid);
    }

    @Override
    public void registerRefPhotoKey(String elementKey, String refPacketId) {
        this.refPhotoMap.put(elementKey, refPacketId);
    }

    @Override
    public void registerRefKey(String elementKey, String refPacketId) {
        this.refMap.put(elementKey, refPacketId);
    }

    @Override
    public void addEventListener(Element element, String event) {
        if (!this.elementEventMap.containsKey(element)) {
            this.elementEventMap.put(element, new HashSet());
        }
        Set<String> eventSet = this.elementEventMap.get(element);
        eventSet.add(event);
        element.setAttribute("chatId", this.chatId);
        ((EventTarget)((Object)element)).addEventListener(event, this.clickListener, false);
    }

    @Override
    public void addErrorEventListener(Element element, String event) {
        if (!this.elementErrorEventMap.containsKey(element)) {
            this.elementErrorEventMap.put(element, new HashSet());
        }
        Set<String> eventSet = this.elementErrorEventMap.get(element);
        eventSet.add(event);
        element.setAttribute("chatId", this.chatId);
        ((EventTarget)((Object)element)).addEventListener(event, this.errorClickListener, false);
    }

    @Override
    public Message getMessageByPacketId(String packetId) {
        return this.callback.getMessageByPacketId(packetId);
    }

    public boolean isScrollBarAtBottom() {
        return this.scrollBarAtBottom;
    }

    public void setScrollBarAtBottom(boolean scrollBarAtBottom) {
        this.scrollBarAtBottom = scrollBarAtBottom;
    }

    public WebView getWebView() {
        return this.webView;
    }

    public Document getDocument() {
        return this.document;
    }

    public static interface MessageAreaCallback {
        public void onScrollTop();

        public void onScrollBottom();

        public void onScrollNotBottom();

        public void dumpToPacketId(String var1);

        public void resendMsg(Message var1);

        public void attachFromName(String var1);

        public Message getMessageByPacketId(String var1);

        public void onQuoteSelected(String var1);

        public boolean isChatModeEnabled();

        public void onDelete(String var1);

        public void onRecall(String var1);
    }

    class NormalEventListener
    implements EventListener {
        NormalEventListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            MessageArea.this.handleAction(evt);
        }
    }

    class ErrorEventListener
    implements EventListener {
        ErrorEventListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            MessageArea.this.handleErrorAction(evt);
        }
    }
}

