/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.AppendLineAction;
import com.blisscloud.ezuc.client.chat.ClearMessageAction;
import com.blisscloud.ezuc.client.chat.IconLocation;
import com.blisscloud.ezuc.client.chat.MessageDropper;
import com.blisscloud.ezuc.client.chat.MessageDropperField;
import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.chat.SendMessageAction;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ListenerCleaner;
import com.blisscloud.ezuc.client.component.HintTextPane;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.FileSelectionCallback;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;

public class MessageInput
extends HintTextPane {
    private JPopupMenu popupMenuMessage;
    private JMenuItem miCut;
    private JMenuItem miCopy;
    private JMenuItem miPaste;
    private JMenuItem miDelete;
    private JMenuItem miSelectAll;
    private MessageInputCallback callback;
    private FileSelectionCallback fileCallback;
    private ClearMessageAction clearMsgAction = null;
    private SendMessageAction sendMsgAction = null;
    private AppendLineAction appendLineAction = null;
    private MessageDropperField dropperField = null;
    private DropTarget mDropTarget;

    public MessageInput(MessageInputCallback callback, FileSelectionCallback fileCallback, MessageDropperField dropperField) {
        super(I18NUtil.getString("chat_fun_send_msg"), UIConstants.FONT_14_PLAIN);
        this.callback = callback;
        this.fileCallback = fileCallback;
        this.dropperField = dropperField;
        this.initGUI();
        this.initMenu();
    }

    private void initGUI() {
        this.setFont(UIConstants.FONT_16_PLAIN);
        this.setBorder(Chatroom.BORDER_TXT_MESSAGE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (MessageInput.this.isEnabled()) {
                    this.checkPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (MessageInput.this.isEnabled()) {
                    this.checkPopup(evt);
                }
            }

            private void checkPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    String selection = MessageInput.this.getSelectedText();
                    boolean hasSelection = TextUtils.isNotBlank((CharSequence)selection);
                    MessageInput.this.miCut.setEnabled(hasSelection);
                    MessageInput.this.miCopy.setEnabled(hasSelection);
                    MessageInput.this.miDelete.setEnabled(hasSelection);
                    boolean hasContent = MessageInput.this.hasClipboardContents();
                    MessageInput.this.miPaste.setEnabled(hasContent);
                    MessageInput.this.popupMenuMessage.show(MessageInput.this, evt.getX(), evt.getY());
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (MessageInput.this.callback != null) {
                    MessageInput.this.callback.focusLost();
                }
            }
        });
        this.mDropTarget = new DropTarget(this, new MessageDropper(this.dropperField, this.fileCallback));
        this.clearMsgAction = new ClearMessageAction(this);
        this.sendMsgAction = new SendMessageAction(this, this.callback);
        this.appendLineAction = new AppendLineAction(this);
        this.updateActionMap();
    }

    private void initMenu() {
        this.miCut = new JMenuItem();
        this.miCut.setText(I18NUtil.getString("common_btn_cut"));
        this.miCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String selection = MessageInput.this.getSelectedText();
                StringSelection stringSelection = new StringSelection(selection);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                MessageInput.this.replaceSelection("");
            }
        });
        this.miCopy = new JMenuItem();
        this.miCopy.setText(I18NUtil.getString("common_btn_copy"));
        this.miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String selection = MessageInput.this.getSelectedText();
                StringSelection stringSelection = new StringSelection(selection);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        });
        this.miPaste = new JMenuItem();
        this.miPaste.setText(I18NUtil.getString("common_btn_paste"));
        this.miPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable trans = clipboard.getContents(clipboard);
                    if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        final List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectFileHandler.handleSelectedFileList(files, MessageInput.this.fileCallback);
                            }
                        });
                    } else if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String text = (String)trans.getTransferData(DataFlavor.stringFlavor);
                        MessageInput.this.replaceSelection(text);
                    } else if (trans.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        final Image image = (Image)trans.getTransferData(DataFlavor.imageFlavor);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectFileHandler.handleSelectedFileList(image, MessageInput.this.fileCallback);
                            }
                        });
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.miDelete = new JMenuItem();
        this.miDelete.setText(I18NUtil.getString("common_btn_delete"));
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageInput.this.replaceSelection("");
            }
        });
        this.miSelectAll = new JMenuItem();
        this.miSelectAll.setText(I18NUtil.getString("chat_btn_content_select_all"));
        this.miSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageInput.this.selectAll();
            }
        });
        this.popupMenuMessage = new JPopupMenu();
        this.popupMenuMessage.add(this.miCut);
        this.popupMenuMessage.add(this.miCopy);
        this.popupMenuMessage.add(this.miPaste);
        this.popupMenuMessage.add(this.miDelete);
        this.popupMenuMessage.addSeparator();
        this.popupMenuMessage.add(this.miSelectAll);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                Log.d(MessageInput.class.getSimpleName(), "keyTyped==>" + String.valueOf(e));
                if (!MessageInput.this.isEnabled()) {
                    return;
                }
                this.handleKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Log.d(MessageInput.class.getSimpleName(), "keyPressed==>" + String.valueOf(e));
                if (!MessageInput.this.isEnabled()) {
                    return;
                }
                if ((e.getKeyCode() == 86 || e.getKeyCode() == 16789778) && (e.isControlDown() || e.isMetaDown())) {
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        Transferable trans = clipboard.getContents(clipboard);
                        if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            final List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectFileHandler.handleSelectedFileList(files, MessageInput.this.fileCallback);
                                }
                            });
                        } else if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String text = (String)trans.getTransferData(DataFlavor.stringFlavor);
                            MessageInput.this.replaceSelection(text);
                        } else if (trans.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                            Image image = (Image)trans.getTransferData(DataFlavor.imageFlavor);
                            SelectFileHandler.handleSelectedFileList(image, MessageInput.this.fileCallback);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Log.d(MessageInput.class.getSimpleName(), "keyReleased==>" + String.valueOf(e));
                if (!MessageInput.this.isEnabled()) {
                    return;
                }
            }

            private void handleKeyEvent(KeyEvent e) {
                if (e.getKeyChar() == '@' || e.getKeyChar() == '\uff20') {
                    boolean skipPop = false;
                    final char eventChar = e.getKeyChar();
                    int index = MessageInput.this.getCaretPosition();
                    if (index >= 1) {
                        try {
                            String x = MessageInput.this.getDocument().getText(index - 1, 1);
                            Pattern pattern = Pattern.compile("^[0-9a-zA-Z]+$");
                            Matcher matcher = pattern.matcher(x);
                            if (matcher.matches()) {
                                skipPop = true;
                            }
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (!skipPop) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                List<LiteContact> contactList;
                                String keyChar = "@";
                                if (eventChar == '\uff20') {
                                    keyChar = "\uff20";
                                }
                                if ((contactList = MessageInput.this.callback.pickContact()) != null) {
                                    StringBuffer b = new StringBuffer();
                                    for (int i = 0; i < contactList.size(); ++i) {
                                        String name;
                                        LiteContact contact = contactList.get(i);
                                        if (contact.getId() == -10000L) {
                                            name = "All";
                                            if (name == null) continue;
                                            if (i != 0) {
                                                b.append(keyChar);
                                            }
                                            b.append(name + " ");
                                            continue;
                                        }
                                        name = ContactManager.getContactShortName((Context)UCChatClient.context, contact);
                                        if (name == null) continue;
                                        if (i != 0) {
                                            b.append(keyChar);
                                        }
                                        b.append(name + " ");
                                    }
                                    try {
                                        MessageInput.this.getDocument().insertString(MessageInput.this.getCaretPosition(), b.toString(), null);
                                    }
                                    catch (BadLocationException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void paste() {
    }

    public boolean hasClipboardContents() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable trans = clipboard.getContents(clipboard);
            if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    String fileExt = UCUploadFileChooser.getFileExtension(file);
                    if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                        return true;
                    }
                    if (!UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) && !UCUploadFileChooser.AUDIO_TYPES.contains(fileExt) && !UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) continue;
                    return true;
                }
            } else {
                if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return true;
                }
                if (trans.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    return true;
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public String getMessageTextWithIconKey() {
        Element element;
        String ELEM = "$ename";
        String ICON = "icon";
        String COMP = "component";
        Document doc = this.getDocument();
        Object docText = null;
        try {
            docText = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        ArrayList<IconLocation> iconLocations = new ArrayList<IconLocation>();
        ElementIterator iterator = new ElementIterator(doc);
        while ((element = iterator.next()) != null) {
            AttributeSet as = element.getAttributes();
            if (as.containsAttribute("$ename", "icon")) {
                ImageIcon icon = (ImageIcon)StyleConstants.getIcon(as);
                iconLocations.add(new IconLocation(element.getStartOffset(), icon.getDescription()));
            }
            if (!as.containsAttribute("$ename", "component")) continue;
        }
        int iconCount = iconLocations.size();
        for (int i = iconCount - 1; i >= 0; --i) {
            IconLocation iconLoc = (IconLocation)iconLocations.get(i);
            docText = ((String)docText).substring(0, iconLoc.index) + iconLoc.iconKey + ((String)docText).substring(iconLoc.index + 1);
        }
        return docText;
    }

    public void updateActionMap() {
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "myEsc");
        this.getActionMap().put("myEsc", this.clearMsgAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(83, 512), "Alt+S");
        this.getActionMap().put("Alt+S", this.sendMsgAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "Shift+Enter");
        this.getActionMap().put("Shift+Enter", this.appendLineAction);
        PreferencesUtil.ReturnPolicy returnPolicy = PreferencesUtil.getReturnPolicy();
        switch (returnPolicy) {
            case returnOnly: {
                this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "myEnter");
                this.getActionMap().put("myEnter", this.sendMsgAction);
                this.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "Ctrl+Enter");
                this.getActionMap().put("Ctrl+Enter", this.appendLineAction);
                break;
            }
            case ctrlReturn: {
                this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "myEnter");
                this.getActionMap().put("myEnter", this.appendLineAction);
                this.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "Ctrl+Enter");
                this.getActionMap().put("Ctrl+Enter", this.sendMsgAction);
            }
        }
    }

    public void setPendingText(String pendingMsg) {
        if (TextUtils.isBlank((CharSequence)pendingMsg)) {
            this.setText("");
            return;
        }
        try {
            this.handleText(pendingMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleText(String text) throws Exception {
        int lastIndex = 0;
        Matcher m = Chatroom.PATTERN_EMOTICON.matcher(text);
        while (m.find()) {
            String iconPath;
            int s = m.start();
            int e = m.end();
            String prefix = text.substring(lastIndex, s);
            String emoticonKey = text.substring(s, e);
            this.getDocument().insertString(this.getCaretPosition(), prefix, null);
            boolean isHandle = false;
            if ((emoticonKey.startsWith("[emoticon_") || emoticonKey.startsWith("[emo")) && TextUtils.isNotBlank((CharSequence)(iconPath = ChatRoomManager.getEmoticonSmallPath(emoticonKey)))) {
                ImageIcon eIcon = GraphicUtil.getScaledIcon(iconPath, 16, 16);
                eIcon.setDescription(emoticonKey);
                this.insertIcon(eIcon);
                isHandle = true;
            }
            if (!isHandle) {
                this.getDocument().insertString(this.getCaretPosition(), emoticonKey, null);
            }
            lastIndex = e;
        }
        String finalStr = text.substring(lastIndex);
        this.getDocument().insertString(this.getCaretPosition(), finalStr, null);
    }

    public void onClose() {
        ListenerCleaner.cleanActionListner(this.miCut);
        ListenerCleaner.cleanActionListner(this.miCopy);
        ListenerCleaner.cleanActionListner(this.miPaste);
        ListenerCleaner.cleanActionListner(this.miDelete);
        ListenerCleaner.cleanActionListner(this.miSelectAll);
        ListenerCleaner.cleanPropertyChangeListener(this.clearMsgAction);
        ListenerCleaner.cleanPropertyChangeListener(this.sendMsgAction);
        ListenerCleaner.cleanPropertyChangeListener(this.appendLineAction);
        this.getInputMap().clear();
        this.getActionMap().clear();
    }

    public static interface MessageInputCallback {
        public void onSendMessage(String var1);

        public List<LiteContact> pickContact();

        public void focusLost();
    }
}

