/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ResendMessagePanel
extends RoundedCornerPanel {
    private JLabel lblTitle;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblMessage;
    private JButton btnCancel;
    private JButton btnResend;
    private JButton btnDelete;
    private JPanel panelToolbar;
    MessageArea messageArea;
    String packetId;
    long msgId;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ResendMessagePanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ResendMessagePanel() {
        this.initGUI();
    }

    public ResendMessagePanel(MessageArea messageArea, String packetId, long msgId) {
        this.initGUI();
        this.messageArea = messageArea;
        this.packetId = packetId;
        this.msgId = msgId;
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("chat_notice_msg_not_sent"));
            this.lblTitle.setFont(UIConstants.FONT_16_BOLD);
            this.lblTitle.setForeground(UIConstants.COLOR_DIALOG_TITLE);
            this.jSeparator1 = new JSeparator();
            this.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(20, 20, 20, 20), 0, 0));
            this.lblMessage.setText(I18NUtil.getString("chat_title_resend_confirm"));
            this.lblMessage.setFont(UIConstants.FONT_16_PLAIN);
            this.jSeparator2 = new JSeparator();
            this.add((Component)this.jSeparator2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panelToolbar = new JPanel();
            this.add((Component)this.panelToolbar, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 20), 0, 0));
            this.panelToolbar.setOpaque(false);
            this.btnCancel = new JButton();
            this.panelToolbar.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ResendMessagePanel.this.btnCancelActionPerformed(evt);
                }
            });
            this.btnResend = new JButton();
            this.panelToolbar.add(this.btnResend);
            this.btnResend.setText(I18NUtil.getString("chat_btn_resend"));
            this.btnResend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ResendMessagePanel.this.btnResendActionPerformed(evt);
                }
            });
            this.btnDelete = new JButton();
            this.panelToolbar.add(this.btnDelete);
            this.btnDelete.setText(I18NUtil.getString("common_btn_delete"));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ResendMessagePanel.this.btnDeleteActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        UCChatClient.getInstance().hideGlassPanel();
    }

    private void btnResendActionPerformed(ActionEvent evt) {
        Message message = ChatRoomManager.getMsg(UCChatClient.context, this.msgId);
        this.messageArea.resendMsg(message);
        this.deleteMessage();
        UCChatClient.getInstance().hideGlassPanel();
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.deleteMessage();
        UCChatClient.getInstance().hideGlassPanel();
    }

    void deleteMessage() {
        ChatRoomManager.clearSpecificChatMsg((Context)UCChatClient.context, this.msgId);
        this.messageArea.cleanMsgUI(this.packetId);
    }
}

