/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.FileUploadConfirmDialog;
import com.blisscloud.ezuc.client.chat.ImageUploadConfirmDialog;
import com.blisscloud.ezuc.client.chat.TiffUploadConfirmDialog;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.fax.FaxDocUploadConfirmDialog;
import com.blisscloud.ezuc.client.fax.FaxImageUploadConfirmDialog;
import com.blisscloud.ezuc.client.fax.FaxTiffUploadConfirmDialog;
import com.blisscloud.ezuc.client.fax.FaxTxtUploadConfirmDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.FaxTransferInfo;
import com.blisscloud.mobile.ezuc.util.FaxSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class SelectFileHandler {
    public static void handleSelectedFileList(Image image, FileSelectionCallback callback) {
        try {
            if (!PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context)) {
                JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("permission_no_photo_license"), I18NUtil.getString("common_title_warning"), 2);
                return;
            }
            if (callback == null) {
                return;
            }
            BufferedImage buffered = (BufferedImage)image;
            File outputfile = new File(FileUtil.getTempDir(), "screendump_" + System.currentTimeMillis() + ".png");
            ImageIO.write((RenderedImage)buffered, "png", outputfile);
            ImageUploadConfirmDialog dialog = new ImageUploadConfirmDialog(UCChatClient.getInstance(), callback.getRoomName(), outputfile);
            dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
            ToastUtil.hide();
            boolean result = dialog.showDialog();
            if (result) {
                callback.onSendFile(outputfile, dialog.isOriginal());
            }
        }
        catch (IOException e) {
            Log.e(SelectFileHandler.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
    }

    public static void handleSelectedFileList(List<File> files, FileSelectionCallback callback) {
        if (!PreferencesUtil.hasChatFileActionPermission(UCChatClient.context)) {
            JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("permission_no_file_license"), I18NUtil.getString("common_title_warning"), 2);
            return;
        }
        ArrayList<File> invalidFiles = new ArrayList<File>();
        for (File file : files) {
            boolean result;
            GenericDialog dialog;
            String fileExt = UCUploadFileChooser.getFileExtension(file);
            if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new ImageUploadConfirmDialog(UCChatClient.getInstance(), callback.getRoomName(), file);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((ImageUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                callback.onSendFile(file, ((ImageUploadConfirmDialog)dialog).isOriginal());
                continue;
            }
            if (UCUploadFileChooser.TIFF_TYPES.contains(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new TiffUploadConfirmDialog(UCChatClient.getInstance(), callback.getRoomName(), file);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((TiffUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                callback.onSendFile(file, true);
                continue;
            }
            if (UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) || UCUploadFileChooser.AUDIO_TYPES.contains(fileExt) || UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new FileUploadConfirmDialog(UCChatClient.getInstance(), callback.getRoomName(), file);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((FileUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                callback.onSendFile(file, true);
                continue;
            }
            invalidFiles.add(file);
        }
        if (!invalidFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (File invalidFile : invalidFiles) {
                sb.append(invalidFile.getName()).append("\n");
            }
            JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("media_unsupported_type") + "\n" + sb.toString(), I18NUtil.getString("common_title_warning"), 2);
        }
    }

    public static void handleSelectedFileForFax(List<File> files, String phoneNumber, FaxSelectionCallback callback) {
        ArrayList<File> invalidFiles = new ArrayList<File>();
        for (File file : files) {
            FaxTransferInfo fileTransferInfo;
            boolean result;
            GenericDialog dialog;
            String fileExt = UCUploadFileChooser.getFileExtension(file);
            if (UCUploadFileChooser.FAX_IMAGE_TYPES.contains(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new FaxImageUploadConfirmDialog(UCChatClient.getInstance(), file, phoneNumber);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((FaxImageUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                fileTransferInfo = new FaxTransferInfo(file, ((FaxImageUploadConfirmDialog)dialog).getPhoneNumber(), null);
                callback.onSendFile(fileTransferInfo);
                continue;
            }
            if (UCUploadFileChooser.TIFF_TYPES.contains(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new FaxTiffUploadConfirmDialog(UCChatClient.getInstance(), file, phoneNumber);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((FaxTiffUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                fileTransferInfo = new FaxTransferInfo(file, ((FaxTiffUploadConfirmDialog)dialog).getPhoneNumber(), null);
                callback.onSendFile(fileTransferInfo);
                continue;
            }
            if ("txt".equalsIgnoreCase(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new FaxTxtUploadConfirmDialog(UCChatClient.getInstance(), file, phoneNumber);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((FaxTxtUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                fileTransferInfo = new FaxTransferInfo(file, ((FaxTxtUploadConfirmDialog)dialog).getPhoneNumber(), ((FaxTxtUploadConfirmDialog)dialog).getEncodingType());
                callback.onSendFile(fileTransferInfo);
                continue;
            }
            if (UCUploadFileChooser.FAX_TYPES.contains(fileExt)) {
                ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
                dialog = new FaxDocUploadConfirmDialog(UCChatClient.getInstance(), file, phoneNumber);
                dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                ToastUtil.hide();
                result = ((FaxDocUploadConfirmDialog)dialog).showDialog();
                if (!result) continue;
                fileTransferInfo = new FaxTransferInfo(file, ((FaxDocUploadConfirmDialog)dialog).getPhoneNumber(), null);
                callback.onSendFile(fileTransferInfo);
                continue;
            }
            invalidFiles.add(file);
        }
        if (!invalidFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (File invalidFile : invalidFiles) {
                sb.append(invalidFile.getName()).append("\n");
            }
            JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("media_unsupported_type") + "\n" + sb.toString(), I18NUtil.getString("common_title_warning"), 2);
        }
    }

    public static void handleSelectedFileForFax(Image image, String phoneNumber, FaxSelectionCallback callback) {
        try {
            if (callback == null) {
                return;
            }
            BufferedImage buffered = (BufferedImage)image;
            File outputfile = new File(FileUtil.getTempDir(), "screendump_" + System.currentTimeMillis() + ".png");
            ImageIO.write((RenderedImage)buffered, "png", outputfile);
            ToastUtil.showShort(I18NUtil.getString("common_label_processing"));
            FaxImageUploadConfirmDialog dialog = new FaxImageUploadConfirmDialog(UCChatClient.getInstance(), outputfile, phoneNumber);
            dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
            ToastUtil.hide();
            boolean result = dialog.showDialog();
            if (result) {
                FaxTransferInfo fileTransferInfo = new FaxTransferInfo(outputfile, dialog.getPhoneNumber(), null);
                callback.onSendFile(fileTransferInfo);
            }
        }
        catch (IOException e) {
            Log.e(SelectFileHandler.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
    }
}

