/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyDownloadCopyAsTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.component.CopyImages;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import javafx.application.Platform;

public class CopyFile
extends ActionBase {
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        String packetId = targetMap.get("packetId");
        if (actionService.hasDownloadTask(packetId)) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CopyFile.doCopyFile(actionService, targetMap);
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    private static void doCopyFile(ActionService actionService, ElementAttrMap targetMap) throws UCThreadException {
        String packetId = targetMap.get("packetId");
        String fileInfoStorageId = targetMap.get("fileInfoStorageId");
        Message message = actionService.getMessageByPacketId(packetId);
        String fileDownloadURL = message.getFileDownloadURL();
        File cacheFile = FileUtil.getDownloadCacheFile(fileDownloadURL);
        if (cacheFile.exists() && cacheFile.length() != 0L) {
            BufferedImage bi = FileUtil.readFileHandleExif(cacheFile);
            CopyImages im = new CopyImages(bi);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(im, null);
            ToastUtil.showShort(I18NUtil.getString("media_save_to_clipboard_success"));
        } else {
            if (actionService.hasDownloadUrl(fileDownloadURL)) {
                return;
            }
            FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, CopyFile.isLeft(targetMap));
            String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
            DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, 0L, new MyDownloadCopyAsTaskCallBack(actionService, packetId, cacheFile));
            actionService.registerDownloadMap(packetId, task);
            actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
            task.start();
        }
    }
}

