/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import java.awt.Desktop;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

public class DisplayLocation {
    public static void handle(ActionService actionService, ElementAttrMap targetMap) {
        String packetId = targetMap.get("packetId");
        Message message = actionService.getMessageByPacketId(packetId);
        String props = message.getProps();
        if (props != null) {
            try {
                JSONObject obj = new JSONObject(props);
                double latitude = 0.0;
                double longitude = 0.0;
                if (obj.has("latitude")) {
                    String latitudeStr = obj.getString("latitude");
                    try {
                        latitude = Double.parseDouble(latitudeStr);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (obj.has("longitude")) {
                    String longitudeStr = obj.getString("longitude");
                    try {
                        longitude = Double.parseDouble(longitudeStr);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (latitude != 0.0 && longitude != 0.0) {
                    String address = message.getContent();
                    String title = message.getTitle();
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    int option = database.getMapOption();
                    if (option == 1) {
                        DisplayLocation.openQQMap(latitude, longitude, title, address);
                    } else {
                        DisplayLocation.openGoogleMap(latitude, longitude, title, address);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void openGoogleMap(double latitude, double longitude, String title, String address) throws Exception {
        String urlToOpen = "https://maps.google.com/maps";
        String query = latitude + "," + longitude;
        Object descr = "";
        if (TextUtils.isNotEmpty((CharSequence)title) && TextUtils.isNotEmpty((CharSequence)address)) {
            descr = title + "-" + address;
        } else if (TextUtils.isNotEmpty((CharSequence)address)) {
            descr = address;
        } else if (TextUtils.isNotEmpty((CharSequence)title)) {
            descr = title;
        }
        if (TextUtils.isNotEmpty((CharSequence)descr)) {
            query = query + (String)descr + "@" + query;
        }
        String encodedQuery = URLEncoder.encode(query, "UTF-8");
        String uriString = urlToOpen + "?q=" + encodedQuery + "&z=16";
        Desktop.getDesktop().browse(new URL(uriString).toURI());
    }

    public static void openQQMap(double latitude, double longitude, String title, String address) throws Exception {
        String urlToOpen = "http://apis.map.qq.com/uri/v1/marker";
        String uriString = urlToOpen + "?marker=coord:" + latitude + "," + longitude;
        if (TextUtils.isNotEmpty((CharSequence)title) && TextUtils.isNotEmpty((CharSequence)address)) {
            uriString = uriString + ";title:" + URLEncoder.encode(title);
            uriString = uriString + ";addr:" + URLEncoder.encode(address);
        } else if (TextUtils.isNotEmpty((CharSequence)address)) {
            uriString = uriString + ";title:" + URLEncoder.encode(address);
            uriString = uriString + ";addr:" + URLEncoder.encode(address);
        } else if (TextUtils.isNotEmpty((CharSequence)title)) {
            uriString = uriString + ";title:" + URLEncoder.encode(title);
            uriString = uriString + ";addr:" + URLEncoder.encode(title);
        }
        Desktop.getDesktop().browse(new URL(uriString).toURI());
    }
}

