/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyDownloadOpenTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javafx.application.Platform;

public class DownloadDocument
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            final String packetId = targetMap.get("packetId");
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            Message message = actionService.getMessageByPacketId(packetId);
            String fileDownloadURL = message.getFileDownloadURL();
            if (actionService.hasDownloadUrl(fileDownloadURL)) {
                Log.i(DownloadDocument.class.getSimpleName(), "Downloading " + fileDownloadURL + ", skip now ...");
                return;
            }
            String fileName = message.getFileNameForDisp();
            File cacheFile = FileUtil.getDownloadCacheFile(fileDownloadURL);
            if (cacheFile.exists()) {
                DownloadDocument.handleFileCacheOpen(actionService, cacheFile, fileName);
            } else {
                if (TextUtils.isBlank((CharSequence)fileDownloadURL)) {
                    return;
                }
                int index = fileDownloadURL.indexOf("/ucrm");
                if (index == -1) {
                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("media_filepath_is_corrupted"), 10);
                    return;
                }
                final String fileInfoStorageId = targetMap.get("fileInfoStorageId");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, ActionBase.isLeft(targetMap));
                        }
                        catch (UCThreadException e) {
                            Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                        }
                    }
                });
                String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
                DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, 0L, new MyDownloadOpenTaskCallBack(actionService, packetId, fileName, cacheFile, fileDownloadURL));
                actionService.registerDownloadMap(packetId, task);
                actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
                task.start();
            }
        }
    }

    public static void handleFileCacheOpen(ActionService actionService, File cacheFile, String fileName) {
        try {
            File fileToDiaplay = new File(MediaFileUtil.getDocRoot(UCChatClient.context), fileName);
            if (!fileToDiaplay.exists() || !FileUtil.contentEquals(fileToDiaplay, cacheFile)) {
                Files.copy(cacheFile.toPath(), fileToDiaplay.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            actionService.openFile(fileToDiaplay);
        }
        catch (Exception e) {
            Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }
}

