/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyRecordingDownloadOpenTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import javafx.application.Platform;

public class DownloadPersonalRecord
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(ActionService actionService, ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            VoiceItem item;
            String packetId = targetMap.get("packetId");
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            String fileInfoStorageId = targetMap.get("fileInfoStorageId");
            Log.i(MessageArea.class.getSimpleName(), "Click Audio icon---------" + packetId);
            Message message = actionService.getMessageByPacketId(packetId);
            if (!message.isPlayed()) {
                ChatRoomManager.markMsgAsPlayed(UCChatClient.context, message);
            }
            if ((item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, message)) == null) {
                Log.i(MessageArea.class.getSimpleName(), "VoiceItem null:" + message.getContent());
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            if (actionService.hasDownloadUrl(item.getUrl())) {
                return;
            }
            File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
            if (localRecFile != null) {
                if (localRecFile.exists()) {
                    actionService.openFile(localRecFile);
                }
            } else {
                File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
                if (cacheFile == null) {
                    return;
                }
                if (cacheFile.exists()) {
                    actionService.openFile(cacheFile);
                } else {
                    DownloadPersonalRecord.downloadAndOpenRecording(actionService, packetId, fileInfoStorageId, cacheFile, item, DownloadPersonalRecord.isLeft(targetMap));
                }
            }
        }
    }

    private static void downloadAndOpenRecording(final ActionService actionService, final String packetId, final String fileInfoStorageId, File cacheFile, VoiceItem item, final boolean isLeft) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, isLeft);
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
        String fileDownloadURL = item.getUrl();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new MyRecordingDownloadOpenTaskCallBack(actionService, packetId, cacheFile, item));
        actionService.registerDownloadMap(packetId, task);
        actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
        task.start();
    }
}

