/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.component.CopyImages;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;

class MyDownloadCopyAsTaskCallBack
implements DownloadFileTaskCallBack {
    String mPackId;
    File mFile;
    ActionService mActionService;

    public MyDownloadCopyAsTaskCallBack(ActionService actionService, String packetId, File toFile) {
        this.mActionService = actionService;
        this.mPackId = packetId;
        this.mFile = toFile;
    }

    @Override
    public void onFileLengthGot(int length) {
    }

    @Override
    public void onProgressUpdated(int progress) {
        this.mActionService.updateFileDownloadProgress(this.mPackId, progress);
    }

    @Override
    public void onDownloadFileStarted() {
    }

    @Override
    public void onDownloadFileCompleted() {
        this.mActionService.updateFileDownloadCompleted(this.mPackId);
        BufferedImage bi = FileUtil.readFileHandleExif(this.mFile);
        CopyImages im = new CopyImages(bi);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(im, null);
        ToastUtil.showShort(I18NUtil.getString("media_save_to_clipboard_success"));
        this.unlock();
    }

    @Override
    public void onDownloadFileCancelled() {
        this.mActionService.updateFileDownloadCancelled(this.mPackId);
        this.unlock();
    }

    @Override
    public void onDownloadFileFailed() {
        this.mActionService.updateFileDownloadFailed(this.mPackId);
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
    }

    private void unlock() {
        this.mActionService.unregisterDownloadMap(this.mPackId);
        this.mActionService.unregisterDownloadUrlMap(this.mPackId);
    }

    @Override
    public void onDownloadFileNotFound() {
        ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
    }
}

