/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.chat.action.DownloadDocument;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import java.io.File;

class MyDownloadOpenTaskCallBack
implements DownloadFileTaskCallBack {
    String mPackId;
    File mCacheFile;
    String mFileName;
    String mDownloadUrl;
    ActionService mActionService;

    public MyDownloadOpenTaskCallBack(ActionService actionService, String packetId, String fileName, File toCacheFile, String downloadUrl) {
        this.mActionService = actionService;
        this.mPackId = packetId;
        this.mCacheFile = toCacheFile;
        this.mFileName = fileName;
        this.mDownloadUrl = downloadUrl;
    }

    @Override
    public void onFileLengthGot(int size) {
    }

    @Override
    public void onProgressUpdated(int progress) {
        this.mActionService.updateFileDownloadProgress(this.mPackId, progress);
    }

    @Override
    public void onDownloadFileStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadFileCompleted() {
        this.mActionService.updateFileDownloadCompleted(this.mPackId);
        try {
            ActionService actionService = this.mActionService;
            synchronized (actionService) {
                DownloadDocument.handleFileCacheOpen(this.mActionService, this.mCacheFile, this.mFileName);
            }
        }
        catch (Throwable t) {
            Log.i(DownloadDocument.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
        this.unlock();
    }

    @Override
    public void onDownloadFileCancelled() {
        this.mActionService.updateFileDownloadCancelled(this.mPackId);
        this.unlock();
    }

    @Override
    public void onDownloadFileFailed() {
        this.mActionService.updateFileDownloadFailed(this.mPackId);
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
    }

    @Override
    public void onDownloadFileNotFound() {
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
    }

    private void unlock() {
        this.mActionService.unregisterDownloadMap(this.mPackId);
        this.mActionService.unregisterDownloadUrlMap(this.mPackId);
    }
}

