/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import java.io.File;
import javafx.application.Platform;
import javax.swing.SwingUtilities;

class MyVoicemailDownloadOpenTaskCallBack
implements DownloadFileTaskCallBack {
    private Message mMessage;
    private File mFile;
    private ActionService mActionService;
    private ElementAttrMap mTargetMap;

    public MyVoicemailDownloadOpenTaskCallBack(ActionService actionService, Message message, File toFile, ElementAttrMap targetMap) {
        this.mActionService = actionService;
        this.mMessage = message;
        this.mFile = toFile;
        this.mTargetMap = targetMap;
    }

    @Override
    public void onFileLengthGot(int size) {
    }

    @Override
    public void onProgressUpdated(int progress) {
        this.mActionService.updateFileDownloadProgress(this.mMessage.getPacketId(), progress);
    }

    @Override
    public void onDownloadFileStarted() {
    }

    @Override
    public void onDownloadFileCompleted() {
        this.mActionService.updateFileDownloadCompleted(this.mMessage.getPacketId());
        if (this.mFile != null) {
            try {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MyVoicemailDownloadOpenTaskCallBack.this.mActionService.playAudioFile(MyVoicemailDownloadOpenTaskCallBack.this.mTargetMap, MyVoicemailDownloadOpenTaskCallBack.this.mMessage, MyVoicemailDownloadOpenTaskCallBack.this.mFile, 2);
                        }
                        catch (Throwable e) {
                            Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                        }
                    }
                });
            }
            catch (Exception e) {
                Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtil.showErrorLong("cannot open audio:" + e.getLocalizedMessage());
                    }
                });
            }
        }
        this.unlock();
    }

    @Override
    public void onDownloadFileCancelled() {
        this.mActionService.updateFileDownloadCancelled(this.mMessage.getPacketId());
        this.unlock();
    }

    @Override
    public void onDownloadFileFailed() {
        this.mActionService.updateFileDownloadFailed(this.mMessage.getPacketId());
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
    }

    private void unlock() {
        this.mActionService.unregisterDownloadMap(this.mMessage.getPacketId());
        this.mActionService.unregisterDownloadUrlMap(this.mMessage.getPacketId());
    }

    @Override
    public void onDownloadFileNotFound() {
        ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
    }
}

