/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyVoicemailDownloadSaveAsTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javafx.application.Platform;

public class SaveVoicePersonalFile
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            String packetId = targetMap.get("packetId");
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SaveVoicePersonalFile.doSaveFile(actionService, targetMap);
                    }
                    catch (UCThreadException e) {
                        Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            });
        }
    }

    private static void doSaveFile(ActionService actionService, ElementAttrMap targetMap) throws UCThreadException {
        String packetId = targetMap.get("packetId");
        String fileInfoStorageId = targetMap.get("fileInfoStorageId");
        Message message = actionService.getMessageByPacketId(packetId);
        int msgType = message.getMsgType();
        if (msgType != 12 && msgType != 1005 && msgType != 13 && msgType != 1006) {
            return;
        }
        VoiceItem item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, message);
        if (item == null) {
            Log.i(MessageArea.class.getSimpleName(), "VoiceItem null:" + message.getContent());
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
            return;
        }
        String fileName = VoicemailManager.getVoiceItemDispName(item);
        if (fileName == null) {
            Log.i(SaveVoicePersonalFile.class.getSimpleName(), "filename is null");
            return;
        }
        File saveAsFile = DomUtil.selectFileFromChooser(actionService.getWindow(), fileName);
        if (saveAsFile != null) {
            File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
            if (localRecFile != null) {
                if (localRecFile.exists()) {
                    try {
                        Files.copy(localRecFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                }
            } else {
                long id = item.getId();
                int type = item.getGroup();
                Log.i(MessageArea.class.getSimpleName(), "doDeleteVoiceMail : id " + id + " Type :" + type);
                File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
                if (cacheFile.exists()) {
                    try {
                        Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                } else {
                    FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, SaveVoicePersonalFile.isLeft(targetMap));
                    SaveVoicePersonalFile.downloadAndSaveAsVoiceRecording(actionService, packetId, fileInfoStorageId, cacheFile, saveAsFile, item);
                }
            }
        }
    }

    private static void downloadAndSaveAsVoiceRecording(ActionService actionService, String packetId, String fileInfoStorageId, File cacheFile, File saveAsFile, VoiceItem item) {
        String fileDownloadURL = item.getUrl();
        if (actionService.hasDownloadUrl(fileDownloadURL)) {
            return;
        }
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new MyVoicemailDownloadSaveAsTaskCallBack(actionService, packetId, cacheFile, saveAsFile));
        actionService.registerDownloadMap(packetId, task);
        actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
        task.start();
    }
}

