/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import javafx.application.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MyPunchcardRenderer
extends MyRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String myJid, String myName, boolean isMultiRoom, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        String address = msg.getContent();
        String status = msg.getStatus();
        String title = null;
        MessageStatus msgStatus = DomUtil.convertMsgStatus(status);
        Element textElement = (Element)textNode;
        MyPunchcardRenderer.fillMyCommonData(domService, textElement, myJid, myName, msg, msgStatus, isMultiRoom);
        if (TextUtils.isEmpty((CharSequence)address)) {
            address = I18NUtil.getString("chat_punchcard_no_address_hint");
        }
        Element elem_myPunchCardAddrText = domService.getElementById("myPunchCardAddress");
        elem_myPunchCardAddrText.setAttribute("id", "myPunchCardAddress_" + packetId);
        elem_myPunchCardAddrText.setAttribute("packetId", packetId);
        elem_myPunchCardAddrText.setAttribute("style", "cursor:pointer;");
        elem_myPunchCardAddrText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_myPunchCardAddrText, "click");
        ChatTextWriter writer1 = new ChatTextWriter(domService, elem_myPunchCardAddrText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(address, writer1);
        if (TextUtils.isEmpty(title)) {
            title = I18NUtil.getString("chat_msg_type_punch_card_title");
        }
        Element elem_myPunchCardLabelText = domService.getElementById("myPunchCardLabel");
        elem_myPunchCardLabelText.setAttribute("id", "myPunchCardLabel_" + packetId);
        elem_myPunchCardLabelText.setAttribute("packetId", packetId);
        elem_myPunchCardLabelText.setAttribute("style", "cursor:pointer;");
        elem_myPunchCardLabelText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_myPunchCardLabelText, "click");
        ChatTextWriter writer2 = new ChatTextWriter(domService, elem_myPunchCardLabelText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(title, writer2);
        Element elem_myPunchCardTimeText = domService.getElementById("myPunchCardTime");
        elem_myPunchCardTimeText.setAttribute("id", "myPunchCardTime_" + packetId);
        elem_myPunchCardTimeText.setAttribute("packetId", packetId);
        elem_myPunchCardTimeText.setAttribute("style", "cursor:pointer;");
        elem_myPunchCardTimeText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_myPunchCardTimeText, "click");
        Text prefixText = domService.createTextNode(DateTimeUtil.getTimeStr(msg.getServerTime(), 2));
        elem_myPunchCardTimeText.appendChild(prefixText);
    }
}

