/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NoticeMsgRenderer {
    public static void render(DomService domService, Node noticeNode, Message msg, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String fileName = msg.getFileNameForDisp();
        long fileSize = msg.getFileSizeToCal();
        String packetId = msg.getPacketId();
        long timeStamp = msg.getServerTime();
        Element noticeElement = (Element)noticeNode;
        noticeElement.setAttribute("id", "noticeMessage_" + packetId);
        noticeElement.setAttribute("packetId", packetId);
        noticeElement.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_noticeMessageTitle = domService.getElementById("noticeMessageTitle");
        elem_noticeMessageTitle.setAttribute("id", "noticeMessageTitle_" + packetId);
        ChatTextWriter.writeTextMatchSearchKey(domService, elem_noticeMessageTitle, msg.getContent(), searchKey, packetId, targetPacketId);
        Element elem_noticeMessageContent = domService.getElementById("noticeMessageContent");
        elem_noticeMessageContent.setAttribute("id", "noticeMessageContent_" + packetId);
        elem_noticeMessageContent.appendChild(domService.createTextNode(msg.getNoticeContent()));
        Element elem_noticeMessageImages = domService.getElementById("noticeMessageImages");
        elem_noticeMessageImages.setAttribute("id", "noticeMessageImages_" + packetId);
        Element elem_noticeMessageVideos = domService.getElementById("noticeMessageVideos");
        elem_noticeMessageVideos.setAttribute("id", "noticeMessageVideos_" + packetId);
        Element elem_noticeMessageDocs = domService.getElementById("noticeMessageDocs");
        elem_noticeMessageDocs.setAttribute("id", "noticeMessageDocs_" + packetId);
        String noticeThumbnail = msg.getNoticeThumbnail();
        if (TextUtils.isBlank((CharSequence)noticeThumbnail)) {
            if (!TextUtils.isBlank((CharSequence)fileName)) {
                if (fileName.toLowerCase().endsWith(".mp4")) {
                    String blockId = "noticeMessageVideo_1_" + packetId;
                    NoticeMsgRenderer.appendVideoBlock(domService, fileName, fileSize, blockId, packetId, elem_noticeMessageVideos, searchKey, targetPacketId);
                } else {
                    String blockId = "noticeMessageDoc_1_" + packetId;
                    NoticeMsgRenderer.appendDocumentBlock(domService, fileName, fileSize, blockId, packetId, elem_noticeMessageDocs, false, searchKey, targetPacketId);
                }
            }
        } else {
            String blockId = "noticeMessageImage_1_" + packetId;
            NoticeMsgRenderer.appendImageBlock(domService, fileSize, noticeThumbnail, blockId, packetId, elem_noticeMessageVideos);
        }
    }

    private static void appendImageBlock(DomService domService, long imageSize, String thumbnail, String id, String packetId, Element parentElement) throws UCThreadException {
        String fileInfoStorageId = "fileInfoStorage_" + id;
        Element imgThumbnail = domService.createElement("img");
        imgThumbnail.setAttribute("id", "noticeMessageThumbnail_" + packetId);
        imgThumbnail.setAttribute("class", "otherImage");
        if (TextUtils.isNotBlank((CharSequence)thumbnail) && !"<LAZY>".equals(thumbnail)) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(thumbnail);
            if (bi != null) {
                int imageWidth = bi.getWidth();
                int imageHeight = bi.getHeight();
                imgThumbnail.setAttribute("src", "data:image/png;base64," + thumbnail);
                imgThumbnail.setAttribute("width", String.valueOf(imageWidth));
                imgThumbnail.setAttribute("height", String.valueOf(imageHeight));
            } else {
                imgThumbnail.setAttribute("width", String.valueOf(160));
                imgThumbnail.setAttribute("height", String.valueOf(120));
                imgThumbnail.setAttribute("src", MessageResource.fileMissingIconURI);
            }
        } else {
            imgThumbnail.setAttribute("width", String.valueOf(160));
            imgThumbnail.setAttribute("height", String.valueOf(120));
            imgThumbnail.setAttribute("src", MessageResource.fileMissingIconURI);
        }
        imgThumbnail.setAttribute("packetId", packetId);
        imgThumbnail.setAttribute("fileInfoStorageId", fileInfoStorageId);
        imgThumbnail.setAttribute("command", "downloadImage");
        domService.addEventListener(imgThumbnail, "click");
        Element divSize = domService.createElement("div");
        divSize.setAttribute("class", "sizeText");
        divSize.appendChild(domService.createTextNode(FileUtil.getFileSizeText(imageSize)));
        Element divInfo = domService.createElement("div");
        divInfo.setAttribute("id", fileInfoStorageId);
        divInfo.setAttribute("style", "display:inline-block; padding-left:10px; vertical-align:top;");
        divInfo.appendChild(divSize);
        Element divImage = domService.createElement("div");
        divImage.appendChild(imgThumbnail);
        divImage.appendChild(divInfo);
        parentElement.appendChild(divImage);
    }

    private static void appendVideoBlock(DomService domService, String videoName, long videoDuration, String id, String packetId, Element parentElement, String searchKey, String targetPacketId) throws UCThreadException {
        String fileInfoStorageId = "fileInfoStorage_" + id;
        Element imgIcon = domService.createElement("img");
        imgIcon.setAttribute("src", MessageResource.videoIconURI);
        imgIcon.setAttribute("style", "cursor:pointer;");
        imgIcon.setAttribute("packetId", packetId);
        imgIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        imgIcon.setAttribute("command", "downloadVideo");
        domService.addEventListener(imgIcon, "click");
        Element divName = domService.createElement("div");
        divName.setAttribute("class", "nameText");
        ChatTextWriter.writeTextMatchSearchKey(domService, divName, videoName, searchKey, packetId, targetPacketId);
        Element divDuration = domService.createElement("div");
        divDuration.setAttribute("class", "sizeText");
        divDuration.appendChild(domService.createTextNode(CommonUtil.getDurationMilliSeconds(videoDuration)));
        Element divInfo = domService.createElement("div");
        divInfo.setAttribute("id", fileInfoStorageId);
        divInfo.setAttribute("style", "display:inline-block; padding-left:10px; vertical-align:top;");
        divInfo.appendChild(divName);
        divInfo.appendChild(divDuration);
        Element divVideo = domService.createElement("div");
        divVideo.appendChild(imgIcon);
        divVideo.appendChild(divInfo);
        parentElement.appendChild(divVideo);
    }

    private static void appendDocumentBlock(DomService domService, String fileName, long fileSize, String id, String packetId, Element parentElement, boolean isFromMe, String searchKey, String targetPacketId) throws UCThreadException {
        String fileInfoStorageId = "fileInfoStorage_" + id;
        Element imgIcon = domService.createElement("img");
        imgIcon.setAttribute("src", DomUtil.getDocumentIconURI(fileName));
        imgIcon.setAttribute("style", "cursor:pointer;");
        imgIcon.setAttribute("width", String.valueOf(80));
        imgIcon.setAttribute("height", String.valueOf(80));
        imgIcon.setAttribute("packetId", packetId);
        imgIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        imgIcon.setAttribute("command", "downloadDocument");
        imgIcon.setAttribute("isFromMe", isFromMe ? "true" : "false");
        domService.addEventListener(imgIcon, "click");
        Element divName = domService.createElement("div");
        divName.setAttribute("class", "nameText");
        ChatTextWriter.writeTextMatchSearchKey(domService, divName, fileName, searchKey, packetId, targetPacketId);
        Element divSize = domService.createElement("div");
        divSize.setAttribute("class", "sizeText");
        divSize.appendChild(domService.createTextNode(FileUtil.getFileSizeText(fileSize)));
        Element divInfo = domService.createElement("div");
        divInfo.setAttribute("id", fileInfoStorageId);
        divInfo.setAttribute("style", "display:inline-block; padding-left:10px; vertical-align:top;");
        divInfo.appendChild(divName);
        divInfo.appendChild(divSize);
        Element divDoc = domService.createElement("div");
        divDoc.appendChild(imgIcon);
        divDoc.appendChild(divInfo);
        parentElement.appendChild(divDoc);
    }
}

