/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.dom.OtherRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OtherImageRenderer
extends OtherRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String otherJid, String otherName, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        String imageBase64Content = msg.getContent();
        String extraInfo = msg.getExtraMsgInfo();
        Element textElement = (Element)textNode;
        OtherImageRenderer.fillOtherCommonData(domService, textElement, otherJid, otherName, msg);
        String fileInfoStorageId = "otherMessageInfo_" + packetId;
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            Element elem_otherImageWithMsgText = domService.getElementById("otherExtraText");
            elem_otherImageWithMsgText.setAttribute("id", "otherExtraText_" + packetId);
            elem_otherImageWithMsgText.setAttribute("packetId", packetId);
            elem_otherImageWithMsgText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_otherImageWithMsgText, "dblclick");
            ChatTextWriter writer = new ChatTextWriter(domService, elem_otherImageWithMsgText, packetId, searchKey, targetPacketId);
            MsgTextConverter.convertAndAppendText(extraInfo, writer);
        }
        Element elem_imageInfo = domService.getElementById("otherMessageInfo");
        elem_imageInfo.setAttribute("id", fileInfoStorageId);
        elem_imageInfo.setAttribute("packetId", packetId);
        elem_imageInfo.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_imageIcon = domService.getElementById("otherMessageIcon");
        elem_imageIcon.setAttribute("id", "otherMessageIcon_" + packetId);
        elem_imageIcon.setAttribute("packetId", packetId);
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content)) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
            if (bi != null) {
                int imageWidth = bi.getWidth();
                int imageHeight = bi.getHeight();
                elem_imageIcon.setAttribute("width", String.valueOf(imageWidth));
                elem_imageIcon.setAttribute("height", String.valueOf(imageHeight));
                elem_imageIcon.setAttribute("src", "data:image/png;base64," + imageBase64Content);
            } else {
                elem_imageIcon.setAttribute("width", String.valueOf(120));
                elem_imageIcon.setAttribute("height", String.valueOf(90));
                elem_imageIcon.setAttribute("src", MessageResource.fileMissingIconURI);
            }
        } else {
            elem_imageIcon.setAttribute("width", String.valueOf(120));
            elem_imageIcon.setAttribute("height", String.valueOf(90));
            elem_imageIcon.setAttribute("src", MessageResource.fileMissingIconURI);
        }
        elem_imageIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        elem_imageIcon.setAttribute("command", "downloadImage");
        domService.addEventListener(elem_imageIcon, "click");
    }
}

