/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.dom.OtherRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import javafx.application.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OtherLocationRenderer
extends OtherRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String otherJid, String otherName, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        String address = msg.getContent();
        String title = msg.getTitle();
        Element textElement = (Element)textNode;
        OtherLocationRenderer.fillOtherCommonData(domService, textElement, otherJid, otherName, msg);
        if (TextUtils.isEmpty((CharSequence)address)) {
            address = I18NUtil.getString("chat_location_no_address_hint");
        }
        Element elem_otherLocationAddrText = domService.getElementById("otherLocationAddress");
        elem_otherLocationAddrText.setAttribute("id", "otherLocationAddress_" + packetId);
        elem_otherLocationAddrText.setAttribute("packetId", packetId);
        elem_otherLocationAddrText.setAttribute("style", "cursor:pointer;");
        elem_otherLocationAddrText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_otherLocationAddrText, "click");
        ChatTextWriter writer1 = new ChatTextWriter(domService, elem_otherLocationAddrText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(address, writer1);
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = I18NUtil.getString("chat_msg_type_location_title");
        }
        Element elem_otherLocationLabelText = domService.getElementById("otherLocationLabel");
        elem_otherLocationLabelText.setAttribute("id", "otherLocationLabel_" + packetId);
        elem_otherLocationLabelText.setAttribute("packetId", packetId);
        elem_otherLocationLabelText.setAttribute("style", "cursor:pointer;");
        elem_otherLocationLabelText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_otherLocationLabelText, "click");
        ChatTextWriter writer2 = new ChatTextWriter(domService, elem_otherLocationLabelText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(title, writer2);
    }
}

