/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import javafx.application.Platform;
import org.w3c.dom.Element;

public class OtherRendererBase {
    public static void fillOtherCommonData(DomService domService, Element messageElement, String otherJid, String otherName, Message msg) throws UCThreadException {
        Element elem_otherMessageTime;
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        messageElement.setAttribute("id", "msg_" + packetId);
        messageElement.setAttribute("packetId", packetId);
        messageElement.setAttribute("messageId", String.valueOf(msg.getId()));
        messageElement.setAttribute("mineFlag", String.valueOf(0));
        Object otherPhotoURI = null;
        boolean isFixed = false;
        if (JidUtil.isAPIUserJid(otherJid)) {
            MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(UCChatClient.context, otherJid);
            if (channel != null) {
                otherPhotoURI = MessageChannelManager.getChannelPhotoURI(channel.getId());
            }
        } else if (JidUtil.isMyContactJid(otherJid)) {
            long contactId = JidUtil.trimExternalContactId(otherJid);
            otherPhotoURI = ContactManager.getExternalContactPhotoURI(contactId);
        } else if (JidUtil.isEmployeeJid(otherJid)) {
            otherPhotoURI = ContactManager.getContactPhotoURI(otherJid);
        } else if (JidUtil.isCustomerJid(otherJid)) {
            otherPhotoURI = CustomerManager.getContactPhotoURI(otherJid);
        } else if (JidUtil.isLocationJid(otherJid)) {
            otherPhotoURI = MessageResource.publicPhonePhotoURI;
            isFixed = true;
        }
        if (otherPhotoURI == null) {
            otherPhotoURI = MessageResource.noNamePhotoURI;
            isFixed = true;
        }
        if (!isFixed) {
            otherPhotoURI = (String)otherPhotoURI + "?" + System.currentTimeMillis();
        }
        if ((elem_otherMessageTime = domService.getElementById("otherMessageTime")) != null) {
            elem_otherMessageTime.setAttribute("id", "elem_otherMessageTime_" + packetId);
            String serverTime = DateTimeUtil.getTimeStr(msg.getServerTime(), 2);
            elem_otherMessageTime.appendChild(domService.createTextNode(serverTime));
        }
        Element elem_otherPhoto = domService.getElementById("otherPhoto");
        elem_otherPhoto.setAttribute("id", "otherPhoto_" + packetId);
        elem_otherPhoto.setAttribute("packetId", packetId);
        elem_otherPhoto.setAttribute("src", (String)otherPhotoURI);
        domService.registerPhotoKey("otherPhoto_" + packetId, otherJid);
        elem_otherPhoto.setAttribute("command", "attachName");
        elem_otherPhoto.setAttribute("style", "cursor:pointer;");
        domService.addEventListener(elem_otherPhoto, "click");
        Element elem_otherName = domService.getElementById("otherName");
        elem_otherName.setAttribute("id", "otherName_" + packetId);
        elem_otherName.appendChild(domService.createTextNode(otherName));
    }
}

