/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.popup;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.popup.StickerPopupMenu;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class StickerButton
extends JButton {
    private String stickerKey;
    private StickerPopupMenu.BtnClickListener mStickerClickListener;

    public StickerButton(String key, String iconPath, StickerPopupMenu.BtnClickListener stickerClickListener) {
        this.stickerKey = key;
        this.mStickerClickListener = stickerClickListener;
        this.setFont(UIConstants.FONT_12_PLAIN);
        Image img = Toolkit.getDefaultToolkit().getImage(StickerButton.class.getClassLoader().getResource(iconPath));
        int imgWidth = img.getWidth(null);
        int imgHeight = img.getHeight(null);
        float widthRatio = 60.0f / (float)imgWidth;
        float heightRatio = 60.0f / (float)imgHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        ratio = Math.min(1.0f, ratio);
        ImageIcon imgIcon = GraphicUtil.getScaledIcon(img, (int)((double)((float)imgWidth * ratio) * 0.85), (int)((double)((float)imgHeight * ratio) * 0.85));
        this.setIcon(imgIcon);
        this.setPreferredSize(new Dimension(60, 60));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StickerButton.this.mStickerClickListener.onClick(StickerButton.this.stickerKey);
            }
        });
    }
}

