/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ChangeChatroomNamePanel
extends RoundedCornerPanel {
    private JLabel lblTitle;
    private JSeparator jSeparator1;
    private JTextField txtRoomName;
    private JLabel lblMessage;
    private JButton btnConfirm;
    private JButton btnCancel;
    String roomJID;
    String roomName;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ChangeChatroomNamePanel("roomJID", "Room Name"));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ChangeChatroomNamePanel(String roomJID, String roomName) {
        this.initGUI();
        this.roomJID = roomJID;
        this.roomName = roomName;
        this.txtRoomName.setText(roomName);
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("chatroom_title_name"));
            this.lblTitle.setFont(UIConstants.FONT_16_BOLD);
            this.lblTitle.setForeground(UIConstants.COLOR_DIALOG_TITLE);
            this.jSeparator1 = new JSeparator();
            this.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtRoomName = new JTextField();
            this.add((Component)this.txtRoomName, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(10, 20, 0, 20), 0, 0));
            this.txtRoomName.setPreferredSize(new Dimension(200, 28));
            this.txtRoomName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangeChatroomNamePanel.this.txtRoomNameActionPerformed(evt);
                }
            });
            this.txtRoomName.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "myEsc");
            this.txtRoomName.getActionMap().put("myEsc", new EscAction());
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 20, 0, 20), 0, 0));
            this.lblMessage.setText(" ");
            this.btnConfirm = new JButton();
            this.add((Component)this.btnConfirm, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 10), 0, 0));
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.setMinimumSize(new Dimension(75, 30));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangeChatroomNamePanel.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.add((Component)this.btnCancel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.setMinimumSize(new Dimension(75, 30));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangeChatroomNamePanel.this.btnCancelActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void txtRoomNameActionPerformed(ActionEvent evt) {
        if (this.validateValue()) {
            this.changeChatRoomName();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.validateValue()) {
            this.changeChatRoomName();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        UCChatClient.getInstance().hideGlassPanel();
    }

    private boolean validateValue() {
        String newRoomName = this.txtRoomName.getText();
        if (TextUtils.isBlank((CharSequence)newRoomName)) {
            this.lblMessage.setText(I18NUtil.getString("chatroom_validation_empty"));
            this.txtRoomName.requestFocus();
            return false;
        }
        return true;
    }

    private void changeChatRoomName() {
        String newRoomName = this.txtRoomName.getText();
        WebAgent.getInstance().changeRoomSubject(this.roomJID, newRoomName);
        UCChatClient.getInstance().hideGlassPanel();
    }

    public void focusTextField() {
        this.txtRoomName.requestFocus();
    }

    class EscAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            UCChatClient.getInstance().hideGlassPanel();
        }
    }
}

