/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.util.FuzzyNumberUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class MsgPhoneFormatter {
    public static String convertInboundMissCallContent(Context ctx, String content) {
        return MsgPhoneFormatter.convertInboundMissCallContent(ctx, content, "\n");
    }

    public static String convertInboundMissCallContent(Context ctx, String content, String delimiter) {
        ArrayList<String> contentList = new ArrayList<String>();
        if ("[PHONE_CANCEL_IN]".equals(content)) {
            contentList.add("[PHONE_CANCEL]");
            contentList.add(I18NUtil.getString("call_status_miss"));
        } else if (content.startsWith("[PHONE_CANCEL_IN2]")) {
            contentList.add("[PHONE_CANCEL]");
            String[] comps = content.split("_@@_");
            if (comps.length >= 3) {
                String siteId = comps[1];
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    contentList.add(PhoneNoUtil.getPhoneNumDisp(ctx, siteId, comps[2]));
                } else {
                    contentList.add(comps[2]);
                }
            }
            contentList.add(I18NUtil.getString("call_status_miss"));
        } else {
            contentList.add(content);
        }
        return String.join((CharSequence)delimiter, contentList);
    }

    public static String convertInboundTalkingContent(Context ctx, String content) {
        return MsgPhoneFormatter.convertInboundTalkingContent(ctx, content, null, "\n");
    }

    public static String convertInboundTalkingContent(Context ctx, String content, String prefix2, String delimiter) {
        ArrayList<String> contentList = new ArrayList<String>();
        if (TextUtils.isBlank((CharSequence)content) || content.indexOf("_@@_") == -1) {
            contentList.add(content);
        } else {
            String[] comps = content.split("_@@_");
            if (comps.length >= 4) {
                String siteId = comps[1];
                contentList.add("[PHONE_TALKING]");
                if (StringUtils.isNotBlank((CharSequence)prefix2)) {
                    contentList.add(prefix2);
                }
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    contentList.add(PhoneNoUtil.getPhoneNumDisp(ctx, siteId, comps[2]));
                } else {
                    contentList.add(comps[2]);
                }
                contentList.add(comps[3]);
            }
        }
        return String.join((CharSequence)delimiter, contentList);
    }

    public static String convertOutboundMissCallContent(Context ctx, String content) {
        return MsgPhoneFormatter.convertOutboundMissCallContent(ctx, content, "\n", false);
    }

    public static String convertOutboundMissCallContent(Context ctx, String content, String delimiter, boolean encrypted) {
        ArrayList<String> contentList = new ArrayList<String>();
        if (TextUtils.isBlank((CharSequence)content) || content.indexOf("_@@_") == -1) {
            if ("[PHONE_CANCEL_OUT]".equals(content)) {
                contentList.add("[PHONE_CANCEL]");
                contentList.add(I18NUtil.getString("call_status_cancel"));
            } else {
                contentList.add(content);
            }
        } else {
            String[] comps = content.split("_@@_");
            if (comps.length >= 3) {
                String phoneNum;
                String siteId = comps[1];
                contentList.add("[PHONE_CANCEL]");
                String string = phoneNum = encrypted ? FuzzyNumberUtil.convert(comps[2]) : comps[2];
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    contentList.add(PhoneNoUtil.getPhoneNumDisp(ctx, siteId, phoneNum));
                } else {
                    contentList.add(phoneNum);
                }
                if ("[PHONE_CANCEL_OUT]".equals(comps[0])) {
                    contentList.add(I18NUtil.getString("call_status_cancel"));
                } else {
                    contentList.add(comps[3]);
                }
            }
        }
        return String.join((CharSequence)delimiter, contentList);
    }

    public static String convertOutboundTalkingContent(Context ctx, String content) {
        return MsgPhoneFormatter.convertOutboundTalkingContent(ctx, content, null, "\n", false);
    }

    public static String convertOutboundTalkingContent(Context ctx, String content, String prefix2, String delimiter, boolean encrypted) {
        ArrayList<String> contentList = new ArrayList<String>();
        if (TextUtils.isBlank((CharSequence)content) || content.indexOf("_@@_") == -1) {
            contentList.add(content);
        } else {
            String[] comps = content.split("_@@_");
            if (comps.length >= 4) {
                String phoneNum;
                String siteId = comps[1];
                contentList.add("[PHONE_TALKING]");
                if (StringUtils.isNotBlank((CharSequence)prefix2)) {
                    contentList.add(prefix2);
                }
                String string = phoneNum = encrypted ? FuzzyNumberUtil.convert(comps[2]) : comps[2];
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    contentList.add(PhoneNoUtil.getPhoneNumDisp(ctx, siteId, phoneNum));
                } else {
                    contentList.add(phoneNum);
                }
                contentList.add(comps[3]);
            }
        }
        return String.join((CharSequence)delimiter, contentList);
    }
}

