/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;

public class BubbleBorder
extends AbstractBorder {
    private Color color;
    private int thickness = 4;
    private int radii = 8;
    private int pointerSize = 7;
    private Insets insets = null;
    private BasicStroke stroke = null;
    private int strokePad;
    private int pointerPad = 4;
    private boolean left = true;
    RenderingHints hints;

    public BubbleBorder(Color color) {
        this(color, 4, 8, 7);
    }

    public BubbleBorder(Color color, int thickness, int radii, int pointerSize) {
        this.thickness = thickness;
        this.radii = radii;
        this.pointerSize = pointerSize;
        this.color = color;
        this.stroke = new BasicStroke(thickness);
        this.strokePad = thickness / 2;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int pad = radii + this.strokePad;
        int bottomPad = pad + pointerSize + this.strokePad;
        this.insets = new Insets(pad, pad, bottomPad, pad);
    }

    public BubbleBorder(Color color, int thickness, int radii, int pointerSize, boolean left) {
        this(color, thickness, radii, pointerSize);
        this.left = left;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int bottomLineY = height - this.thickness - this.pointerSize;
        RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(0 + this.strokePad, 0 + this.strokePad, width - this.thickness, bottomLineY, this.radii, this.radii);
        Polygon pointer = new Polygon();
        if (this.left) {
            pointer.addPoint(this.strokePad + this.radii + this.pointerPad, bottomLineY);
            pointer.addPoint(this.strokePad + this.radii + this.pointerPad + this.pointerSize, bottomLineY);
            pointer.addPoint(this.strokePad + this.radii + this.pointerPad + this.pointerSize / 2, height - this.strokePad);
        } else {
            pointer.addPoint(width - (this.strokePad + this.radii + this.pointerPad), bottomLineY);
            pointer.addPoint(width - (this.strokePad + this.radii + this.pointerPad + this.pointerSize), bottomLineY);
            pointer.addPoint(width - (this.strokePad + this.radii + this.pointerPad + this.pointerSize / 2), height - this.strokePad);
        }
        Area area = new Area(bubble);
        area.add(new Area(pointer));
        g2.setRenderingHints(this.hints);
        Container parent = c.getParent();
        if (parent != null) {
            Color bg = parent.getBackground();
            Rectangle rect = new Rectangle(0, 0, width, height);
            Area borderRegion = new Area(rect);
            borderRegion.subtract(area);
            g2.setClip(borderRegion);
            g2.setColor(bg);
            g2.fillRect(0, 0, width, height);
            g2.setClip(null);
        }
        g2.setColor(this.color);
        g2.setStroke(this.stroke);
        g2.draw(area);
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JPanel gui = new JPanel(new GridLayout(2, 0, 5, 5));
                gui.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                gui.setBackground(Color.RED);
                BubbleBorder brdrLeft = new BubbleBorder(Color.BLACK, 2, 16, 16);
                BubbleBorder brdrRight = new BubbleBorder(Color.BLACK, 2, 16, 16, false);
                JLabel l1 = new JLabel("Label 1");
                l1.setBorder(brdrRight);
                gui.add(l1);
                JLabel l2 = new JLabel("Label 2");
                l2.setBorder(brdrLeft);
                l2.setBackground(Color.YELLOW);
                l2.setOpaque(true);
                gui.add(l2);
                JPanel p1 = new JPanel();
                p1.add(new JLabel("Panel 1"));
                p1.setBorder(brdrRight);
                p1.setOpaque(false);
                gui.add(p1);
                JPanel p2 = new JPanel();
                p2.add(new JLabel("Panel 2"));
                p2.setBorder(brdrLeft);
                gui.add(p2);
                JFrame frame = new JFrame();
                frame.getContentPane().add(gui);
                frame.setDefaultCloseOperation(3);
                frame.setSize(400, 300);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

