/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Component;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CountrySelectionRenderer
implements ListCellRenderer<LiteOutboundPrefix> {
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public static String getCountryRegion(LiteOutboundPrefix prefix) {
        Object value = "";
        if (prefix != null) {
            Locale defaultLocale = I18NUtil.getAppLocale();
            value = Locale.TAIWAN.equals(defaultLocale) ? (prefix.getCountryNameTw() == null ? prefix.getCountryCode() : prefix.getCountryNameTw() + " (" + prefix.getCountryCode() + ")/" + prefix.getNameTw() + " (" + prefix.getPrefix() + ")") : (Locale.CHINA.equals(defaultLocale) || Locale.CHINESE.equals(defaultLocale) ? (prefix.getCountryNameCn() == null ? prefix.getCountryCode() : prefix.getCountryNameCn() + " (" + prefix.getCountryCode() + ")/" + prefix.getNameCn() + " (" + prefix.getPrefix() + ")") : (prefix.getCountryNameEn() == null ? prefix.getCountryCode() : prefix.getCountryNameEn() + " (" + prefix.getCountryCode() + ")/" + prefix.getNameEn() + " (" + prefix.getPrefix() + ")"));
        }
        return value;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends LiteOutboundPrefix> list, LiteOutboundPrefix value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            if (value.getId() == -1L) {
                renderer.setText("     ");
            } else {
                renderer.setText(CountrySelectionRenderer.getCountryRegion(value));
            }
        }
        return renderer;
    }
}

