/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.util.TextUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;

public class EmailLabel
extends JLabel {
    public static Cursor CURSOR_HAND = new Cursor(12);
    public static final Color COLOR_NORMAL = Color.DARK_GRAY;
    public static final Color COLOR_OVER = new Color(0, 128, 255);
    String email;

    public EmailLabel() {
        this("");
    }

    public EmailLabel(String email) {
        super(email);
        this.email = email;
        this.setForeground(COLOR_NORMAL);
        this.setCursor(CURSOR_HAND);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                EmailLabel.this.setForeground(COLOR_OVER);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                EmailLabel.this.setForeground(COLOR_NORMAL);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                EmailLabel.this.sendMail();
            }
        });
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.setText(TextUtils.isBlank((CharSequence)email) ? "" : email);
    }

    @Override
    public void setText(String text) {
        this.email = text;
        super.setText(text);
    }

    private void sendMail() {
        if (TextUtils.isNotBlank((CharSequence)this.email)) {
            try {
                Desktop.getDesktop().mail(new URI("mailto:" + this.email));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

