/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.CustomLineBorder;
import com.blisscloud.ezuc.client.component.ExpandListener;
import com.blisscloud.ezuc.client.component.GroupPanelType;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class GroupPanel
extends JPanel {
    public static final Color TITLE_FOREGROUND = new Color(0x808080);
    public static final Color TITLE_BACKGROUND = new Color(0xF9F9F9);
    public static final Color TITLE_BORDER_COLOR = new Color(0xC6C6C6);
    public static final Border TITLE_BORDER = BorderFactory.createCompoundBorder(new CustomLineBorder(TITLE_BORDER_COLOR, 0, 0, 1, 0), BorderFactory.createEmptyBorder(6, 15, 6, 15));
    public static final Border CONTENT_EMPTY_BORDER = BorderFactory.createEmptyBorder();
    public static final Border CONTENT_BORDER = new CustomLineBorder(TITLE_BORDER_COLOR, 0, 0, 1, 0);
    private JPanel panelTitle;
    private JPanel panelContent;
    private JLabel lblTitle;
    private JLabel lblExpand;
    String groupId;
    String groupName;
    boolean expanded = false;
    boolean updateTitleWhenContentChanged = true;
    private GroupPanelType mGroupPanelType;
    private ExpandListener expandListener;
    private boolean showCompCount = true;
    private int entryHeight = 60;

    public static void main(String[] args) {
        JTextField area1 = new JTextField("text 11111 ");
        area1.setMinimumSize(new Dimension(Integer.MAX_VALUE, 50));
        area1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        JTextArea area2 = new JTextArea("test 22222");
        area2.setMinimumSize(new Dimension(Integer.MAX_VALUE, 50));
        area2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        GroupPanel groupPanel1 = new GroupPanel("Group1", "Group 1", null, GroupPanelType.alphabet, null);
        groupPanel1.addContentComponent(area1);
        groupPanel1.addContentComponent(area2);
        groupPanel1.addContentComponent(new JButton("bbb"));
        groupPanel1.addContentComponent(new JLabel("ccc"));
        GroupPanel groupPanel2 = new GroupPanel("Group2", "Group 2", null, GroupPanelType.alphabet, null);
        groupPanel2.addContentComponent(new JCheckBox("aaa"));
        groupPanel2.addContentComponent(new JCheckBox("bbb"));
        groupPanel2.addContentComponent(new JCheckBox("ccc"));
        JPanel groups = new JPanel();
        BoxLayout panelContentLayout = new BoxLayout(groups, 1);
        groups.setLayout(panelContentLayout);
        groups.add(groupPanel1);
        groups.add(groupPanel2);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(groups);
        JFrame frame = new JFrame();
        frame.getContentPane().add(jScrollPane1);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public GroupPanel(String groupId, String groupName, Icon groupIcon, GroupPanelType groupPanelType, ExpandListener expandListener) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.mGroupPanelType = groupPanelType;
        this.expandListener = expandListener;
        this.initGUI();
        this.lblTitle.setText(groupName);
        this.lblTitle.setIcon(groupIcon);
    }

    public GroupPanel(String groupId, String groupName, boolean titleVisible) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.initGUI();
        this.panelTitle.setVisible(titleVisible);
        if (!titleVisible) {
            this.panelContent.setVisible(true);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.panelTitle = new JPanel();
            BorderLayout panelTitleLayout = new BorderLayout();
            this.panelTitle.setLayout(panelTitleLayout);
            this.add((Component)this.panelTitle, "North");
            this.panelTitle.setBackground(TITLE_BACKGROUND);
            this.panelTitle.setBorder(TITLE_BORDER);
            this.panelTitle.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    GroupPanel.this.panelTitleMousePressed(evt);
                }
            });
            this.lblTitle = new JLabel();
            this.panelTitle.add((Component)this.lblTitle, "Center");
            this.lblTitle.setText("");
            this.lblTitle.setIcon(UIConstants.ICON_GROUP);
            this.lblTitle.setForeground(TITLE_FOREGROUND);
            this.lblTitle.setFont(UIConstants.FONT_14_BOLD);
            this.lblExpand = new JLabel();
            this.panelTitle.add((Component)this.lblExpand, "East");
            this.lblExpand.setIcon(UIConstants.ICON_COLLAPSE);
            this.lblExpand.setCursor(UIConstants.CURSOR_HAND);
            this.lblExpand.setVisible(false);
            this.panelContent = new JPanel();
            BoxLayout panelContentLayout = new BoxLayout(this.panelContent, 1);
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.panelContent.setBorder(CONTENT_EMPTY_BORDER);
            this.panelContent.setVisible(false);
            this.add((Component)this.panelContent, "Center");
            this.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clean() {
        this.expandListener = null;
    }

    public void updateTitleByVisibleComponentCount() {
        if (this.updateTitleWhenContentChanged) {
            int visibleCompCount = this.getVisibleContentComponentCount();
            if (this.showCompCount) {
                this.lblTitle.setText(this.groupName + (visibleCompCount == 0 ? " (" + visibleCompCount + ")" : " (" + visibleCompCount + ")"));
            }
            this.panelContent.setBorder(visibleCompCount == 0 ? CONTENT_EMPTY_BORDER : CONTENT_BORDER);
        }
    }

    private void panelTitleMousePressed(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.clickGroup();
            this.expandListener.onChanged();
        }
    }

    public void clickGroup() {
        if (this.expanded) {
            if (this.mGroupPanelType == GroupPanelType.alphabet) {
                PreferencesUtil.removeFromCompanyAddressBookExpandList(UCChatClient.context, this.groupId);
            } else if (this.mGroupPanelType == GroupPanelType.department) {
                PreferencesUtil.removeFromOrgAddressBookExpandList(UCChatClient.context, this.groupId);
            } else if (this.mGroupPanelType == GroupPanelType.status) {
                PreferencesUtil.removeFromStatusAddressBookExpandList(UCChatClient.context, this.groupId);
            } else if (this.mGroupPanelType == GroupPanelType.general) {
                PreferencesUtil.addToGeneralBookCollapseList(UCChatClient.context, this.groupId);
            }
        } else if (this.mGroupPanelType == GroupPanelType.alphabet) {
            PreferencesUtil.addToCompanyAddressBookExpandList(UCChatClient.context, this.groupId);
        } else if (this.mGroupPanelType == GroupPanelType.department) {
            PreferencesUtil.addToOrgAddressBookExpandList(UCChatClient.context, this.groupId);
        } else if (this.mGroupPanelType == GroupPanelType.status) {
            PreferencesUtil.addToStatusAddressBookExpandList(UCChatClient.context, this.groupId);
        } else if (this.mGroupPanelType == GroupPanelType.general) {
            PreferencesUtil.removeFromGeneralBookCollapseList(UCChatClient.context, this.groupId);
        }
        this.setExpanded(!this.expanded);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.lblTitle.setText(groupName);
    }

    public void setGroupIcon(Icon icon) {
        this.lblTitle.setIcon(icon);
    }

    public void setMode(boolean isSearch) {
        if (isSearch) {
            this.setExpanded(true);
        }
    }

    public boolean isExpaned() {
        return this.expanded;
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
        if (this.expanded) {
            this.panelContent.setVisible(true);
            this.lblExpand.setIcon(UIConstants.ICON_COLLAPSE);
        } else {
            this.panelContent.setVisible(false);
            this.lblExpand.setIcon(UIConstants.ICON_EXPAND);
        }
    }

    public void setUpdateTitleWhenContentChanged(boolean updateTitleWhenContentChanged) {
        this.updateTitleWhenContentChanged = updateTitleWhenContentChanged;
        if (updateTitleWhenContentChanged) {
            this.updateTitleByVisibleComponentCount();
        } else {
            this.lblTitle.setText(this.groupName);
        }
    }

    public Component[] getContentComponents() {
        return this.panelContent.getComponents();
    }

    public Component[] getContentComponents(Class cls) {
        Component[] childComps;
        ArrayList<Component> ret = new ArrayList<Component>();
        for (Component childComp : childComps = this.panelContent.getComponents()) {
            if (!cls.isAssignableFrom(childComp.getClass())) continue;
            ret.add(childComp);
        }
        return ret.toArray(new Component[ret.size()]);
    }

    public int getVisibleContentComponentCount() {
        Component[] comps;
        int count = 0;
        for (Component comp : comps = this.panelContent.getComponents()) {
            if (!comp.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void addContentComponent(JComponent comp) {
        this.panelContent.add(comp);
        this.panelContent.setBorder(CONTENT_BORDER);
        this.initContentComponent(comp);
        this.lblExpand.setVisible(true);
        this.updateTitleByVisibleComponentCount();
    }

    public void addContentComponent(JComponent comp, int index) {
        this.panelContent.add((Component)comp, index);
        this.panelContent.setBorder(CONTENT_BORDER);
        this.initContentComponent(comp);
        this.lblExpand.setVisible(true);
        this.setVisible(true);
        this.updateTitleByVisibleComponentCount();
    }

    public void removeContentComponent(Component comp) {
        this.panelContent.remove(comp);
        int visibleCompCount = this.getVisibleContentComponentCount();
        this.panelContent.setBorder(visibleCompCount == 0 ? CONTENT_EMPTY_BORDER : CONTENT_BORDER);
        this.lblExpand.setVisible(visibleCompCount > 0);
        this.setVisible(visibleCompCount > 0);
        this.updateTitleByVisibleComponentCount();
    }

    public void moveContentComponent(JComponent comp, int index) {
        this.panelContent.remove(comp);
        this.panelContent.add((Component)comp, index);
    }

    public void clearContentComponent() {
        this.panelContent.removeAll();
        this.panelContent.setBorder(CONTENT_EMPTY_BORDER);
        this.lblExpand.setVisible(false);
        this.updateTitleByVisibleComponentCount();
    }

    private void initContentComponent(JComponent comp) {
        comp.setMinimumSize(new Dimension(Integer.MAX_VALUE, this.entryHeight));
        comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.entryHeight));
        comp.setAlignmentX(0.0f);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, this.getComponentsHeight());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getComponentsHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getComponentsHeight());
    }

    private int getComponentsHeight() {
        Component[] comps;
        Insets inset = this.panelContent.getBorder().getBorderInsets(this.panelContent);
        int visibleCompCount = 0;
        for (Component comp : comps = this.panelContent.getComponents()) {
            if (!comp.isVisible()) continue;
            ++visibleCompCount;
        }
        return this.panelTitle.getPreferredSize().height + (this.panelContent.isVisible() ? visibleCompCount * this.entryHeight + inset.top + inset.bottom : 0);
    }

    public boolean isShowCompCount() {
        return this.showCompCount;
    }

    public void setShowCompCount(boolean showCompCount) {
        this.showCompCount = showCompCount;
    }

    public int getEntryHeight() {
        return this.entryHeight;
    }

    public void setEntryHeight(int entryHeight) {
        this.entryHeight = entryHeight;
    }
}

