/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JList;
import javax.swing.UIManager;

public class HintList
extends JList {
    String hintText;

    public HintList(String hintText) {
        this.hintText = hintText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getModel().getSize() == 0) {
            int width = this.getWidth();
            int height = this.getHeight();
            Font prev = g.getFont();
            Font hintFont = prev.deriveFont(1, 20.0f);
            Color prevColor = g.getColor();
            g.setFont(hintFont);
            g.setColor(UIManager.getColor("textInactiveText"));
            int hintWidth = g.getFontMetrics().stringWidth(this.hintText);
            int h = g.getFontMetrics().getHeight();
            int textBottom = (height - h) / 2 + h - 4;
            int x = (width - hintWidth) / 2;
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.hintText, x, textBottom);
            g2d.setRenderingHints(hints);
            g.setFont(prev);
            g.setColor(prevColor);
        }
    }
}

