/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.ChatRoomItem;
import com.blisscloud.ezuc.client.chat.ChatRoomMember;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class MeetmeItemCellRenderer
extends DefaultListCellRenderer {
    int photoSize = 48;

    public MeetmeItemCellRenderer(int photoSize) {
        this.photoSize = photoSize;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            ChatRoomItem m = (ChatRoomItem)value;
            ChatRoomMember crm = (ChatRoomMember)m;
            String contactName = crm.getTitle();
            Image image = null;
            image = JidUtil.isEmployeeJid(crm.getJid()) ? this.getEmpParticipantImage(crm) : (JidUtil.isLocationJid(crm.getJid()) ? this.getLocationParticipantImage(crm) : (JidUtil.isMyContactJid(crm.getJid()) ? this.getMyContactParticipantImage(crm) : this.getNomanParticipantImage(crm)));
            this.setIcon(image == null ? UIConstants.ICON_PERSON32 : new ImageIcon(image));
            this.setText(contactName);
        }
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        return this;
    }

    private Image getEmpParticipantImage(ChatRoomMember crm) {
        LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, crm.getJid());
        Image participantImage = ContactManager.getContactImage(contact, this.photoSize, false, true);
        return this.mix(crm, participantImage);
    }

    private Image getLocationParticipantImage(ChatRoomMember crm) {
        Image participantImage = UIConstants.ICON_PHONE_PUBLIC_PHONE32.getImage();
        return this.mix(crm, participantImage);
    }

    private Image getMyContactParticipantImage(ChatRoomMember crm) {
        long myContactId = JidUtil.trimExternalContactId(crm.getJid());
        LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, myContactId);
        Image participantImage = ContactManager.getExternalContactImage(myContact, 48, false, true);
        return this.mix(crm, participantImage);
    }

    private Image getNomanParticipantImage(ChatRoomMember crm) {
        Image participantImage = UIConstants.ICON_PERSON48.getImage();
        return this.mix(crm, participantImage);
    }

    private Image mix(ChatRoomMember crm, Image participantImage) {
        Image muteImage = null;
        if (crm.isAdmin()) {
            return GraphicUtil.getPresencedPersonalPhoto(48, 48, participantImage, null, true, Color.YELLOW, Color.ORANGE, muteImage);
        }
        return GraphicUtil.getPresencedPersonalPhoto(48, 48, participantImage, null, true, null, null, muteImage);
    }
}

