/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class RoundedCornerPanel
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int RADIAL = 2;
    public static final int DIAGONAL_LEFT = 3;
    public static final int DIAGONAL_RIGHT = 4;
    protected int arc = 12;
    private Color borderColor = Color.LIGHT_GRAY;
    private BasicStroke borderStroke;
    private int direction = 0;
    private boolean cyclic;
    private int maxLength;
    private Color fromColor;
    private Color toColor;

    public RoundedCornerPanel() {
        this(12, 1.0f, Color.LIGHT_GRAY);
    }

    public RoundedCornerPanel(int arc) {
        this(arc, 1.0f, Color.LIGHT_GRAY);
    }

    public RoundedCornerPanel(int arc, float borderThick) {
        this(arc, borderThick, Color.LIGHT_GRAY);
    }

    public RoundedCornerPanel(int arc, float borderThick, Color borderColor) {
        this.arc = arc;
        this.borderColor = borderColor;
        this.borderStroke = new BasicStroke(borderThick, 2, 0, 1.0f, null, 0.0f);
        this.setBorder(BorderFactory.createEmptyBorder((int)borderThick, (int)borderThick, (int)borderThick, (int)borderThick));
    }

    public RoundedCornerPanel(int arc, float borderThick, Color borderColor, int direction, Color fromColor, Color toColor) {
        this.arc = arc;
        this.borderColor = borderColor;
        this.borderStroke = new BasicStroke(borderThick, 2, 0, 1.0f, null, 0.0f);
        this.setBorder(BorderFactory.createEmptyBorder((int)borderThick, (int)borderThick, (int)borderThick, (int)borderThick));
        this.direction = direction;
        this.fromColor = fromColor;
        this.toColor = toColor;
        if (fromColor != null && toColor != null) {
            this.setOpaque(false);
        }
    }

    public Color getFromColor() {
        return this.fromColor;
    }

    public void setFromColor(Color fromColor) {
        this.fromColor = fromColor;
    }

    public Color getToColor() {
        return this.toColor;
    }

    public void setToColor(Color toColor) {
        this.toColor = toColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, this.arc, this.arc);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.fromColor == null || this.toColor == null) {
            if (this.isOpaque()) {
                g2d.setColor(this.getBackground());
                g2d.fill(rect);
            }
        } else {
            Paint paint = null;
            switch (this.direction) {
                case 0: {
                    paint = new GradientPaint(0.0f, height / 2, this.fromColor, width, height / 2, this.toColor, this.cyclic);
                    break;
                }
                case 1: {
                    paint = new GradientPaint(width / 2, 0.0f, this.fromColor, width / 2, this.maxLength > 0 ? (float)this.maxLength : (float)height, this.toColor, this.cyclic);
                    break;
                }
                case 2: {
                    paint = new RadialGradientPaint(new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0), (float)this.getWidth() / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{this.fromColor, this.toColor});
                    break;
                }
                case 3: {
                    paint = new GradientPaint(0.0f, 0.0f, this.fromColor, width, height, this.toColor, this.cyclic);
                    break;
                }
                case 4: {
                    paint = new GradientPaint(width, 0.0f, this.fromColor, 0.0f, height, this.toColor, this.cyclic);
                }
            }
            if (paint == null) {
                throw new RuntimeException("Invalid direction specified in GradientPanel");
            }
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            g2d.fill(rect);
            g2d.setPaint(oldPaint);
        }
        g2d.setColor(this.borderColor);
        g2d.setStroke(this.borderStroke);
        g2d.draw(rect);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }
}

