/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.util.TextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToastPanel
extends RoundedCornerPanel {
    private JLabel lblMessage;
    Timer hideTimer;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ToastPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ToastPanel() {
        super(20, 0.0f);
        this.initGUI();
        this.hideTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToastPanel.this.setVisible(false);
                    }
                });
            }
        });
        this.hideTimer.setRepeats(false);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setBackground(Color.DARK_GRAY);
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, "Center");
            this.lblMessage.setFont(UIConstants.FONT_16_PLAIN);
            this.lblMessage.setForeground(new Color(240, 240, 240));
            this.lblMessage.setBorder(BorderFactory.createEmptyBorder(6, 20, 6, 20));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showMessage(String message, int duration) {
        this.setBackground(Color.DARK_GRAY);
        this._showMessage(message, duration);
    }

    public void showErrorMessage(String message, int duration) {
        this.setBackground(Color.RED);
        this._showMessage(message, duration);
    }

    private void _showMessage(String message, int duration) {
        if (TextUtils.isBlank((CharSequence)message)) {
            return;
        }
        this.lblMessage.setText(message);
        Dimension preSize = this.getPreferredSize();
        int width = preSize.width;
        int height = preSize.height;
        int x = (this.getParent().getWidth() - width) / 2;
        int y = this.getParent().getHeight() - height - 20;
        this.setSize(preSize);
        this.setLocation(x, y);
        this.setVisible(true);
        this.hideTimer.setInitialDelay(duration);
        this.hideTimer.restart();
    }
}

