/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UCPopupWindow
extends JWindow {
    MouseGrabber mg = new MouseGrabber();
    Component invoker;

    public UCPopupWindow() {
        this.init();
    }

    public UCPopupWindow(Frame frame) {
        super(frame);
        this.init();
    }

    private void init() {
        this.setBackground(new Color(0, 0, 0, 0));
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(this.mg, 131120L);
        this.getOwner().addComponentListener(this.mg);
        this.getOwner().addWindowListener(this.mg);
    }

    public void show(Component invoker, int x, int y) {
        int displayY;
        this.invoker = invoker;
        Point clickP = invoker.getLocationOnScreen();
        Dimension windowSize = this.getPreferredSize();
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                virtualBounds = virtualBounds.union(gc[i].getBounds());
            }
        }
        int displayX = clickP.x + x;
        if (displayX < virtualBounds.x) {
            displayX = virtualBounds.x;
        }
        if (displayX + windowSize.width > virtualBounds.x + virtualBounds.width) {
            displayX = virtualBounds.x + virtualBounds.width - windowSize.width;
        }
        if ((displayY = clickP.y + y) < virtualBounds.y) {
            displayY = virtualBounds.y;
        }
        if (displayY + windowSize.height > virtualBounds.y + virtualBounds.height) {
            displayY = virtualBounds.y + virtualBounds.height - windowSize.height;
        }
        this.setSize(windowSize);
        this.setLocation(displayX, displayY);
        this.setVisible(true);
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)new JLabel("this is popup window"), "North");
                p.add((Component)new JTable(), "Center");
                p.add(new JComboBox<String>(new String[]{"Item One", "Item Two"}), "South");
                JFrame frame = new JFrame();
                final UCPopupWindow win = new UCPopupWindow(frame);
                win.setContentPane(p);
                win.setSize(400, 300);
                final JButton btn = new JButton("click");
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        win.setVisible(true);
                        win.setLocation(btn.getLocationOnScreen().x, btn.getLocationOnScreen().y + btn.getHeight());
                    }
                });
                frame.getContentPane().add(btn);
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    class MouseGrabber
    implements ChangeListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        MouseGrabber() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.hidePopupWindow();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.hidePopupWindow();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.hidePopupWindow();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.hidePopupWindow();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.hidePopupWindow();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (!(ev instanceof MouseEvent)) {
                return;
            }
            MouseEvent me = (MouseEvent)ev;
            Component src = me.getComponent();
            switch (me.getID()) {
                case 501: 
                case 506: 
                case 507: {
                    if (this.isInPopupWindow(src)) break;
                    this.hidePopupWindow();
                    return;
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }

        boolean isInPopupWindow(Component src) {
            for (Component c = src; c != null; c = c.getParent()) {
                if (c == UCPopupWindow.this) {
                    return true;
                }
                if (c instanceof JPopupMenu) {
                    return true;
                }
                if (c instanceof UCPopupWindow && c != UCPopupWindow.this) {
                    UCPopupWindow ucPopupWindow = (UCPopupWindow)c;
                    Component invoker = ucPopupWindow.getInvoker();
                    if (!SwingUtilities.isDescendingFrom(invoker, UCPopupWindow.this)) break;
                    return true;
                }
                if (c instanceof Window) break;
            }
            return false;
        }

        void hidePopupWindow() {
            UCPopupWindow.this.setVisible(false);
        }
    }
}

