/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contact;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamPanel;
import com.github.sarxos.webcam.WebcamPicker;
import com.github.sarxos.webcam.WebcamResolution;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class ChangePhotoDialog
extends GenericDialog
implements WebcamListener,
Thread.UncaughtExceptionHandler {
    public static final int MIN_CLIP_SIZE = 96;
    public static final String CARD_PHOTO = "photo";
    public static final String CARD_WEBCAM = "webcam";
    public static final String CARD_HINT_PHOTO = "hint_photo";
    public static final String CARD_HINT_WEBCAM = "hint_webcam";
    private JPanel panelContent;
    private JLabel lblTitle;
    private JLabel lblHint1;
    private JLabel lblHintPhoto;
    private JPanel panelFunction;
    private JButton btnAgain;
    private WebcamPicker webcamPicker;
    private JLabel lblChangeWebcam;
    private JPanel panelHintWebcam;
    private JPanel panelHint;
    CardLayout panelHintLayout = new CardLayout();
    private JPanel panelWebcam;
    private JPanel jPanel1;
    CardLayout jPanel1Layout = new CardLayout();
    private JButton btnConfirm;
    private JButton btnBrowse;
    private JButton btnTakePhoto;
    private PhotoPanel panelPhoto;
    private ClippedArea areaClip;
    private JLabel resizerSouthEast;
    private JLabel resizerSouthWest;
    private JLabel resizerNorthEast;
    private JLabel resizerNorthWest;
    BufferedImage mSourceImage;
    BufferedImage mClippedImage;
    Webcam webcam;
    WebcamPanel webcamPanel;
    Point clippedAreaLoc;
    Dimension clippedAreaSize;
    Point pressLoc;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ChangePhotoDialog inst = new ChangePhotoDialog(frame);
                inst.setVisible(true);
                System.exit(0);
            }
        });
    }

    public ChangePhotoDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.setClippedHelperVisible(false);
    }

    private void initGUI() {
        try {
            this.setTitle(String.format(I18NUtil.getString("setting_label_photo_config_title"), I18NUtil.getAppName()));
            this.setResizable(false);
            this.setSize(640, 480);
            this.setIconImages(UIConstants.APP_ICONS);
            this.setModal(true);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(20, 20, 20, 20), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("setting_label_edit_personal_photo"));
            this.lblTitle.setFont(UIConstants.FONT_20_BOLD);
            this.lblHint1 = new JLabel();
            this.panelContent.add((Component)this.lblHint1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(20, 20, 0, 0), 0, 0));
            this.lblHint1.setText("<html><body>" + I18NUtil.getString("setting_label_photo_or_camera") + "</body></html>");
            this.lblHint1.setFont(UIConstants.FONT_14_PLAIN);
            this.lblHint1.setVerticalAlignment(1);
            this.panelHint = new JPanel();
            this.panelHint.setLayout(this.panelHintLayout);
            this.panelContent.add((Component)this.panelHint, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 20, 0, 0), 0, 0));
            this.panelHint.setOpaque(false);
            this.lblHintPhoto = new JLabel();
            this.panelHint.add((Component)this.lblHintPhoto, CARD_HINT_PHOTO);
            this.lblHintPhoto.setText("<html><body>" + I18NUtil.getString("setting_label_area_drag") + "</body></html>");
            this.lblHintPhoto.setFont(UIConstants.FONT_14_PLAIN);
            this.lblHintPhoto.setVerticalAlignment(1);
            this.panelHintWebcam = new JPanel();
            BorderLayout panelHintWebcamLayout = new BorderLayout();
            panelHintWebcamLayout.setVgap(5);
            this.panelHintWebcam.setLayout(panelHintWebcamLayout);
            this.panelHint.add((Component)this.panelHintWebcam, CARD_HINT_WEBCAM);
            this.panelHintWebcam.setOpaque(false);
            this.lblChangeWebcam = new JLabel();
            this.panelHintWebcam.add((Component)this.lblChangeWebcam, "North");
            this.lblChangeWebcam.setText("<html><body>" + I18NUtil.getString("setting_label_select_other_camera") + "</body></html>");
            this.lblChangeWebcam.setFont(UIConstants.FONT_14_PLAIN);
            try {
                this.webcamPicker = new WebcamPicker();
                this.panelHintWebcam.add((Component)this.webcamPicker, "Center");
                this.webcamPicker.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            Webcam webcam = (Webcam)e.getItem();
                            ChangePhotoDialog.this.launchWebcam(webcam);
                        }
                    }
                });
            }
            catch (Throwable xx) {
                xx.printStackTrace();
            }
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(this.jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 11, 0, new Insets(20, 20, 0, 30), 0, 0));
            this.jPanel1.setBorder(new LineBorder(Color.DARK_GRAY, 1, false));
            this.jPanel1.setOpaque(false);
            this.panelPhoto = new PhotoPanel();
            this.jPanel1.add((Component)this.panelPhoto, CARD_PHOTO);
            this.panelPhoto.setBackground(Color.BLACK);
            this.panelPhoto.setPreferredSize(new Dimension(320, 240));
            this.panelPhoto.setMaximumSize(new Dimension(320, 240));
            this.panelPhoto.setMinimumSize(new Dimension(320, 240));
            this.panelPhoto.setLayout(null);
            this.resizerNorthWest = new JLabel();
            this.panelPhoto.add(this.resizerNorthWest);
            this.resizerNorthWest.setBackground(Color.LIGHT_GRAY);
            this.resizerNorthWest.setOpaque(true);
            this.resizerNorthWest.setCursor(new Cursor(6));
            this.resizerNorthWest.setBounds(150, 150, 8, 8);
            this.resizerNorthWest.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMouseDragged(evt);
                }
            });
            this.resizerNorthWest.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMousePressed(evt);
                }
            });
            this.resizerNorthEast = new JLabel();
            this.panelPhoto.add(this.resizerNorthEast);
            this.resizerNorthEast.setBackground(Color.LIGHT_GRAY);
            this.resizerNorthEast.setOpaque(true);
            this.resizerNorthEast.setBounds(180, 150, 8, 8);
            this.resizerNorthEast.setCursor(new Cursor(7));
            this.resizerNorthEast.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMouseDragged(evt);
                }
            });
            this.resizerNorthEast.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMousePressed(evt);
                }
            });
            this.resizerSouthWest = new JLabel();
            this.panelPhoto.add(this.resizerSouthWest);
            this.resizerSouthWest.setBackground(Color.LIGHT_GRAY);
            this.resizerSouthWest.setOpaque(true);
            this.resizerSouthWest.setBounds(150, 180, 8, 8);
            this.resizerSouthWest.setCursor(new Cursor(4));
            this.resizerSouthWest.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMouseDragged(evt);
                }
            });
            this.resizerSouthWest.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMousePressed(evt);
                }
            });
            this.resizerSouthEast = new JLabel();
            this.panelPhoto.add(this.resizerSouthEast);
            this.resizerSouthEast.setBackground(Color.LIGHT_GRAY);
            this.resizerSouthEast.setOpaque(true);
            this.resizerSouthEast.setBounds(180, 180, 8, 8);
            this.resizerSouthEast.setCursor(new Cursor(5));
            this.resizerSouthEast.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMouseDragged(evt);
                }
            });
            this.resizerSouthEast.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedResizerMousePressed(evt);
                }
            });
            this.areaClip = new ClippedArea();
            this.panelPhoto.add(this.areaClip);
            this.areaClip.setBounds(20, 20, 128, 128);
            this.areaClip.setCursor(new Cursor(13));
            this.areaClip.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedAreaMouseDragged(evt);
                }
            });
            this.areaClip.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedAreaMousePressed(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ChangePhotoDialog.this.clippedAreaMouseClickeded(evt);
                }
            });
            this.areaClip.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ChangePhotoDialog.this.changeResizerLocation();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    ChangePhotoDialog.this.changeResizerLocation();
                }
            });
            this.panelWebcam = new JPanel();
            BorderLayout panelWebcamLayout = new BorderLayout();
            this.panelWebcam.setLayout(panelWebcamLayout);
            this.jPanel1.add((Component)this.panelWebcam, CARD_WEBCAM);
            this.panelFunction = new JPanel();
            FlowLayout panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setHgap(10);
            panelFunctionLayout.setAlignment(0);
            this.panelFunction.setLayout(panelFunctionLayout);
            this.panelContent.add((Component)this.panelFunction, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
            this.panelFunction.setOpaque(false);
            this.btnBrowse = new JButton();
            this.panelFunction.add(this.btnBrowse);
            this.btnBrowse.setText(I18NUtil.getString("setting_label_photo_browse"));
            this.btnBrowse.setMargin(new Insets(2, 12, 2, 12));
            this.btnBrowse.setFocusPainted(false);
            this.btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangePhotoDialog.this.btnBrowseActionPerformed(evt);
                }
            });
            this.btnTakePhoto = new JButton();
            this.panelFunction.add(this.btnTakePhoto);
            this.btnTakePhoto.setText(I18NUtil.getString("setting_btn_photo_take"));
            this.btnTakePhoto.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/camera16.png")));
            this.btnTakePhoto.setMargin(new Insets(2, 12, 2, 12));
            this.btnTakePhoto.setFocusPainted(false);
            this.btnTakePhoto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangePhotoDialog.this.btnTakePhotoActionPerformed(evt);
                }
            });
            this.btnAgain = new JButton();
            this.panelFunction.add(this.btnAgain);
            this.btnAgain.setText(I18NUtil.getString("setting_btn_photo_reset"));
            this.btnAgain.setMargin(new Insets(2, 12, 2, 12));
            this.btnAgain.setFocusPainted(false);
            this.btnAgain.setVisible(false);
            this.btnAgain.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangePhotoDialog.this.btnAgainActionPerformed(evt);
                }
            });
            this.btnConfirm = new JButton();
            this.panelFunction.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_done"));
            this.btnConfirm.setMargin(new Insets(2, 12, 2, 12));
            this.btnConfirm.setFocusPainted(false);
            this.btnConfirm.setVisible(false);
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChangePhotoDialog.this.btnConfirmActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void noWebcam() {
        this.panelWebcam.removeAll();
        JLabel label = new JLabel(I18NUtil.getString("setting_notice_no_camera"));
        this.panelWebcam.add((Component)label, "Center");
    }

    private void stopWebcam() {
        if (this.webcam != null) {
            this.webcamPanel.stop();
            this.panelWebcam.removeAll();
            this.webcam.removeWebcamListener((WebcamListener)this);
            this.webcam.close();
            this.webcam = null;
            this.webcamPanel = null;
        }
    }

    private void launchWebcam(Webcam _webcam) {
        if (this.webcam == _webcam) {
            return;
        }
        this.stopWebcam();
        Log.d(ChangePhotoDialog.class.getSimpleName(), "selected " + _webcam.getName());
        this.webcam = _webcam;
        this.webcam.setViewSize(WebcamResolution.QVGA.getSize());
        this.webcam.addWebcamListener((WebcamListener)this);
        try {
            this.webcamPanel = new WebcamPanel(this.webcam, false);
            this.panelWebcam.add((Component)this.webcamPanel, "Center");
            this.panelWebcam.revalidate();
            this.panelWebcam.repaint();
            Thread t = new Thread(){

                @Override
                public void run() {
                    ChangePhotoDialog.this.webcamPanel.start();
                }
            };
            t.setName("UC-webcam_starter");
            t.setDaemon(true);
            t.setUncaughtExceptionHandler(this);
            t.start();
        }
        catch (Exception e) {
            JLabel label = new JLabel(I18NUtil.getString("setting_notice_camera_locked"));
            this.panelWebcam.add((Component)label, "Center");
        }
    }

    private void btnTakePhotoActionPerformed(ActionEvent evt) {
        BufferedImage originalBI = this.webcam.getImage();
        this.changeSourceImage(originalBI);
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser fc = new FileChooser();
                UCUploadFileChooser.setInitialOpenDir(fc);
                fc.getExtensionFilters().clear();
                fc.getExtensionFilters().addAll(UCUploadFileChooser.getExtensionFilter(I18NUtil.getString("chat_msg_type_image"), UCUploadFileChooser.IMAGE_TYPES, null, null));
                final File selectedFile = fc.showOpenDialog(null);
                if (selectedFile != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BufferedImage originalBI = FileUtil.readFileHandleExif(selectedFile);
                            ChangePhotoDialog.this.changeSourceImage(originalBI);
                            PreferencesUtil.setChatLastOpenDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    private void changeSourceImage(BufferedImage originalBI) {
        this.mSourceImage = GraphicUtil.createScaledCenterImage(originalBI, this.panelPhoto.getWidth(), this.panelPhoto.getHeight());
        this.panelPhoto.repaint();
        this.btnTakePhoto.setVisible(false);
        this.btnBrowse.setVisible(false);
        this.btnAgain.setVisible(true);
        this.btnConfirm.setVisible(true);
        this.toPhotoMode();
        this.setClippedHelperVisible(true);
    }

    private void clippedAreaMousePressed(MouseEvent evt) {
        this.clippedAreaLoc = this.areaClip.getLocation();
        this.pressLoc = evt.getLocationOnScreen();
    }

    private void clippedAreaMouseClickeded(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int value = Math.max(this.areaClip.getWidth(), this.areaClip.getHeight());
            this.areaClip.setSize(value, value);
        }
    }

    private void clippedAreaMouseDragged(MouseEvent evt) {
        if (evt.getComponent() == this.areaClip) {
            this.moveClippedArea(evt);
        }
    }

    private void clippedResizerMousePressed(MouseEvent evt) {
        this.clippedAreaLoc = this.areaClip.getLocation();
        this.clippedAreaSize = this.areaClip.getSize();
        this.pressLoc = evt.getLocationOnScreen();
    }

    private void clippedResizerMouseDragged(MouseEvent evt) {
        if (evt.getComponent() == this.resizerNorthWest) {
            this.resizeNorthWest(evt);
        } else if (evt.getComponent() == this.resizerNorthEast) {
            this.resizeNorthEast(evt);
        } else if (evt.getComponent() == this.resizerSouthWest) {
            this.resizeSouthWest(evt);
        } else if (evt.getComponent() == this.resizerSouthEast) {
            this.resizeSouthEast(evt);
        }
    }

    private void moveClippedArea(MouseEvent evt) {
        Point dragLoc = evt.getLocationOnScreen();
        int diffX = dragLoc.x - this.pressLoc.x;
        int diffY = dragLoc.y - this.pressLoc.y;
        Point newLoc = new Point(this.clippedAreaLoc.x + diffX, this.clippedAreaLoc.y + diffY);
        if (newLoc.x < 0) {
            newLoc.x = 0;
        } else if (newLoc.x + this.areaClip.getWidth() > this.areaClip.getParent().getWidth()) {
            newLoc.x = this.areaClip.getParent().getWidth() - this.areaClip.getWidth();
        }
        if (newLoc.y < 0) {
            newLoc.y = 0;
        } else if (newLoc.y + this.areaClip.getHeight() > this.areaClip.getParent().getHeight()) {
            newLoc.y = this.areaClip.getParent().getHeight() - this.areaClip.getHeight();
        }
        this.areaClip.setLocation(newLoc);
    }

    private void resizeNorthWest(MouseEvent evt) {
        Point dragLoc = evt.getLocationOnScreen();
        int diffX = dragLoc.x - this.pressLoc.x;
        int diffY = dragLoc.y - this.pressLoc.y;
        if (this.clippedAreaSize.width - diffX < 96) {
            diffX = this.clippedAreaSize.width - 96;
        } else if (this.clippedAreaLoc.x + diffX < 0) {
            diffX = -this.clippedAreaLoc.x;
        }
        if (this.clippedAreaSize.height - diffY < 96) {
            diffY = this.clippedAreaSize.height - 96;
        } else if (this.clippedAreaLoc.y + diffY < 0) {
            diffY = -this.clippedAreaLoc.y;
        }
        if (diffX == 0 && diffY == 0) {
            return;
        }
        Rectangle newBound = new Rectangle(this.clippedAreaLoc.x + diffX, this.clippedAreaLoc.y + diffY, this.clippedAreaSize.width - diffX, this.clippedAreaSize.height - diffY);
        this.areaClip.setBounds(newBound);
    }

    private void resizeNorthEast(MouseEvent evt) {
        Point dragLoc = evt.getLocationOnScreen();
        int diffX = dragLoc.x - this.pressLoc.x;
        int diffY = dragLoc.y - this.pressLoc.y;
        if (this.clippedAreaSize.width + diffX < 96) {
            diffX = 96 - this.clippedAreaSize.width;
        } else if (this.clippedAreaLoc.x + this.clippedAreaSize.width + diffX > this.panelPhoto.getWidth()) {
            diffX = this.panelPhoto.getWidth() - this.clippedAreaLoc.x - this.clippedAreaSize.width;
        }
        if (this.clippedAreaSize.height - diffY < 96) {
            diffY = this.clippedAreaSize.height - 96;
        } else if (this.clippedAreaLoc.y + diffY < 0) {
            diffY = -this.clippedAreaLoc.y;
        }
        if (diffX == 0 && diffY == 0) {
            return;
        }
        Rectangle newBound = new Rectangle(this.clippedAreaLoc.x, this.clippedAreaLoc.y + diffY, this.clippedAreaSize.width + diffX, this.clippedAreaSize.height - diffY);
        this.areaClip.setBounds(newBound);
    }

    private void resizeSouthWest(MouseEvent evt) {
        Point dragLoc = evt.getLocationOnScreen();
        int diffX = dragLoc.x - this.pressLoc.x;
        int diffY = dragLoc.y - this.pressLoc.y;
        if (this.clippedAreaSize.width - diffX < 96) {
            diffX = this.clippedAreaSize.width - 96;
        } else if (this.clippedAreaLoc.x + diffX < 0) {
            diffX = -this.clippedAreaLoc.x;
        }
        if (this.clippedAreaSize.height + diffY < 96) {
            diffY = 96 - this.clippedAreaSize.height;
        } else if (this.clippedAreaLoc.y + this.clippedAreaSize.height + diffY > this.panelPhoto.getHeight()) {
            diffY = this.panelPhoto.getHeight() - this.clippedAreaLoc.y - this.clippedAreaSize.height;
        }
        if (diffX == 0 && diffY == 0) {
            return;
        }
        Rectangle newBound = new Rectangle(this.clippedAreaLoc.x + diffX, this.clippedAreaLoc.y, this.clippedAreaSize.width - diffX, this.clippedAreaSize.height + diffY);
        this.areaClip.setBounds(newBound);
    }

    private void resizeSouthEast(MouseEvent evt) {
        Point dragLoc = evt.getLocationOnScreen();
        int diffX = dragLoc.x - this.pressLoc.x;
        int diffY = dragLoc.y - this.pressLoc.y;
        if (this.clippedAreaSize.width + diffX < 96) {
            diffX = 96 - this.clippedAreaSize.width;
        } else if (this.clippedAreaLoc.x + this.clippedAreaSize.width + diffX > this.panelPhoto.getWidth()) {
            diffX = this.panelPhoto.getWidth() - this.clippedAreaLoc.x - this.clippedAreaSize.width;
        }
        if (this.clippedAreaSize.height + diffY < 96) {
            diffY = 96 - this.clippedAreaSize.height;
        } else if (this.clippedAreaLoc.y + this.clippedAreaSize.height + diffY > this.panelPhoto.getHeight()) {
            diffY = this.panelPhoto.getHeight() - this.clippedAreaLoc.y - this.clippedAreaSize.height;
        }
        if (diffX == 0 && diffY == 0) {
            return;
        }
        Dimension newSize = new Dimension(this.clippedAreaSize.width + diffX, this.clippedAreaSize.height + diffY);
        this.areaClip.setSize(newSize);
    }

    private void changeResizerLocation() {
        Point loc = this.areaClip.getLocation();
        Dimension size = this.areaClip.getSize();
        this.resizerNorthWest.setLocation(loc.x - 4, loc.y - 4);
        this.resizerNorthEast.setLocation(loc.x + size.width - 4, loc.y - 4);
        this.resizerSouthWest.setLocation(loc.x - 4, loc.y + size.height - 4);
        this.resizerSouthEast.setLocation(loc.x + size.width - 4, loc.y + size.height - 4);
    }

    private void setClippedHelperVisible(boolean b) {
        this.areaClip.setVisible(b);
        this.resizerNorthWest.setVisible(b);
        this.resizerNorthEast.setVisible(b);
        this.resizerSouthWest.setVisible(b);
        this.resizerSouthEast.setVisible(b);
        int x = (this.panelPhoto.getWidth() - this.areaClip.getWidth()) / 2;
        int y = (this.panelPhoto.getHeight() - this.areaClip.getHeight()) / 2;
        this.areaClip.setLocation(x, y);
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.produceClippedImage();
        this.setVisible(false);
    }

    private void btnAgainActionPerformed(ActionEvent evt) {
        this.resetUI();
    }

    private void resetUI() {
        this.toWebcamMode();
        this.mClippedImage = null;
        this.mSourceImage = null;
        this.panelPhoto.repaint();
        this.btnBrowse.setVisible(true);
        this.btnTakePhoto.setVisible(true);
        this.btnAgain.setVisible(false);
        this.btnConfirm.setVisible(false);
        this.areaClip.setBounds(20, 20, 192, 192);
        this.setClippedHelperVisible(false);
    }

    private void produceClippedImage() {
        Point location = this.areaClip.getLocation();
        Dimension size = this.areaClip.getSize();
        this.mClippedImage = new BufferedImage(size.width, size.height, 2);
        this.mClippedImage.getGraphics().drawImage(this.mSourceImage, 0, 0, size.width, size.height, location.x, location.y, location.x + size.width, location.y + size.height, null);
    }

    public BufferedImage getClippedPhoto() {
        return this.mClippedImage;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.resetUI();
        } else {
            this.stopWebcam();
        }
        super.setVisible(b);
    }

    private void toPhotoMode() {
        this.panelHintLayout.show(this.panelHint, CARD_HINT_PHOTO);
        this.jPanel1Layout.show(this.jPanel1, CARD_PHOTO);
        this.btnTakePhoto.setEnabled(false);
        this.panelHint.revalidate();
        this.panelHint.repaint();
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    private void toWebcamMode() {
        try {
            Webcam webcam = Webcam.getDefault();
            if (webcam == null) {
                this.panelHintLayout.show(this.panelHint, CARD_HINT_PHOTO);
                this.jPanel1Layout.show(this.jPanel1, CARD_PHOTO);
                this.btnTakePhoto.setEnabled(false);
                this.noWebcam();
            } else {
                this.panelHintLayout.show(this.panelHint, CARD_HINT_WEBCAM);
                this.jPanel1Layout.show(this.jPanel1, CARD_WEBCAM);
                this.btnTakePhoto.setEnabled(true);
                this.panelHintWebcam.setVisible(Webcam.getWebcams().size() > 1);
                this.webcamPicker.setSelectedIndex(0);
                this.launchWebcam(webcam);
            }
        }
        catch (Throwable t) {
            this.panelHintLayout.show(this.panelHint, CARD_HINT_PHOTO);
            this.jPanel1Layout.show(this.jPanel1, CARD_PHOTO);
            this.btnTakePhoto.setEnabled(false);
            this.noWebcam();
        }
        this.panelHint.revalidate();
        this.panelHint.repaint();
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Log.e(ChangePhotoDialog.class.getSimpleName(), "uncaughtException", e);
    }

    public void webcamOpen(WebcamEvent arg0) {
        Log.i(ChangePhotoDialog.class.getSimpleName(), "webcamOpen:" + arg0.getSource().getName());
    }

    public void webcamClosed(WebcamEvent arg0) {
        Log.i(ChangePhotoDialog.class.getSimpleName(), "webcamClosed:" + arg0.getSource().getName());
    }

    public void webcamDisposed(WebcamEvent arg0) {
        Log.i(ChangePhotoDialog.class.getSimpleName(), "webcamDisposed:" + arg0.getSource().getName());
    }

    public void webcamImageObtained(WebcamEvent arg0) {
    }

    class PhotoPanel
    extends JPanel {
        PhotoPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ChangePhotoDialog.this.mSourceImage != null) {
                Graphics2D g2d = (Graphics2D)g;
                Composite com = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
                g2d.drawImage((Image)ChangePhotoDialog.this.mSourceImage, 0, 0, null);
                g2d.setComposite(com);
            }
        }
    }

    class ClippedArea
    extends JPanel {
        ClippedArea() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ChangePhotoDialog.this.mSourceImage != null) {
                Graphics2D g2d = (Graphics2D)g;
                Point location = this.getLocation();
                Dimension size = this.getSize();
                g2d.drawImage(ChangePhotoDialog.this.mSourceImage, 0, 0, size.width, size.height, location.x, location.y, location.x + size.width, location.y + size.height, null);
            }
        }
    }
}

