/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contact;

import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.bean.web.LiteTeleNumberType;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.contact.EditPhoneResult;
import com.blisscloud.ezuc.client.contact.Phone;
import com.blisscloud.ezuc.client.contact.PhoneTableModel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditPhoneDialog
extends GenericDialog {
    private JPanel panelContent;
    private JScrollPane spPhone;
    private JPanel panelToolbar;
    private JButton btnAdd;
    private JTable tablePhone;
    private JPanel jPanel1;
    private JPanel jPanel20;
    private JButton btnConfirm;
    private JButton btnCancel;
    PhoneTableModel tableModelPhone = new PhoneTableModel();
    boolean mOK;
    LiteTeleNumberType mType;
    List<Phone> mPhoneList = new ArrayList<Phone>();

    public EditPhoneDialog(JDialog dialog) {
        super(dialog);
        this.initGUI();
        this.tableModelPhone.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                EditPhoneDialog.this.btnAdd.setVisible(EditPhoneDialog.this.tableModelPhone.getRowCount() < 3);
            }
        });
    }

    public EditPhoneDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.tableModelPhone.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                EditPhoneDialog.this.btnAdd.setVisible(EditPhoneDialog.this.tableModelPhone.getRowCount() < 3);
            }
        });
    }

    private void initGUI() {
        try {
            this.setModal(true);
            this.setLocationRelativeTo(this.getParent());
            this.panelContent = new JPanel();
            BorderLayout panelContentLayout = new BorderLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.panelToolbar = new JPanel();
            FlowLayout panelToolbarLayout = new FlowLayout();
            panelToolbarLayout.setAlignment(0);
            this.panelToolbar.setLayout(panelToolbarLayout);
            this.panelContent.add((Component)this.panelToolbar, "North");
            this.btnAdd = new JButton();
            this.panelToolbar.add(this.btnAdd);
            this.btnAdd.setText(I18NUtil.getString("common_btn_add"));
            this.btnAdd.setFocusable(false);
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditPhoneDialog.this.btnAddActionPerformed(evt);
                }
            });
            this.spPhone = new JScrollPane();
            this.panelContent.add((Component)this.spPhone, "Center");
            this.tablePhone = new JTable();
            this.spPhone.setViewportView(this.tablePhone);
            this.tablePhone.setRowHeight(28);
            this.tablePhone.setModel(this.tableModelPhone);
            this.tablePhone.setSelectionMode(0);
            this.jPanel20 = new JPanel();
            this.jPanel20.setLayout(new BorderLayout());
            this.jPanel20.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelContent.add((Component)this.jPanel20, "South");
            this.jPanel1 = new JPanel();
            this.jPanel20.add((Component)this.jPanel1, "Center");
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditPhoneDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditPhoneDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(400, 300);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.tablePhone.isEditing()) {
            this.tablePhone.getCellEditor().stopCellEditing();
        }
        this.closeDialog(true);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.tablePhone.isEditing()) {
            this.tablePhone.getCellEditor().cancelCellEditing();
        }
        this.closeDialog(false);
    }

    @Override
    protected void onESCPressed() {
        if (this.tablePhone.isEditing()) {
            this.tablePhone.getCellEditor().cancelCellEditing();
        }
        this.closeDialog(false);
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        Phone newPhone = new Phone();
        this.tableModelPhone.addPhone(newPhone);
    }

    private void closeDialog(boolean isOK) {
        if (isOK) {
            List<Phone> phone = this.tableModelPhone.getPhones();
            for (int i = 0; phone != null && i < phone.size(); ++i) {
                Phone p = phone.get(i);
                if (this.validateValue(p.getNumber())) continue;
                return;
            }
        }
        this.mPhoneList.clear();
        this.mPhoneList.addAll(this.tableModelPhone.getPhones());
        this.mOK = isOK;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.tableModelPhone.clear();
        }
        super.setVisible(b);
    }

    public EditPhoneResult showDialog(LiteTeleNumberType type, List<LiteTeleNumber> numberList) {
        this.mOK = false;
        this.mType = type;
        this.mPhoneList.clear();
        if (type == LiteTeleNumberType.HOME) {
            this.setTitle(I18NUtil.getString("abook_label_edit_home_phone"));
        } else if (type == LiteTeleNumberType.MOBILE) {
            this.setTitle(I18NUtil.getString("abook_label_edit_mobile_phone"));
        } else if (type == LiteTeleNumberType.OFFICE) {
            this.setTitle(I18NUtil.getString("abook_label_edit_office_phone"));
        }
        TableColumn colDelete = this.tablePhone.getColumnModel().getColumn(1);
        colDelete.setPreferredWidth(30);
        colDelete.setMaxWidth(30);
        colDelete.setMinWidth(30);
        colDelete.setResizable(false);
        colDelete.setCellRenderer(new DeleteCellRenderer(this));
        colDelete.setCellEditor(new DeleteCellEditor());
        if (numberList == null) {
            this.tableModelPhone.clear();
        } else {
            ArrayList<Phone> phoneList = new ArrayList<Phone>();
            for (LiteTeleNumber number : numberList) {
                String teleNumber = number.getNumber();
                phoneList.add(new Phone(teleNumber));
            }
            this.tableModelPhone.setPhones(phoneList);
        }
        this.setVisible(true);
        if (this.mOK) {
            ArrayList<LiteTeleNumber> numbers = new ArrayList<LiteTeleNumber>();
            for (Phone phone : this.mPhoneList) {
                if (!TextUtils.isNotBlank((CharSequence)phone.getNumber())) continue;
                LiteTeleNumber number = new LiteTeleNumber();
                number.setType(type);
                number.setNumber(phone.getNumber().trim());
                numbers.add(number);
            }
            EditPhoneResult res = new EditPhoneResult();
            res.setNumbers(numbers);
            return res;
        }
        return null;
    }

    private boolean validateValue(String phoneNum) {
        Pattern pattern;
        Matcher matcher;
        if (!TextUtils.isBlank((CharSequence)phoneNum) && !(matcher = (pattern = Pattern.compile("^[+][0-9][0-9,]{1,28}$|^[0-9][0-9,]{2,29}$")).matcher(phoneNum.trim())).matches()) {
            String msg = "<html><p style=\"text-align:left;padding:10px 20px;\">" + I18NUtil.getString("abook_validation_phone_format_incorrect") + "</p></html>";
            JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_title_error"), 0);
            return false;
        }
        return true;
    }

    class DeleteCellRenderer
    implements TableCellRenderer {
        JPanel panel = new JPanel();
        JButton btnDelete = new JButton();

        public DeleteCellRenderer(EditPhoneDialog this$0) {
            this.btnDelete.setPreferredSize(new Dimension(22, 22));
            this.btnDelete.setIcon(new ImageIcon(DeleteCellEditor.class.getClassLoader().getResource("images/cancel16.png")));
            this.panel.setLayout(new FlowLayout(0, 2, 2));
            this.panel.add(this.btnDelete);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.panel;
        }
    }

    class DeleteCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JPanel panel = new JPanel();
        JButton btnDelete = new JButton();

        public DeleteCellEditor() {
            this.btnDelete.setPreferredSize(new Dimension(22, 22));
            this.btnDelete.setIcon(new ImageIcon(DeleteCellEditor.class.getClassLoader().getResource("images/cancel16.png")));
            this.btnDelete.addActionListener(this);
            this.panel.setLayout(new FlowLayout(0, 2, 2));
            this.panel.add(this.btnDelete);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point locationOfTable = SwingUtilities.convertPoint(this.btnDelete, new Point(1, 1), EditPhoneDialog.this.tablePhone);
            int row = EditPhoneDialog.this.tablePhone.rowAtPoint(locationOfTable);
            EditPhoneDialog.this.tableModelPhone.removePhone(row);
        }
    }
}

