/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contact;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteGenderType;
import com.blisscloud.ezuc.bean.web.LiteBirthdayHideType;
import com.blisscloud.ezuc.bean.web.LiteDepartment;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.bean.web.LiteTeleNumberType;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bean.ExtenNode;
import com.blisscloud.ezuc.client.bean.Node;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.contact.ChangePhotoDialog;
import com.blisscloud.ezuc.client.contact.EditPhoneDialog;
import com.blisscloud.ezuc.client.contact.EditPhoneResult;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.LiteContactHelper;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.AuthOption;
import com.blisscloud.mobile.ezuc.bean.Device;
import com.blisscloud.mobile.ezuc.bean.LoginDeviceItem;
import com.blisscloud.mobile.ezuc.db.UCDBDept;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DeviceManager;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.EmpExtendedSysPhoneConfig;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

public class PersonalInfoDialog
extends GenericDialog
implements PropertyChangeListener {
    private JPanel panelContent;
    private PersonalPhoto lblHeadIcon;
    private JLabel lblContactName;
    private JLabel lblDepartmentHeader;
    private JLabel lblDepartment;
    private JLabel lblExtensionHeader;
    private JLabel lblExtension;
    private JLabel lblMobilePhoneHeader;
    private JLabel lblMobilePhone;
    private JLabel lblHomePhoneHeader;
    private JLabel lblHomePhone;
    private JLabel lblBirthdayHeader;
    private JLabel lblBirthday;
    private JLabel lblBirthdayHideType;
    private JLabel lblEmailHeader;
    private JLabel lblEmail;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JLabel lblPadding;
    private JPanel jPanel1;
    private JButton btnSavePersonalData;
    private JButton btnSaveClosePersonalData;
    private JButton btnCancelPersonalData;
    private JPanel panelLoginedDevices;
    private JLabel lblAccount;
    private JPasswordField txtConfirmPassword;
    private JPasswordField txtNewPassword;
    private JButton btnChangePassword;
    private JLabel lblConfirmPassword;
    private JLabel lblNewPassword;
    private JLabel lblChangePassword;
    private JLabel lblAccountHeader;
    private JPanel panelLoginDevice;
    private JPanel panelMyAccount;
    private JPanel panelPersonalData;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jScrollPane1;
    private JPanel panelHead;
    LiteContact mUserContact;
    EditPhoneDialog epd;
    ChangePhotoDialog cpd;
    List<LiteTeleNumber> mMobileNumbers;
    boolean mMobileNumbersChanged = false;
    List<LiteTeleNumber> mHomeNumbers;
    boolean mHomeNumbersChanged = false;
    LiteGenderType mGenderType;
    LiteBirthdayHideType mBirthdayHideType;
    Long mBirthday;
    BufferedImage mPhotoImage;
    boolean mPhotoImageChanged;
    boolean mShowSite;
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    private boolean mIsOn = false;
    final int Extra_Extension_Init_GridY = 3;
    int extensionCount = 0;
    int currentExtraExtensionGridY = 3;
    List<Component> extraExtensionComps = new ArrayList<Component>();
    protected JPopupMenu popupBirthdayHide;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected boolean isInitialized;
    protected boolean dateSelected;
    protected Date lastSelectedDate;
    private ChangeListener changeListener;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PersonalInfoDialog inst = new PersonalInfoDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public PersonalInfoDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initReceiver();
    }

    public void display() {
        this.setVisible(true);
    }

    public void displayLoginList() {
        this.jTabbedPane1.setSelectedIndex(2);
        this.cleanMultiLoginAlert();
        this.setVisible(true);
    }

    public void displayPassword() {
        this.jTabbedPane1.setSelectedIndex(1);
        this.setVisible(true);
    }

    private void cleanMultiLoginAlert() {
        PreferencesUtil.setMultiLoginAlertFlag(false);
        BroadcastUtil.sendMultiLoginDeviceFlashEvent(UCChatClient.context, 0);
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("setting_label_personal_info"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.jTabbedPane1 = new JTabbedPane();
            this.getContentPane().add((Component)this.jTabbedPane1, "Center");
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                    int index = sourceTabbedPane.getSelectedIndex();
                    if (index == 2) {
                        PersonalInfoDialog.this.cleanMultiLoginAlert();
                    }
                }
            };
            this.jTabbedPane1.addChangeListener(changeListener);
            this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelPersonalData = new JPanel();
            BorderLayout panelPersonalDataLayout = new BorderLayout();
            panelPersonalDataLayout.setVgap(10);
            this.panelPersonalData.setLayout(panelPersonalDataLayout);
            this.jTabbedPane1.addTab(I18NUtil.getString("setting_label_personal_info"), null, this.panelPersonalData, null);
            this.panelPersonalData.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelHead = new JPanel();
            this.panelPersonalData.add((Component)this.panelHead, "North");
            BorderLayout panelHeadLayout = new BorderLayout();
            panelHeadLayout.setHgap(10);
            this.panelHead.setLayout(panelHeadLayout);
            boolean hasEditPermission = PreferencesUtil.hasPhotoEditPermission(UCChatClient.context);
            this.lblHeadIcon = hasEditPermission ? new PersonalPhoto(true) : new PersonalPhoto();
            this.panelHead.add((Component)this.lblHeadIcon, "West");
            this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
            if (PreferencesUtil.hasPhotoEditPermission(UCChatClient.context)) {
                this.lblHeadIcon.setToolTipText(I18NUtil.getString("abook_btn_edit_photo"));
            } else {
                this.lblHeadIcon.setToolTipText(I18NUtil.getString("setting_no_photo_edit_permission"));
            }
            this.lblHeadIcon.setPreferredSize(new Dimension(64, 64));
            this.lblHeadIcon.setMinimumSize(new Dimension(64, 64));
            this.lblHeadIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (PreferencesUtil.hasPhotoEditPermission(UCChatClient.context)) {
                        PersonalInfoDialog.this.lblHeadIconMouseClicked(evt);
                    }
                }
            });
            this.lblContactName = new JLabel();
            this.panelHead.add((Component)this.lblContactName, "Center");
            this.lblContactName.setFont(UIConstants.FONT_14_BOLD);
            this.lblContactName.setHorizontalTextPosition(2);
            this.lblContactName.setToolTipText(I18NUtil.getString("abook_btn_modify_gender"));
            this.lblContactName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PersonalInfoDialog.this.lblContactNameMouseClicked(evt);
                }
            });
            this.jScrollPane1 = new UCScrollPane(10);
            this.panelPersonalData.add((Component)this.jScrollPane1, "Center");
            this.panelContent = new JPanel();
            this.jScrollPane1.setViewportView(this.panelContent);
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.jPanel1 = new RoundedCornerPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setBackground(Color.WHITE);
            this.lblDepartmentHeader = new JLabel();
            this.jPanel1.add((Component)this.lblDepartmentHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblDepartmentHeader.setText(I18NUtil.getString("abook_department"));
            this.lblDepartmentHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblDepartment = new JLabel();
            this.jPanel1.add((Component)this.lblDepartment, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblDepartment.setFont(UIConstants.FONT_12_PLAIN);
            this.jSeparator1 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(Color.LIGHT_GRAY);
            this.jSeparator1.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblExtensionHeader = new JLabel();
            this.jPanel1.add((Component)this.lblExtensionHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblExtensionHeader.setText(I18NUtil.getString("abook_extension"));
            this.lblExtensionHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblExtension = new JLabel();
            this.jPanel1.add((Component)this.lblExtension, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblExtension.setFont(UIConstants.FONT_12_PLAIN);
            this.jPanel2 = new RoundedCornerPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.panelContent.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setBackground(Color.WHITE);
            this.lblMobilePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblMobilePhoneHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblMobilePhoneHeader.setText(I18NUtil.getString("abook_mobile"));
            this.lblMobilePhoneHeader.setIcon(UIConstants.ICON_MOBILEPHONE);
            this.lblMobilePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblMobilePhone = new JLabel(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel2.add((Component)this.lblMobilePhone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblMobilePhone.setCursor(UIConstants.CURSOR_HAND);
            this.lblMobilePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblMobilePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PersonalInfoDialog.this.lblMobilePhoneMouseClicked(evt);
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator4, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator4.setForeground(Color.LIGHT_GRAY);
            this.jSeparator4.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblHomePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblHomePhoneHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblHomePhoneHeader.setText(I18NUtil.getString("abook_home"));
            this.lblHomePhoneHeader.setIcon(UIConstants.ICON_HOME);
            this.lblHomePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblHomePhone = new JLabel(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel2.add((Component)this.lblHomePhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblHomePhone.setCursor(UIConstants.CURSOR_HAND);
            this.lblHomePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblHomePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PersonalInfoDialog.this.lblHomePhoneMouseClicked(evt);
                }
            });
            this.jSeparator5 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator5, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator5.setForeground(Color.LIGHT_GRAY);
            this.jSeparator5.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblBirthdayHeader = new JLabel();
            this.jPanel2.add((Component)this.lblBirthdayHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblBirthdayHeader.setText(I18NUtil.getString("abook_birthday"));
            this.lblBirthdayHeader.setIcon(UIConstants.ICON_BIRTHDAY);
            this.lblBirthdayHeader.setFont(UIConstants.FONT_12_BOLD);
            this.jPanel4 = new JPanel();
            BorderLayout jPanel4Layout = new BorderLayout();
            jPanel4Layout.setHgap(10);
            this.jPanel4.setLayout(jPanel4Layout);
            this.jPanel2.add((Component)this.jPanel4, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.jPanel4.setOpaque(false);
            this.lblBirthday = new JLabel(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel4.add((Component)this.lblBirthday, "West");
            this.lblBirthday.setCursor(UIConstants.CURSOR_HAND);
            this.lblBirthday.setFont(UIConstants.FONT_12_PLAIN);
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PersonalInfoDialog.this.lblBirthdayMouseClicked(evt);
                }
            });
            this.lblBirthdayHideType = new JLabel();
            this.jPanel4.add((Component)this.lblBirthdayHideType, "Center");
            this.lblBirthdayHideType.setText(I18NUtil.getString("setting_label_privacy"));
            this.lblBirthdayHideType.setCursor(UIConstants.CURSOR_HAND);
            this.lblBirthdayHideType.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PersonalInfoDialog.this.lblBirthdayHideTypeMouseClicked(evt);
                }
            });
            this.jSeparator6 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator6, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator6.setForeground(Color.LIGHT_GRAY);
            this.jSeparator6.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblEmailHeader = new JLabel();
            this.jPanel2.add((Component)this.lblEmailHeader, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblEmailHeader.setText(I18NUtil.getString("abook_email"));
            this.lblEmailHeader.setIcon(UIConstants.ICON_MAIL);
            this.lblEmailHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblEmail = new JLabel(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel2.add((Component)this.lblEmail, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblEmail.setFont(UIConstants.FONT_12_PLAIN);
            this.lblEmail.setForeground(HintTextField.HINT_COLOR);
            this.lblPadding = new JLabel();
            this.panelContent.add((Component)this.lblPadding, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel3 = new JPanel();
            this.panelPersonalData.add((Component)this.jPanel3, "South");
            FlowLayout jPanel3Layout = new FlowLayout();
            jPanel3Layout.setAlignment(1);
            this.jPanel3.setLayout(jPanel3Layout);
            this.jPanel3.setOpaque(false);
            this.btnSavePersonalData = new JButton();
            this.jPanel3.add(this.btnSavePersonalData);
            this.btnSavePersonalData.setText(I18NUtil.getString("common_btn_apply"));
            this.btnSavePersonalData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PersonalInfoDialog.this.btnSavePersonalDataActionPerformed(evt, false);
                }
            });
            this.btnSaveClosePersonalData = new JButton();
            this.jPanel3.add(this.btnSaveClosePersonalData);
            this.btnSaveClosePersonalData.setText(I18NUtil.getString("common_btn_apply_close"));
            this.btnSaveClosePersonalData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PersonalInfoDialog.this.btnSavePersonalDataActionPerformed(evt, true);
                }
            });
            this.btnCancelPersonalData = new JButton();
            this.jPanel3.add(this.btnCancelPersonalData);
            this.btnCancelPersonalData.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancelPersonalData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PersonalInfoDialog.this.setVisible(false);
                }
            });
            this.panelMyAccount = new JPanel();
            GridBagLayout panelMyAccountLayout = new GridBagLayout();
            this.jTabbedPane1.addTab(I18NUtil.getString("fun_title_myaccount_setting"), null, this.panelMyAccount, null);
            this.panelMyAccount.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelMyAccount.setLayout(panelMyAccountLayout);
            int y = 0;
            AuthOption authOption = PreferencesUtil.getAuthOption(UCChatClient.context);
            boolean enableUCAuth = authOption != AuthOption.AD_ONLY;
            this.lblAccountHeader = new JLabel();
            this.panelMyAccount.add((Component)this.lblAccountHeader, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.lblAccountHeader.setText(I18NUtil.getString("login_label_account_s"));
            this.lblAccount = new JLabel();
            this.panelMyAccount.add((Component)this.lblAccount, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(20, 20, 0, 0), 0, 0));
            this.lblAccount.setText(PreferencesUtil.getLoginID(UCChatClient.context));
            this.lblChangePassword = new JLabel();
            this.panelMyAccount.add((Component)this.lblChangePassword, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.lblChangePassword.setText(I18NUtil.getString("fun_title_change_password"));
            this.lblChangePassword.setVisible(enableUCAuth);
            this.lblNewPassword = new JLabel();
            this.panelMyAccount.add((Component)this.lblNewPassword, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 0), 0, 0));
            this.lblNewPassword.setText(I18NUtil.getString("pw_placeholder_enter_first_pw"));
            this.lblNewPassword.setVisible(enableUCAuth);
            this.txtNewPassword = new JPasswordField();
            this.panelMyAccount.add((Component)this.txtNewPassword, new GridBagConstraints(2, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 0), 0, 0));
            this.txtNewPassword.setVisible(enableUCAuth);
            this.lblConfirmPassword = new JLabel();
            this.panelMyAccount.add((Component)this.lblConfirmPassword, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 0), 0, 0));
            this.lblConfirmPassword.setText(I18NUtil.getString("pw_placeholder_enter_2nd_pw"));
            this.lblConfirmPassword.setVisible(enableUCAuth);
            this.txtConfirmPassword = new JPasswordField();
            this.panelMyAccount.add((Component)this.txtConfirmPassword, new GridBagConstraints(2, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 10, 0, 0), 0, 0));
            this.txtConfirmPassword.setVisible(enableUCAuth);
            this.btnChangePassword = new JButton();
            this.panelMyAccount.add((Component)this.btnChangePassword, new GridBagConstraints(0, ++y, 3, 1, 1.0, 1.0, 15, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.btnChangePassword.setText(I18NUtil.getString("common_btn_apply_close"));
            this.btnChangePassword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PersonalInfoDialog.this.btnChangePasswordActionPerformed(evt);
                }
            });
            this.btnChangePassword.setVisible(enableUCAuth);
            JLabel xx = new JLabel();
            this.panelMyAccount.add((Component)xx, new GridBagConstraints(0, ++y, 3, 1, 1.0, 1.0, 17, 1, new Insets(20, 20, 0, 0), 0, 0));
            xx.setText("");
            xx.setVisible(!enableUCAuth);
            this.panelLoginDevice = new JPanel();
            BorderLayout panelLoginDeviceLayout = new BorderLayout();
            this.panelLoginDevice.setLayout(panelLoginDeviceLayout);
            this.jTabbedPane1.addTab(I18NUtil.getString("fun_title_login_device_single"), null, this.panelLoginDevice, null);
            this.panelLoginDevice.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelLoginedDevices = new RoundedCornerPanel();
            this.panelLoginDevice.add((Component)this.panelLoginedDevices, "North");
            BoxLayout jPanel3Layout2 = new BoxLayout(this.panelLoginedDevices, 1);
            this.panelLoginedDevices.setLayout(jPanel3Layout2);
            this.panelLoginedDevices.setBackground(Color.WHITE);
            this.setSize(460, 620);
            this.setMinimumSize(new Dimension(460, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if (action.equals("ezuc.intent.action.event.FETCH_LOGIN_DEVICE") || "ezuc.intent.action.event.FETCH_DEVICE_INFO".equals(action)) {
                        PersonalInfoDialog.this.web_loginDeviceChanged();
                    } else if (action.equals("ezuc.intent.action.event.PERSONAL_INFO_CHANGED")) {
                        boolean hasEditPermission = PreferencesUtil.hasPhotoEditPermission(UCChatClient.context);
                        if (hasEditPermission) {
                            PersonalInfoDialog.this.lblHeadIcon.setHasEditLabel(true);
                        } else {
                            PersonalInfoDialog.this.lblHeadIcon.setHasEditLabel(false);
                        }
                        if (PreferencesUtil.hasPhotoEditPermission(UCChatClient.context)) {
                            PersonalInfoDialog.this.lblHeadIcon.setToolTipText(I18NUtil.getString("abook_btn_edit_photo"));
                        } else {
                            PersonalInfoDialog.this.lblHeadIcon.setToolTipText(I18NUtil.getString("setting_no_photo_edit_permission"));
                        }
                        PersonalInfoDialog.this.lblHeadIcon.repaint();
                        PersonalInfoDialog.this.lblHeadIcon.revalidate();
                    } else if ("ezuc.intent.action.event.EXE_DEVICE_UPDATE_DONE".equals(action)) {
                        if (PersonalInfoDialog.this.mIsOn) {
                            ToastUtil.show(UCChatClient.context, I18NUtil.getString("setting_label_device_ring_on"), 10);
                        } else {
                            ToastUtil.show(UCChatClient.context, I18NUtil.getString("setting_label_device_ring_off"), 10);
                        }
                    } else if ("ezuc.intent.action.event.AUTH_OPTION_CHANGE".equals(action)) {
                        AuthOption authOption = PreferencesUtil.getAuthOption(UCChatClient.context);
                        boolean enableUCAuth = authOption != AuthOption.AD_ONLY;
                        PersonalInfoDialog.this.lblChangePassword.setVisible(enableUCAuth);
                        PersonalInfoDialog.this.lblNewPassword.setVisible(enableUCAuth);
                        PersonalInfoDialog.this.lblConfirmPassword.setVisible(enableUCAuth);
                        PersonalInfoDialog.this.txtNewPassword.setVisible(enableUCAuth);
                        PersonalInfoDialog.this.txtConfirmPassword.setVisible(enableUCAuth);
                        PersonalInfoDialog.this.btnChangePassword.setVisible(enableUCAuth);
                    }
                }
                catch (Throwable t) {
                    Log.e(PersonalInfoDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.FETCH_LOGIN_DEVICE");
        this.filter.addAction("ezuc.intent.action.event.FETCH_DEVICE_INFO");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.EXE_DEVICE_UPDATE_DONE");
        this.filter.addAction("ezuc.intent.action.event.AUTH_OPTION_CHANGE");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void web_loginDeviceChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PersonalInfoDialog.this.loadLoginDevices();
                PersonalInfoDialog.this.adjustDialogSize();
            }
        });
    }

    private void loadPersonalInfo() {
        Activity ctx = UCChatClient.context;
        this.mUserContact = ContactManager.getContact((Context)ctx, PreferencesUtil.getUserJid(ctx));
        this.mMobileNumbers = this.mUserContact.getMobilePhone();
        this.mMobileNumbersChanged = false;
        this.mHomeNumbers = this.mUserContact.getHomePhone();
        this.mHomeNumbersChanged = false;
        this.mBirthday = this.mUserContact.getBirthDay();
        this.mBirthdayHideType = this.mUserContact.getBirthdayHideType();
        this.mGenderType = this.mUserContact.getGender();
        this.mPhotoImage = null;
        this.mPhotoImageChanged = false;
        List<LiteSite> siteList = UCDBSite.getAllSites(ctx);
        this.mShowSite = siteList != null && siteList.size() > 1;
        Image image = ContactManager.getContactImage(this.mUserContact, 64, false, true);
        this.lblHeadIcon.setImage(image);
        this.lblContactName.setText(ContactManager.getContactFullName(this.mUserContact));
        LiteGenderType gender = this.mUserContact.getGender();
        switch (gender) {
            case MALE: {
                this.lblContactName.setIcon(UIConstants.ICON_GENDER_MALE);
                break;
            }
            case FEMALE: {
                this.lblContactName.setIcon(UIConstants.ICON_GENDER_FEMALE);
                break;
            }
            case OTHERS: {
                this.lblContactName.setIcon(UIConstants.ICON_GENDER_MALE);
            }
        }
        LiteDepartment dept = UCDBDept.getDeptByNamePath(UCChatClient.context, this.mUserContact.getDepartmentNamePath());
        if (dept != null) {
            this.lblDepartment.setText(dept.getDispName());
        } else {
            this.lblDepartment.setText(this.mUserContact.getDepartmentNamePath());
        }
        this.loadExtension(this.mUserContact);
        String email = this.mUserContact.getEmail();
        if (TextUtils.isBlank((CharSequence)email)) {
            this.lblEmail.setForeground(HintTextField.HINT_COLOR);
            this.lblEmail.setText(I18NUtil.getString("common_not_yet_setting"));
        } else {
            this.lblEmail.setText(this.mUserContact.getEmail());
            this.lblEmail.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.loadBirthDay();
        if (this.mBirthdayHideType == null) {
            this.lblBirthdayHideType.setText(I18NUtil.getString("setting_label_privacy") + ":" + I18NUtil.getString("common_not_yet_setting"));
        } else {
            this.lblBirthdayHideType.setText(I18NUtil.getString("setting_label_privacy") + ":" + this.getTypeName(this.mBirthdayHideType));
        }
        List<LiteTeleNumber> mobilePhones = this.mUserContact.getMobilePhone();
        if (mobilePhones == null || mobilePhones.size() == 0) {
            this.lblMobilePhone.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblMobilePhone.setText(CommonUtil.getNumberHtmlTable(mobilePhones, false));
            this.lblMobilePhone.setForeground(UIManager.getColor("Label.foreground"));
        }
        List<LiteTeleNumber> homePhones = this.mUserContact.getHomePhone();
        if (homePhones == null || homePhones.size() == 0) {
            this.lblHomePhone.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblHomePhone.setText(CommonUtil.getNumberHtmlTable(homePhones, false));
            this.lblHomePhone.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.loadLoginDevices();
        this.adjustDialogSize();
    }

    private void loadExtension(LiteContact contact) {
        int i;
        String label;
        this.extensionCount = 0;
        this.currentExtraExtensionGridY = 3;
        for (Component extraExtensionComp : this.extraExtensionComps) {
            this.jPanel1.remove(extraExtensionComp);
        }
        this.extraExtensionComps.clear();
        Activity ctx = UCChatClient.context;
        ArrayList<Node> data = new ArrayList<Node>();
        LiteContactHelper.addExtNoByContact(ctx, data, true, contact);
        EmpExtendedSysPhoneConfig config = PreferencesUtil.getEmpExtendedSysPhoneConfig(ctx);
        if (config.isEmpExtendedSystemPhoneFlag1() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber1())) {
            label = config.getEmpExtendedSysPhoneName1(I18NUtil.getAppLocale());
            data.add(new Node(contact.getJid(), label, contact.getExtendedPhoneNumber1(), false));
        }
        if (config.isEmpExtendedSystemPhoneFlag2() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber2())) {
            label = config.getEmpExtendedSysPhoneName2(I18NUtil.getAppLocale());
            data.add(new Node(contact.getJid(), label, contact.getExtendedPhoneNumber2(), false));
        }
        if (config.isEmpExtendedSystemPhoneFlag3() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber3())) {
            label = config.getEmpExtendedSysPhoneName3(I18NUtil.getAppLocale());
            data.add(new Node(contact.getJid(), label, contact.getExtendedPhoneNumber3(), false));
        }
        if (config.isEmpExtendedSystemPhoneFlag4() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber4())) {
            label = config.getEmpExtendedSysPhoneName4(I18NUtil.getAppLocale());
            data.add(new Node(contact.getJid(), label, contact.getExtendedPhoneNumber4(), false));
        }
        String unknown = I18NUtil.getString("common_not_yet_setting");
        for (i = 0; i < data.size(); ++i) {
            ++this.extensionCount;
        }
        if (this.extensionCount > 1) {
            this.lblExtensionHeader.setVisible(false);
            this.lblExtension.setVisible(false);
            this.jSeparator1.setVisible(false);
        } else {
            this.lblExtensionHeader.setVisible(true);
            this.lblExtension.setVisible(true);
            this.jSeparator1.setVisible(true);
        }
        for (i = 0; i < data.size(); ++i) {
            Node node = data.get(i);
            if (node instanceof ExtenNode) {
                ExtenNode extenNode = (ExtenNode)node;
                LiteSite site = null;
                Object ext = "";
                if (extenNode.getSiteId() != null) {
                    site = SiteManager.getSite(ctx, extenNode.getSiteId());
                }
                boolean hasData = false;
                if (TextUtils.isBlank((CharSequence)node.getSubText())) {
                    ext = unknown;
                } else {
                    hasData = true;
                    ext = node.getSubText();
                    if (this.mShowSite && site != null) {
                        ext = site.getName() + " " + (String)ext;
                    }
                }
                this.addExtensionData(i, node.getMainText(), (String)ext, hasData);
                continue;
            }
            String ext = "";
            boolean hasData = false;
            if (TextUtils.isBlank((CharSequence)node.getSubText())) {
                ext = unknown;
            } else {
                hasData = true;
                ext = node.getSubText();
            }
            this.addExtensionData(i, node.getMainText(), ext, hasData);
        }
    }

    private void addExtensionData(int index, String title, String extension, boolean hasData) {
        if (this.extensionCount <= 1) {
            this.lblExtensionHeader.setText(title);
            this.lblExtension.setText(extension);
            if (!hasData) {
                this.lblExtension.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblExtension.setForeground(UIManager.getColor("Label.foreground"));
            }
        } else {
            JSeparator sep = new JSeparator();
            this.jPanel1.add((Component)sep, new GridBagConstraints(0, this.currentExtraExtensionGridY, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            sep.setForeground(Color.LIGHT_GRAY);
            sep.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            JLabel extExtensionTitle = new JLabel();
            this.jPanel1.add((Component)extExtensionTitle, new GridBagConstraints(0, this.currentExtraExtensionGridY + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            extExtensionTitle.setText(title);
            extExtensionTitle.setFont(UIConstants.FONT_12_BOLD);
            JLabel rbExten = new JLabel();
            this.jPanel1.add((Component)rbExten, new GridBagConstraints(1, this.currentExtraExtensionGridY + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            rbExten.setText(extension);
            rbExten.setOpaque(false);
            rbExten.setFont(UIConstants.FONT_12_PLAIN);
            if (!hasData) {
                rbExten.setForeground(HintTextField.HINT_COLOR);
            } else {
                rbExten.setForeground(UIManager.getColor("Label.foreground"));
            }
            this.extraExtensionComps.add(sep);
            this.extraExtensionComps.add(extExtensionTitle);
            this.extraExtensionComps.add(rbExten);
            this.currentExtraExtensionGridY += 2;
        }
    }

    private void loadBirthDay() {
        String birthday = this.mUserContact.getBirthDayStr();
        if (TextUtils.isBlank((CharSequence)birthday)) {
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthdayHideType.setVisible(false);
        } else {
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
            this.lblBirthday.setText(birthday);
            this.lblBirthdayHideType.setVisible(true);
        }
    }

    private void setBirthday(Date date) {
        Long l = this.mBirthday = date == null ? null : Long.valueOf(date.getTime());
        if (date == null) {
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthdayHideType.setVisible(false);
        } else {
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
            this.lblBirthday.setText(DateTimeUtil.getBirthdayTimeStr(date));
            this.lblBirthdayHideType.setVisible(true);
        }
    }

    private void loadLoginDevices() {
        this.panelLoginedDevices.removeAll();
        List<LoginDeviceItem> list = DeviceManager.getLoginDeviceItemList(UCChatClient.context);
        for (LoginDeviceItem item : list) {
            LoginDevicePanel panel = new LoginDevicePanel(item);
            this.panelLoginedDevices.add(panel);
        }
        this.panelLoginedDevices.revalidate();
        this.panelLoginedDevices.repaint();
    }

    private void lblHeadIconMouseClicked(MouseEvent evt) {
        if (this.cpd == null) {
            this.cpd = new ChangePhotoDialog(UCChatClient.getInstance());
        }
        this.cpd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        this.cpd.setVisible(true);
        this.mPhotoImage = this.cpd.getClippedPhoto();
        this.mPhotoImageChanged = true;
        if (this.mPhotoImage != null) {
            this.lblHeadIcon.setImage(this.mPhotoImage);
        }
    }

    private void lblContactNameMouseClicked(MouseEvent evt) {
        LiteGenderType gender = this.mGenderType == null ? this.mUserContact.getGender() : this.mGenderType;
        switch (gender) {
            case MALE: {
                this.mGenderType = LiteGenderType.FEMALE;
                this.lblContactName.setIcon(UIConstants.ICON_GENDER_FEMALE);
                break;
            }
            case FEMALE: 
            case OTHERS: {
                this.mGenderType = LiteGenderType.MALE;
                this.lblContactName.setIcon(UIConstants.ICON_GENDER_MALE);
            }
        }
    }

    private void btnSavePersonalDataActionPerformed(ActionEvent evt, boolean shouldClose) {
        if (this.mMobileNumbersChanged || this.mHomeNumbersChanged) {
            ArrayList<LiteTeleNumber> phones = new ArrayList<LiteTeleNumber>();
            phones.addAll(this.mMobileNumbers == null ? this.mUserContact.getMobilePhone() : this.mMobileNumbers);
            phones.addAll(this.mHomeNumbers == null ? this.mUserContact.getHomePhone() : this.mHomeNumbers);
            String phoneStr = LiteContactHelper.getNumbers(phones);
            WebAgent.getInstance().updatePersonalPhones(phoneStr);
        }
        if (this.mPhotoImageChanged) {
            BufferedImage scaledBI = GraphicUtil.createScaledCenterImage(this.mPhotoImage, 96, 96);
            this.lblHeadIcon.setImage(scaledBI);
            String base64ImageValue = GraphicUtil.convertImageToBase64String(scaledBI);
            WebAgent.getInstance().changePersonalPhoto(PreferencesUtil.getUserAccount(UCChatClient.context), base64ImageValue);
        }
        if (this.mGenderType != this.mUserContact.getGender()) {
            WebAgent.getInstance().updatePersonalGender(this.mGenderType.getId());
        }
        if (this.mBirthday != this.mUserContact.getBirthDay()) {
            WebAgent.getInstance().updatePersonalBirthday(DateTimeUtil.getBirthdayTimeStr(this.mBirthday));
        }
        if (this.mBirthdayHideType != this.mUserContact.getBirthdayHideType()) {
            WebAgent.getInstance().updatePersonalBirthdayHideType(this.mBirthdayHideType.getId());
        }
        if (shouldClose) {
            this.setVisible(false);
        }
    }

    private void btnChangePasswordActionPerformed(ActionEvent evt) {
        if (this.validatePassword()) {
            WebAgent.getInstance().changePassword(this.txtNewPassword.getText());
            this.setVisible(false);
        }
    }

    public boolean validatePassword() {
        String newPassword = this.txtNewPassword.getText();
        String confirmPassword = this.txtConfirmPassword.getText();
        if (TextUtils.isBlank((CharSequence)newPassword) || newPassword.length() < 4) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("pw_validation_pw_too_short"), I18NUtil.getString("common_title_error"), 0);
            this.txtNewPassword.requestFocus();
            return false;
        }
        if (!newPassword.equals(confirmPassword)) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("pw_validation_pw_not_match"), I18NUtil.getString("common_title_error"), 0);
            this.txtConfirmPassword.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void onESCPressed() {
        this.setVisible(false);
    }

    private void resetUI() {
        this.lblContactName.setText("");
        this.lblDepartment.setText("");
        this.lblExtension.setText("");
        this.lblMobilePhone.setText(I18NUtil.getString("common_not_yet_setting"));
        this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
        this.lblHomePhone.setText(I18NUtil.getString("common_not_yet_setting"));
        this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
        this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
        this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
        this.lblEmail.setText("");
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.loadPersonalInfo();
        } else {
            this.resetUI();
        }
        super.setVisible(b);
    }

    private void adjustDialogSize() {
        List<LoginDeviceItem> list;
        List<LiteTeleNumber> homeNumbers;
        int extraItemCount = 0;
        List<LiteTeleNumber> mobileNumbers = this.mUserContact.getMobilePhone();
        if (mobileNumbers != null) {
            int count = mobileNumbers.size();
            extraItemCount += count <= 1 ? 0 : count - 1;
        }
        if ((homeNumbers = this.mUserContact.getHomePhone()) != null) {
            int count = homeNumbers.size();
            extraItemCount += count <= 1 ? 0 : count - 1;
        }
        if ((list = DeviceManager.getLoginDeviceItemList(UCChatClient.context)) != null) {
            int count = list.size();
            extraItemCount += count <= 1 ? 0 : count - 1;
        }
        int appendHeight = extraItemCount > 0 ? extraItemCount * 28 : 0;
        this.setSize(320, 500 + appendHeight);
        this.lblMobilePhone.revalidate();
        this.lblHomePhone.revalidate();
        this.jPanel2.revalidate();
        this.jPanel2.repaint();
    }

    private void lblMobilePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.MOBILE, this.mMobileNumbers);
        if (result != null) {
            this.mMobileNumbers = result.getNumbers();
            this.mMobileNumbersChanged = true;
            if (this.mMobileNumbers == null || this.mMobileNumbers.size() == 0) {
                this.lblMobilePhone.setText(I18NUtil.getString("common_not_yet_setting"));
                this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblMobilePhone.setText(CommonUtil.getNumberHtmlTable(this.mMobileNumbers, false));
                this.lblMobilePhone.setForeground(UIManager.getColor("Label.foreground"));
            }
            this.adjustDialogSize();
        }
    }

    private void lblHomePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.HOME, this.mHomeNumbers);
        if (result != null) {
            this.mHomeNumbers = result.getNumbers();
            this.mHomeNumbersChanged = true;
            if (this.mHomeNumbers == null || this.mHomeNumbers.size() == 0) {
                this.lblHomePhone.setText(I18NUtil.getString("common_not_yet_setting"));
                this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblHomePhone.setText(CommonUtil.getNumberHtmlTable(this.mHomeNumbers, false));
                this.lblHomePhone.setForeground(UIManager.getColor("Label.foreground"));
            }
            this.adjustDialogSize();
        }
    }

    private EditPhoneResult showEditPhoneDialog(LiteTeleNumberType type, List<LiteTeleNumber> numbers) {
        if (this.epd == null) {
            this.epd = new EditPhoneDialog(this);
        }
        this.epd.setLocationRelativeTo(this);
        return this.epd.showDialog(type, numbers);
    }

    private void lblBirthdayMouseClicked(MouseEvent evt) {
        if (this.jcalendar == null) {
            this.initJCalendar();
        }
        int x = 0;
        int y = this.lblBirthday.getHeight();
        Calendar calendar = Calendar.getInstance();
        if (this.mBirthday != null) {
            calendar.setTime(new Date(this.mBirthday));
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.lblBirthday, x, y);
        this.dateSelected = false;
    }

    private void lblBirthdayHideTypeMouseClicked(MouseEvent evt) {
        if (this.popupBirthdayHide == null) {
            this.popupBirthdayHide = new JPopupMenu();
            this.popupBirthdayHide.add(new BirthdayHideAction(LiteBirthdayHideType.ALL));
            this.popupBirthdayHide.add(new BirthdayHideAction(LiteBirthdayHideType.YEAR));
            this.popupBirthdayHide.add(new BirthdayHideAction(LiteBirthdayHideType.NONE));
        }
        int x = 0;
        int y = this.lblBirthdayHideType.getHeight();
        this.popupBirthdayHide.show(this.lblBirthdayHideType, x, y);
    }

    public String getTypeName(LiteBirthdayHideType type) {
        if (type == LiteBirthdayHideType.NONE) {
            return I18NUtil.getString("setting_birthday_hidetype_none");
        }
        if (type == LiteBirthdayHideType.YEAR) {
            return I18NUtil.getString("setting_birthday_hidetype_year");
        }
        if (type == LiteBirthdayHideType.ALL) {
            return I18NUtil.getString("setting_birthday_hidetype_all");
        }
        return "NA";
    }

    private void initJCalendar() {
        this.jcalendar = new JCalendar();
        this.jcalendar.getDayChooser().addPropertyChangeListener("day", (PropertyChangeListener)this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.jcalendar.setMaxSelectableDate(new Date());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && PersonalInfoDialog.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (PersonalInfoDialog.this.popup.isVisible() && PersonalInfoDialog.this.jcalendar.getMonthChooser().getComboBox().hasFocus()) {
                    MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] newMe = new MenuElement[me.length + 1];
                    newMe[0] = PersonalInfoDialog.this.popup;
                    for (int i = 0; i < me.length; ++i) {
                        newMe[i + 1] = me[i];
                    }
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(newMe);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day") && this.popup.isVisible()) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            if ((Integer)evt.getNewValue() > 0) {
                this.setBirthday(this.jcalendar.getCalendar().getTime());
            } else {
                this.setBirthday(null);
            }
        }
    }

    class LoginDevicePanel
    extends JPanel {
        LoginDeviceItem loginDeviceItem;
        JLabel lblType = new JLabel();
        JLabel lblDeviceName = new JLabel();
        JPanel panelFunction = new JPanel(new FlowLayout(4));

        public LoginDevicePanel(LoginDeviceItem loginDeviceItem) {
            this.loginDeviceItem = loginDeviceItem;
            this.initGUI();
        }

        private void initGUI() {
            this.panelFunction.setOpaque(false);
            int appType = Integer.parseInt(this.loginDeviceItem.getAppType().toString());
            switch (appType) {
                case -1: {
                    this.lblType.setIcon(UIConstants.ICON_APPTYPE_HARDPHONE);
                    break;
                }
                case 0: {
                    this.lblType.setIcon(UIConstants.ICON_APPTYPE_NONE);
                    break;
                }
                case 1: {
                    this.lblType.setIcon(UIConstants.ICON_APPTYPE_ANDROID);
                    break;
                }
                case 2: {
                    this.lblType.setIcon(UIConstants.ICON_APPTYPE_IOS);
                    break;
                }
                case 3: {
                    this.lblType.setIcon(UIConstants.ICON_APPTYPE_DESKTOP);
                    break;
                }
                case 4: {
                    this.lblType.setIcon(UIConstants.ICON_APPTYPE_WEB);
                }
            }
            String thisDeviceId = PreferencesUtil.getString(UCChatClient.context, "DEVICEID", "");
            JButton btnRing = new JButton();
            btnRing.setIcon(UIConstants.ICON_RING_OFF);
            btnRing.setVisible(false);
            Device d = this.loginDeviceItem.getDevice();
            if (d != null) {
                btnRing.setVisible(true);
                if (d.isRingIn()) {
                    btnRing.setIcon(UIConstants.ICON_RING_ON);
                    btnRing.setToolTipText(I18NUtil.getString("setting_label_device_ring_off_hint"));
                } else {
                    btnRing.setIcon(UIConstants.ICON_RING_OFF);
                    btnRing.setToolTipText(I18NUtil.getString("setting_label_device_ring_on_hint"));
                }
            }
            btnRing.setPreferredSize(new Dimension(28, 28));
            btnRing.setFocusPainted(false);
            btnRing.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoginDevicePanel.this.btnRingSwitchActionPerformed(evt);
                }
            });
            this.panelFunction.add(btnRing);
            if ("-1".equals(this.loginDeviceItem.getAppType())) {
                this.lblDeviceName.setText(this.loginDeviceItem.getDeviceName() + " " + this.loginDeviceItem.getDeviceUniqueId());
            } else if (this.loginDeviceItem.getDeviceUniqueId().equalsIgnoreCase(thisDeviceId)) {
                String productTypeStr = this.loginDeviceItem.getProductType();
                int productType = -1;
                try {
                    productType = Integer.parseInt(productTypeStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String appTypeName = I18NUtil.getProductName(productType);
                this.lblDeviceName.setText("[" + I18NUtil.getString("logindevice_this_device") + "] " + appTypeName + " " + this.loginDeviceItem.getDeviceName());
                JButton btnClose = new JButton();
                btnClose.setIcon(UIConstants.ICON_EXIT);
                btnClose.setToolTipText(I18NUtil.getString("login_btn_logout_exit"));
                btnClose.setPreferredSize(new Dimension(28, 28));
                btnClose.setFocusPainted(false);
                btnClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        LoginDevicePanel.this.btnCloseActionPerformed(evt);
                    }
                });
                this.panelFunction.add(btnClose);
                JButton btnLogout = new JButton();
                btnLogout.setIcon(UIConstants.ICON_LOGOUT);
                btnLogout.setToolTipText(I18NUtil.getString("login_btn_logout"));
                btnLogout.setPreferredSize(new Dimension(28, 28));
                btnLogout.setFocusPainted(false);
                btnLogout.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        LoginDevicePanel.this.btnLogoutActionPerformed(evt);
                    }
                });
                this.panelFunction.add(btnLogout);
            } else {
                String productTypeStr = this.loginDeviceItem.getProductType();
                int productType = -1;
                try {
                    productType = Integer.parseInt(productTypeStr);
                }
                catch (Throwable appTypeName) {
                    // empty catch block
                }
                String appTypeName = I18NUtil.getProductName(productType);
                this.lblDeviceName.setText(appTypeName + " " + this.loginDeviceItem.getDeviceName());
                JButton btnLogoutOther = new JButton();
                btnLogoutOther.setIcon(UIConstants.ICON_LOGOUT);
                btnLogoutOther.setToolTipText(I18NUtil.getString("login_btn_logout"));
                btnLogoutOther.setPreferredSize(new Dimension(28, 28));
                btnLogoutOther.setFocusPainted(false);
                btnLogoutOther.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        LoginDevicePanel.this.btnLogoutOtherActionPerformed(evt);
                    }
                });
                this.panelFunction.add(btnLogoutOther);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
            this.setLayout(new BorderLayout(10, 0));
            this.add((Component)this.lblType, "West");
            this.panelFunction.setPreferredSize(new Dimension(100, 40));
            this.add((Component)this.lblDeviceName, "Center");
            this.add((Component)this.panelFunction, "East");
        }

        private void btnRingSwitchActionPerformed(ActionEvent evt) {
            Device d = this.loginDeviceItem.getDevice();
            if (d != null) {
                PersonalInfoDialog.this.mIsOn = !d.isRingIn();
                DeviceManager.updateDeviceInfos(UCChatClient.context, d.getDeviceId());
            }
        }

        private void btnCloseActionPerformed(ActionEvent evt) {
            if (!PhoneAgent.getInstance().isCallIdle()) {
                ToastUtil.showLong(I18NUtil.getString("call_incall_exit_not_allowed"));
            } else {
                int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("login_confirm_logout_and_close"), I18NUtil.getString("common_title_warning"), 2, 2);
                if (result == 0) {
                    WebAgent.getInstance().logout(2002, true);
                }
            }
        }

        private void btnLogoutActionPerformed(ActionEvent evt) {
            if (!PhoneAgent.getInstance().isCallIdle()) {
                ToastUtil.showLong(I18NUtil.getString("call_incall_exit_not_allowed"));
            } else {
                int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("login_confirm_logout_only"), I18NUtil.getString("common_title_warning"), 2, 2);
                if (result == 0) {
                    WebAgent.getInstance().logout(2001, true);
                }
            }
        }

        private void btnLogoutOtherActionPerformed(ActionEvent evt) {
            int result = JOptionPane.showConfirmDialog(this, String.format(I18NUtil.getString("logindevice_confirm_force_logout"), this.loginDeviceItem.getDeviceName()), I18NUtil.getString("common_title_warning"), 2, 2);
            if (result == 0) {
                WebAgent.getInstance().removeLoginDeviceById(this.loginDeviceItem.getDeviceUniqueId());
            }
        }
    }

    class BirthdayHideAction
    extends AbstractAction {
        LiteBirthdayHideType type;

        public BirthdayHideAction(LiteBirthdayHideType type) {
            this.type = type;
            this.putValue("Name", PersonalInfoDialog.this.getTypeName(type));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PersonalInfoDialog.this.mBirthdayHideType = this.type;
            PersonalInfoDialog.this.lblBirthdayHideType.setText(I18NUtil.getString("setting_label_privacy") + ":" + PersonalInfoDialog.this.getTypeName(this.type));
        }
    }
}

