/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contact;

import com.blisscloud.ezuc.client.contact.Phone;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class PhoneTableModel
extends AbstractTableModel {
    private String[] columns = new String[]{I18NUtil.getString("common_lable_number"), ""};
    private List<Phone> phoneList = new ArrayList<Phone>();

    PhoneTableModel() {
    }

    public List<Phone> getPhones() {
        return Collections.unmodifiableList(this.phoneList);
    }

    public void clear() {
        this.phoneList.clear();
        this.fireTableDataChanged();
    }

    public void setPhones(List<Phone> phones) {
        this.phoneList.clear();
        if (phones != null) {
            this.phoneList.addAll(phones);
        }
        this.fireTableDataChanged();
    }

    public void addPhone(Phone phone) {
        this.phoneList.add(phone);
        this.fireTableDataChanged();
    }

    public void removePhone(int rowIndex) {
        this.phoneList.remove(rowIndex);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.phoneList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Phone phone = this.phoneList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return phone.getNumber();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.phoneList.size() || rowIndex < 0) {
            return;
        }
        Phone phone = this.phoneList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                phone.setNumber((String)value);
                return;
            }
        }
    }
}

