/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contacthistory;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.EmployeeInfoPopup;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.chat.roomimpl.ConferenceChatroom;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.component.UnreadMessageLabel;
import com.blisscloud.ezuc.client.emoticons.EmoticonUtils;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.HistoryTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.tool.CustomBorder;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.CustomerUtils;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.LastMsg;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.PhoneStatusUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.wechat.WechatInfoPopup;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ConferenceHelper;
import com.blisscloud.mobile.ezuc.manager.ConferenceUtil;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ContactHistoryEntryPanel
extends JPanel
implements ConferenceHelper.VerifyResult {
    private static final long serialVersionUID = -291143398863576026L;
    private static EmployeeInfoPopup employeeInfoPopup;
    private static WechatInfoPopup wechatInfoPopup;
    private PersonalPhoto lblHeadIcon;
    private JLabel lblName;
    private JLabel lblStatus;
    private JPanel jPanel1;
    private JTextPane lblLastMsg;
    private JPanel panelJoin;
    private RoundedCornerLabel btnJoin;
    private RoundedCornerLabel btnCall;
    private UnreadMessageLabel lblUnreadMsgCount;
    private boolean forContentSearch;
    private String chatJid;
    private String statusText;
    private Color statusColor;
    private String timeText;
    private int chatType = -1;
    private boolean mConfRoomJoined = false;
    private boolean selected;
    private boolean isOnTop;
    private MouseAdapter wechatMouseAdapter = null;
    private MouseAdapter personMouseAdapter = null;
    private String searchKey;
    Timer timer1 = null;
    Timer timer2 = null;
    private ConferenceHelper mConferenceHelper = null;

    public ContactHistoryEntryPanel(String chatId, boolean forContentSearch) {
        this.chatJid = chatId;
        this.forContentSearch = forContentSearch;
        this.initGUI();
        this.wechatMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    ContactHistoryEntryPanel.this.showWechatInfo(evt);
                }
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }
        };
        this.personMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    ContactHistoryEntryPanel.this.showPersonalInfo(evt);
                }
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblHeadIcon, evt, ContactHistoryEntryPanel.this);
                ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
            }
        };
    }

    public void upateUnreadCount(int unreadMsgCount) {
        this.setUnreadMessageCount(unreadMsgCount);
    }

    public void updateContactHistory(ChatRoomInfo roomInfo, Map<String, LiteContact> contactsMap, List<String> participantJidList, Message lastMsg, String pendingDraft, int unreadMsgCount, int hasMeCount, Integer matchCount, String searchKey) {
        Activity ctx = UCChatClient.context;
        this.handleCallBtn();
        boolean isConfRoom = false;
        boolean isChatRoom = false;
        this.searchKey = searchKey;
        this.isOnTop = false;
        if (roomInfo != null) {
            this.isOnTop = roomInfo.isOnTop();
        }
        this.lblHeadIcon.removeMouseListener(this.personMouseAdapter);
        this.lblHeadIcon.removeMouseListener(this.wechatMouseAdapter);
        this.lblHeadIcon.setCursor(UIConstants.CURSOR_DEFAULT);
        if (JidUtil.isCustomerJid(this.chatJid)) {
            this.setPanelJoinVisible(false);
            LiteCustomer liteCustomer = CustomerManager.getCustomerInfo(ctx, JidUtil.convertKey(this.chatJid));
            if (liteCustomer != null) {
                this.lblName.setText(liteCustomer.getNickname());
                if (liteCustomer.getType() == 0) {
                    this.lblName.setIcon(UIConstants.ICON_WECHAT_GREEN);
                } else if (liteCustomer.getType() == 1) {
                    this.lblName.setIcon(UIConstants.ICON_LINE_GREEN);
                } else if (liteCustomer.getType() == 2) {
                    this.lblName.setIcon(UIConstants.ICON_WEBCHAT_BLUE);
                }
                this.lblName.setHorizontalTextPosition(2);
                image = CustomerManager.getContactImage(liteCustomer, 48, false);
                this.lblHeadIcon.setImage(image);
                this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
                this.lblHeadIcon.addMouseListener(this.wechatMouseAdapter);
            } else {
                WebAgent.getInstance().getCustomerInfo(JidUtil.convertKey(this.chatJid));
                this.lblName.setText(this.chatJid);
            }
            this.setCustomerExpireTime(liteCustomer);
        } else if (roomInfo == null) {
            this.setPanelJoinVisible(false);
        } else {
            this.chatType = roomInfo.getType();
            if (JidUtil.isFakeExternalCallJid(roomInfo.getChatRoomId())) {
                this.setPanelJoinVisible(false);
                this.lblName.setText(I18NUtil.getString("phone_history_label_external"));
                this.setImage(UIConstants.ICON_EXTERNAL_CALL.getImage());
            } else if (JidUtil.isFakeFaxDocJid(roomInfo.getChatRoomId())) {
                this.setPanelJoinVisible(false);
                this.lblName.setText(I18NUtil.getString("fax_doc_label_external"));
                this.setImage(UIConstants.ICON_FAX_DOC.getImage());
            } else if (this.chatType == 3) {
                this.setPanelJoinVisible(false);
                if (this.chatJid.indexOf("_@@_") != -1) {
                    String[] phoneNum = this.chatJid.split("_@@_");
                    String phoneNumDisp = PhoneNoUtil.getPhoneNumDisp(ctx, phoneNum[0], phoneNum[1]);
                    this.lblName.setText(phoneNumDisp);
                } else {
                    this.lblName.setText(this.chatJid);
                }
                this.setImage(UIConstants.ICON_PERSON48.getImage());
            } else if (this.chatType == 0) {
                if (JidUtil.isBcAnnouncerJid(this.chatJid)) {
                    this.setPanelJoinVisible(false);
                    this.lblName.setText(I18NUtil.getAppName());
                    this.lblHeadIcon.setImage(UIConstants.ICON_LOGO48.getImage());
                    this.setPhoneStatus(null);
                } else {
                    this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
                    this.lblHeadIcon.addMouseListener(this.personMouseAdapter);
                    this.setPanelJoinVisible(false);
                    liteContact = null;
                    if (contactsMap != null && contactsMap.containsKey(this.chatJid)) {
                        liteContact = contactsMap.get(this.chatJid);
                    } else {
                        liteContact = ContactManager.getContact((Context)ctx, this.chatJid);
                        if (contactsMap != null && liteContact != null) {
                            contactsMap.put(this.chatJid, liteContact);
                        }
                    }
                    String contactName = ChatRoomUtil.getEmpRoomTitle(ctx, roomInfo, liteContact, this.chatJid);
                    this.lblName.setText(contactName);
                    Image image = ContactManager.getContactImage(liteContact, 48, false, true);
                    this.lblHeadIcon.setImage(image);
                    if (liteContact != null) {
                        if (JidUtil.isLocationJid(liteContact.getJid())) {
                            this.setPhoneStatus(ContactManager.getPhoneLocStatus(liteContact.getJid()));
                        } else {
                            this.setPhoneStatus(ContactManager.getPhoneEmpStatus("" + liteContact.getId()));
                        }
                    } else {
                        this.setPhoneStatus(null);
                    }
                }
            } else if (this.chatType == 5) {
                this.setPanelJoinVisible(false);
                LiteMyContact contact = ContactManager.getExternalContact((Context)ctx, this.chatJid);
                this.lblName.setText(ChatRoomUtil.getMyContactRoomTitle(ctx, roomInfo, contact));
                image = ContactManager.getExternalContactImage(contact, 48, false, true);
                this.lblHeadIcon.setImage(image);
                this.setPhoneStatus(null);
            } else if (this.chatType == 7) {
                this.setPanelJoinVisible(false);
                MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(ctx, this.chatJid);
                this.lblName.setText(ChatRoomUtil.getMessageChannelRoomTitle(ctx, roomInfo, channel, this.chatJid));
                image = MessageChannelManager.getMessageChannelImage(channel, 48, false, true);
                this.lblHeadIcon.setImage(image);
                this.setPhoneStatus(null);
            } else if (this.chatType == 4) {
                this.setPanelJoinVisible(false);
                liteContact = ContactManager.getContact((Context)ctx, this.chatJid);
                this.lblName.setText(ChatRoomUtil.getLocationRoomTitle(ctx, roomInfo, liteContact, this.chatJid));
                image = ContactManager.getContactImage(liteContact, 48, false, true);
                this.lblHeadIcon.setImage(image);
                if (liteContact != null) {
                    this.setPhoneStatus(ContactManager.getPhoneLocStatus(liteContact.getJid()));
                } else {
                    this.setPhoneStatus(null);
                }
            } else if (this.chatType == 2) {
                isConfRoom = true;
                confRoom = MeetmeManager.getMeetme((Context)ctx, this.chatJid);
                if (confRoom == null) {
                    this.setPanelJoinVisible(false);
                }
                String confRoomTitle = ChatRoomUtil.getConfRoomTitle(ctx, roomInfo, confRoom, false, true);
                title = confRoomTitle;
                if (confRoom != null) {
                    title = confRoomTitle + " (" + OutboundPrefixManager.getMeetmePrefix(ctx) + confRoom.getRoomNo() + ")";
                }
                this.lblName.setText((String)title);
                this.checkConferenceRoomJoined();
                this.setPhoneStatus(null);
            } else if (this.chatType == 1) {
                this.setPanelJoinVisible(false);
                isChatRoom = true;
                confRoom = MeetmeManager.getMeetme((Context)ctx, this.chatJid);
                String chatRoomTitle = ChatRoomUtil.getChatRoomTitleForList(ctx, roomInfo, participantJidList, contactsMap);
                title = chatRoomTitle;
                if (confRoom != null) {
                    title = chatRoomTitle + " (" + OutboundPrefixManager.getMeetmePrefix(ctx) + confRoom.getRoomNo() + ")";
                }
                this.lblName.setText((String)title);
                if (participantJidList == null || participantJidList.size() <= 0) {
                    this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
                } else {
                    this.lblHeadIcon.setImage(GraphicUtil.getChatRoomImage(ctx, participantJidList, contactsMap, false, true));
                }
                this.setPhoneStatus(null);
            }
        }
        if (this.forContentSearch) {
            this.lblLastMsg.setText("");
            this.setMessage(String.format(I18NUtil.getString("contact_history_msg_found"), matchCount));
        } else {
            boolean isDraft = false;
            if (TextUtils.isBlank((CharSequence)pendingDraft)) {
                if (lastMsg != null) {
                    String timeStr = "";
                    if (lastMsg.getMsgType() != 20) {
                        timeStr = DateTimeUtil.getTimeStr(lastMsg.getServerTime(), false);
                    }
                    boolean isFuzzy = false;
                    if (JidUtil.isFakeExternalCallJid(roomInfo.getChatRoomId()) && PreferencesUtil.isFuzzyOutboundNumber(ctx)) {
                        isFuzzy = true;
                    }
                    LastMsg lastMsgResult = MsgUtil.getLastMsgUtil(ctx, lastMsg, contactsMap, isConfRoom, isFuzzy);
                    String content = lastMsgResult.getDispContentShort();
                    String ownerName = null;
                    if (lastMsgResult.isShowMsgSenderName() && (isChatRoom || isConfRoom)) {
                        ownerName = ContactManager.getContactShortName((Context)ctx, contactsMap, lastMsg.getFromJid());
                    }
                    this.setLastMessage(ownerName, content, hasMeCount, isDraft);
                    this.setTime(timeStr);
                }
            } else {
                isDraft = true;
                this.setLastMessage(null, pendingDraft, hasMeCount, isDraft);
            }
            this.setUnreadMessageCount(unreadMsgCount);
        }
    }

    public void checkConferenceRoomJoined() {
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.chatJid);
        if (confRoom == null) {
            this.mConfRoomJoined = false;
            this.setPanelJoinVisible(false);
            this.setCallBtnVisible(false);
            this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
        } else {
            this.mConfRoomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.chatJid);
            if (this.mConfRoomJoined) {
                this.setPanelJoinVisible(false);
                this.setCallBtnVisible(this.selected && isAvailableToCall != PhoneAgent.LineAvailableType.NONE);
                this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_USING_48.getImage());
            } else if (ConferenceUtil.isShowJoinBtn(confRoom)) {
                this.setPanelJoinVisible(true);
                this.setCallBtnVisible(false);
                this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
            } else {
                this.setPanelJoinVisible(false);
                this.setCallBtnVisible(false);
                this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
            }
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(new CustomBorder());
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setPreferredSize(new Dimension(305, 60));
            this.setMinimumSize(new Dimension(200, 60));
            this.setOpaque(false);
            this.lblUnreadMsgCount = new UnreadMessageLabel();
            this.add((Component)this.lblUnreadMsgCount, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.lblUnreadMsgCount.setVisible(false);
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.lblName = new JLabel();
            this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.lblName.setFont(UIConstants.FONT_14_PLAIN);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setHgap(0);
            jPanel1Layout.setVgap(0);
            jPanel1Layout.setAlignment(0);
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.lblLastMsg = new JTextPane();
            this.jPanel1.add(this.lblLastMsg);
            this.lblLastMsg.setFont(UIConstants.FONT_12_PLAIN);
            this.lblLastMsg.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblLastMsg.setOpaque(false);
            this.lblLastMsg.setEnabled(true);
            this.lblLastMsg.setEditable(false);
            this.lblLastMsg.setCaret(new MyCaret());
            this.lblLastMsg.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblLastMsg, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblLastMsg, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblLastMsg, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblLastMsg, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.lblLastMsg, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }
            });
            this.panelJoin = new JPanel();
            this.setPanelJoinVisible(false);
            this.add((Component)this.panelJoin, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelUnjoinedLayout = new FlowLayout();
            panelUnjoinedLayout.setHgap(4);
            panelUnjoinedLayout.setVgap(0);
            this.panelJoin.setLayout(panelUnjoinedLayout);
            this.panelJoin.setOpaque(false);
            this.btnJoin = new RoundedCornerLabel(I18NUtil.getString("common_btn_join"), null, UIConstants.BACKGROUND_UNJOINED_NORMAL, UIConstants.BACKGROUND_UNJOINED_OVER, UIConstants.BACKGROUND_UNJOINED_PRESSED);
            this.panelJoin.add(this.btnJoin);
            this.btnJoin.setForeground(Color.WHITE);
            this.btnJoin.setCursor(UIConstants.CURSOR_HAND);
            this.btnJoin.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.btnJoin, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.btnJoin, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.btnJoin, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.btnJoin, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ContactHistoryEntryPanel.this.btnJoinMouseClicked(evt);
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(ContactHistoryEntryPanel.this.btnJoin, evt, ContactHistoryEntryPanel.this);
                    ContactHistoryEntryPanel.this.dispatchEvent(newEvt);
                }
            });
            JPanel panelCall = new JPanel();
            this.add((Component)panelCall, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelCallLayout = new FlowLayout();
            panelCallLayout.setHgap(4);
            panelCallLayout.setVgap(0);
            panelCall.setLayout(panelCallLayout);
            panelCall.setOpaque(false);
            this.btnCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_callout"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            panelCall.add(this.btnCall);
            this.btnCall.setForeground(Color.WHITE);
            this.btnCall.setToolTipText(I18NUtil.getString("abook_popup_btn_talk"));
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.setCallBtnVisible(false);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ContactHistoryEntryPanel.this.btnCall.isEnabled() && evt.getButton() == 1) {
                        Log.i(ContactHistoryEntryPanel.class.getSimpleName(), "history start dial:" + ContactHistoryEntryPanel.this.chatJid);
                        ChatRoomManager.startDialOut(ContactHistoryEntryPanel.this.btnCall, ContactHistoryEntryPanel.this.chatJid);
                    }
                }
            });
            this.lblStatus = new JLabel();
            this.add((Component)this.lblStatus, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblStatus.setFont(UIConstants.FONT_12_PLAIN);
            this.lblStatus.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblStatus.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showPersonalInfo(MouseEvent e) {
        LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, this.chatJid);
        if (contact == null) {
            return;
        }
        if (employeeInfoPopup == null) {
            employeeInfoPopup = new EmployeeInfoPopup(UCChatClient.getInstance());
        }
        employeeInfoPopup.setContact(contact);
        Component comp = e.getComponent();
        employeeInfoPopup.show(comp, 0, 3 + comp.getHeight());
    }

    private void showWechatInfo(MouseEvent e) {
        if (wechatInfoPopup == null) {
            wechatInfoPopup = new WechatInfoPopup(UCChatClient.getInstance());
        }
        Component comp = e.getComponent();
        wechatInfoPopup.setWechatJID(this.chatJid);
        wechatInfoPopup.show(comp, 0, 3 + comp.getHeight());
    }

    public String getChatId() {
        return this.chatJid;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.handleCallBtn();
        if (this.selected) {
            this.setOpaque(true);
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        } else if (this.isOnTop) {
            this.setOpaque(true);
            this.setBackground(EntryPanel.ON_TOP_BACKGROUND);
        } else {
            this.setOpaque(false);
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        }
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtn() {
        if (!this.selected) {
            this.setCallBtnVisible(false);
            return;
        }
        String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
        if (myJid.equalsIgnoreCase(this.chatJid)) {
            this.setCallBtnVisible(false);
            return;
        }
        PhoneAgent.LineAvailableType ableToCall = PhoneAgent.getInstance().isAvailableToCall();
        boolean btnVisible = false;
        if (!JidUtil.isFakeExternalCallJid(this.chatJid) && !JidUtil.isFakeFaxDocJid(this.chatJid)) {
            if (this.chatType == 3) {
                btnVisible = ableToCall != PhoneAgent.LineAvailableType.NONE;
                this.handleCallBtnText(btnVisible, ableToCall);
            } else if (this.chatType != 7) {
                if (this.chatType == 0) {
                    if (JidUtil.isEmployeeJid(this.chatJid)) {
                        btnVisible = ableToCall != PhoneAgent.LineAvailableType.NONE;
                        this.handleCallBtnText(btnVisible, ableToCall);
                    }
                } else if (this.chatType == 5 || this.chatType == 4) {
                    btnVisible = ableToCall != PhoneAgent.LineAvailableType.NONE;
                    this.handleCallBtnText(btnVisible, ableToCall);
                } else if (this.chatType == 1) {
                    btnVisible = ableToCall != PhoneAgent.LineAvailableType.NONE;
                    this.handleCallBtnText(btnVisible, ableToCall);
                } else if (this.chatType == 2) {
                    btnVisible = this.mConfRoomJoined && ableToCall != PhoneAgent.LineAvailableType.NONE;
                    this.handleCallBtnText(btnVisible, ableToCall);
                }
            }
        }
    }

    private synchronized void setCallBtnVisible(final boolean btnVisible) {
        if (this.timer1 != null) {
            this.timer1.stop();
            this.timer1 = null;
        }
        if (btnVisible) {
            this.timer1 = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    ContactHistoryEntryPanel.this.btnCall.setVisible(btnVisible);
                }
            });
            this.timer1.setRepeats(false);
            this.timer1.start();
        } else {
            this.btnCall.setVisible(btnVisible);
        }
    }

    private synchronized void setPanelJoinVisible(final boolean btnVisible) {
        if (this.timer2 != null) {
            this.timer2.stop();
            this.timer2 = null;
        }
        if (!this.panelJoin.isVisible() && btnVisible) {
            this.timer2 = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    ContactHistoryEntryPanel.this.panelJoin.setVisible(btnVisible);
                }
            });
            this.timer2.setRepeats(false);
            this.timer2.start();
        } else {
            this.panelJoin.setVisible(btnVisible);
        }
    }

    private void handleCallBtnText(boolean btnVisible, PhoneAgent.LineAvailableType ableToCall) {
        this.setCallBtnVisible(btnVisible);
        if (!btnVisible) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line1"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line2"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_THREE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line3"));
        } else {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout"));
        }
    }

    public void setMenuDisplayed(boolean b) {
        if (!this.selected) {
            this.setBackground(EntryPanel.ENTRY_MENU_DISPLAYED_BACKGROUND);
            this.setOpaque(b);
        }
        this.revalidate();
        this.repaint();
    }

    public int getUnreadMessageCount() {
        return this.lblUnreadMsgCount.getUnreadMessageCount();
    }

    public void setUnreadMessageCount(int count) {
        this.lblUnreadMsgCount.setUnreadMessageCount(count);
    }

    public void setPhoneStatus(String status) {
        if (JidUtil.isBcAnnouncerJid(this.chatJid)) {
            return;
        }
        if (JidUtil.isAPIUserJid(this.chatJid)) {
            return;
        }
        if (JidUtil.isCustomerJid(this.chatJid)) {
            return;
        }
        if (JidUtil.isEmployeeJid(this.chatJid) || JidUtil.isLocationJid(this.chatJid)) {
            this.statusText = PhoneStatusUtil.getPhoneStatusText(status);
            this.statusColor = PhoneStatusUtil.getPhoneStatusColor(status);
            this.updateStatusText();
        }
    }

    public void setCustomerExpireTime(LiteCustomer liteCustomer) {
        if (liteCustomer == null) {
            this.statusText = null;
        } else if (!CustomerManager.isValid(UCChatClient.context, liteCustomer)) {
            this.statusText = I18NUtil.getString("wechat_service_is_closed");
            this.statusColor = Color.GRAY;
        } else {
            long second;
            long t = liteCustomer.getExpireTime() - System.currentTimeMillis();
            this.statusText = CustomerUtils.getExpireTime(t);
            this.statusColor = Color.BLACK;
            long hour = t <= 0L ? 0L : t / 1000L / 60L / 60L;
            long minius = t <= 0L ? 0L : t / 1000L / 60L % 60L;
            long l = second = t <= 0L ? 0L : t / 1000L % 60L;
            this.statusColor = hour > 0L ? PhoneStatusUtil.COLOR_ONLINE : (minius > 5L ? PhoneStatusUtil.COLOR_ONLINE : (second > 0L ? Color.RED : Color.GRAY));
        }
        this.updateStatusText();
    }

    public void setTime(String timeStr) {
        this.timeText = timeStr;
        this.updateStatusText();
    }

    private void updateStatusText() {
        if (this.forContentSearch) {
            this.lblStatus.setText("");
            this.lblStatus.setVisible(false);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><table cellspacing=\"1\" cellpadding=\"1\">");
            if (TextUtils.isNotBlank((CharSequence)this.statusText)) {
                if (this.statusColor == null) {
                    this.statusColor = Color.BLACK;
                }
                String colorHex = String.format("#%02x%02x%02x", this.statusColor.getRed(), this.statusColor.getGreen(), this.statusColor.getBlue());
                sb.append("<rd><td nowrap align=\"right\"><font color=\"").append(colorHex).append("\">").append(this.statusText).append("</font></td></tr>");
            }
            if (TextUtils.isNotBlank((CharSequence)this.timeText)) {
                sb.append("<rd><td nowrap align=\"right\">").append(this.timeText).append("</td></tr>");
            }
            sb.append("</table></html>");
            this.lblStatus.setText(sb.toString());
            this.lblStatus.setVisible(true);
        }
    }

    public String getDisplayName() {
        return this.lblName.getText();
    }

    public void setDisplayName(String displayName) {
        this.lblName.setText(displayName);
    }

    public void setLastMessage(String ownerName, String lastMsg, int hasMeCount, boolean isDraft) {
        try {
            StyledDocument doc = (StyledDocument)this.lblLastMsg.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, new Color(173, 0, 0));
            this.lblLastMsg.setText("");
            if (isDraft) {
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), "[" + I18NUtil.getString("chat_msg_type_draft") + "] ", style);
            }
            if (lastMsg.startsWith("[PHONE_TALKING]") || lastMsg.startsWith("[PHONE_CANCEL]") || lastMsg.startsWith("[PHONE_CANCEL_IN]") || lastMsg.startsWith("[PHONE_CANCEL_OUT]")) {
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), (String)(hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : ""), style);
                String[] terms = lastMsg.split(" ");
                String phoneKey = terms[0];
                String phoneIconPath = ChatRoomManager.getPhoneIconPath(phoneKey);
                ImageIcon phoneIcon = GraphicUtil.getScaledIcon(phoneIconPath, 16, 16);
                String remainText = lastMsg.substring(phoneKey.length());
                try {
                    this.lblLastMsg.insertIcon(phoneIcon);
                    this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), remainText, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else if (EmoticonUtils.isStickerContent(lastMsg)) {
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), (String)(hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : ""), style);
                String content = "[" + I18NUtil.getString("chat_msg_type_sticker") + "]";
                if (!TextUtils.isBlank((CharSequence)ownerName)) {
                    content = ownerName + ": " + content;
                }
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), content, null);
            } else {
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), (String)(hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : ""), style);
                Object content = lastMsg;
                if (!TextUtils.isBlank((CharSequence)ownerName)) {
                    content = ownerName + ": " + (String)content;
                }
                this.setMessage((String)content);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void setMessage(String content) {
        String msgContent = content.replace("\n", " ");
        HistoryTextWriter writer = new HistoryTextWriter(this.lblLastMsg, 12, -1);
        try {
            MsgTextConverter.convertAndAppendText(msgContent, writer);
        }
        catch (UCThreadException uCThreadException) {
            // empty catch block
        }
    }

    public void setImage(Image image) {
        if (image == null || image.getWidth(this) <= 0 || image.getHeight(this) <= 0) {
            this.lblHeadIcon.setImage(UIConstants.ICON_PERSON48.getImage());
        } else {
            this.lblHeadIcon.setImage(image);
        }
    }

    private void btnJoinMouseClicked(MouseEvent evt) {
        if (this.btnJoin.isEnabled() && evt.getButton() == 1 && !this.mConfRoomJoined) {
            LiteConferenceRoom liteConfRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.chatJid);
            Long roomId = liteConfRoom.getRoomId();
            if (this.mConferenceHelper != null) {
                this.mConferenceHelper.release();
            }
            this.mConferenceHelper = new ConferenceHelper(UCChatClient.context, roomId, this);
            this.mConferenceHelper.doVerify();
        }
    }

    @Override
    public void verifyOK() {
        if (this.mConferenceHelper != null) {
            this.mConferenceHelper.release();
            this.mConferenceHelper = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.putExtra("unjoined_display_mode", (Serializable)((Object)ConferenceChatroom.UnjoinedDisplayMode.CHAT_HISTORY));
                UCChatClient.getInstance().getMainPanel().showChatroom(ContactHistoryEntryPanel.this.chatJid, intent);
            }
        });
    }

    @Override
    public void verifyFailed(int returnCode, String msg) {
        if (this.mConferenceHelper != null) {
            this.mConferenceHelper.release();
            this.mConferenceHelper = null;
        }
    }

    public boolean isForContentSearch() {
        return this.forContentSearch;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    class MyCaret
    extends DefaultCaret {
        MyCaret() {
        }

        @Override
        protected void adjustVisibility(Rectangle nloc) {
        }
    }
}

