/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contacthistory;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.IMultiUserChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.BaseChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ConferenceChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.MultiUserChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.WechatChatroom;
import com.blisscloud.ezuc.client.component.ChatBackgroundPanel;
import com.blisscloud.ezuc.client.component.CustomLineBorder;
import com.blisscloud.ezuc.client.component.GroupPanel;
import com.blisscloud.ezuc.client.contacthistory.ContactHistoryPanel;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONException;

public class ContactHistoryFramePanel
extends JPanel {
    private JSplitPane jSplitPane1;
    private ContactHistoryPanel contactHistoryPanel;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private Timer contactHistoryFrameTimer = new Timer("ContactHistoryFrameTimer");
    private WechatCountDownThread wechatCountDownThread = null;
    private ChatBackgroundPanel chatBackgroundPanel = null;
    private IChatroom currentView = null;
    private JPanel rightPanel = null;
    private boolean tabSelected = false;

    public ContactHistoryFramePanel() {
        this.setLayout(new BorderLayout());
        this.initView();
        this.initReceiver();
        Calendar nextMidnight = Calendar.getInstance();
        nextMidnight.set(11, 0);
        nextMidnight.set(12, 0);
        nextMidnight.set(13, 5);
        nextMidnight.add(5, 1);
        this.contactHistoryFrameTimer.schedule((TimerTask)new UCTimerTask(){

            @Override
            public void doRun() {
                ContactHistoryFramePanel.this.reloadAllTime();
            }
        }, nextMidnight.getTime(), TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS));
        this.wechatCountDownThread = new WechatCountDownThread();
        this.wechatCountDownThread.start();
    }

    private void initView() {
        this.jSplitPane1 = new JSplitPane();
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
        this.configureDivider();
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent changeEvent) {
                int xdividerSize;
                JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
                String propertyName = changeEvent.getPropertyName();
                if (propertyName.equals("dividerLocation")) {
                    int xdividerLocation = sourceSplitPane.getDividerLocation();
                    if (xdividerLocation != 0) {
                        PreferencesUtil.putInt(UCChatClient.context, "DIVIDER_LOCATION_HISTORY", xdividerLocation);
                    }
                } else if (propertyName.equals("dividerSize") && (xdividerSize = ContactHistoryFramePanel.this.jSplitPane1.getDividerSize()) != 0) {
                    PreferencesUtil.putInt(UCChatClient.context, "DIVIDER_SIZE_HISTORY", xdividerSize);
                }
            }
        });
        this.chatBackgroundPanel = new ChatBackgroundPanel();
        this.contactHistoryPanel = new ContactHistoryPanel();
        this.contactHistoryPanel.setBorder(new CustomLineBorder(GroupPanel.TITLE_BORDER_COLOR, 0, 0, 0, 1));
        this.contactHistoryPanel.setMinimumSize(new Dimension(340, 200));
        this.jSplitPane1.add((Component)this.contactHistoryPanel, "left");
        this.rightPanel = new JPanel();
        this.rightPanel.setOpaque(false);
        this.rightPanel.setLayout(new BorderLayout());
        this.jSplitPane1.add((Component)this.rightPanel, "right");
        this.rightPanel.add((Component)this.chatBackgroundPanel, "Center");
    }

    private void configureDivider() {
        int location = PreferencesUtil.getInt(UCChatClient.context, "DIVIDER_LOCATION_HISTORY", 320);
        int size = PreferencesUtil.getInt(UCChatClient.context, "DIVIDER_SIZE_HISTORY", -1);
        if (location > 0) {
            this.jSplitPane1.setDividerLocation(location);
        }
        if (size > 0) {
            this.jSplitPane1.setDividerSize(size);
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    if ("ezuc.intent.action.event.WEB_LOGOUT_DONE".equals(action)) {
                        ContactHistoryFramePanel.this.contactHistoryPanel.clearContactHistory();
                    } else if ("ezuc.intent.action.event.WEB_LOGIN_FAILED".equals(action)) {
                        ContactHistoryFramePanel.this.contactHistoryPanel.clearContactHistory();
                    } else if ("ezuc.intent.action.event.EXE_CHATROOM_JOIN_DONE".equals(action)) {
                        String roomJID = bundle.getString("chatId");
                        ContactHistoryFramePanel.this.web_addChatroomEvent(roomJID);
                    } else if ("ezuc.intent.action.event.CHAT_ROOM_MSG_DELETED".equals(action)) {
                        String roomJID = bundle.getString("roomJID");
                        ContactHistoryFramePanel.this.contactHistoryPanel.deleteAllChatRoomMsgs(roomJID);
                    } else if ("ezuc.intent.action.event.CHAT_REMOVE_FROM_CHATROOM".equals(action)) {
                        String roomJID = bundle.getString("chatId");
                        ContactHistoryFramePanel.this.chat_removeFromChatroom(roomJID);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_CHANGED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgChanged(intent);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_DELETED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgDeleted(intent);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_RECALLED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgRecalled(intent);
                    } else if ("ezuc.intent.action.event.UPDATE_ACTION_MAP".equals(action)) {
                        ContactHistoryFramePanel.this.updateActionMap();
                    } else if ("ezuc.intent.action.event.CHAT_MSG_PLAYED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgPlayed(intent);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_READED_BY".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgReadedBy(intent);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgStatusChanged(intent);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_CONTENT_CHANGED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_msgContentChanged(intent);
                    } else if ("ezuc.intent.action.event.CHAT_ROOM_CREATED_SUCCEED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_roomCreatedSucceed(intent);
                    } else if ("ezuc.intent.action.event.CHAT_ROOM_CREATED_FAILED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_roomCreatedFailed(intent);
                    } else if ("ezuc.intent.action.event.FILE_UPLOAD_PROGRESSING".equals(action)) {
                        ContactHistoryFramePanel.this.fileUpload_progressing(intent);
                    } else if ("ezuc.intent.action.event.CHAT_ROOM_INFO_UPDATE".equals(action)) {
                        ContactHistoryFramePanel.this.chat_roomInfoUpdated(intent);
                    } else if ("ezuc.intent.action.event.CHAT_ROOM_EXITED_FAILED".equals(action)) {
                        ContactHistoryFramePanel.this.chat_exitRoomFailed(intent);
                    } else if ("ezuc.intent.action.event.CURRENT_SITE_CHANGED".equals(action)) {
                        ContactHistoryFramePanel.this.reloadAllPhoneData();
                    }
                }
                catch (Throwable t) {
                    Log.e(ContactHistoryFramePanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.WEB_LOGOUT_DONE");
        this.filter.addAction("ezuc.intent.action.event.WEB_LOGIN_FAILED");
        this.filter.addAction("ezuc.intent.action.event.EXE_CHATROOM_JOIN_DONE");
        this.filter.addAction("ezuc.intent.action.event.CHAT_ROOM_MSG_DELETED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_REMOVE_FROM_CHATROOM");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_DELETED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_RECALLED");
        this.filter.addAction("ezuc.intent.action.event.UPDATE_ACTION_MAP");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_PLAYED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_READED_BY");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_STATUS_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_CONTENT_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_ROOM_CREATED_SUCCEED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_ROOM_CREATED_FAILED");
        this.filter.addAction("ezuc.intent.action.event.FILE_UPLOAD_PROGRESSING");
        this.filter.addAction("ezuc.intent.action.event.CURRENT_SITE_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    public void refreshData() {
        this.contactHistoryPanel.prepare();
    }

    public void onTabSelected(boolean twice) {
        this.tabSelected = true;
        this.checkAllRoomForFocus();
        if (twice) {
            this.contactHistoryPanel.scrollTop();
        }
    }

    public void onTabUnselected() {
        this.tabSelected = false;
    }

    public void onFocusGainEvent() {
        this.checkAllRoomForFocus();
    }

    private void checkAllRoomForFocus() {
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.loadNewMessage(false);
        }
    }

    private void web_addChatroomEvent(final String roomJID) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ContactHistoryFramePanel.this.isBackgroundPageVisible()) {
                    if (JidUtil.isChatJid(roomJID)) {
                        ContactHistoryFramePanel.this.showChatroom(roomJID);
                    } else if (JidUtil.isConfJid(roomJID)) {
                        ContactHistoryFramePanel.this.showChatroom(roomJID);
                    }
                }
            }
        });
    }

    private void chat_removeFromChatroom(final String roomJID) {
        Log.i(ContactHistoryFramePanel.class.getSimpleName(), "chat removeFromChatroom " + roomJID);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConferenceChatroom confRoom;
                IChatroom room;
                if (JidUtil.isChatJid(roomJID)) {
                    IChatroom room2 = ContactHistoryFramePanel.this.getChatroom(roomJID);
                    if (room2 != null && room2 instanceof MultiUserChatroom) {
                        MultiUserChatroom mucRoom = (MultiUserChatroom)room2;
                        if (mucRoom != null) {
                            mucRoom.updateRoom();
                        }
                        ContactHistoryFramePanel.this.closeChatroom(roomJID);
                    }
                } else if (JidUtil.isConfJid(roomJID) && (room = ContactHistoryFramePanel.this.getChatroom(roomJID)) != null && room instanceof ConferenceChatroom && (confRoom = (ConferenceChatroom)room) != null) {
                    confRoom.updateRoom();
                    MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                    if (mainPanel.getGainFocusFlag() == 1) {
                        confRoom.loadNewMessage(false);
                    }
                }
            }
        });
    }

    private void chat_msgPlayed(Intent intent) {
        String packetId = intent.getStringExtra("chatPacketId");
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.playMessage(packetId);
        }
    }

    private void chat_msgReadedBy(Intent intent) {
        String packetId = intent.getStringExtra("chatPacketId");
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.readedByMessage(packetId);
        }
    }

    private void chat_msgRecalled(Intent intent) {
        String packetId = intent.getStringExtra("chatPacketId");
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.recallMessage(packetId);
        }
    }

    private void chat_msgDeleted(Intent intent) {
        String packetId = intent.getStringExtra("chatPacketId");
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.deleteMessage(packetId);
        }
    }

    private void updateActionMap() {
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.updateActionMap();
        }
    }

    private void chat_msgChanged(Intent intent) {
        boolean selfSendOut = intent.getBooleanExtra("selfSendOut", false);
        JSONArray list = intent.getJSONArrayExtra("chatAry");
        if (list != null) {
            for (int i = 0; i < list.length(); ++i) {
                try {
                    String jid = list.getString(i);
                    this.reloadRoom(jid, selfSendOut);
                    continue;
                }
                catch (JSONException e) {
                    Log.e(ContactHistoryFramePanel.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        } else {
            String jid = intent.getStringExtra("chatId");
            if (jid == null) {
                jid = intent.getStringExtra("key");
            }
            if (jid != null) {
                this.reloadRoom(jid, selfSendOut);
            } else {
                this.reloadAll(selfSendOut);
            }
        }
    }

    private void fileUpload_progressing(final Intent intent) {
        final String chatId = intent.getStringExtra("chatId");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IChatroom room = ContactHistoryFramePanel.this.getChatroom(chatId);
                if (room != null) {
                    room.updateFileUploadProgress(intent);
                }
            }
        });
    }

    private void reloadRoom(final String roomJid, final boolean selfSendOut) {
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        if (mainPanel.getGainFocusFlag() != 1) {
            return;
        }
        if (!this.tabSelected) {
            return;
        }
        if (this.isCurrentChatroom(roomJid)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IChatroom room = ContactHistoryFramePanel.this.getChatroom(roomJid);
                    if (room != null) {
                        room.loadNewMessage(selfSendOut);
                    }
                }
            });
        }
    }

    private void reloadAll(final boolean selfSendOut) {
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        if (mainPanel.getGainFocusFlag() != 1) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IChatroom chatroom = ContactHistoryFramePanel.this.getCurrentChatroom();
                if (chatroom != null) {
                    chatroom.loadNewMessage(selfSendOut);
                }
            }
        });
    }

    private void reloadAllTime() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IChatroom chatroom = ContactHistoryFramePanel.this.getCurrentChatroom();
                if (chatroom != null) {
                    chatroom.checkAllDate();
                }
            }
        });
    }

    private void reloadAllPhoneData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IChatroom chatroom = ContactHistoryFramePanel.this.getCurrentChatroom();
                if (chatroom != null) {
                    chatroom.checkAllPhoneData();
                }
            }
        });
    }

    private void chat_msgStatusChanged(final Intent intent) {
        final String chatId = intent.getStringExtra("chatId");
        if (this.isCurrentChatroom(chatId)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IChatroom room = ContactHistoryFramePanel.this.getChatroom(chatId);
                    if (room != null) {
                        room.updateMessageStatus(intent);
                    }
                }
            });
        }
    }

    private void chat_msgContentChanged(final Intent intent) {
        final String chatId = intent.getStringExtra("chatId");
        if (this.isCurrentChatroom(chatId)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IChatroom room = ContactHistoryFramePanel.this.getChatroom(chatId);
                    if (room != null) {
                        room.updateMessageContent(intent);
                    }
                }
            });
        }
    }

    private void chat_roomCreatedSucceed(Intent intent) {
        final String chatId = intent.getStringExtra("chatId");
        if (JidUtil.isChatConfJid(chatId)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContactHistoryFramePanel.this.showChatroom(chatId);
                }
            });
        }
    }

    private void chat_roomCreatedFailed(Intent intent) {
        String chatId = intent.getStringExtra("chatId");
        if (JidUtil.isChatJid(chatId)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("chatroom_notice_create_failed"), chatId, ""));
        } else if (JidUtil.isConfJid(chatId)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("conference_notice_create_failed"), chatId, ""));
        }
    }

    private void chat_roomInfoUpdated(Intent intent) {
        final String roomJID = intent.getStringExtra("roomJID");
        if (this.isCurrentChatroom(roomJID)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IChatroom room = ContactHistoryFramePanel.this.getChatroom(roomJID);
                    if (room != null && room instanceof IMultiUserChatroom) {
                        ((IMultiUserChatroom)room).updateRoom();
                    }
                }
            });
        }
    }

    private void chat_exitRoomFailed(Intent intent) {
        String roomJID = intent.getStringExtra("chatId");
        String errorMsg = intent.getStringExtra("errorMsg");
        if (JidUtil.isChatJid(roomJID)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("chatroom_notice_exit_failed"), roomJID, errorMsg));
        } else if (JidUtil.isConfJid(roomJID)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("conference_notice_exit_failed"), errorMsg));
        }
    }

    public void onPhoneStatusChanged() {
        IChatroom chatroom = this.getCurrentChatroom();
        if (chatroom != null) {
            chatroom.onPhoneStatusChanged();
        }
    }

    public boolean isBackgroundPageVisible() {
        return this.currentView == null;
    }

    public void showChatroom(String roomJID) {
        this.showChatroom(roomJID, new Intent());
    }

    public synchronized void showChatroom(String roomJID, Intent intent) {
        if (this.isCurrentChatroom(roomJID)) {
            if (intent != null && intent.getBooleanExtra("NO_RELOAD_IF_OPEN", false)) {
                return;
            }
            this.currentView.onShow(intent);
            return;
        }
        this.contactHistoryPanel.setSelectedContactHistory(roomJID, intent);
        BaseChatroom newRoom = null;
        if (intent != null) {
            intent.putExtra("ROOM_INIT", true);
        }
        newRoom = JidUtil.isCustomerJid(roomJID) ? new WechatChatroom(roomJID, this.rightPanel) : (JidUtil.isChatJid(roomJID) ? new MultiUserChatroom(roomJID, this.rightPanel) : (JidUtil.isConfJid(roomJID) ? new ConferenceChatroom(roomJID, this.rightPanel) : new Chatroom(roomJID, this.rightPanel)));
        if (this.currentView != null) {
            this.rightPanel.remove((Component)((Object)this.currentView));
            this.currentView.onClose();
        } else {
            this.rightPanel.remove(this.chatBackgroundPanel);
        }
        newRoom.onShow(intent);
        this.rightPanel.add((Component)newRoom, "Center");
        this.currentView = newRoom;
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    public void release() {
        if (this.wechatCountDownThread != null && this.wechatCountDownThread.isAlive()) {
            this.wechatCountDownThread.stopCountDown();
        }
        this.contactHistoryPanel.release();
        this.closeCurrentRoom();
    }

    public boolean isCurrentChatroom(String roomJID) {
        if (this.currentView == null || roomJID == null) {
            return false;
        }
        return this.currentView.getChatroomID().equals(roomJID);
    }

    public IChatroom getChatroom(String expectJid) {
        if (!this.isCurrentChatroom(expectJid)) {
            return null;
        }
        return this.currentView;
    }

    public IChatroom getCurrentChatroom() {
        return this.currentView;
    }

    public synchronized void closeChatroom(String roomJID) {
        if (!this.isCurrentChatroom(roomJID)) {
            return;
        }
        this.closeCurrentRoom();
    }

    private void closeCurrentRoom() {
        if (this.currentView != null) {
            this.rightPanel.remove((Component)((Object)this.currentView));
            this.currentView.onClose();
        }
        this.rightPanel.add((Component)this.chatBackgroundPanel, "Center");
        this.currentView = null;
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    class WechatCountDownThread
    extends Thread {
        boolean goon = true;

        public WechatCountDownThread() {
            this.setName("UC-WechatCountDownThread");
        }

        public void stopCountDown() {
            this.goon = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.goon) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IChatroom room = ContactHistoryFramePanel.this.getCurrentChatroom();
                        if (room != null && room.getChatroomType() == ChatroomType.WECHAT) {
                            WechatChatroom wechatRoomComp = (WechatChatroom)room;
                            wechatRoomComp.updateExpireTime();
                        }
                    }
                });
                try {
                    WechatCountDownThread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

